/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.mitigation;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.qos.QOSClient;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MitigationEngine {
    private static final Logger LOGGER = Logger.getLogger(MitigationEngine.class.getName());
    private static String cluster;
    private static String localHostIP;
    private static MELogger meLogger;
    private static boolean isMigationEnabled;
    private static Map<String, AtomicLong> mitigationCounter;
    private static Map<String, List<Map<String, Map<String, String>>>> rulesFilterCriteria;

    public static boolean initialise(List<Map<String, String>> filterCriteria) {
        try {
            cluster = DC.getCluster();
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting local host address. ", e);
        }
        try {
            for (Map<String, String> rulesFilter : filterCriteria) {
                if (localHostIP == null || !localHostIP.matches(rulesFilter.get("applicableservers"))) continue;
                HashMap<String, Map> rulesCriteria = new HashMap<String, Map>();
                rulesCriteria.put(rulesFilter.get("ruleid"), (Map)HttpDataWraper.getObject((String)rulesFilter.get("rule")));
                if (rulesFilterCriteria.containsKey(rulesFilter.get("rulekey"))) {
                    rulesFilterCriteria.get("rulekey").add(rulesCriteria);
                    continue;
                }
                ArrayList<HashMap<String, Map>> rulesCriteriaList = new ArrayList<HashMap<String, Map>>();
                rulesCriteriaList.add(rulesCriteria);
                rulesFilterCriteria.put(rulesFilter.get("rulekey"), rulesCriteriaList);
            }
            if (!rulesFilterCriteria.isEmpty()) {
                isMigationEnabled = true;
                if (!meLogger.isAlive()) {
                    meLogger.start();
                }
            } else {
                isMigationEnabled = false;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while initialising filter criteria.", e);
        }
        return true;
    }

    public static boolean process(String ruleKey, Map<String, String> ruleValue) {
        block9: {
            if (!isMigationEnabled) {
                return true;
            }
            try {
                if (!rulesFilterCriteria.containsKey(ruleKey)) break block9;
                for (Map<String, Map<String, String>> rulesFilterCriteriaMap : rulesFilterCriteria.get(ruleKey)) {
                    for (Map.Entry<String, Map<String, String>> ruleEntry : rulesFilterCriteriaMap.entrySet()) {
                        if (!MitigationEngine.isSubSet(ruleValue, ruleEntry.getValue())) continue;
                        try {
                            String ruleid = ruleEntry.getKey();
                            if (mitigationCounter.get(ruleid) != null) {
                                mitigationCounter.get(ruleid).incrementAndGet();
                            } else {
                                AtomicLong count = new AtomicLong(1L);
                                mitigationCounter.put(ruleid, count);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NS--> Error while processing. ", e);
            }
        }
        return true;
    }

    private static boolean isSubSet(Map<String, String> rule, Map<String, String> filterCriteria) {
        try {
            for (Map.Entry<String, String> filterEntry : filterCriteria.entrySet()) {
                String filterKey = filterEntry.getKey();
                if (rule.containsKey(filterKey)) {
                    String filterValue = filterEntry.getValue();
                    if (rule.get(filterKey).matches(filterValue)) continue;
                    return false;
                }
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while checking whether filter is subset of rule. ", e);
        }
        return true;
    }

    static {
        meLogger = new MELogger();
        isMigationEnabled = false;
        mitigationCounter = new HashMap<String, AtomicLong>();
        rulesFilterCriteria = new HashMap<String, List<Map<String, Map<String, String>>>>();
    }

    static class MELogger
    extends Thread {
        private static Map<String, String> notifyTabChange = new HashMap<String, String>();

        public MELogger() {
            super("MELogger/");
            notifyTabChange.put("notify", "security/appfirewall");
            notifyTabChange = Collections.unmodifiableMap(notifyTabChange);
        }

        @Override
        public void run() {
            try {
                while (isMigationEnabled) {
                    Thread.sleep(60000L);
                    try {
                        for (Map.Entry entry : mitigationCounter.entrySet()) {
                            String ruleid = (String)entry.getKey();
                            long count = ((AtomicLong)entry.getValue()).get();
                            StatsDB.addDataInstant(System.currentTimeMillis(), "mitigate", cluster, ruleid, count);
                        }
                        if (!mitigationCounter.isEmpty()) {
                            QOSClient.send(HttpDataWraper.getString(notifyTabChange));
                        }
                        mitigationCounter.clear();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "NS--> Error while storing data in influx db. ", e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NS--> Error inside MELogger thread. ", e);
            }
        }
    }
}

