/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.servercommon.kafka.KafkaEventListener;
import com.adventnet.wms.servercommon.kafka.WMSKafkaProperties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MessageDispatcher {
    private static ThreadPoolExecutor dispatcherTPE = new ThreadPoolExecutor(WMSKafkaProperties.getConsumerDispatcherTPECount(), WMSKafkaProperties.getConsumerDispatcherTPEMaxCount(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static void dispatchData(KafkaEventListener listener, String msg) {
        dispatcherTPE.execute(new Dispatcher(listener, msg));
    }

    static class Dispatcher
    implements Runnable {
        KafkaEventListener listener;
        String msg = "";

        public Dispatcher(KafkaEventListener listener, String msg) {
            this.listener = listener;
            this.msg = msg;
        }

        @Override
        public void run() {
            this.listener.onMessage(this.msg);
        }
    }
}

