/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid.ar;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.grid.ar.ARConstants;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ARModuleStat {
    private static final Logger LOGGER = Logger.getLogger(ARModuleStat.class.getName());
    private ArrayList<Long> endTime = new ArrayList();
    private ArrayList<Long> startTime = new ArrayList();
    private ArrayList<String> duration = new ArrayList();
    private ArrayList<String> operations = new ArrayList();
    private ArrayList<Integer> progress = new ArrayList();
    private ArrayList<Long> durationInMillis = new ArrayList();
    private ArrayList<String> operationStatus = new ArrayList();
    private List<Map<String, String>> progressMap = new ArrayList<Map<String, String>>();
    private static final Map<String, String> NO_OPERATIONS_MAP = new HashMap<String, String>();
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("HH:mm:ss");
    private String status;
    private String moduleName;
    private String executionType;
    private String operation = " ";
    private int operationIndex = 0;
    private int currentStage = -1;
    private int operationCode;

    ARModuleStat(String modulename, int executionType) {
        this.moduleName = modulename;
        this.status = "No operation";
        this.operations.addAll(ARConstants.Operation.operationsMap.values());
        this.executionType = ARConstants.getExecutionType(executionType);
        NO_OPERATIONS_MAP.put("Title", "No operation");
        for (int index = 0; index < this.operations.size(); ++index) {
            this.progress.add(0);
            this.endTime.add(0L);
            this.startTime.add(0L);
            this.duration.add("0ms");
            this.durationInMillis.add(0L);
            this.operationStatus.add("No operation");
            this.progressMap.add(NO_OPERATIONS_MAP);
            this.progressMap.add(NO_OPERATIONS_MAP);
        }
        if (executionType == 2) {
            this.currentStage = 0;
        }
    }

    protected void setStartTime() {
        this.startTime.set(this.operationIndex, System.currentTimeMillis());
    }

    protected void setCurrentStage(int stage) {
        this.currentStage = stage;
    }

    protected void setProgress(Map<String, String> progress) {
        try {
            if (this.currentStage >= 0 && this.currentStage < 4) {
                HashMap<String, String> progressMap = new HashMap<String, String>();
                if (!CommonUtil.isEmpty(progress)) {
                    if (this.operationStatus.get(this.operationIndex) == "Completed") {
                        this.progress.set(this.operationIndex, 100);
                        progressMap.put("Progress", "100");
                    } else if (!CommonUtil.isEmpty((String)progress.get("Progress"))) {
                        this.progress.set(this.operationIndex, Integer.parseInt(progress.get("Progress")));
                        progressMap.put("Progress", progress.get("Progress"));
                    } else {
                        progressMap.put("Progress", String.valueOf(this.progress.get(this.operationIndex)));
                    }
                    if (!CommonUtil.isEmpty((String)progress.get("Title"))) {
                        this.setOverAllStatus(progress.get("Title"));
                        progressMap.put("Title", progress.get("Title"));
                    } else if (this.isInProgress(this.operationCode)) {
                        progressMap.put("Title", this.operationStatus.get(this.operationIndex));
                    } else {
                        progressMap.put("Title", "No operation");
                    }
                } else {
                    if (this.operationStatus.get(this.operationIndex) == "Completed") {
                        this.progress.set(this.operationIndex, 100);
                    }
                    progressMap.put("Progress", String.valueOf(this.progress.get(this.operationIndex)));
                    if (this.isInProgress(this.operationCode)) {
                        progressMap.put("Title", this.operationStatus.get(this.operationIndex));
                    } else {
                        progressMap.put("Title", "No operation");
                    }
                }
                this.progressMap.set(this.currentStage, progressMap);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AR-->Error while setting Progress for module : " + this.moduleName, e);
        }
    }

    protected void setOperation(int operationCode) {
        this.operationCode = operationCode;
        this.operation = ARConstants.Operation.operationsMap.get(operationCode);
        this.operationIndex = this.operations.indexOf(this.operation);
    }

    protected void setStatus(String status) {
        this.operationStatus.set(this.operationIndex, status);
    }

    protected void setEndTime(Long end_Time) {
        LOGGER.info("UM-->set endtime" + this.moduleName);
        this.endTime.set(this.operationIndex, end_Time);
    }

    protected void setOverAllStatus(String status) {
        this.status = status;
    }

    protected void setDetails(long startTime, long endTime, String operation) {
    }

    private int getProgress() {
        return this.progress.get(this.operationIndex);
    }

    private Object getDuration(boolean forAdmin) {
        try {
            if (!CommonUtil.isEmpty((String)this.operation)) {
                if (this.endTime.get(this.operationIndex) != 0L) {
                    this.durationInMillis.set(this.operationIndex, this.endTime.get(this.operationIndex) - this.startTime.get(this.operationIndex));
                    this.duration.set(this.operationIndex, WMSUtil.HumanReadable.getDuration(this.endTime.get(this.operationIndex) - this.startTime.get(this.operationIndex), true));
                } else if (this.startTime.get(this.operationIndex) != 0L) {
                    this.durationInMillis.set(this.operationIndex, System.currentTimeMillis() - this.startTime.get(this.operationIndex));
                    this.duration.set(this.operationIndex, WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - this.startTime.get(this.operationIndex), true));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting Duration.", e);
        }
        return forAdmin ? this.duration : this.duration.get(this.operationIndex);
    }

    public ArrayList<Long> getDurationInMillis() {
        return this.durationInMillis;
    }

    private String getOverAllDuration() {
        try {
            if (!CommonUtil.isEmpty((String)this.operation)) {
                long totalDuration = 0L;
                for (int index = 0; index < this.operations.size(); ++index) {
                    totalDuration += this.durationInMillis.get(index).longValue();
                }
                return WMSUtil.HumanReadable.getDuration(totalDuration, true);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting Duration.", e);
        }
        return "0ms";
    }

    protected String getOperation() {
        return this.operation;
    }

    private String getType() {
        return this.executionType;
    }

    protected String getStatus() {
        return this.operationStatus.get(this.operationIndex);
    }

    protected String getOverAllStatus() {
        return this.status;
    }

    protected int getCurrentStage() {
        return this.currentStage;
    }

    protected boolean isInProgress(int operationCode) {
        try {
            int index = this.operations.indexOf(ARConstants.Operation.operationsMap.get(operationCode));
            if (index != -1 && this.operationStatus.get(index) == "Inprogress") {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AR-->Error while checking InProgress status for operation : " + operationCode, e);
            return false;
        }
        return false;
    }

    protected Hashtable<String, Object> getDetails(boolean forAdmin) {
        Hashtable<String, Object> details = new Hashtable<String, Object>();
        try {
            if (this.startTime.get(0) != 0L) {
                details.put("StartTime", DATEFORMAT.format(this.startTime.get(0)));
            }
            if (forAdmin) {
                details.put("Operation", this.operations);
                details.put("Duration", this.getDuration(forAdmin));
                details.put("Status", this.operationStatus);
                details.put("Progress", this.progress);
                details.put("TotalDuration", this.getOverAllDuration());
                details.put("OverAllStatus", this.status);
                details.put("stage", this.currentStage);
                details.put("progressMap", this.progressMap);
            } else if (!CommonUtil.isEmpty(this.operations)) {
                details.put("Duration", this.getDuration(forAdmin));
                details.put("Progress", this.getProgress() + "%");
                details.put("Status", this.getStatus());
                if (this.endTime.get(this.operationIndex) != 0L) {
                    details.put("EndTime", DATEFORMAT.format(new Date(this.endTime.get(this.operationIndex))));
                }
                details.put("_order", HttpDataWraper.getString(ARConstants.MODULE_ORDER));
            }
            details.put("Type", this.getType());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting getDetails().", e);
        }
        return details;
    }
}

