/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid.ar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ARConstants {
    public static final int SERVERMODE_OLD = 1;
    public static final int SERVERMODE_NEW = 2;
    public static final int EXECUTION_TYPE_PARALLEL = 1;
    public static final int EXECUTION_TYPE_SEQUENTIAL = 2;
    public static final double PROGRESS_PERCENTAGE = 17.0;
    public static final int AR_COMPLETED = 100;
    public static final int AR_FAILED = 101;
    private static Map<Integer, String> statusMap = null;
    public static final String PROGRESS = "Progress";
    public static final String TITLE = "Title";
    public static final String USER = "User";
    public static final String TYPE = "Type";
    public static final String ORDER = "_order";
    public static final String STAGE = "stage";
    public static final String STORE = "__store";
    public static final String OLD_IP = "OldIP";
    public static final String STATUS = "Status";
    public static final String STIME = "stime";
    public static final String END_TIME = "EndTime";
    public static final String DURATION = "Duration";
    public static final String OPERATION = "Operation";
    public static final String START_TIME = "StartTime";
    public static final String PROGRESS_MAP = "progressMap";
    public static final String TOTAL_DURATION = "TotalDuration";
    public static final String REPLACEMENT_IP = "ReplacementIP";
    public static final String OVER_ALL_STATUS = "OverAllStatus";
    public static final String PARALLEL_MODULES = "ParallelModules";
    public static final String DURATION_IN_MILLIS = "DurationMillis";
    public static final String SEQUENTIAL_MODULES = "SequentialModules";
    public static final List<String> AR_ORDER = new ArrayList<String>();
    public static final List<String> MODULE_ORDER = new ArrayList<String>();

    public static boolean isValidStatusCode(int statusCode, String operation) {
        if (Operation.operationsMap.get(1).equals(operation)) {
            if (statusCode != 100 && statusCode != 101) {
                return false;
            }
        } else if (Operation.operationsMap.get(2).equals(operation)) {
            if (statusCode != 200 && statusCode != 201) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static String getStatusMessage(int statusCode) {
        return statusMap.get(statusCode);
    }

    public static String getExecutionType(int executionType) {
        switch (executionType) {
            case 1: {
                return "Parallel";
            }
            case 2: {
                return "Sequential";
            }
        }
        return null;
    }

    static {
        AR_ORDER.add(START_TIME);
        AR_ORDER.add(DURATION);
        AR_ORDER.add(TITLE);
        AR_ORDER.add(STATUS);
        AR_ORDER.add(PROGRESS);
        AR_ORDER.add(PARALLEL_MODULES);
        AR_ORDER.add(SEQUENTIAL_MODULES);
        AR_ORDER.add(OLD_IP);
        AR_ORDER.add(REPLACEMENT_IP);
        AR_ORDER.add(USER);
        MODULE_ORDER.add(START_TIME);
        MODULE_ORDER.add(DURATION);
        MODULE_ORDER.add(PROGRESS);
        MODULE_ORDER.add(STATUS);
        MODULE_ORDER.add(END_TIME);
        MODULE_ORDER.add(TYPE);
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(100, "Prepare Completed");
        statusMap.put(101, "Prepare Failed");
        statusMap.put(200, "Perform Completed");
        statusMap.put(201, "Perform Failed");
        ARConstants.statusMap = Collections.unmodifiableMap(statusMap);
    }

    public static class Status {
        public static final String YET_TO_START = "Yet to Start";
        public static final String STARTED = "Started";
        public static final String COMPLETED = "Completed";
        public static final String INPROGRESS = "Inprogress";
        public static final String FAILED = "Failed";
        public static final String NO_OPERATIONS = "No operation";
    }

    public static class WCP {
        public static final String AR_URI = "/grid/ar";
        public static final String AR_CONTEXT = "default_ar";
        public static final String ARDISPATCHER = "ardispatcher";
    }

    public static class Module {
        public static final int BUFFEREDQUEUE = 101;
        public static final int TASKMANAGER = 102;
        public static final int WCP = 103;
        public static final int ROCKSDB = 104;
        public static final int TOMCAT = 105;
    }

    public static class Perform {
        public static final int COMPLETED = 200;
        public static final int FAILED_AND_ABORT = 201;
    }

    public static class Prepare {
        public static final int COMPLETED = 100;
        public static final int FAILED_AND_ABORT = 101;
    }

    public static class Operation {
        public static final int PREPARE = 1;
        public static final int PERFORM = 2;
        public static Map<Integer, String> operationsMap = null;

        static {
            LinkedHashMap<Integer, String> operationsMap = new LinkedHashMap<Integer, String>();
            operationsMap.put(1, "Prepare");
            operationsMap.put(2, "Perform");
            Operation.operationsMap = Collections.unmodifiableMap(operationsMap);
        }
    }

    public static class Progress {
        public static final int STARTED = 1;
        public static final int NOTIFIED_AR_START = 2;
        public static final int PREPARE = 3;
        public static final int PERFORM = 4;
        public static final int NOTIFIED_NEW = 5;
        public static final int COMPLETED = 6;
        public static final int FAILED = -1;
    }
}

