/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.grid.ClusterDistributionLogic;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.json.JSONObject;

public class WCH
extends ClusterDistributionLogic {
    private int crange;
    private int reason;
    private String version;
    private static AtomicInteger serversMapIndex = new AtomicInteger(0);
    private static final Logger LOGGER = Logger.getLogger(WCH.class.getName());
    private NavigableMap<Integer, String> circle = new TreeMap<Integer, String>();
    private NavigableMap<String, Integer> servers = new TreeMap<String, Integer>();

    public WCH(JSONObject details) throws Exception {
        this.crange = details.getInt("crange");
        try {
            this.version = Long.toString(details.getLong("rcv"));
        }
        catch (Exception e) {
            this.version = details.getString("rcv");
        }
        JSONObject ips = null;
        try {
            ips = (JSONObject)details.get("ips");
        }
        catch (ClassCastException e) {
            ips = new JSONObject((Map)((Hashtable)details.get("ips")));
        }
        try {
            this.reason = details.getInt("reason");
        }
        catch (Exception e) {
            this.reason = -1;
        }
        Iterator keys = ips.keys();
        while (keys.hasNext()) {
            String node = (String)keys.next();
            int weight = ips.getInt(node);
            this.servers.put(node, weight);
            this.circle.put(weight, node);
        }
        LOGGER.info(" rcv :" + this.circle + " servers :" + this.servers + " reason :" + this.reason);
    }

    public WCH(Hashtable<String, Object> wch) {
        this.crange = (Integer)wch.get("crange");
        this.version = (String)wch.get("version");
        Hashtable circle = (Hashtable)wch.get("circle");
        circle.entrySet().stream().forEach(entry -> {
            String cfr_ignored_0 = (String)this.circle.put(Integer.parseInt("" + entry.getKey()), (String)entry.getValue());
        });
        Hashtable servers = (Hashtable)wch.get("servers");
        servers.entrySet().stream().forEach(entry -> this.servers.put((String)entry.getKey(), Integer.parseInt("" + entry.getValue())));
    }

    public void addNode(String ip, int weight) {
        this.servers.put(ip, weight);
        this.circle.put(weight, ip);
    }

    public void removeNode(String ip) {
        if (this.servers.containsKey(ip)) {
            this.circle.remove(this.servers.remove(ip));
        }
    }

    public void removeWeight(int weight) {
        if (this.circle.containsKey(weight)) {
            this.servers.remove(this.circle.remove(weight));
        }
    }

    public Integer getHashCode(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes());
            return Math.abs(new BigInteger(1, md5.digest()).intValue()) % this.crange;
        }
        catch (Exception e) {
            return str.hashCode();
        }
    }

    @Override
    public String getServer(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hashCode = this.getHashCode(key);
        if (!this.circle.containsKey(hashCode)) {
            SortedMap<Integer, String> tailMap = this.circle.tailMap(hashCode);
            hashCode = tailMap.isEmpty() ? ((Integer)this.circle.firstKey()).intValue() : tailMap.firstKey().intValue();
        }
        return (String)this.circle.get(hashCode);
    }

    @Override
    public String getServer() {
        ArrayList set = new ArrayList(this.servers.keySet());
        int index = serversMapIndex.incrementAndGet();
        if (index >= set.size()) {
            serversMapIndex.set(0);
            index = 0;
        }
        return (String)set.get(index);
    }

    public String getBackupServer(String server) {
        if (this.servers.isEmpty()) {
            return null;
        }
        SortedMap<String, Integer> headMap = this.servers.headMap(server);
        if (headMap == null) {
            return null;
        }
        if (headMap.isEmpty()) {
            return (String)this.servers.lastKey();
        }
        return headMap.lastKey();
    }

    public String getAlternateServer(String server) {
        if (this.servers.isEmpty()) {
            return null;
        }
        SortedMap<String, Integer> headMap = this.servers.headMap(server);
        if (headMap == null) {
            return null;
        }
        if (headMap.isEmpty()) {
            return (String)this.servers.lastKey();
        }
        return headMap.lastKey();
    }

    public String getPredecessor(String server) {
        if (this.circle.isEmpty()) {
            return null;
        }
        String predecessor = null;
        Integer predecessorWeight = this.circle.lowerKey((Integer)this.servers.get(server));
        if (predecessorWeight == null) {
            SortedMap<Integer, String> tailMap = this.circle.tailMap((Integer)this.servers.get(server));
            predecessor = (String)this.circle.get(tailMap.lastKey());
        } else {
            predecessor = (String)this.circle.get(predecessorWeight);
        }
        return predecessor;
    }

    public String getPredecessor(int weight) {
        if (this.circle.isEmpty()) {
            return null;
        }
        String predecessor = null;
        Integer predecessorWeight = this.circle.lowerKey(weight);
        if (predecessorWeight == null) {
            SortedMap<Integer, String> tailMap = this.circle.tailMap(weight);
            predecessor = (String)this.circle.get(tailMap.lastKey());
        } else {
            predecessor = (String)this.circle.get(predecessorWeight);
        }
        return predecessor;
    }

    public String getSuccessor(String server) {
        if (this.circle.isEmpty()) {
            return null;
        }
        String successor = null;
        Integer successorWeight = this.circle.higherKey((Integer)this.servers.get(server));
        if (successorWeight == null) {
            SortedMap<Integer, String> headMap = this.circle.headMap((Integer)this.servers.get(server));
            successor = (String)this.circle.get(headMap.firstKey());
        } else {
            successor = (String)this.circle.get(successorWeight);
        }
        return successor;
    }

    public String getSuccessor(int weight) {
        if (this.circle.isEmpty()) {
            return null;
        }
        String successor = null;
        Integer successorWeight = this.circle.higherKey(weight);
        if (successorWeight == null) {
            SortedMap<Integer, String> headMap = this.circle.headMap(weight);
            successor = (String)this.circle.get(headMap.firstKey());
        } else {
            successor = (String)this.circle.get(successorWeight);
        }
        return successor;
    }

    public Set<String> getServers() {
        return Collections.unmodifiableSet(this.servers.keySet());
    }

    public boolean isMember(String wnet) {
        return this.servers.containsKey(wnet);
    }

    public int getAvailableNodesCount() {
        return this.servers.size();
    }

    public String getVersion() {
        return this.version;
    }

    public int getReason() {
        return this.reason;
    }

    public boolean isSameVersion(String version) {
        return this.version.equals(version);
    }

    public boolean isSameVersion(WCH rc) {
        return this.getVersion().equals(rc.getVersion());
    }

    public int getCRange() {
        return this.crange;
    }

    public Hashtable<String, Object> wrap() {
        Hashtable<String, Object> wch = new Hashtable<String, Object>();
        wch.put("crange", new Integer(this.crange));
        wch.put("version", new String(this.version));
        wch.put("circle", new TreeMap<Integer, String>((SortedMap<Integer, String>)this.circle));
        wch.put("servers", new TreeMap<String, Integer>((SortedMap<String, Integer>)this.servers));
        return wch;
    }

    public WCH duplicate() {
        return new WCH((Hashtable)HttpDataWraper.getObject((String)HttpDataWraper.getString(this.wrap())));
    }

    public String toString() {
        return "version=" + this.version + " circle=" + this.circle + " crange=" + this.crange + " reason=" + this.reason;
    }
}

