/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.qos.QOSClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedConf {
    private static final Logger LOGGER = Logger.getLogger(SharedConf.class.getName());
    public static final int SCOPE_ALL = 1;
    public static final int SCOPE_DEFAULT = 2;
    private static ConcurrentHashMap<String, String> allClustersMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> defaultClusterMap = new ConcurrentHashMap();

    public static boolean initialise(Map<String, Map<String, String>> sharedConfMap) {
        try {
            if (sharedConfMap.containsKey("all")) {
                allClustersMap = new ConcurrentHashMap<String, String>(sharedConfMap.get("all"));
            }
            if (sharedConfMap.containsKey("default")) {
                defaultClusterMap = new ConcurrentHashMap<String, String>(sharedConfMap.get("default"));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while initializing SharedConf. ", e);
            return false;
        }
    }

    public static boolean put(String key, String value, int scopeType) {
        try {
            if (scopeType == 1 || scopeType == 2) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("key", key);
                details.put("opr", "add");
                details.put("value", value);
                if (scopeType == 2) {
                    details.put("sharedconf", "default");
                } else if (scopeType == 1) {
                    details.put("sharedconf", "all");
                }
                QOSClient.send(HttpDataWraper.getString(details));
                return true;
            }
            LOGGER.log(Level.WARNING, "NS--> Invalid scope type. scopeType-->" + scopeType);
            return false;
        }
        catch (Exception e) {
            StringBuilder info = new StringBuilder().append("NS--> Error while putting ").append("key: " + key).append(" value: " + value).append(" in cluster map. \n");
            LOGGER.log(Level.WARNING, info.toString(), e);
            return false;
        }
    }

    public static boolean containsKey(String key, int scopeType) {
        try {
            if (scopeType == 1) {
                return allClustersMap.containsKey(key);
            }
            if (scopeType == 2) {
                return defaultClusterMap.containsKey(key);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "NS--> Error while checking key " + key + " in cluster map.", e);
        }
        return false;
    }

    public static String get(String key, int scopeType) {
        try {
            if (scopeType == 1) {
                return allClustersMap.get(key);
            }
            if (scopeType == 2) {
                return defaultClusterMap.get(key);
            }
        }
        catch (Exception e) {
            StringBuilder info = new StringBuilder().append("NS--> Error while getting value for ").append("key: " + key).append(" from cluster map. \n");
            LOGGER.log(Level.WARNING, info.toString(), e);
        }
        return null;
    }

    public static String remove(String key, int scopeType) {
        try {
            if (SharedConf.containsKey(key, scopeType)) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("key", key);
                details.put("opr", "remove");
                if (scopeType == 2) {
                    details.put("sharedconf", "default");
                } else if (scopeType == 1) {
                    details.put("sharedconf", "all");
                }
                QOSClient.send(HttpDataWraper.getString(details));
                return SharedConf.get(key, scopeType);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while removing key: " + key + " from cluster map. ", e);
        }
        return null;
    }
}

