/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProvisionHandler {
    private final Logger logger = Logger.getLogger(ProvisionHandler.class.getName());
    private int provisionType = -1;
    private boolean provStatus = false;
    private Map<String, String> provisionMap = null;
    private ThreadPoolExecutor tpexecutor;
    private ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue(5);

    public ProvisionHandler() {
        this.tpexecutor = new ThreadPoolExecutor(1, 1, 300L, TimeUnit.SECONDS, this.workQueue);
    }

    public boolean initialise(long provisionId) {
        try {
            String serverHome = System.getProperty("server.home");
            Properties provisionProp = FileUtil.getFileAsProperties(serverHome + File.separator + "conf" + File.separator + provisionId + ".properties");
            this.provStatus = Boolean.parseBoolean((String)provisionProp.get("status"));
            try {
                this.provisionType = Integer.parseInt((String)provisionProp.get("provtype"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.provStatus) {
                this.provisionMap = (Map)HttpDataWraper.getObject((String)((String)provisionProp.get("provmap")));
            } else {
                this.provisionMap = new HashMap<String, String>();
                this.logger.info("NS--> Provisioning map is not set as status is false. ");
            }
            this.logger.info("NS--> Successfully initialised ProvisionHandler. ");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "NSERR--> Error while initialising ProvisionHandler. \n", e);
            return false;
        }
    }

    public int getProvType() {
        return this.provisionType;
    }

    public Map<String, String> getProvMap() {
        return this.provisionMap;
    }

    public boolean startProvisioning() {
        boolean status = false;
        try {
            this.logger.info("AR-->" + this.provisionType);
            if (this.provisionType == 1) {
                status = this.provisionAsNewNode(this.provisionMap);
            } else if (this.provisionType == 4) {
                status = this.provisionWarmly(this.provisionMap);
            } else if (this.provisionType == 5) {
                status = this.provisionAsUpgrade(this.provisionMap);
            } else if (this.provisionType == 3) {
                status = ARManager.startActiveReplacement(2, this.provisionMap);
            } else if (this.provisionType == 2) {
                status = this.provisionAsReplaceFailure(this.provisionMap);
            } else {
                this.logger.info("NS--> Invalid provision type: " + this.provisionType);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "NS--> Error inside start Provisioning method. provisionType=" + this.provisionType, e);
        }
        return status;
    }

    public abstract boolean provisionAsNewNode(Map<String, String> var1);

    public abstract boolean provisionAsReplaceActive(Map<String, String> var1);

    public abstract boolean provisionAsReplaceFailure(Map<String, String> var1);

    public abstract boolean provisionWarmly(Map<String, String> var1);

    public abstract boolean provisionAsUpgrade(Map<String, String> var1);

    public abstract void deprovisionInEvictMode(Map<String, String> var1);

    public abstract void prepareFor(Map<String, String> var1);

    public boolean handleProvision(final int opr, final int type, String provisionMap) throws Exception {
        this.logger.info("NS_DEBUG--> provMap " + provisionMap + " type " + type);
        try {
            final Map provMap = (Map)HttpDataWraper.getObject((String)provisionMap);
            this.tpexecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ProvisionHandler.this.logger.info("NS_DEBUG--> Inside handleProvision Thread; provMap = " + provMap + " opr=" + opr);
                    if (opr == 4) {
                        if (type == 2) {
                            try {
                                ARManager.startActiveReplacement(1, provMap);
                            }
                            catch (Exception e) {
                                ProvisionHandler.this.logger.log(Level.SEVERE, "NS--> Error while starting Active Replacement provMap=" + provMap, e);
                            }
                        } else if (type == 1) {
                            ProvisionHandler.this.deprovisionInEvictMode(provMap);
                        }
                    } else if (opr == 11) {
                        if ("upgrade".equals(provMap.get("opr"))) {
                            ARManager.waitTillARComplete(10L, TimeUnit.SECONDS);
                        }
                        ProvisionHandler.this.prepareFor(provMap);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "NSERR--> Error inside handleProvision type=" + type + " provisionMap=" + provisionMap, e);
            return false;
        }
    }
}

