/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.servercommon.grid.ClusterDistributionLogic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class IPMap
extends ClusterDistributionLogic {
    private static final Logger LOGGER = Logger.getLogger(IPMap.class.getName());
    private long version;
    private AtomicInteger serversMapIndex = new AtomicInteger(0);
    private Map<String, Integer> ipMap = new HashMap<String, Integer>();
    private Map<String, Integer> wnetMap = new HashMap<String, Integer>();
    private int reason = -1;

    public IPMap(long version, Map<String, Integer> wnetMap) throws Exception {
        this.wnetMap = wnetMap;
        this.version = version;
        for (String wnet : this.wnetMap.keySet()) {
            this.ipMap.put(wnet.split(":")[0], wnetMap.get(wnet));
        }
        LOGGER.info(" ipm " + this.ipMap + " version=" + version);
    }

    public IPMap(long version, Map<String, Integer> wnetMap, int reason) throws Exception {
        this.wnetMap = wnetMap;
        this.version = version;
        for (String wnet : this.wnetMap.keySet()) {
            this.ipMap.put(wnet.split(":")[0], wnetMap.get(wnet));
        }
        this.reason = reason;
        LOGGER.info(" ipm " + this.ipMap + " version=" + version + " reason=" + reason);
    }

    @Override
    public String getServer(String position) {
        if (this.ipMap.isEmpty()) {
            return null;
        }
        int pos = Integer.parseInt(position);
        for (Map.Entry<String, Integer> entry : this.ipMap.entrySet()) {
            if (entry.getValue() != pos) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public String getServer() {
        ArrayList<String> set = new ArrayList<String>(this.ipMap.keySet());
        int index = this.serversMapIndex.incrementAndGet();
        if (index >= set.size()) {
            this.serversMapIndex.set(0);
        }
        return (String)set.get(index - 1);
    }

    public Set<String> getServers() {
        return Collections.unmodifiableSet(this.ipMap.keySet());
    }

    public Integer getPosition(String ip) {
        return this.ipMap.get(ip);
    }

    public boolean isMember(String ip) {
        return this.ipMap.containsKey(ip);
    }

    public int getAvailableNodesCount() {
        return this.ipMap.size();
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isSameVersion(long version) {
        return this.version == version;
    }

    public boolean isSameVersion(IPMap rc) {
        return this.getVersion() == rc.getVersion();
    }

    public int getReason() {
        return this.reason;
    }

    public String toString() {
        return "version=" + this.version + " ipmap=" + this.ipMap + " wnetMap=" + this.wnetMap;
    }
}

