/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbsAutoReBalancer {
    private static final Logger LOGGER = Logger.getLogger(AbsAutoReBalancer.class.getName());
    private static final Long CONTEXT_NOT_REGISTERED = -1L;
    private static final Long SUCCESS = 1L;
    private static final Long FAILED = 0L;
    private static Map<String, AbsAutoReBalancer> contextMap = new ConcurrentHashMap<String, AbsAutoReBalancer>();
    private static Map<String, AtomicLong> contextLoadInfo = new ConcurrentHashMap<String, AtomicLong>();
    private static Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>> contextVsHits = new Hashtable();

    public abstract boolean rebalanceContext(Map<String, Object> var1, String var2) throws Exception;

    public static boolean register(String context, AbsAutoReBalancer instance) {
        try {
            contextMap.put(context, instance);
            contextLoadInfo.put(context, new AtomicLong(0L));
            contextVsHits.put(context, new Hashtable());
            LOGGER.info("ARB--> registered " + context);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ARB-->Exception while registerting context : " + context, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, Hashtable<String, Hashtable<String, Long>>> getHitsInfo(List<String> contextList) {
        Hashtable<String, Hashtable<String, Hashtable<String, Long>>> totalHits = new Hashtable<String, Hashtable<String, Hashtable<String, Long>>>();
        Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>> hashtable = contextVsHits;
        synchronized (hashtable) {
            LOGGER.info("ARB getHitsInfo --> contextList=" + contextList);
            for (String context : contextList) {
                Hashtable hitsCount = new Hashtable();
                Hashtable<String, Hashtable<String, AtomicLong>> hits = contextVsHits.get(context);
                for (String prd : hits.keySet()) {
                    for (String appServerIp : hits.get(prd).keySet()) {
                        hitsCount.putIfAbsent(prd, new Hashtable());
                        ((Hashtable)hitsCount.get(prd)).put(appServerIp, hits.get(prd).get(appServerIp).longValue());
                    }
                }
                totalHits.put(context, hitsCount);
                contextVsHits.put(context, new Hashtable());
            }
        }
        totalHits.put("machine-up-time", new Hashtable());
        ((Hashtable)totalHits.get("machine-up-time")).put(String.valueOf(DC.getMachineUpTime()), new Hashtable());
        LOGGER.info("ARB getHitsInfo --> totalHits=" + totalHits);
        return totalHits;
    }

    public static void addApiHits(String context, String prd, String remoteIp) {
        try {
            if (!CommonUtil.isEmpty((String)prd) && !CommonUtil.isEmpty((String)remoteIp) && contextVsHits.containsKey(context)) {
                Hashtable<String, Hashtable<String, AtomicLong>> apiHits = contextVsHits.get(context);
                apiHits.putIfAbsent(prd, new Hashtable());
                apiHits.get(prd).putIfAbsent(remoteIp, new AtomicLong(0L));
                apiHits.get(prd).get(remoteIp).incrementAndGet();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, Long> getLoadInfo(List<String> contextList) {
        HashMap<String, Long> data = new HashMap<String, Long>();
        for (String context : contextList) {
            data.put(context, AbsAutoReBalancer.getLoadInfo(context));
        }
        return data;
    }

    public static Long getLoadInfo(String context) {
        if (contextLoadInfo.containsKey(context)) {
            return contextLoadInfo.get(context).longValue();
        }
        return CONTEXT_NOT_REGISTERED;
    }

    public static void increment(String context) throws Exception {
        if (contextLoadInfo.get(context) == null) {
            throw new Exception("Context: " + context + " not registered");
        }
        contextLoadInfo.get(context).incrementAndGet();
    }

    public static void decrement(String context) throws Exception {
        if (contextLoadInfo.get(context) == null) {
            throw new Exception("Context: " + context + " not registered");
        }
        contextLoadInfo.get(context).decrementAndGet();
    }

    public static void set(String context, long value) throws Exception {
        if (contextLoadInfo.get(context) == null) {
            throw new Exception("Context: " + context + " not registered");
        }
        contextLoadInfo.get(context).set(value);
    }

    public static Map<String, Long> rebalance(Map<String, Map<String, Object>> rebalanceDetails) {
        LOGGER.info("ARB rebalance --> rebalanceDetails=" + rebalanceDetails);
        HashMap<String, Long> data = new HashMap<String, Long>();
        try {
            block2: for (String context : rebalanceDetails.keySet()) {
                int counter = 1;
                while (counter <= 3) {
                    if (contextMap.get(context).rebalanceContext(rebalanceDetails.get(context), context)) {
                        data.put(context, SUCCESS);
                        continue block2;
                    }
                    if (++counter <= 3) continue;
                    data.put(context, FAILED);
                    LOGGER.info("ARB-->failed to rebalance for context :" + context + " data : " + rebalanceDetails.get(context));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ARB-->Exception while rebalancing context for rebalancing.data : " + rebalanceDetails, e);
        }
        LOGGER.info("ARB rebalance --> data=" + data);
        return data;
    }
}

