/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.sqm.usages;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.components.sqm.usages.GFURTimeOutListener;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;

public class GFURDispatcher
extends Thread {
    public static final String GUR_DISPATCHER = "GUR_DISPATCHER";
    private static final int RECORD_SESSION = 1;
    private static final int SEND_GRP_SESSION_DATA = 2;
    private static WMSThreadPoolExecutor tpe;
    private static boolean isInitialized;

    static void init() {
        BufferedQueue bq = new BufferedQueue(ServerUtil.dataHome + "sqm", "gur", 1000, false);
        tpe = new WMSThreadPoolExecutor(GUR_DISPATCHER, 1, 5, 5L, TimeUnit.SECONDS, bq, new SQMDispatchHandler());
        isInitialized = true;
    }

    static void recordSession(Hashtable<String, String> sessionData) {
        if (isInitialized) {
            tpe.execute(new SQMDataDispatcher(1, sessionData));
        }
    }

    protected static void sendData() {
        if (isInitialized) {
            tpe.execute(new SQMDataDispatcher(2, null));
        }
    }

    static {
        isInitialized = false;
    }

    static class SQMDispatchHandler
    implements WmsTask {
        SQMDispatchHandler() {
        }

        @Override
        public void handle(Object obj) {
            SQMDataDispatcher dispatcher = (SQMDataDispatcher)obj;
            switch (dispatcher.processType) {
                case 1: {
                    GFURTimeOutListener.recordSession(dispatcher.dataMap);
                    break;
                }
                case 2: {
                    GFURTimeOutListener.sendDataToSQM();
                }
            }
        }
    }

    static class SQMDataDispatcher {
        private final int processType;
        private final Hashtable<String, String> dataMap;

        SQMDataDispatcher(int processType, Hashtable<String, String> dataMap) {
            this.processType = processType;
            this.dataMap = dataMap;
        }
    }
}

