/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.security;

import com.adventnet.wms.servercommon.components.security.CryptoAlgorithm;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class AESAlgorithm
extends CryptoAlgorithm {
    private static final Logger LOGGER = Logger.getLogger(AESAlgorithm.class.getName());
    private static int keySize = 128;
    private static int iterations = 65536;
    private static final String AES = "AES";
    private static final String CHARSETNAME = "UTF-8";
    private static final String SECRETKEY = "PBKDF2WithHmacSHA1";
    private static final String CIPHERKEY = "AES/CBC/PKCS5Padding";

    @Override
    public String encrypt(String passPhrase, String salt, String data) throws Exception {
        byte[] saltBytes = salt.getBytes();
        SecretKeyFactory skf = SecretKeyFactory.getInstance(SECRETKEY);
        PBEKeySpec spec = new PBEKeySpec(passPhrase.toCharArray(), saltBytes, iterations, keySize);
        SecretKey secretKey = skf.generateSecret(spec);
        SecretKeySpec secretSpec = new SecretKeySpec(secretKey.getEncoded(), AES);
        Cipher cipher = Cipher.getInstance(CIPHERKEY);
        cipher.init(1, secretSpec);
        AlgorithmParameters params = cipher.getParameters();
        byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
        int ivLength = ivBytes.length;
        byte[] encryptedTextBytes = cipher.doFinal(String.valueOf(data).getBytes(CHARSETNAME));
        ByteBuffer bb = ByteBuffer.allocate(ivBytes.length + encryptedTextBytes.length + 8);
        bb.put(ivBytes);
        bb.put(encryptedTextBytes);
        int rnd = AESAlgorithm.getRandom();
        bb.putInt(ivLength ^ rnd);
        bb.putInt(rnd);
        bb.flip();
        return DatatypeConverter.printBase64Binary((byte[])bb.array());
    }

    @Override
    public String decrypt(String passPhrase, String salt, String encryptedData) throws Exception {
        byte[] saltBytes = salt.getBytes();
        SecretKeyFactory skf = SecretKeyFactory.getInstance(SECRETKEY);
        PBEKeySpec spec = new PBEKeySpec(passPhrase.toCharArray(), saltBytes, iterations, keySize);
        SecretKey secretKey = skf.generateSecret(spec);
        byte[] rawdata = DatatypeConverter.parseBase64Binary((String)new String(encryptedData.getBytes(CHARSETNAME), CHARSETNAME));
        ByteBuffer bb = ByteBuffer.wrap(rawdata);
        bb.position(rawdata.length - 8);
        int ivLength = bb.getInt() ^ bb.getInt();
        bb.rewind();
        byte[] ivBytes = new byte[ivLength];
        bb.get(ivBytes);
        byte[] encryptedTextBytes = new byte[rawdata.length - 24];
        bb.get(encryptedTextBytes);
        SecretKeySpec secretSpec = new SecretKeySpec(secretKey.getEncoded(), AES);
        Cipher cipher = Cipher.getInstance(CIPHERKEY);
        cipher.init(2, (Key)secretSpec, new IvParameterSpec(ivBytes));
        byte[] decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
        return new String(decryptedTextBytes, CHARSETNAME);
    }

    private static int getRandom() throws Exception {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        return sr.nextInt();
    }
}

