/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.scn;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import com.adventnet.wms.servercommon.components.scn.CallBackListener;
import com.adventnet.wms.servercommon.components.scn.NotificationEngine;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class NotificationManager {
    private static Logger logger = Logger.getLogger(NotificationManager.class.getName());
    private String manager;
    private int maxCount;
    private int maxResponseCount;
    private ConcurrentHashMap<String, String> sentMap;
    private ConcurrentHashMap<String, NotificationEngine> nfeEngineMap = new ConcurrentHashMap();

    protected NotificationManager(String manager, int maxCount, int maxResponseCount, ConcurrentHashMap<String, String> sentMap) {
        this.manager = manager;
        this.sentMap = sentMap;
        this.maxCount = maxCount;
        this.maxResponseCount = maxResponseCount;
        logger.info("Nfe --> new NotificationManager started manager = " + this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startEngine(String engineName, int timeoutInSecs, int retryCount, CallBackListener listener) throws Exception {
        NotificationEngine engine = this.nfeEngineMap.get(engineName);
        if (engine == null) {
            ConcurrentHashMap<String, NotificationEngine> concurrentHashMap = this.nfeEngineMap;
            synchronized (concurrentHashMap) {
                engine = new NotificationEngine(this.manager, engineName, this.maxCount, this.maxResponseCount, listener, timeoutInSecs, retryCount, this.sentMap);
                this.nfeEngineMap.put(engineName, engine);
            }
        }
    }

    protected void sendCBNotification(WMSServiceCBEvent event) throws WMSException {
        String nfeEngine = event.getListener();
        if (!this.nfeEngineMap.containsKey(nfeEngine)) {
            throw new WMSException("Engine - " + nfeEngine + " is not registered");
        }
        this.nfeEngineMap.get(nfeEngine).sendCBNotification(event);
    }

    protected void updateResponse(String nfid, String nfeEngine) {
        if (this.nfeEngineMap.containsKey(nfeEngine)) {
            this.nfeEngineMap.get(nfeEngine).updateResponse(nfid);
        }
    }

    protected void updateResponse(WMSServiceCBEvent event) {
        String nfeEngine = event.getListener();
        if (this.nfeEngineMap.containsKey(nfeEngine)) {
            this.nfeEngineMap.get(nfeEngine).updateResponse(event);
        }
    }
}

