/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.scn;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import com.adventnet.wms.servercommon.components.scn.CallBackListener;
import com.adventnet.wms.servercommon.components.scn.NotificationManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class NotificationExecutorService {
    private static Logger logger = Logger.getLogger(NotificationExecutorService.class.getName());
    private static ConcurrentHashMap<String, NotificationManager> nfeManagerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> sentMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startEngine(String managerName, String engineName, int maxCount, int responseThreads, int timeoutInSecs, int retryCount, CallBackListener listener) throws Exception {
        NotificationManager manager = nfeManagerMap.get(managerName);
        if (manager == null) {
            ConcurrentHashMap<String, NotificationManager> concurrentHashMap = nfeManagerMap;
            synchronized (concurrentHashMap) {
                manager = new NotificationManager(managerName, maxCount, responseThreads, sentMap);
                nfeManagerMap.put(managerName, manager);
            }
        }
        manager.startEngine(engineName, timeoutInSecs, retryCount, listener);
    }

    public static void sendCBNotification(WMSServiceCBEvent event) throws WMSException {
        String manager = event.getCategory();
        if (!nfeManagerMap.containsKey(manager)) {
            throw new WMSException("manager - " + manager + " not registered");
        }
        nfeManagerMap.get(manager).sendCBNotification(event);
    }

    public static void updateResponse(String managerName, String engineName, String nfid) {
        if (nfeManagerMap.containsKey(managerName)) {
            nfeManagerMap.get(managerName).updateResponse(nfid, engineName);
        }
    }

    public static void updateResponse(WMSServiceCBEvent event) {
        String managerName = event.getCategory();
        if (nfeManagerMap.containsKey(managerName)) {
            nfeManagerMap.get(managerName).updateResponse(event);
        }
    }
}

