/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.scn;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.components.scn.CallBackListener;
import com.adventnet.wms.servercommon.components.scn.CallBackWCPListener;
import com.adventnet.wms.servercommon.components.scn.NotificationEngineTask;
import com.adventnet.wms.servercommon.dc.DC;
import java.io.File;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationEngine {
    private static Logger logger = Logger.getLogger(NotificationEngine.class.getName());
    private String manager;
    private String engine;
    private int dispatchCount;
    private int responseThreadsCount;
    private String serverip;
    private boolean isResponseEnabled = false;
    private int timeoutInSecs;
    private int maxRetryCount;
    private String cluster;
    private NotificationEngineTask task;
    private ConcurrentHashMap<String, PRDManager> prdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> sentMap;
    private BlockingQueue<Runnable> freePRDQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor executor;
    private BufferedQueue responseQueue;
    private WMSThreadPoolExecutor responseExecutor;
    private CallBackWCPListener cblistener;

    protected NotificationEngine(String manager, String engine, int dispatchCount, int responseThreads, CallBackListener listener, int timeoutInSecs, int retryCount, ConcurrentHashMap<String, String> sentMap) throws Exception {
        this.manager = manager;
        this.engine = engine;
        this.timeoutInSecs = timeoutInSecs;
        this.maxRetryCount = retryCount;
        this.dispatchCount = dispatchCount;
        this.responseThreadsCount = responseThreads;
        this.serverip = InetAddress.getLocalHost().getHostAddress();
        this.cluster = DC.getCluster();
        if (responseThreads > 0) {
            this.isResponseEnabled = true;
            this.responseQueue = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "nfe_api" + File.separator + manager + "-" + engine + File.separator + "response_tmp", "response", 1000, true);
            this.responseExecutor = new WMSThreadPoolExecutor("SCB/" + manager + "-" + engine + "-ResponseHandler", 1, this.responseThreadsCount, 30L, TimeUnit.SECONDS, this.responseQueue, new ResponseTask());
        }
        this.cblistener = new CallBackWCPListener(this.isResponseEnabled);
        this.sentMap = sentMap;
        this.executor = new ThreadPoolExecutor(1, dispatchCount, 30L, TimeUnit.SECONDS, this.freePRDQueue, new NotificationThreadFactory("SCB/" + manager + "-" + engine));
        this.task = new NFETask(listener);
        logger.info("Nfe --> new NotificationEngine started engine = " + engine + " manager = " + manager);
    }

    protected void sendCBNotification(WMSServiceCBEvent event) {
        String prd = event.getPrd();
        this.prdMap.putIfAbsent(prd, new PRDManager(prd));
        this.prdMap.get(prd).add(event);
    }

    protected void updateResponse(String nfid) {
        if (this.sentMap.containsKey(nfid)) {
            String prd = this.sentMap.remove(nfid);
            this.prdMap.putIfAbsent(prd, new PRDManager(prd));
            this.prdMap.get(prd).updateResponse();
        }
    }

    protected void updateResponse(WMSServiceCBEvent event) {
        String nfid = event.getNfid();
        if (this.sentMap.containsKey(nfid)) {
            String prd = this.sentMap.remove(nfid);
            this.prdMap.putIfAbsent(prd, new PRDManager(prd));
            this.prdMap.get(prd).updateResponse();
        }
        this.responseExecutor.execute(event);
    }

    private void dispatch(WMSServiceCBEvent event) {
        if (event.getRetryCount() != null) {
            event.setRetryCount(Integer.toString(Integer.parseInt(event.getRetryCount()) + 1));
        } else {
            event.setRetryCount("1");
        }
        event.setSourceIP(this.serverip);
        event.setSourceCluster(this.cluster);
        if (this.isResponseEnabled) {
            event.enableResponse();
        }
        WCPRequest wcpRequest = new WCPRequest("scn/sendcbtoals");
        wcpRequest.setTimeOut(this.timeoutInSecs);
        wcpRequest.addHeader("nfid", event.getNfid());
        wcpRequest.addHeader("category", this.manager);
        wcpRequest.addHeader("listener", this.engine);
        wcpRequest.setData(HttpDataWraper.getString((Object)event));
        try {
            WCPDispatcher.sendRequest("servicecb", wcpRequest, this.cblistener);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NFE_ERR --> Exception in NFE Dispatcher prd = " + event.getPrd() + " engine = " + this.engine + " manager = " + this.manager, e);
        }
    }

    private static String geNfid() {
        return UUID.randomUUID().toString();
    }

    private class ResponseTask
    implements WmsTask {
        private ResponseTask() {
        }

        @Override
        public void handle(Object object) {
            String responseCode;
            WMSServiceCBEvent event = (WMSServiceCBEvent)object;
            switch (responseCode = event.getResponseCode()) {
                case "200": {
                    NotificationEngine.this.task.handleSuccess(event);
                    break;
                }
                case "500": {
                    NotificationEngine.this.task.handleFailure(event);
                    break;
                }
                case "408": {
                    if (Integer.parseInt(event.getRetryCount()) > NotificationEngine.this.maxRetryCount) {
                        NotificationEngine.this.task.handleTimeOut(event);
                        break;
                    }
                    NotificationEngine.this.sendCBNotification(event);
                    break;
                }
                case "501": {
                    ((NFETask)NotificationEngine.this.task).handleNoRegisteration(event);
                }
            }
        }
    }

    private class NFETask
    implements NotificationEngineTask {
        private CallBackListener listener;

        public NFETask(CallBackListener listener) {
            this.listener = listener;
        }

        @Override
        public boolean handle(WMSServiceCBEvent event) {
            return this.listener.preProcess(event);
        }

        @Override
        public void handleSuccess(WMSServiceCBEvent event) {
            this.listener.onSuccess(event, event.getResponseData());
        }

        @Override
        public void handleFailure(WMSServiceCBEvent event) {
            this.listener.onFailure(event);
        }

        @Override
        public void handleTimeOut(WMSServiceCBEvent event) {
            this.listener.onTimeout(event);
        }

        public void handleNoRegisteration(WMSServiceCBEvent event) {
            this.listener.onNoCBRegistered(event);
        }
    }

    private class NotificationThreadFactory
    implements ThreadFactory {
        private int counter = 0;
        private String prefix = "";

        public NotificationThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix + "-" + this.counter++);
        }
    }

    private class DispatchHandler
    implements Runnable {
        private String prd;

        DispatchHandler(String prd) {
            this.prd = prd;
        }

        @Override
        public void run() {
            try {
                PRDManager prdManager = (PRDManager)NotificationEngine.this.prdMap.get(this.prd);
                WMSServiceCBEvent event = prdManager.getEvent();
                if (event != null) {
                    String nfid = NotificationEngine.geNfid();
                    event.setNfid(nfid);
                    if (NotificationEngine.this.task.handle(event)) {
                        NotificationEngine.this.sentMap.put(nfid, this.prd);
                    }
                    NotificationEngine.this.dispatch(event);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "NFE_ERR --> Exception in NFE Dispatcher prd = " + this.prd + " engine = " + NotificationEngine.this.engine + " manager = " + NotificationEngine.this.manager, e);
            }
        }
    }

    private class PRDManager {
        private String prd;
        private AtomicInteger dispatchedCount = new AtomicInteger();
        private BufferedQueue prdDispatchQueue;

        PRDManager(String prd) {
            this.prd = prd;
            this.prdDispatchQueue = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "nfe_api" + File.separator + NotificationEngine.this.manager + "-" + NotificationEngine.this.engine + File.separator + prd + "_tmp", prd, 1000, true);
        }

        void add(WMSServiceCBEvent event) {
            this.prdDispatchQueue.add(event);
            if (this.dispatchedCount.get() < NotificationEngine.this.dispatchCount) {
                NotificationEngine.this.executor.execute(new DispatchHandler(this.prd));
                this.dispatchedCount.incrementAndGet();
            }
        }

        void updateResponse() {
            if (!this.prdDispatchQueue.isEmpty()) {
                NotificationEngine.this.executor.execute(new DispatchHandler(this.prd));
            } else {
                this.dispatchedCount.decrementAndGet();
            }
        }

        WMSServiceCBEvent getEvent() {
            WMSServiceCBEvent event = (WMSServiceCBEvent)this.prdDispatchQueue.get(5);
            if (event == null) {
                this.updateResponse();
            }
            return event;
        }
    }
}

