/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue.ar;

import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketFactory;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.util.HashMap;
import java.util.logging.Logger;

public class BQAckConnection {
    private static final Logger LOGGER = Logger.getLogger(BQAckConnection.class.getName());
    private WebSocket ws;
    private WebSocketHandler wsHandler = null;
    private String sockurl;
    private HashMap<String, String> headers;
    private boolean isInitialised = false;

    public void init(String wnet, WebSocketHandler wsHandler, boolean reInitialize) throws WMSCommunicationException {
        this.init(wnet, null, wsHandler, reInitialize);
    }

    public void init(String wnet, HashMap<String, String> headers, WebSocketHandler wsHandler, boolean reInitialize) throws WMSCommunicationException {
        try {
            if (!this.isInitialised || reInitialize) {
                if (wnet == null) {
                    throw new Exception("NS--> QOS Connecting url is null. Unable to establish connection.");
                }
                this.wsHandler = wsHandler;
                this.sockurl = "ws://" + wnet + "/grid/bqack";
                this.ws = WebSocketFactory.createSocket((String)this.sockurl, (boolean)true);
                if (headers != null && !headers.isEmpty()) {
                    this.headers = headers;
                    this.ws.addHeaders(headers);
                }
                this.ws.setHandler(this.wsHandler);
                this.ws.connect();
                this.isInitialised = true;
            } else {
                LOGGER.info("HB--> BQARConnection is already initialised. ");
            }
        }
        catch (Exception e) {
            LOGGER.severe("NS--> Exception while initializing QOSClient. Exception: " + e.getMessage());
            this.isInitialised = false;
        }
    }

    public void reconnect() throws WMSCommunicationException {
        this.ws = WebSocketFactory.createSocket((String)this.sockurl);
        if (this.headers != null && !this.headers.isEmpty()) {
            this.ws.addHeaders(this.headers);
        }
        this.ws.setHandler(this.wsHandler);
        this.ws.connect();
    }

    public void write(byte[] data) throws WMSCommunicationException {
        this.ws.writeBinary(data);
    }

    public void close() {
        this.ws.close();
    }
}

