/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import com.adventnet.wms.common.util.CommonWMSUtil;
import java.io.Serializable;

public class CircularList
implements Serializable {
    private int qSize;
    private Object[] objs;
    private boolean flip;
    private int tail;
    private int head;

    public CircularList(int qSize) {
        this.qSize = qSize;
        this.objs = new Object[qSize];
        this.tail = 0;
        this.head = 0;
        this.flip = false;
    }

    public boolean put(Object obj) {
        if (!this.isFull()) {
            this.objs[this.head] = obj;
            ++this.head;
            if (this.head == this.qSize) {
                this.head = 0;
                this.flip = true;
            }
            return true;
        }
        return false;
    }

    public Object take() {
        if (!this.isEmpty()) {
            Object data = this.objs[this.tail];
            this.objs[this.tail] = null;
            ++this.tail;
            if (this.tail == this.qSize) {
                this.tail = 0;
                this.flip = false;
            }
            return data;
        }
        return null;
    }

    public Object poll() {
        if (!this.isEmpty()) {
            Object data = this.objs[this.tail];
            ++this.tail;
            if (this.tail == this.qSize) {
                this.tail = 0;
                this.flip = false;
            }
            return data;
        }
        return null;
    }

    public Object peek() {
        if (!this.isEmpty()) {
            Object data = this.objs[this.tail];
            return data;
        }
        return null;
    }

    public int size() {
        if (!this.flip) {
            return this.head - this.tail;
        }
        return this.qSize - Math.abs(this.head - this.tail);
    }

    public boolean isFull() {
        return this.head == this.tail && this.flip;
    }

    public boolean isEmpty() {
        return this.head == this.tail && !this.flip;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.qSize; ++i) {
            this.objs[i] = null;
        }
    }

    public int removeAllUnSerializableElements() {
        int unSerializableElements = 0;
        for (int i = 0; i < this.qSize; ++i) {
            if (this.objs[i] == null || CommonWMSUtil.isSerializable((Object)this.objs[i])) continue;
            this.objs[i] = null;
            ++unSerializableElements;
        }
        return unSerializableElements;
    }

    public void resetRing() {
        this.tail = 0;
        this.head = 0;
        this.flip = false;
    }

    public void setRingPositions(int head, int tail, boolean flip) {
        this.head = head;
        this.tail = tail;
        this.flip = flip;
    }

    public Object[] getQueue() {
        return this.objs;
    }

    public int getHead() {
        return this.head;
    }

    public int getTail() {
        return this.tail;
    }

    public boolean getFlip() {
        return this.flip;
    }

    public void setHead(int head) {
        this.head = head;
    }

    public void setTail(int tail) {
        this.tail = tail;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }
}

