/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.executor.StatusCollector;
import com.adventnet.wms.servercommon.components.queue.BQARModule;
import com.adventnet.wms.servercommon.components.queue.BQPacket;
import com.adventnet.wms.servercommon.components.queue.BQPacketStat;
import com.adventnet.wms.servercommon.components.queue.BQPacketizer;
import com.adventnet.wms.servercommon.components.queue.BQStatusCollector;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.components.queue.ar.BQAckConnection;
import com.adventnet.wms.servercommon.components.queue.ar.BQAckWSHandler;
import com.adventnet.wms.servercommon.components.queue.ar.BQDTConnection;
import com.adventnet.wms.servercommon.components.queue.ar.BQWSHandler;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.FileUtil;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BQInventory {
    private static final Logger LOGGER = Logger.getLogger(BQInventory.class.getName());
    private static Map<String, BufferedQueue> bqInventoryMap = new ConcurrentHashMap<String, BufferedQueue>();
    private static Hashtable<String, BQPacketStat> bqARInventory = new Hashtable();
    private static Hashtable<String, BQPacketStat> bqARSuccessAckMap = new Hashtable();
    private static Hashtable<String, BQPacketStat> bqARErrorAckMap = new Hashtable();
    private static String wnet = null;
    private static LinkedBlockingQueue<String> bqPacketWriterBLQ = null;
    private static LinkedBlockingQueue<String> bqAckPacketWriterLBQ = new LinkedBlockingQueue();
    private static ArrayList<Thread> bqAckWriterThreads = new ArrayList();
    private static Map<String, String> bqPacketWriterThreadInventory = new ConcurrentHashMap<String, String>();
    private static Hashtable<String, AtomicLong> threadPacketCount = new Hashtable();
    private static LinkedBlockingQueue<Runnable> bqPacketReaderBLQ = new LinkedBlockingQueue();
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(50, 100, 1L, TimeUnit.SECONDS, bqPacketReaderBLQ);
    private static ARModule arModule = null;
    private static final long MAXIMUM_IN_MEMORY = 350000L;
    private static long totalFilesCount = 0L;
    private static long totalDataSize = 0L;
    private static AtomicLong totalAckReceived = new AtomicLong(0L);
    private static AtomicLong totalAckReceivedTime = new AtomicLong(0L);
    private static AtomicLong inCount = new AtomicLong(0L);
    private static AtomicLong outCount = new AtomicLong(0L);
    private static AtomicLong writeCount = new AtomicLong(0L);
    private static AtomicLong totalDataSizeSent = new AtomicLong(0L);
    private static Semaphore semaphore = null;
    private static final ReentrantLock ACK_LOCK = new ReentrantLock();
    private static final Condition ACK_AVAILABLE = ACK_LOCK.newCondition();
    private static boolean isBQStatsRegistered = false;
    private static boolean isARInProgress = false;
    private static String arProgress = "Yet to start";

    public static void register(BufferedQueue bq) {
        bqInventoryMap.put(bq.getFilePath() + "/" + bq.getFileName(), bq);
    }

    public static void unRegister(BufferedQueue bq) {
        bqInventoryMap.remove(bq.getFilePath() + "/" + bq.getFileName());
    }

    public static void createBQAckConnection() {
        try {
            for (int i = 1; i <= 20; ++i) {
                bqAckWriterThreads.add(new BQAckPacketWriter(bqAckPacketWriterLBQ, i));
                bqAckWriterThreads.get(i - 1).start();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "HB--> Error while creating BQACKWriter Threads", e);
        }
    }

    public static int interruptBqAckWriterThreads() {
        int count = 0;
        for (Thread t : bqAckWriterThreads) {
            try {
                t.interrupt();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "HB--> Error while interrupting BQACKWriterThread", e);
                continue;
            }
            ++count;
        }
        return count;
    }

    public static boolean initiateAR(String wnet, int threadCount, BQARModule arModule) throws Exception {
        if (threadCount > 0) {
            int semaphorePermits;
            isARInProgress = true;
            arProgress = "BQAR initiated";
            BQInventory.clear();
            if (!isBQStatsRegistered) {
                BQInventory.addBQARInfluxStats();
            }
            try {
                semaphorePermits = (int)(350000L / (BQInventory.getTotalSize() / 1000L / BQInventory.getTotalFilesCount()));
                if (semaphorePermits > 1000) {
                    semaphorePermits = 1000;
                }
            }
            catch (Exception e) {
                semaphorePermits = threadCount;
            }
            semaphore = new Semaphore(semaphorePermits);
            BQInventory.arModule = arModule;
            BQInventory.wnet = wnet;
            bqPacketWriterBLQ = new LinkedBlockingQueue();
            for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
                int count = 0;
                BufferedQueue bq = entry.getValue();
                if (bq.isAREnabled()) {
                    bq.close();
                    File fileDir = new File(bq.getFilePath());
                    File[] listOfFiles = fileDir.listFiles();
                    if (listOfFiles != null) {
                        for (File file : listOfFiles) {
                            if (file.isDirectory()) {
                                LOGGER.warning("BQWARN--> File is a directory; Hence skipping; file=" + file.toString());
                                continue;
                            }
                            if (bqARInventory.containsKey(file.toString())) {
                                LOGGER.warning("BQWARN--> File is has been already added; Hence skipping; file=" + file.toString());
                                continue;
                            }
                            bqPacketWriterBLQ.add(file.toString());
                            BQPacketStat bqps = new BQPacketStat();
                            bqps.setStartTime(System.currentTimeMillis());
                            bqARInventory.put(file.toString(), bqps);
                            ++count;
                        }
                    }
                    LOGGER.info("NSAR--> queue = " + bq.getFilePath() + " filecount = " + count);
                    continue;
                }
                LOGGER.info("NSAR--> AR disabled for queue = " + entry.getKey());
            }
            totalDataSize = BQInventory.getTotalSize();
            totalFilesCount = bqARInventory.size();
            if (bqPacketWriterBLQ.isEmpty()) {
                LOGGER.info("HBAR--> No bq files found with AR enabled");
                ARManager.updateStatus(arModule, 200, " No BQ files found ");
                return true;
            }
            for (int i = 1; i <= threadCount; ++i) {
                new Thread(new BQPacketWriter(bqPacketWriterBLQ, i)).start();
                bqPacketWriterThreadInventory.put("BQDT-" + i, "");
            }
            LOGGER.info("NSAR--> BQPacketWriter started successfully. threadCount=" + threadCount + " totalfilesCount=" + totalFilesCount);
            arProgress = "BQPacket transmission started";
            return true;
        }
        return false;
    }

    public static void abortAR() {
        int count = 0;
        for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
            BufferedQueue bq = entry.getValue();
            if (!bq.isAREnabled()) continue;
            bq.open();
            ++count;
        }
        LOGGER.info("BQAR--> Inside AbortAR; re-opened BQ's Count=" + count);
    }

    public static int shutDown() {
        int count = 0;
        try {
            for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
                BufferedQueue bq = entry.getValue();
                bq.close();
                ++count;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while closing BufferedQueues. ", e);
        }
        LOGGER.info("BufferedQueue ShutDown--> Closed BQ Count=" + count);
        return count;
    }

    public static int reopen() {
        int count = 0;
        try {
            for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
                BufferedQueue bq = entry.getValue();
                bq.open();
                ++count;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while ReOpening BufferedQueues. ", e);
        }
        LOGGER.info("BufferedQueue reopen--> reopened BQ Count=" + count);
        return count;
    }

    public static String getWnet() {
        return wnet;
    }

    public static void addBQPacket(byte[] data) {
        if (!isBQStatsRegistered) {
            BQInventory.addBQARInfluxStats();
        }
        if (data != null) {
            tpe.execute(new BQPacketReader(data));
            inCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBQAck(Hashtable<String, String> writeStatus) {
        String filePath = writeStatus.get("filepath");
        BQPacketStat bqps = bqARInventory.remove(filePath);
        if (bqps == null) {
            LOGGER.warning("BQWARN--> BQPacketStat is empty for filePath=" + filePath + "; Hence skipping writeStatus update;; writeStatus=" + writeStatus);
            return;
        }
        threadPacketCount.get(bqps.getWorkerThreadName()).decrementAndGet();
        semaphore.release();
        boolean status = Boolean.parseBoolean(writeStatus.get("writestatus"));
        if (!status) {
            try {
                bqps.setErrorCode(Integer.parseInt(writeStatus.get("errorcode")));
            }
            catch (Exception e) {
                bqps.setErrorCode(-2);
            }
            bqps.setErrorMsg(writeStatus.get("errormsg"));
            bqARErrorAckMap.put(filePath, bqps);
            return;
        }
        bqps.setAckTime(System.currentTimeMillis() - bqps.getStartTime());
        long transferTime = System.currentTimeMillis() - bqps.getTransferStartTime();
        bqps.setTransferTime(transferTime);
        bqARSuccessAckMap.put(filePath, bqps);
        totalAckReceived.incrementAndGet();
        totalAckReceivedTime.addAndGet(transferTime);
        StatsDB.addData("bqarstats", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), filePath, 0, 1, 0, 0, transferTime, 0, 0);
        ACK_LOCK.lock();
        try {
            if (bqARInventory.isEmpty()) {
                ACK_AVAILABLE.signal();
            }
        }
        finally {
            ACK_LOCK.unlock();
        }
    }

    public static LinkedHashMap<String, Object> getStatus() {
        int arCount = 0;
        int backlogCount = 0;
        int zerodataCount = 0;
        LinkedHashMap<String, Object> bufferedQueueStatus = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
            if (entry.getValue().isAREnabled()) {
                ++arCount;
            }
            if (entry.getValue().isOverFlowed()) {
                ++backlogCount;
            }
            if (entry.getValue().size() != 0) continue;
            ++zerodataCount;
        }
        bufferedQueueStatus.put("Number of BQs", bqInventoryMap.size());
        bufferedQueueStatus.put("No. of AR Enabled BQs", arCount);
        bufferedQueueStatus.put("Number of BQs with Backlog", backlogCount);
        bufferedQueueStatus.put("Number of BQs with Zero Data", zerodataCount);
        ArrayList bufferedQueueStatusOrder = new ArrayList(bufferedQueueStatus.keySet());
        bufferedQueueStatus.put("_order", bufferedQueueStatusOrder);
        return bufferedQueueStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> bufferedQueueStatus = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
            bufferedQueueStatus.put(entry.getKey(), entry.getValue().getDetailedStatus());
        }
        return bufferedQueueStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus(String fileName) {
        if (!bqInventoryMap.containsKey(fileName)) {
            LinkedHashMap<String, Object> errorStatus = new LinkedHashMap<String, Object>();
            errorStatus.put("Error", "Invalid Buffered Queue Name");
            return errorStatus;
        }
        return bqInventoryMap.get(fileName).getDetailedStatus();
    }

    public static void clear() {
        bqARSuccessAckMap = new Hashtable();
        bqARErrorAckMap = new Hashtable();
        bqARInventory = new Hashtable();
        wnet = null;
        bqPacketWriterBLQ = null;
        bqPacketWriterThreadInventory = new ConcurrentHashMap<String, String>();
        bqPacketReaderBLQ = new LinkedBlockingQueue();
        tpe = new ThreadPoolExecutor(50, 100, 1L, TimeUnit.SECONDS, bqPacketReaderBLQ);
        arModule = null;
        inCount = new AtomicLong(0L);
        outCount = new AtomicLong(0L);
        writeCount = new AtomicLong(0L);
        totalDataSizeSent = new AtomicLong(0L);
        totalAckReceived = new AtomicLong(0L);
        totalAckReceivedTime = new AtomicLong(0L);
    }

    public static long getTotalSize() {
        long size = 0L;
        for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
            BufferedQueue bq = entry.getValue();
            if (!bq.isAREnabled()) continue;
            String filePath = bq.getFilePath();
            File directory = new File(filePath);
            size += FileUtil.getDirSize(directory);
        }
        return size;
    }

    public static long getTotalFilesCount() {
        long count = 0L;
        for (Map.Entry<String, BufferedQueue> entry : bqInventoryMap.entrySet()) {
            BufferedQueue bq = entry.getValue();
            if (!bq.isAREnabled()) continue;
            String filePath = bq.getFilePath();
            File directory = new File(filePath);
            count += (long)FileUtil.getFilesCount(directory);
        }
        return count;
    }

    public static Map<String, String> getARProgress() {
        HashMap<String, String> arMap = new HashMap<String, String>();
        if (isARInProgress) {
            if (totalFilesCount == 0L) {
                BQInventory.getTotalFilesCount();
            }
            try {
                arMap.put("Progress", Long.toString(100L * totalAckReceived.get() / totalFilesCount));
                if (arProgress.equals("BQPacket transmission started")) {
                    arMap.put("Title", totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transfered ");
                } else {
                    arMap.put("Title", arProgress);
                }
            }
            catch (Exception e) {
                arMap.put("Progress", "100");
                arMap.put("Title", arProgress);
            }
        }
        return arMap;
    }

    protected static Hashtable<String, Object> getARStatus() {
        Hashtable<String, Object> arStatus = new Hashtable<String, Object>();
        if (totalFilesCount == 0L) {
            BQInventory.getTotalFilesCount();
        }
        arStatus.put("Total Files count", totalFilesCount);
        arStatus.put("Total Files Sent", outCount.get());
        arStatus.put("Ack count for Files Sent", totalAckReceived.get());
        arStatus.put("BQ AR Inventory", bqARInventory);
        arStatus.put("BQ AR Error Map", bqARErrorAckMap);
        if (totalDataSize == 0L) {
            BQInventory.getTotalSize();
        }
        arStatus.put("Total Memory Size", WMSUtil.HumanReadable.getMemSize(totalDataSize));
        arStatus.put("Total Memory Sent", WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()));
        try {
            arStatus.put("Transfer Percentage", 100L * totalAckReceived.get() / totalFilesCount);
        }
        catch (Exception e) {
            arStatus.put("Transfer Percentage", 100);
        }
        return arStatus;
    }

    protected static Hashtable<String, Object> getDetailedARStatus() {
        Hashtable<String, Object> arStatus = new Hashtable<String, Object>();
        if (totalFilesCount == 0L) {
            BQInventory.getTotalFilesCount();
        }
        arStatus.put("Total Files count", totalFilesCount);
        arStatus.put("Total Files Sent", outCount.get());
        arStatus.put("Ack count for Files Sent", totalAckReceived.get());
        arStatus.put("BQ AR Inventory", bqARInventory);
        arStatus.put("BQ AR Error Map", bqARErrorAckMap);
        if (totalDataSize == 0L) {
            BQInventory.getTotalSize();
        }
        arStatus.put("Total Memory Size", WMSUtil.HumanReadable.getMemSize(totalDataSize));
        arStatus.put("Total Memory Sent", WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()));
        try {
            arStatus.put("Transfer Percentage", 100L * totalAckReceived.get() / totalFilesCount);
        }
        catch (Exception e) {
            arStatus.put("Transfer Percentage", 100);
        }
        arStatus.put("Total ack recived", totalAckReceived.get());
        try {
            arStatus.put("per File transfer Time", WMSUtil.HumanReadable.getDuration(totalAckReceivedTime.get() / totalAckReceived.get()));
        }
        catch (Exception e) {
            // empty catch block
        }
        Hashtable<String, String> errStatus = new Hashtable<String, String>();
        for (String filePath : bqARErrorAckMap.keySet()) {
            errStatus.put(filePath, bqARErrorAckMap.get(filePath).getErrorMsg());
        }
        if (errStatus.size() == 0) {
            arStatus.put("Error", "Nil");
        } else {
            arStatus.put("Error", errStatus);
        }
        return arStatus;
    }

    private static void addBQARInfluxStats() {
        Hashtable<String, String> defs = new Hashtable<String, String>();
        defs.put("bqarstats", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"bqarstats\",false,,,,2000],[\"servertype\",\"cluster\",\"destinationip\",\"versionid\"],[\"filename\"],[\"sentfiles\",\"ackreceivedfiles\",\"sentdatasize\",\"receiveddatasize\",\"transfertime\",\"receivedfiles\",\"acksent\"]]");
        defs.put("bqarstatus", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"bqarstatus\",false],[\"servertype\",\"cluster\",\"destinationip\",\"versionid\"],[],[\"sentfiles\",\"sentdatasize\",\"acksmissing\",\"erroracks\"]]");
        if (StatsConf.loadStatsKeyDef(defs)) {
            StatsDB.initialize();
        }
        isBQStatsRegistered = true;
    }

    static {
        StatusCollector.register(new BQStatusCollector());
    }

    private static class BQPacketReader
    implements Runnable {
        byte[] data = null;
        Hashtable<String, String> ackstat;

        public BQPacketReader(byte[] data) {
            this.data = data;
            this.ackstat = new Hashtable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String filePath = null;
            Boolean writeStatus = false;
            try {
                BQPacket bqpacket = BQPacketizer.getDataFromPacket(this.data);
                filePath = new String(bqpacket.getFilePathData(), "UTF-8");
                this.ackstat.put("filepath", filePath);
                File file = new File(filePath);
                StatsDB.addData("bqarstats", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), filePath, 0, 0, 0, this.data.length, 0, 1, 0);
                writeStatus = FileUtil.writeAllBytes(bqpacket.getData(), file);
                if (!writeStatus.booleanValue()) {
                    this.ackstat.put("errorcode", "0");
                    this.ackstat.put("errormsg", "IOException while writing in file");
                }
                writeCount.incrementAndGet();
            }
            catch (Exception e) {
                this.ackstat.put("errorcode", "1");
                this.ackstat.put("errormsg", e.getMessage());
                LOGGER.log(Level.SEVERE, "NS--> Error inside BQPacketReader inside BQInventory filePath=" + filePath, e);
            }
            finally {
                try {
                    this.ackstat.put("writestatus", "" + writeStatus);
                    this.ackstat.put("attempt", "1");
                    bqAckPacketWriterLBQ.add(HttpDataWraper.getString(this.ackstat));
                    LOGGER.info("VS --> Send ack for file = " + filePath);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NS--> Error while sending error-ack in finally-BQPacketReader. filePath=" + filePath, e);
                }
            }
        }
    }

    private static class BQPacketWriter
    implements Runnable {
        int threadID = -1;
        String threadName = null;
        BQDTConnection conn = null;
        LinkedBlockingQueue<String> lbq = null;

        public BQPacketWriter(LinkedBlockingQueue<String> lbq, int threadID) {
            this.lbq = lbq;
            this.threadID = threadID;
            this.threadName = "BQDT-" + threadID;
            Thread.currentThread().setName(this.threadName);
            threadPacketCount.put(this.threadName, new AtomicLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            try {
                String filePath;
                this.conn = new BQDTConnection();
                this.conn.init(BQInventory.getWnet(), new BQWSHandler(), false);
                while ((filePath = this.lbq.poll(100L, TimeUnit.MILLISECONDS)) != null || !this.lbq.isEmpty()) {
                    long st = System.currentTimeMillis();
                    File file = new File(filePath);
                    byte[] data = FileUtil.readAllBytes(file);
                    totalDataSizeSent.addAndGet(file.length());
                    BQPacketStat bqps = (BQPacketStat)bqARInventory.get(filePath);
                    bqps.setFileLoadTime(System.currentTimeMillis() - st);
                    bqps.setFileSize(data.length);
                    BQPacket bqpacket = BQPacketizer.getPacketFromData(System.currentTimeMillis(), 0L, filePath, data);
                    if (bqpacket == null) {
                        LOGGER.info("NS--> BQPacket is null " + filePath);
                        continue;
                    }
                    data = bqpacket.getCompletePacketData();
                    if (data == null) {
                        LOGGER.info("NS--> BQCompletePacket is null " + filePath);
                        continue;
                    }
                    semaphore.acquire();
                    bqps.setTransferStartTime(System.currentTimeMillis());
                    this.conn.write(data);
                    outCount.incrementAndGet();
                    bqps.setWorkerThreadName(this.threadName);
                    ((AtomicLong)threadPacketCount.get(this.threadName)).incrementAndGet();
                    StatsDB.addData("bqarstats", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), filePath, 1, 0, data.length, 0, 0, 0, 0);
                }
                bqPacketWriterThreadInventory.remove(this.threadName);
            }
            catch (Exception e) {
                try {
                    LOGGER.log(Level.SEVERE, "NS--> Error inside BQPacketWriter thread id=" + this.threadID, e);
                    bqPacketWriterThreadInventory.remove(this.threadName);
                }
                catch (Throwable throwable) {
                    bqPacketWriterThreadInventory.remove(this.threadName);
                    if (bqPacketWriterThreadInventory.isEmpty()) {
                        ACK_LOCK.lock();
                        try {
                            int retryCount = 0;
                            do {
                                if (bqARInventory.isEmpty()) {
                                    break;
                                }
                                ACK_AVAILABLE.await(3L, TimeUnit.SECONDS);
                            } while (++retryCount <= 5);
                        }
                        catch (Exception e2) {
                            LOGGER.log(Level.SEVERE, "HB--> Error while ackLock-await, 30sec", e2);
                        }
                        finally {
                            ACK_LOCK.unlock();
                        }
                        if (bqARErrorAckMap.isEmpty() && bqARInventory.isEmpty()) {
                            try {
                                ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                            }
                            catch (Exception e3) {
                                LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e3);
                            }
                        } else {
                            LOGGER.severe("NSERR--> Un-Acked BQ's: " + bqARInventory.size() + " Ack with Error: " + bqARErrorAckMap + " Un-Acked BQ's " + bqARInventory.keySet());
                            try {
                                ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                            }
                            catch (Exception e4) {
                                LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e4);
                            }
                        }
                        arProgress = "BQAR completed";
                        isARInProgress = false;
                        LOGGER.info("NSAR--> BQ Files written count=" + outCount.get() + " Total Data Size Transfered = " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + " Raw Size: " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()));
                        StatsDB.addData("bqarstatus", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), totalFilesCount, totalDataSize, bqARInventory.size(), bqARErrorAckMap.size());
                    }
                    int counter = 0;
                    while (((AtomicLong)threadPacketCount.get(this.threadName)).get() != 0L && counter++ <= 20) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e5) {
                            LOGGER.fine("NS--> Thread Interrupted ");
                        }
                    }
                    this.conn.close();
                    LOGGER.info(this.threadName + " ended, Time Taken = " + (System.currentTimeMillis() - startTime) + "ms");
                    throw throwable;
                }
                if (bqPacketWriterThreadInventory.isEmpty()) {
                    ACK_LOCK.lock();
                    try {
                        int retryCount = 0;
                        do {
                            if (bqARInventory.isEmpty()) {
                                break;
                            }
                            ACK_AVAILABLE.await(3L, TimeUnit.SECONDS);
                        } while (++retryCount <= 5);
                    }
                    catch (Exception e6) {
                        LOGGER.log(Level.SEVERE, "HB--> Error while ackLock-await, 30sec", e6);
                    }
                    finally {
                        ACK_LOCK.unlock();
                    }
                    if (bqARErrorAckMap.isEmpty() && bqARInventory.isEmpty()) {
                        try {
                            ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                        }
                        catch (Exception e7) {
                            LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e7);
                        }
                    } else {
                        LOGGER.severe("NSERR--> Un-Acked BQ's: " + bqARInventory.size() + " Ack with Error: " + bqARErrorAckMap + " Un-Acked BQ's " + bqARInventory.keySet());
                        try {
                            ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                        }
                        catch (Exception e8) {
                            LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e8);
                        }
                    }
                    arProgress = "BQAR completed";
                    isARInProgress = false;
                    LOGGER.info("NSAR--> BQ Files written count=" + outCount.get() + " Total Data Size Transfered = " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + " Raw Size: " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()));
                    StatsDB.addData("bqarstatus", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), totalFilesCount, totalDataSize, bqARInventory.size(), bqARErrorAckMap.size());
                }
                int counter = 0;
                while (((AtomicLong)threadPacketCount.get(this.threadName)).get() != 0L && counter++ <= 20) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e9) {
                        LOGGER.fine("NS--> Thread Interrupted ");
                    }
                }
                this.conn.close();
                LOGGER.info(this.threadName + " ended, Time Taken = " + (System.currentTimeMillis() - startTime) + "ms");
            }
            if (bqPacketWriterThreadInventory.isEmpty()) {
                ACK_LOCK.lock();
                try {
                    int retryCount = 0;
                    do {
                        if (bqARInventory.isEmpty()) {
                            break;
                        }
                        ACK_AVAILABLE.await(3L, TimeUnit.SECONDS);
                    } while (++retryCount <= 5);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "HB--> Error while ackLock-await, 30sec", e);
                }
                finally {
                    ACK_LOCK.unlock();
                }
                if (bqARErrorAckMap.isEmpty() && bqARInventory.isEmpty()) {
                    try {
                        ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e);
                    }
                } else {
                    LOGGER.severe("NSERR--> Un-Acked BQ's: " + bqARInventory.size() + " Ack with Error: " + bqARErrorAckMap + " Un-Acked BQ's " + bqARInventory.keySet());
                    try {
                        ARManager.updateStatus(arModule, 200, totalAckReceived.get() + "/" + totalFilesCount + " files (" + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + ") Transferred ");
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "NS--> Exception while calling updateStatus inside BQInventory", e);
                    }
                }
                arProgress = "BQAR completed";
                isARInProgress = false;
                LOGGER.info("NSAR--> BQ Files written count=" + outCount.get() + " Total Data Size Transfered = " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()) + " Raw Size: " + WMSUtil.HumanReadable.getMemSize(totalDataSizeSent.get()));
                StatsDB.addData("bqarstatus", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), totalFilesCount, totalDataSize, bqARInventory.size(), bqARErrorAckMap.size());
            }
            int counter = 0;
            while (((AtomicLong)threadPacketCount.get(this.threadName)).get() != 0L && counter++ <= 20) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.fine("NS--> Thread Interrupted ");
                }
            }
            this.conn.close();
            LOGGER.info(this.threadName + " ended, Time Taken = " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    private static class BQAckPacketWriter
    extends Thread {
        int threadID = -1;
        String threadName = null;
        BQAckConnection bqAckConn = null;
        LinkedBlockingQueue<String> lbq = null;

        public BQAckPacketWriter(LinkedBlockingQueue<String> lbq, int threadID) {
            this.lbq = lbq;
            this.threadID = threadID;
            this.threadName = "BQAck-" + threadID;
            Thread.currentThread().setName(this.threadName);
        }

        @Override
        public void run() {
            try {
                this.bqAckConn = new BQAckConnection();
                this.bqAckConn.init(ARManager.getARIp() + ":" + ARManager.getGACPort(), new BQAckWSHandler(), false);
                LOGGER.info("HB--> bqack connection created successfully - threadName=" + this.threadName);
                while (true) {
                    String ackFile;
                    if ((ackFile = this.lbq.take()) == null && this.lbq.isEmpty()) {
                        LOGGER.info("BQARDEBUG--> ackQueue is empty.");
                        break;
                    }
                    StatsDB.addData("bqarstats", DC.getServertype(), DC.getCluster(), ARManager.getARIp(), ARManager.getVersion(), ackFile, 0, 0, 0, 0, 0, 0, 1);
                    LOGGER.info("BQARDEBUG--> sending ackPacket. file=" + ackFile);
                    this.bqAckConn.write(ackFile.getBytes());
                    LOGGER.info("BQARDEBUG--> ackPacket SENT. file=" + ackFile);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "HB--> BQAckPacketWriter thread Interrupted. id=" + this.threadID, e);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "HB--> Error inside BQAckPacketWriter thread id=" + this.threadID, e);
            }
            finally {
                if (this.bqAckConn != null) {
                    this.bqAckConn.close();
                    this.bqAckConn = null;
                }
            }
        }
    }
}

