/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import com.adventnet.wms.servercommon.components.queue.BQInventory;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BQARModule
implements ARModule {
    private static Logger logger = Logger.getLogger(BQARModule.class.getName());
    private static int threadCount = 20;

    @Override
    public boolean init(int serverMode) {
        logger.info("HB--> \tBQARModule initialize. serverMode=" + serverMode);
        if (serverMode == 2) {
            BQInventory.createBQAckConnection();
        }
        return true;
    }

    @Override
    public void prepare() {
        logger.log(Level.INFO, "Prepare - BQARModule");
        String dataSize = WMSUtil.HumanReadable.getMemSize(BQInventory.getTotalSize());
        long fileCount = BQInventory.getTotalFilesCount();
        logger.info("VS --> Total data size = " + dataSize + " files count = " + fileCount);
        try {
            ARManager.updateStatus(this, 100, "Est Files - " + fileCount + " (" + dataSize + ")");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "NS--> Exception while calling updateStatus", e);
        }
    }

    @Override
    public void perform() {
        logger.log(Level.INFO, "NS--> Going to Start BQDT");
        try {
            BQInventory.initiateAR(ARManager.getARIp() + ":" + ARManager.getGACPort(), threadCount, this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "BQInventory - Failed to initiate AR. ", e);
            try {
                ARManager.updateStatus(this, 201, " BQ Transfer Failed - " + e);
            }
            catch (Exception exp) {
                logger.log(Level.FINE, "NS--> Exception while calling updateStatus", exp);
            }
        }
    }

    @Override
    public void onComplete(int serverMode) {
        if (serverMode == 2) {
            BQInventory.interruptBqAckWriterThreads();
        }
    }

    @Override
    public Map<String, String> getProgress() {
        return BQInventory.getARProgress();
    }

    @Override
    public int getExecutionType() {
        return 2;
    }

    @Override
    public int getModuleId() {
        return 101;
    }

    @Override
    public String getModuleName() {
        return "BufferedQueue";
    }

    @Override
    public Hashtable<String, Object> getStatus(int serverMode) {
        return BQInventory.getARStatus();
    }

    @Override
    public Hashtable<String, Object> getDetailedStatus(int serverMode) {
        return BQInventory.getDetailedARStatus();
    }

    @Override
    public void abort() {
        logger.log(Level.INFO, "abort - BQARModule");
        BQInventory.abortAR();
    }

    @Override
    public long getMaximumPrepareTime() {
        return 5000L;
    }

    @Override
    public long getMaximumPerformTime() {
        return 45000L;
    }
}

