/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.util;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.LockManager;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.util.LimitedQueue;
import com.adventnet.wms.servercommon.components.net.util.WCPSessionIDGenerator;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WCPUtil {
    private static Logger logger = Logger.getLogger(WCPUtil.class.getName());
    private static LockManager objLock = new LockManager();
    private static LockManager sessionLock = new LockManager();
    private static Map<String, String> clustersMap = new ConcurrentHashMap<String, String>();

    public static boolean isNull(String data) {
        return data == null || data.trim().equals("") || data.trim().equals("null");
    }

    public static void printDebugLogs(String logStr) {
        if (WCPConfManager.isDebugLogsEnabled()) {
            logger.info(logStr);
        }
    }

    public static void printDebugLogs(String logStr, Exception ex) {
        if (WCPConfManager.isDebugLogsEnabled()) {
            logger.log(Level.INFO, logStr, ex);
        }
    }

    public static WmsEvent setWCPHeaders(WmsEvent event, WCPResponse response) throws Exception {
        return WCPUtil.setWCPHeaders(event, response, null);
    }

    public static WmsEvent setWCPHeaders(WmsEvent event, WCPResponse response, WCPRequest request) throws Exception {
        String reqId = response.getRequestId();
        String resId = response.getResponseId();
        if (reqId == null || resId == null) {
            throw new Exception("Illegal Data");
        }
        event.putHeader("wcp-resid", resId);
        event.putHeader("wcp-reqid", reqId);
        event.putHeader("wcp-res-headers", response.getResponseHeaders());
        if (request != null) {
            event.setExpiryTime(request.getExpiryTime());
        }
        return event;
    }

    public static void removeWCPHeaders(WmsEvent event) {
        event.removeHeader("wcp-resid");
        event.removeHeader("wcp-reqid");
        event.removeHeader("wcp-res-headers");
    }

    public static WCPResponse getWCPResponse(WmsEvent event) throws Exception {
        String reqId = event.getHeader("wcp-reqid");
        String resId = event.getHeader("wcp-resid");
        Hashtable resHeaders = (Hashtable)event.getHeaderAsObject("wcp-res-headers");
        WCPResponse response = null;
        if (reqId != null && resId != null) {
            response = new WCPResponse(reqId, resId);
            if (resHeaders != null) {
                response.setHeaders(resHeaders);
            }
        } else {
            throw new Exception("Illegal Data");
        }
        WCPUtil.removeWCPHeaders(event);
        return response;
    }

    public static void transferWCPHeaders(WmsEvent newEvent, WmsEvent oldEvent) {
        if (oldEvent.getHeader("wcp-resid") != null) {
            newEvent.putHeader("wcp-resid", oldEvent.getHeader("wcp-resid"));
        }
        if (oldEvent.getHeader("wcp-reqid") != null) {
            newEvent.putHeader("wcp-reqid", oldEvent.getHeader("wcp-reqid"));
        }
    }

    public static long calculateAverage(LimitedQueue<Long> lq) {
        long sum = 0L;
        if (!lq.isEmpty()) {
            for (Long mark : lq) {
                sum += mark.longValue();
            }
            return sum / (long)lq.size();
        }
        return sum;
    }

    public static String getServerSessionId(String csid) {
        if (WCPSessionManager.getServerSessionId(csid) == null) {
            String ssid = null;
            try {
                ssid = WCPSessionIDGenerator.getSid();
            }
            catch (WMSException e) {
                logger.log(Level.SEVERE, "HB_ERR Error while getting sessionId for csid=" + csid, e);
            }
            WCPSessionManager.setServerSessionId(csid, ssid);
        }
        return WCPSessionManager.getServerSessionId(csid);
    }

    public static Object getObjLock(String ip) {
        return objLock.lock(ip);
    }

    public static void releaseObjLock(String ip) {
        objLock.release(ip);
    }

    public static Object getObjLockForRegister(String ip) {
        return sessionLock.lock(ip);
    }

    public static void releaseObjForRegister(String ip) {
        sessionLock.release(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerType(String clusterName) {
        String servertype = clustersMap.get(clusterName);
        if (servertype == null) {
            Map<String, String> map = clustersMap;
            synchronized (map) {
                servertype = clustersMap.get(clusterName);
                if (servertype == null) {
                    servertype = clusterName.split("-")[0];
                    clustersMap.put(clusterName, servertype);
                }
            }
        }
        return servertype;
    }

    public static long parseLong(String longValue, long defaultValue) {
        try {
            if (longValue != null) {
                return Long.parseLong(longValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean isValidIPAddress(String ip) {
        Pattern ipParrrten = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
        if (CommonUtil.isEmpty((String)ip)) {
            return false;
        }
        Matcher m = ipParrrten.matcher(ip);
        return m.matches();
    }
}

