/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.util;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPPacketizer {
    private static final Logger LOGGER = Logger.getLogger(WCPPacketizer.class.getName());

    public static WCPPacket getDataFromPacket(byte[] packetData) {
        return WCPPacketizer.getDataFromPacket(packetData, false);
    }

    public static WCPPacket getDataFromPacket(byte[] packetData, boolean ignorePayLoadData) {
        long netInTime;
        long qTime;
        byte[] payloadData;
        int statusCode;
        int payloadType;
        Hashtable header;
        long flag;
        byte packetType;
        long packetId;
        block35: {
            ByteBuffer bb = ByteBuffer.wrap(packetData);
            int position = 0;
            packetId = bb.getLong(position);
            packetType = bb.get(position += 8);
            ++position;
            flag = 0L;
            header = new Hashtable();
            payloadType = 0;
            statusCode = -1;
            payloadData = new byte[]{};
            qTime = -1L;
            netInTime = -1L;
            if (packetType == 1 || packetType == 6 || packetType == 9 || packetType == 10 || packetType == 13) {
                flag = bb.getLong(position);
                int headerLen = bb.getInt(position += 8);
                position += 4;
                if (headerLen > 0) {
                    bb.position(position);
                    byte[] bytes = new byte[headerLen];
                    bb.get(bytes, 0, headerLen);
                    position += headerLen;
                    String dat = null;
                    try {
                        dat = new String(bytes, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    header = (Hashtable)HttpDataWraper.getObject(dat);
                }
                payloadType = bb.getInt(position);
                int payloadLen = bb.getInt(position += 4);
                position += 4;
                if (payloadLen > 0) {
                    bb.position(position);
                    if (!ignorePayLoadData) {
                        payloadData = new byte[payloadLen];
                        bb.get(payloadData, 0, payloadLen);
                    }
                    position += payloadLen;
                }
                if (bb.capacity() >= position + 1) {
                    int instrumentationValue = bb.get(position) & 0xFF;
                    ++position;
                    if (instrumentationValue == 2) {
                        qTime = bb.getLong(position);
                        netInTime = bb.getLong(position += 8);
                        position += 8;
                    }
                }
            } else if (packetType == 2) {
                payloadType = bb.get(position);
                ++position;
                if (bb.capacity() >= 14) {
                    statusCode = bb.getInt(position);
                    position += 4;
                }
                try {
                    if (bb.capacity() < position + 1) break block35;
                    int instrumentationValue = bb.get(position) & 0xFF;
                    ++position;
                    if (instrumentationValue == 2) {
                        qTime = bb.getLong(position);
                        netInTime = bb.getLong(position += 8);
                        position += 8;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "WCPERR --> Error while getting qTime and rttTime in ACK packet.. ", e);
                }
            } else if (packetType == 4) {
                int payloadLen = bb.getInt(position);
                position += 4;
                if (payloadLen > 0) {
                    bb.position(position);
                    payloadData = new byte[payloadLen];
                    bb.get(payloadData, 0, payloadLen);
                    position += payloadLen;
                }
            } else if (packetType == 7 || packetType == 8 || packetType == 14 || packetType == 15) {
                flag = bb.getLong(position);
                int headerLen = bb.getInt(position += 8);
                position += 4;
                if (headerLen > 0) {
                    bb.position(position);
                    byte[] bytes = new byte[headerLen];
                    bb.get(bytes, 0, headerLen);
                    position += headerLen;
                    String dat = null;
                    try {
                        dat = new String(bytes, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    header = (Hashtable)HttpDataWraper.getObject(dat);
                }
                int payloadLen = bb.getInt(position);
                position += 4;
                if (payloadLen > 0) {
                    bb.position(position);
                    payloadData = new byte[payloadLen];
                    bb.get(payloadData, 0, payloadLen);
                    position += payloadLen;
                }
            } else if (packetType == 3) {
                flag = bb.getLong(position);
                int headerLen = bb.getInt(position += 8);
                position += 4;
                if (headerLen > 0) {
                    bb.position(position);
                    byte[] bytes = new byte[headerLen];
                    bb.get(bytes, 0, headerLen);
                    position += headerLen;
                    String dat = null;
                    try {
                        dat = new String(bytes, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    header = (Hashtable)HttpDataWraper.getObject(dat);
                }
                payloadType = bb.getInt(position);
                int payloadLen = bb.getInt(position += 4);
                position += 4;
                if (payloadLen > 0) {
                    bb.position(position);
                    payloadData = new byte[payloadLen];
                    bb.get(payloadData, 0, payloadLen);
                    position += payloadLen;
                }
            } else if (packetType == 5) {
                flag = bb.getLong(position);
                int headerLen = bb.getInt(position += 8);
                position += 4;
                if (headerLen > 0) {
                    bb.position(position);
                    byte[] bytes = new byte[headerLen];
                    bb.get(bytes, 0, headerLen);
                    position += headerLen;
                    String dat = null;
                    try {
                        dat = new String(bytes, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    header = (Hashtable)HttpDataWraper.getObject(dat);
                }
                payloadType = bb.getInt(position);
                int payloadLen = bb.getInt(position += 4);
                position += 4;
                if (payloadLen > 0) {
                    bb.position(position);
                    payloadData = new byte[payloadLen];
                    bb.get(payloadData, 0, payloadLen);
                    position += payloadLen;
                }
            }
        }
        WCPPacket packet = new WCPPacket(packetId, packetType, flag, header, payloadType, payloadData, statusCode);
        packet.setQTime(qTime);
        packet.setNetInTime(netInTime);
        return packet;
    }

    public static WCPPacket getPacketFromData(long packetId, int packetType, int payloadType) throws Exception {
        return WCPPacketizer.getPacketFromData(packetId, packetType, 0L, new Hashtable<String, String>(), payloadType, "");
    }

    public static WCPPacket getPacketFromData(long packetId, int packetType, byte[] data) throws Exception {
        return WCPPacketizer.getPacketFromData(packetId, packetType, 0L, new Hashtable<String, String>(), 0, data);
    }

    public static WCPPacket getPacketFromData(long packetId, int packetType, String data) throws Exception {
        return WCPPacketizer.getPacketFromData(packetId, packetType, 0L, new Hashtable<String, String>(), 0, data);
    }

    public static WCPPacket getPacketFromData(long packetId, int packetType, long flag, Hashtable<String, String> header, int payloadType, String payloadData) throws Exception {
        return WCPPacketizer.getPacketFromData(packetId, packetType, flag, header, payloadType, payloadData.getBytes("UTF-8"));
    }

    public static WCPPacket getPacketFromData(long packetId, int packetType, long flag, Hashtable<String, String> header, int payloadType, byte[] payloadData) throws Exception {
        return new WCPPacket(packetId, packetType, flag, header, payloadType, payloadData);
    }

    public static long getPacketId(ByteBuffer bb) {
        return bb.getLong(0);
    }

    public static int getPacketType(ByteBuffer bb) {
        return bb.get(8);
    }

    public static Hashtable<String, String> getIDBPacketHeader(ByteBuffer bb) {
        int position = 17;
        int headerLen = bb.getInt(position);
        position += 4;
        if (headerLen > 0) {
            bb.position(position);
            byte[] bytes = new byte[headerLen];
            bb.get(bytes, 0, headerLen);
            position += headerLen;
            String data = null;
            try {
                data = new String(bytes, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (Hashtable)HttpDataWraper.getObject(data);
        }
        return new Hashtable<String, String>();
    }

    public static void setPacketInfoOnIDBPacket(ByteBuffer bb, long packetId, long qTime, long netInTime) {
        bb.putLong(0, packetId);
        int position = 17;
        int headerLen = bb.getInt(position);
        int payLoadLen = bb.getInt(position += headerLen + 4 + 4);
        if (bb.capacity() >= (position += payLoadLen + 4) + 1) {
            int instrumentationValue = bb.get(position) & 0xFF;
            ++position;
            if (instrumentationValue == 2) {
                bb.putLong(position, qTime);
                bb.putLong(position += 8, netInTime);
            }
        }
    }
}

