/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.servlet;

import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.callback.WCPBrdCstCBListnr;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import java.util.Hashtable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPBroadcastFuture
extends WCPFuture {
    private static Logger logger = Logger.getLogger(WCPBroadcastFuture.class.getName());
    private Hashtable<String, WCPFuture> futureMap = null;
    private Hashtable<String, WCPResponse> responseMap = null;
    private AtomicInteger successCount = new AtomicInteger(0);
    private AtomicInteger failureCount = new AtomicInteger(0);
    private WCPBrdCstCBListnr listener = null;

    public WCPBroadcastFuture(WCPRequest req, WCPResponse res, WCPBrdCstCBListnr listener, String poolName) {
        super(req, res, null, poolName);
        this.futureMap = new Hashtable();
        this.responseMap = new Hashtable();
        this.listener = listener;
    }

    public boolean addFuture(String ip, WCPFuture future) {
        if (ip != null & future != null) {
            this.futureMap.put(ip, future);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.req_canceled = mayInterruptIfRunning;
        for (String ip : this.futureMap.keySet()) {
            WCPFuture future = this.futureMap.get(ip);
            future = null;
        }
        this.futureMap = null;
        this.responseMap = null;
        if (mayInterruptIfRunning) {
            this.lock.lock();
            try {
                this.resAvailable.signalAll();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Exception on cancel", ex);
            }
            finally {
                this.lock.unlock();
            }
        }
        return mayInterruptIfRunning;
    }

    public Hashtable<String, WCPResponse> getBrodcastResponse() {
        if (this.isCancelled()) {
            throw new CancellationException("WCPRequest canceled");
        }
        this.lock.lock();
        try {
            this.resAvailable.await(this.req.getTimeOutInMillis() + WCPConfManager.getWCPRequestTimeOutTrackerIntervalInMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
        return this.responseMap;
    }

    public void setResponse(String ip, WCPResponse res) {
        this.responseMap.put(ip, res);
        this.futureMap.remove(ip);
        if (res.getResponseCode().equals("408")) {
            this.failureCount.incrementAndGet();
        } else {
            this.successCount.incrementAndGet();
        }
        if (this.listener != null) {
            if (this.futureMap.size() == 0) {
                this.listener.onResponse(this.req, this.responseMap);
            }
        } else {
            this.lock.lock();
            try {
                if (this.futureMap.size() == 0) {
                    this.resAvailable.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.req_canceled;
    }

    @Override
    public boolean isDone() {
        return this.futureMap.size() == 0;
    }

    @Override
    public WCPRequest getRequest() {
        return this.req;
    }

    public void setBroadcastResponseListener(WCPBrdCstCBListnr listener) {
        this.listener = listener;
    }
}

