/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.security;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.security.AccessTokenProvider;
import com.adventnet.wms.servercommon.components.security.CryptoAlgorithm;
import com.adventnet.wms.servercommon.components.security.WMSSecurityUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerAccessTokenProviderImpl
implements AccessTokenProvider {
    private static final Logger LOGGER = Logger.getLogger(ServerAccessTokenProviderImpl.class.getName());

    @Override
    public String getAccessToken(String poolName, String serverType, String remoteServerType, String clusterName, String remoteClusterName) {
        try {
            StringBuilder data = new StringBuilder();
            data.append(WCPConfManager.getServerIp());
            data.append("@");
            data.append(DC.getServertype());
            data.append("@");
            data.append(remoteServerType);
            data.append("@");
            data.append(System.currentTimeMillis());
            return WMSSecurityUtil.encrypt(CryptoAlgorithm.ALGORITHM.AES, "server2server", remoteServerType, DC.getServertype(), data.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while getAccessToken. remoteServerType=" + remoteServerType, e);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_GET_ACCESS_TOKEN.getErrorCode(), 1L);
            WCPStats.addErrorStats("EXCEPTION_IN_GET_ACCESS_TOKEN", "[remoteServerType : " + remoteServerType + "]");
            return null;
        }
    }
}

