/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Hashtable;

public class IDBPayload {
    private String batchId;
    private String toDC;
    private String originDC;
    private String payload;
    private int payloadSize;
    private long startTime;
    private long count;
    private long batchCount;
    private long originTime;

    public IDBPayload(String batchId) {
        this.batchId = batchId;
        this.startTime = System.currentTimeMillis();
    }

    public IDBPayload setCount(long count) {
        this.count = count;
        return this;
    }

    public IDBPayload setStartTime() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public IDBPayload setBatchCount(long batchCount) {
        this.batchCount = batchCount;
        return this;
    }

    public IDBPayload setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public IDBPayload setPayloadSize(int payloadSize) {
        this.payloadSize = payloadSize;
        return this;
    }

    public IDBPayload setReqOriginTime(long originTime) {
        this.originTime = originTime;
        return this;
    }

    public IDBPayload setDC(String toDC) {
        this.toDC = toDC;
        return this;
    }

    public IDBPayload setOriginDC() {
        this.originDC = DC.getDCId();
        return this;
    }

    public String toString() {
        Hashtable<String, String> idbpayload = new Hashtable<String, String>();
        idbpayload.put("batchid", this.batchId);
        idbpayload.put("dc", this.toDC);
        idbpayload.put("origin_dc", this.originDC);
        idbpayload.put("payloadsize", String.valueOf(this.payloadSize));
        idbpayload.put("msg_starttime", String.valueOf(this.startTime));
        idbpayload.put("count", String.valueOf(this.count));
        idbpayload.put("batchcount", String.valueOf(this.batchCount));
        idbpayload.put("origintime", String.valueOf(this.originTime));
        idbpayload.put("origin_cluster", DC.getCluster());
        idbpayload.put("payload", this.payload);
        return HttpDataWraper.getString(idbpayload);
    }
}

