/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTest;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBPayloadStatus;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServlet;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDBLoadTestServlet
implements WCPServlet {
    private static Logger logger = Logger.getLogger(IDBLoadTestServlet.class.getName());
    private static Hashtable<String, IDBPayloadStatus> map = IDBLoadTest.getMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wcpService(WCPRequest req, WCPResponse res) throws Exception {
        try {
            logger.info("SH --> arrived request=" + req.getReqAsData());
            if (!map.containsKey(req.getHeader("batchid"))) {
                WCPRequest wCPRequest = req;
                synchronized (wCPRequest) {
                    if (!map.containsKey(req.getHeader("batchid"))) {
                        IDBPayloadStatus st = new IDBPayloadStatus(req.getHeader("batchid"), Long.parseLong(req.getHeader("batchcount")), Long.parseLong(req.getHeader("origintime")), "req");
                        map.put(req.getHeader("batchid"), st);
                        st.setDC(req.getHeader("origin_dc"));
                        st.setCluster(req.getHeader("origin_cluster"));
                    }
                }
            }
            map.get(req.getHeader("batchid")).dataRecieved();
            res.setResponseData(req.getData());
            res.setHeaders(req.getHeaders());
            res.setResponseCode("200");
            res.sendResponse();
            WCPStats.addIDBLoadTestStats("req", req.getHeader("dc"), req.getHeader("batchid"), System.currentTimeMillis() - Long.parseLong(req.getHeader("msg_starttime")), 0L, Long.parseLong(req.getHeader("payloadsize")));
            map.get(req.getHeader("batchid")).responseSent();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SH --> ERROR IN REQ LISTENER map = " + map + " :::::::::::::::::: req=" + req.getHeaders(), e);
        }
    }
}

