/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idb.grid;

import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.grid.DistributionManager;
import com.adventnet.wms.servercommon.grid.GeoMap;
import com.adventnet.wms.servercommon.grid.IPMap;
import com.adventnet.wms.servercommon.grid.WCH;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDBDistributionManager
extends DistributionManager {
    private static final Logger LOGGER = Logger.getLogger(IDBDistributionManager.class.getName());
    private static Map<String, WCH> currentDistributionMap = new HashMap<String, WCH>();

    @Override
    public boolean handleCDChange(String dcid, String cluster, Map<String, WCH> wchMap, String filter) {
        WCH wch = wchMap.get("cur");
        boolean idbcdChanged = false;
        if (currentDistributionMap.get(cluster) != null) {
            idbcdChanged = !wch.isSameVersion(currentDistributionMap.get(cluster));
        }
        currentDistributionMap.put(cluster, wchMap.get("cur"));
        try {
            if (idbcdChanged) {
                WCPDispatcher.refreshSeeds(cluster);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while refreshSeeds. clusterName=" + cluster + " idbcdChanged=" + idbcdChanged, e);
        }
        LOGGER.info("HB--> CD Change, clusterName=" + cluster + " currentDistributionMap=" + currentDistributionMap + " dcid=" + dcid + " idbcdChanged=" + idbcdChanged);
        return true;
    }

    @Override
    public boolean handleIPMChange(String dc, String cluster, IPMap ipMap) {
        return true;
    }

    @Override
    public boolean handleGeoChange(String paramString1, String paramString2, GeoMap paramGeoMap) {
        return true;
    }
}

