/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.callback;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCBResponseHandler {
    private Logger logger = Logger.getLogger(WCPCBResponseHandler.class.getName());
    private boolean closed = false;
    private BufferedQueue bq = null;
    private WMSThreadPoolExecutor wmsTPE = null;

    public WCPCBResponseHandler(String dir, String fileName, int queueSize) {
        this.bq = new BufferedQueue(dir, fileName, queueSize, false);
        this.wmsTPE = new WMSThreadPoolExecutor("WCP/-CBResponseHandler", 1, 1, 5L, TimeUnit.SECONDS, this.bq, new WCPCBResponseNotifier());
    }

    public void putData(String reqSource, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.wmsTPE.execute(new WCPCBEvent("cbrequest", reqSource, packet));
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "WCPERR--> putData exception with prd. ip=" + reqSource, ex);
        }
    }

    public synchronized void setCorePoolSize(int corePoolSize) {
        this.wmsTPE.setCorePoolSize(corePoolSize);
    }

    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        this.wmsTPE.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setPoolSize(int corePoolSize, int maximumPoolSize) {
        this.wmsTPE.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public void start() {
        this.wmsTPE.start();
        this.wmsTPE.prestartAllCoreThreads();
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public long getQueueSize() {
        return this.bq.size();
    }

    public int getActiveThreadsCount() {
        return this.wmsTPE.getActivePoolSize();
    }

    public int getMaxThreadsCount() {
        return this.wmsTPE.getMaximumPoolSize();
    }

    class WCPCBResponseNotifier
    implements WmsTask {
        WCPCBResponseNotifier() {
        }

        @Override
        public void handle(Object wcpCBEvent) {
            long processTime = System.currentTimeMillis();
            WCPCBEvent cbe = (WCPCBEvent)wcpCBEvent;
            if (cbe != null) {
                try {
                    if (cbe.getWCPPacket().getPacketType() == 15) {
                        String id = cbe.getWCPPacket().getHeaderAsTable().get("reqid");
                        String[] splt = id.split("@");
                        String reqSource = splt[0];
                        String sid = splt[1];
                        String reqId = splt[2];
                        WCPFuture future = WCPSessionManager.removeWCPFutureObj(reqId);
                        if (future != null) {
                            String data = new String(cbe.getWCPPacket().getPayLoadData(), "UTF-8");
                            Hashtable ht = (Hashtable)HttpDataWraper.getObject((String)data);
                            WCPResponse res = new WCPResponse(ht);
                            future.setResponse(res);
                        } else {
                            WCPCBResponseHandler.this.logger.info("[WCP][No WCPFutureObject CBRequest][" + reqSource + "][" + sid + "][" + reqId + "]");
                        }
                    } else {
                        WCPCBResponseHandler.this.logger.warning("Invalid packet inside WCPCBResponse-Handler; packettype=" + cbe.getWCPPacket().getPacketType());
                    }
                }
                catch (Exception ex) {
                    WCPCBResponseHandler.this.logger.log(Level.SEVERE, "WCPERR--> Error while executing WCPCBReponse inside", ex);
                }
            }
            WCPStats.addWCPHandlerProcessingTime("CBResponseHandler", System.currentTimeMillis() - processTime);
        }
    }
}

