/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.net.APIRemoteIPSessionInfo;
import com.adventnet.wms.servercommon.components.net.NewWCPServerSessionMap;
import com.adventnet.wms.servercommon.components.net.WCPARModule;
import com.adventnet.wms.servercommon.components.net.WCPApiHitsReBalancer;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPFilter;
import com.adventnet.wms.servercommon.components.net.WCPFilterResponse;
import com.adventnet.wms.servercommon.components.net.WCPServerSessionMap;
import com.adventnet.wms.servercommon.components.net.WCPSessionListener;
import com.adventnet.wms.servercommon.components.net.WCPThreadLocal;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBResponseHandler;
import com.adventnet.wms.servercommon.components.net.callback.WCPDefaultCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPDefaultListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPMetaListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.servercommon.components.net.connection.WCPConnection;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServlet;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.timeoutlistener.WCPCBReqTimeOutListener;
import com.adventnet.wms.servercommon.components.net.util.WCPAccessLogger;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.net.util.WCPPacketizer;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.AbsAutoReBalancer;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.ListOrderedMap;

public class WCPSessionManager {
    private static Logger logger = Logger.getLogger(WCPSessionManager.class.getName());
    private static boolean initialized = false;
    private static Hashtable<String, WCPServerSessionMap> uriMap = null;
    private static Hashtable<String, NewWCPServerSessionMap> newUriMap = null;
    private static Hashtable<String, WCPConnection> sidConnMap = null;
    private static Hashtable<String, WCPListener> listenerMap = null;
    private static Hashtable<String, WCPCBListener> cbListenerMap = null;
    private static Hashtable<String, String> requestIdMap = null;
    private static Hashtable<String, String> serverSidMap = new Hashtable();
    private static Hashtable<String, Boolean> uriPauseStatus = new Hashtable();
    private static WCPMetaListener metaListener = null;
    private static ThreadLocal<Boolean> cvMismatchStatus = new ThreadLocal();
    private static ConcurrentHashMap<String, List<String>> prdRemoteipMap = null;
    private static ListOrderedMap<String, APIRemoteIPSessionInfo> remoteIPSessions = null;
    private static WCPFilter wcpFilter = null;
    private static AtomicLong wcpCBRequestId = new AtomicLong(0L);
    private static Hashtable<String, WCPFuture> wcpCBRequestMap;
    private static Hashtable<String, ArrayList<String>> prdReqSourceMap;
    private static WCPCBResponseHandler cbResponseHandler;
    private static WCPSessionListener sessionListener;
    public static SecureRandom random;

    public static boolean initialize() {
        return WCPSessionManager.initialize(null);
    }

    public static boolean initialize(WCPFilter filter) {
        if (initialized) {
            logger.info("HB--> WCPSessionManager already Initialized.");
            return false;
        }
        uriMap = new Hashtable();
        newUriMap = new Hashtable();
        sidConnMap = new Hashtable();
        requestIdMap = new Hashtable();
        listenerMap = new Hashtable();
        cbListenerMap = new Hashtable();
        prdRemoteipMap = new ConcurrentHashMap();
        remoteIPSessions = ListOrderedMap.listOrderedMap(Collections.synchronizedMap(new ListOrderedMap()));
        listenerMap.put("default", new WCPDefaultListener());
        cbListenerMap.put("default", new WCPDefaultCBListener());
        WCPServletMapper.initialize(WCPConfManager.getServletProperties());
        AbsAutoReBalancer.register("wcpapi", new WCPApiHitsReBalancer());
        wcpFilter = filter;
        wcpCBRequestMap = new Hashtable();
        prdReqSourceMap = new Hashtable();
        cbResponseHandler = new WCPCBResponseHandler(WCPConfManager.getWCPHome() + "cbresponse" + File.separator, "cbresponse", 1000);
        cbResponseHandler.start();
        initialized = true;
        logger.info("[WCPSessionManager - Initilized!!]");
        return true;
    }

    public static void setCBResponseHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        cbResponseHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public static boolean isPaused(String uri) {
        if (uriPauseStatus.containsKey(uri)) {
            logger.info("HB--> uriPauseStatus, uri=" + uri + " uriPausedStatusMap=" + uriPauseStatus);
            logger.log(Level.INFO, "HB--> uriPauseStatus, uri={0} uriPausedStatusMap={1}", new Object[]{uri, uriPauseStatus});
            return uriPauseStatus.get(uri);
        }
        return false;
    }

    public static int pauseDataStream(String uri) throws Exception {
        uriPauseStatus.put(uri, true);
        logger.info("HB--> pauseDataStream " + uri + " = " + uriPauseStatus.get(uri));
        if ("api".equals(uri)) {
            return 0;
        }
        return WCPSessionManager.sendControlPacketToAll(1, uri, null);
    }

    public static int resumeDataStream(String uri) throws Exception {
        uriPauseStatus.put(uri, false);
        logger.info("HB--> resumeDataStream " + uri + " = " + uriPauseStatus.get(uri));
        if ("api".equals(uri)) {
            return 0;
        }
        return WCPSessionManager.sendControlPacketToAll(2, uri, null);
    }

    public static boolean registerSessionListener(WCPSessionListener sessionlistener) {
        if (sessionlistener == null) {
            logger.info("WCPERR--> sessionlistener is null");
            return false;
        }
        if (sessionListener == null) {
            sessionListener = sessionlistener;
            logger.info("HB--> registered Connection State Listener");
            return true;
        }
        logger.info("WCPERR--> registering ConnStateListener failed; Already Registered.");
        return false;
    }

    public static boolean registerListener(String context, WCPListener listener) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return false;
        }
        if (listener != null) {
            if (context != null) {
                listenerMap.put(context, listener);
                logger.info("[WCPSessionManager][NewListener Registered][" + context + "]");
                return true;
            }
            logger.info("WCPERR--> registerListener failed. context is null.");
        }
        logger.info("WCPERR--> registerListener failed. listener is null.");
        return false;
    }

    public static boolean registerCBListener(String context, WCPCBListener cbListener) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            throw new Exception("WCPSessionManager Not Initialized");
        }
        if (cbListener != null) {
            if (context != null) {
                cbListenerMap.put(context, cbListener);
                logger.info("[WCPSessionManager][New CBListener Registered][" + context + "]");
                return true;
            }
            logger.info("WCPERR--> registerCBListener failed. context is null.");
        }
        logger.info("WCPERR--> registerCBListener failed. cbListener is null.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean registerStream(String uri, String poolName, String ip, String sid, WCPConnection conn) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            throw new Exception("WCPSessionManager Not Initialized. uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        if (sidConnMap.get(sid) != null) {
            throw new Exception("ServerSessionId has been already registered. uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        uriMap.putIfAbsent(uri, new WCPServerSessionMap());
        WCPServerSessionMap serverSessionMap = uriMap.get(uri);
        try {
            Object object = WCPUtil.getObjLockForRegister(ip);
            synchronized (object) {
                serverSessionMap.clusterContextIPMap.putIfAbsent(poolName, new ArrayList());
                List ipList = serverSessionMap.clusterContextIPMap.get(poolName);
                if (!ipList.contains(ip)) {
                    serverSessionMap.clusterContextIPMap.get(poolName).add(ip);
                }
                serverSessionMap.ipSidMap.putIfAbsent(poolName + "_" + ip, new ArrayList());
                serverSessionMap.ipSidMap.get(poolName + "_" + ip).add(sid);
            }
        }
        finally {
            WCPUtil.releaseObjForRegister(ip);
        }
        sidConnMap.put(sid, conn);
        if ("api".equals(uri)) {
            WCPSessionManager.addAPIRemoteIPInfo(uri, null, conn.getRemoteServerType(), ip, poolName, sid);
        }
        logger.info("[WCPSessionManager][registerStream][" + uri + "][" + poolName + "][" + ip + "][" + sid + "]");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean unRegisterStream(String uri, String poolName, String ip, String sid) throws Exception {
        ArrayList<String> sidList;
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            throw new Exception("WCPSessionManager Not Initialized uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        if (uriMap.get(uri) == null) {
            throw new Exception("URI is not registered. uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        if (sidConnMap.get(sid) == null) {
            throw new Exception("ServerSessionId is not registered. uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        WCPServerSessionMap serverSessionMap = uriMap.get(uri);
        ArrayList<String> ipList = serverSessionMap.clusterContextIPMap.get(poolName);
        if (ipList == null) {
            throw new Exception("No Ips registered for poolname. uri=" + uri + " poolName=" + poolName + " ip=" + ip + " sid=" + sid);
        }
        boolean status = false;
        if (ipList.contains(ip) && (sidList = serverSessionMap.ipSidMap.get(poolName + "_" + ip)) != null) {
            if ("api".equals(uri)) {
                WCPSessionManager.removeAPIRemoteIpInfo(sidConnMap.get(sid).getRemoteServerType(), ip);
            }
            try {
                Object object = WCPUtil.getObjLockForRegister(ip);
                synchronized (object) {
                    WCPConnection wcpConnection = sidConnMap.remove(sid);
                    wcpConnection = null;
                    sidList.remove(sid);
                    status = true;
                    if (sidList.size() == 0) {
                        serverSessionMap.ipSidMap.remove(poolName + "_" + ip);
                        ipList.remove(ip);
                        serverSessionMap.clusterContextIPMap.put(poolName, ipList);
                        if (ipList.size() == 0) {
                            serverSessionMap.clusterContextIPMap.remove(poolName);
                            logger.info("[WCPSessionManager][unRegisterStream][Removing poolname from ClusterContextIpMap][" + uri + "][" + poolName + "][" + ip + "][" + sid + "]");
                        }
                    }
                }
            }
            finally {
                WCPUtil.releaseObjForRegister(ip);
            }
            logger.info("[WCPSessionManager][unRegisterStream][" + uri + "][" + poolName + "][" + ip + "][" + sid + "]");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean registerStream(String reqSource, String uri, String source, String ip, String poolName, String context, String sid, WCPConnection conn) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            throw new Exception("WCPSessionManager Not Initialized. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid);
        }
        if (sidConnMap.get(sid) != null) {
            throw new Exception("ServerSessionId has been already registered. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid);
        }
        long sidInTime = System.currentTimeMillis();
        newUriMap.putIfAbsent(uri, new NewWCPServerSessionMap());
        NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
        serverSessionMap.overAllMap.putIfAbsent(source, new ConcurrentHashMap());
        serverSessionMap.overAllMap.get(source).putIfAbsent(ip, new ConcurrentHashMap());
        try {
            Object object = WCPUtil.getObjLockForRegister(ip);
            synchronized (object) {
                serverSessionMap.overAllMap.get(source).get(ip).putIfAbsent(poolName, new ConcurrentHashMap());
                serverSessionMap.overAllMap.get(source).get(ip).get(poolName).put(sid, sidInTime);
                sidConnMap.put(sid, conn);
                serverSessionMap.reqSourceMap.putIfAbsent(reqSource, new TreeMap(Collections.synchronizedMap(new TreeMap())));
                serverSessionMap.reqSourceMap.get(reqSource).put(sid, sidInTime);
                if ("api".equals(uri)) {
                    WCPSessionManager.addAPIRemoteIPInfo(uri, source, conn.getRemoteServerType(), ip, poolName, sid);
                    prdReqSourceMap.putIfAbsent(source.toLowerCase(), new ArrayList());
                    prdReqSourceMap.get(source.toLowerCase()).add(reqSource);
                    if (sessionListener != null) {
                        try {
                            sessionListener.onConnect(source, ip, poolName, context);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Exception in sessionListener onConnect", e);
                        }
                    }
                }
                logger.info("[WCPSessionManager][NewRegisterStream] uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid + " reqSource=" + reqSource);
            }
        }
        finally {
            WCPUtil.releaseObjForRegister(ip);
        }
        WCPStats.addServerSessionStats("register", reqSource, uri, source, ip, poolName, context, sid, System.currentTimeMillis() - sidInTime);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean unRegisterStream(String reqSource, String uri, String source, String ip, String poolName, String context, String sid) throws Exception {
        long listenerStartTime;
        long sidInTime;
        boolean status;
        block27: {
            if (!initialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
                throw new Exception("WCPSessionManager Not Initialized uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid);
            }
            if (newUriMap.get(uri) == null) {
                throw new Exception("URI is not registered. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid);
            }
            if (sidConnMap.get(sid) == null) {
                throw new Exception("ServerSessionId is not registered. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " sid=" + sid);
            }
            NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
            status = false;
            sidInTime = 0L;
            listenerStartTime = System.currentTimeMillis();
            if (serverSessionMap.overAllMap.containsKey(source)) {
                try {
                    Object object = WCPUtil.getObjLockForRegister(ip);
                    synchronized (object) {
                        if (serverSessionMap.overAllMap.get(source).containsKey(ip)) {
                            if (serverSessionMap.overAllMap.get(source).get(ip).containsKey(poolName)) {
                                if (serverSessionMap.overAllMap.get(source).get(ip).get(poolName).containsKey(sid)) {
                                    sidInTime = serverSessionMap.overAllMap.get(source).get(ip).get(poolName).remove(sid);
                                    if (serverSessionMap.overAllMap.get(source).get(ip).get(poolName).isEmpty()) {
                                        serverSessionMap.overAllMap.get(source).get(ip).remove(poolName);
                                    }
                                    if (serverSessionMap.reqSourceMap.containsKey(reqSource)) {
                                        serverSessionMap.reqSourceMap.get(reqSource).remove(sid);
                                    }
                                    if ("api".equals(uri)) {
                                        String prd = sidConnMap.get(sid).getRemoteServerType();
                                        if (prd != null) {
                                            WCPSessionManager.removeAPIRemoteIpInfo(prd, ip);
                                        } else {
                                            logger.info("HBERR--> remoteServerType(prd) is null. remoteIp=" + ip);
                                        }
                                        prdReqSourceMap.get(source.toLowerCase()).remove(reqSource);
                                        if (prdReqSourceMap.get(source.toLowerCase()).isEmpty()) {
                                            prdReqSourceMap.remove(source);
                                        }
                                        if (sessionListener != null) {
                                            try {
                                                sessionListener.onClose(source, ip, poolName, context);
                                            }
                                            catch (Exception e) {
                                                logger.log(Level.SEVERE, "Exception in sessionListener onClose", e);
                                            }
                                        }
                                    }
                                    WCPConnection wcpConnection = sidConnMap.remove(sid);
                                    wcpConnection = null;
                                    status = true;
                                } else {
                                    logger.info("SMERR--> sid not found in overAllMap. sid=" + sid + " overAllMap=" + serverSessionMap.overAllMap);
                                    status = false;
                                }
                                if (serverSessionMap.overAllMap.get(source).get(ip).isEmpty()) {
                                    serverSessionMap.overAllMap.get(source).remove(ip);
                                }
                            } else {
                                logger.info("SMERR--> poolName not found in overAllMap. poolName=" + poolName + " overAllMap=" + serverSessionMap.overAllMap);
                                status = false;
                            }
                            if (serverSessionMap.overAllMap.get(source).isEmpty()) {
                                serverSessionMap.overAllMap.remove(source);
                            }
                        } else {
                            logger.info("SMERR--> ip not found in overAllMap. ip=" + ip + " overAllMap=" + serverSessionMap.overAllMap);
                            status = false;
                        }
                        break block27;
                    }
                }
                finally {
                    WCPUtil.releaseObjForRegister(ip);
                }
            }
            logger.info("SMERR--> source not found in overAllMap. source=" + source + " overAllMap=" + serverSessionMap.overAllMap);
            status = false;
        }
        logger.info("[WCPSessionManager][NewUnRegisterStream] status=" + status + " uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " context=" + context + " reqSource=" + reqSource + " sid=" + sid + " lifeTime=" + (System.currentTimeMillis() - sidInTime) + "ms");
        WCPStats.addServerSessionStats("unregister", reqSource, uri, source, ip, poolName, context, sid, System.currentTimeMillis() - listenerStartTime);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAPIRemoteIPInfo(String uri, String source, String prd, String remoteip, String poolName, String sid) {
        try {
            AbsAutoReBalancer.increment("wcpapi");
            prdRemoteipMap.putIfAbsent(prd, new ArrayList());
            List<String> list = prdRemoteipMap.get(prd);
            synchronized (list) {
                if (!prdRemoteipMap.get(prd).contains(remoteip)) {
                    prdRemoteipMap.get(prd).add(remoteip);
                    remoteIPSessions.put((Object)remoteip, (Object)new APIRemoteIPSessionInfo(uri, source, poolName, remoteip, sid, prd));
                } else {
                    APIRemoteIPSessionInfo obj = (APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteip);
                    obj.incrementSessionsCount();
                    remoteIPSessions.remove((Object)remoteip);
                    remoteIPSessions.put((Object)remoteip, (Object)obj);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ARB-->Exception while adding api remoteip for [prd :" + prd + "] [uri :" + uri + "][pool :" + poolName + "][ip :" + remoteip + "][sid :" + sid + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAPIRemoteIpInfo(String prd, String remoteip) {
        block8: {
            try {
                AbsAutoReBalancer.decrement("wcpapi");
                if (!prdRemoteipMap.containsKey(prd)) break block8;
                List<String> list = prdRemoteipMap.get(prd);
                synchronized (list) {
                    if (prdRemoteipMap.get(prd).contains(remoteip)) {
                        if (((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteip)).getSessionsCount() > 1) {
                            ((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteip)).decrementSessionsCount();
                        } else {
                            remoteIPSessions.remove((Object)remoteip);
                            prdRemoteipMap.get(prd).remove(remoteip);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ARB-->Exception while removing remoteip : " + remoteip + " and prd : " + prd, e);
            }
        }
    }

    public static ArrayList<String> returnConnAvgMsgRcvTime() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (String key : sidConnMap.keySet()) {
                WCPConnection conn = sidConnMap.get(key);
                list.add("" + conn.getRemoteIP() + "-" + conn.getAvgMsgRecieveTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("[WCPSessionManager - AvgMsgRcvTime][" + Arrays.toString(list.toArray()) + "]");
        return list;
    }

    public static void returnErrorMsg(String cluster, int dataType, String data, String reason) {
        WCPSessionManager.returnErrorMsg("default", cluster, dataType, data, reason);
    }

    public static void returnErrorMsg(String context, String cluster, int dataType, byte[] data, String reason) {
        try {
            WCPSessionManager.returnErrorMsg(context, cluster, dataType, new String(data, "UTF-8"), reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnErrorMsg(String context, String cluster, int dataType, String data, String reason) {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        if (WCPUtil.isNull(context) || listenerMap.get(context) == null) {
            context = "default";
        }
        long currTime = System.currentTimeMillis();
        WCPUtil.printDebugLogs("[WCPSessionManager - returnErrorMsg][" + context + "][" + cluster + "][" + reason + "]");
        listenerMap.get(context).onError(cluster, dataType, data, reason);
        WCPStats.addWCPListenerStats("on_error", cluster, System.currentTimeMillis() - currTime);
    }

    public static void processDataPackets(String context, String source, int dataType, String data) {
        WCPSessionManager.processDataPackets(context, source, dataType, data.getBytes(), null);
    }

    public static void processDataPackets(String context, String source, int dataType, byte[] payloadData, Hashtable<String, String> headers) {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        if (wcpFilter != null && !CommonUtil.isEmpty(headers)) {
            try {
                if (headers.containsKey("rkey") || headers.containsKey("rkeys")) {
                    WCPFilterResponse wcpFilterResponse = null;
                    if (!WCPUtil.isNull(headers.get("rkeys"))) {
                        ArrayList rkeys = (ArrayList)HttpDataWraper.getObject((String)headers.get("rkeys"));
                        WCPThreadLocal.setRKeys(rkeys);
                        wcpFilterResponse = wcpFilter.doRKeyFilterForData(context, rkeys, WMSUtil.getInteger(headers.get("x-redirection-count"), 0), headers.get("rpath"));
                    } else if (!WCPUtil.isNull(headers.get("rkey"))) {
                        WCPThreadLocal.setRKey(headers.get("rkey"));
                        wcpFilterResponse = wcpFilter.doRKeyFilterForData(context, headers.get("rkey"), WMSUtil.getInteger(headers.get("x-redirection-count"), 0), headers.get("rpath"));
                    }
                    if (wcpFilterResponse != null) {
                        if (wcpFilterResponse.isDroppedRequest()) {
                            WCPStats.wcpFilterFailed("request", "New Filter Data", context, source);
                            logger.fine("SH --> Dropping Data as per the new filter");
                            return;
                        }
                        if (wcpFilterResponse.doRedirect()) {
                            if (wcpFilterResponse.getIps() != null) {
                                if (headers.containsKey("rpath")) {
                                    headers.put("rpath", headers.get("rpath") + "," + WCPConfManager.getServerIp());
                                } else {
                                    headers.put("rpath", WCPConfManager.getServerIp());
                                }
                                headers.put("x-redirection-count", Integer.toString(WMSUtil.getInteger(headers.get("x-redirection-count"), 0) + 1));
                                Hashtable<String, Set<String>> connectionPoolMap = wcpFilterResponse.getIps();
                                for (String poolName : connectionPoolMap.keySet()) {
                                    for (String ip : connectionPoolMap.get(poolName)) {
                                        WCPDispatcher.frwdData(poolName, ip, dataType, payloadData, headers);
                                    }
                                }
                            } else if (wcpFilterResponse.getPoolName() != null && wcpFilterResponse.getIp() != null) {
                                WCPDispatcher.frwdData(wcpFilterResponse.getPoolName(), wcpFilterResponse.getIp(), dataType, payloadData, headers);
                            }
                            return;
                        }
                        WCPThreadLocal.rKeyFilterPassed();
                    }
                }
            }
            catch (Exception e) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_DATA_FILTER.getErrorCode(), 1L);
                logger.log(Level.SEVERE, "WCPERR--> Exception while handling filter.", e);
                return;
            }
        }
        if (WCPUtil.isNull(context) || listenerMap.get(context) == null) {
            context = "default";
        }
        long currTime = System.currentTimeMillis();
        WCPUtil.printDebugLogs("[WCPSessionManager - processDataPackets][" + context + "][" + source + "]");
        String sourceIp = source.split(":")[0];
        String data = null;
        try {
            data = new String(payloadData, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.log(Level.SEVERE, "WCPERR--> Error while parsing data. context=" + context + " soucre=" + source, e1);
        }
        try {
            if (wcpFilter != null) {
                try {
                    if (!wcpFilter.doFilterForData(context, source, dataType, data)) {
                        WCPStats.wcpFilterFailed("data", "Old Filter", context, sourceIp);
                        return;
                    }
                }
                catch (Exception e) {
                    StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_DATA_FILTER.getErrorCode(), 1L);
                    logger.log(Level.SEVERE, "WCPERR--> Error while handling WCPFilter. context=" + context + " soucre=" + source, e);
                    return;
                }
            }
            listenerMap.get(context).onMessage(source, dataType, data);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_DATA_LISTENER.getErrorCode(), 1L);
            logger.log(Level.SEVERE, "WCPERR--> Error while calling servlet-onMessage. context=" + context + " soucre=" + source, e);
        }
        WCPStats.addWCPListenerStats("on_message", sourceIp, System.currentTimeMillis() - currTime);
        if (WCPThreadLocal.getClientType() == WCPConstants.ClientType.API) {
            AbsAutoReBalancer.addApiHits("wcpapi", WCPThreadLocal.getPRD(), WCPThreadLocal.getRemoteIp());
        }
    }

    public static void processNotifyPackets(String context, String source, String ip, String data) {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        if (WCPUtil.isNull(context) || cbListenerMap.get(context) == null) {
            context = "default";
        }
        long currTime = System.currentTimeMillis();
        cbListenerMap.get(context).onNotify(source, ip, data);
        WCPStats.addWCPListenerStats("on_notify", source, System.currentTimeMillis() - currTime);
    }

    public static void sendCBNotifyData(String destination, int dataType, String data) throws Exception {
        WCPPacket packet;
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        String[] split = destination.split(":", 3);
        String sid = split[1];
        String sourceIp = null;
        try {
            sourceIp = split[2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (sid != null) {
            int packetType = 4;
            Hashtable<String, String> headers = new Hashtable<String, String>();
            if (sourceIp != null) {
                packetType = 13;
                headers.put("x-req-source-ip", sourceIp);
            }
            packet = WCPPacketizer.getPacketFromData(-1L, packetType, 0L, headers, dataType, data);
            if (sidConnMap.get(sid) == null) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_NOTIFY.getErrorCode(), 1L);
                WCPStats.addErrorStats("NO_VALID_SESSION_FOUND_ON_NOTIFY", "[sid : " + sid + "]");
                throw new Exception("No Valid Session Present ip:sid=" + destination);
            }
        } else {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_ID_NULL.getErrorCode(), 1L);
            WCPStats.addErrorStats("SESSION_ID_NULL", "[destination : " + destination + "]");
            throw new Exception("sid is null");
        }
        sidConnMap.get(sid).writeData(packet);
    }

    public static void sendIDBCBPacket(WCPPacket idbCBPacket) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        String sourceIp = idbCBPacket.getHeader("x-req-source-ip");
        sourceIp = sourceIp.split(":")[0];
        String sourceCluster = idbCBPacket.getHeader("x-req-source-cluster");
        StringBuilder reqSource = new StringBuilder();
        reqSource.append("idb");
        reqSource.append("|");
        reqSource.append(sourceCluster);
        reqSource.append("|");
        reqSource.append(sourceIp);
        reqSource.append("|");
        reqSource.append("idbconnpool");
        StringBuilder clusterContextIp = new StringBuilder();
        clusterContextIp.append("idbserver-main");
        clusterContextIp.append("_");
        clusterContextIp.append("intra_dc");
        clusterContextIp.append("_");
        clusterContextIp.append(sourceIp);
        String sid = null;
        WCPServerSessionMap serverSessionMap = uriMap.get("idb");
        try {
            sid = serverSessionMap.ipSidMap.get(clusterContextIp).get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sid != null) {
            if (sidConnMap.get(sid) != null) {
                sidConnMap.get(sid).writeData(idbCBPacket);
                return;
            }
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_NOTIFY.getErrorCode(), 1L);
            throw new Exception("No Valid Session Present. sid=" + sid + " reqSource=" + reqSource.toString());
        }
        if (newUriMap.containsKey("idb")) {
            NewWCPServerSessionMap sessionMap = newUriMap.get("idb");
            TreeMap<String, Long> map = sessionMap.reqSourceMap.get(reqSource.toString());
            if (map == null || map.isEmpty()) {
                throw new Exception("No Valid Session Present. sid=" + sid + " sidMap=" + map + " sessionMap.reqSourceMap=" + sessionMap.reqSourceMap + " reqSource=" + reqSource.toString());
            }
            sid = map.firstKey();
            if (sidConnMap.containsKey(sid)) {
                sidConnMap.get(sid).writeData(idbCBPacket);
            } else {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_NOTIFY.getErrorCode(), 1L);
                WCPStats.addErrorStats("NO_VALID_SESSION_FOUND_ON_NOTIFY", "[sid : " + sid + "]");
                throw new Exception("No Valid Session Present. sid=" + sid + " sidMap=" + map);
            }
        }
    }

    public static void processMetaPackets(String context, String source, int dataType, String data) {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        if (WCPUtil.isNull(context) || metaListener == null) {
            return;
        }
        long currTime = System.currentTimeMillis();
        metaListener.onNotification(context, source, dataType, data);
        WCPStats.addWCPListenerStats("meta", source, System.currentTimeMillis() - currTime);
    }

    public static int sendControlPacketToAll(int controlPacketType, String uri, Hashtable<String, String> headers) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return -1;
        }
        int totalSessions = 0;
        if (uriMap.containsKey(uri)) {
            WCPServerSessionMap ds = uriMap.get(uri);
            logger.info("HB--> sendControlPacketToAll ipSidMap=" + ds.ipSidMap);
            for (String ip : ds.ipSidMap.keySet()) {
                ArrayList<String> sidList = ds.ipSidMap.get(ip);
                logger.info("HB--> sendControlPacketToAll cluster_context_ip=" + ip + " connCount=" + sidList.size());
                for (String sid : sidList) {
                    WCPSessionManager.sendControlPacket(sid, controlPacketType, headers);
                    ++totalSessions;
                }
            }
        }
        if (newUriMap.containsKey(uri)) {
            NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
            for (String source : serverSessionMap.overAllMap.keySet()) {
                int clusterWiseSidCount = 0;
                for (String ip : serverSessionMap.overAllMap.get(source).keySet()) {
                    for (String poolName : serverSessionMap.overAllMap.get(source).get(ip).keySet()) {
                        for (String sid : serverSessionMap.overAllMap.get(source).get(ip).get(poolName).keySet()) {
                            if (!sidConnMap.containsKey(sid)) continue;
                            WCPSessionManager.sendControlPacket(sid, controlPacketType, headers);
                            logger.info("HB--> sending control packet.. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " sid=" + sid + " controlType=" + WCPConstants.CONTROL.getName(controlPacketType));
                            ++totalSessions;
                            ++clusterWiseSidCount;
                        }
                    }
                }
                logger.info("HB--> control packets count for cluster=" + source + " count=" + clusterWiseSidCount + " controlType=" + WCPConstants.CONTROL.getName(controlPacketType) + " totalSessionSent=" + totalSessions);
            }
        }
        if (totalSessions == 0) {
            logger.info("HB--> No sessions found. [Control] uri=" + uri + " Control PacketType=" + WCPConstants.CONTROL.getName(controlPacketType));
        }
        return totalSessions;
    }

    public static void sendControlPacket(String sid, int controlPacketType) throws Exception {
        WCPSessionManager.sendControlPacket(sid, controlPacketType, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendControlPacket(String sid, int controlPacketType, Hashtable<String, String> headers) throws Exception {
        if (sid == null) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_ID_NULL.getErrorCode(), 1L);
            WCPStats.addErrorStats("SESSION_ID_NULL", "[method : sendControlPacket]");
            throw new Exception("sid is null");
        }
        WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 5, 0L, headers, controlPacketType, "control-data");
        if (sidConnMap.get(sid) == null) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_CONTROL.getErrorCode(), 1L);
            WCPStats.addErrorStats("NO_VALID_SESSION_FOUND_ON_CONTROL", "[sid : " + sid + "]");
            throw new Exception("No Valid Session Present. sid=" + sid + " controlType=" + controlPacketType);
        }
        try {
            sidConnMap.get(sid).writeData(packet);
            if (controlPacketType != 1) {
                if (controlPacketType != 5) return;
            }
            WCPARModule.addControlAck(sid);
            return;
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_CONTROL_PACKET_FAILED.getErrorCode(), 1L);
            logger.log(Level.SEVERE, "WCPERR--> Error in connection while sending controlPacket. controlPacketType=" + WCPConstants.CONTROL.getName(controlPacketType) + " packet. sid=" + sid, e);
            return;
        }
    }

    public static int notifySeedsChangeToAPI(String data) throws Exception {
        return WCPSessionManager.sendMetaPacketToAll(1, data, "api");
    }

    public static int notifySeedsChangeToAPI(String data, String prd) throws Exception {
        return WCPSessionManager.sendMetaPacket(1, data, prd, null);
    }

    public static int notifySeedsChangeToAPI(String data, String prd, String remoteIp) throws Exception {
        return WCPSessionManager.sendMetaPacket(1, data, prd, remoteIp);
    }

    public static int sendMetaPacket(int metaType, String data, String prd, String remoteIp) throws Exception {
        if (!initialized) {
            throw new Exception("WCP not Initialized");
        }
        if (newUriMap.containsKey("api")) {
            int sessions = 0;
            NewWCPServerSessionMap serverSessionMap = newUriMap.get("api");
            if (serverSessionMap.overAllMap.containsKey(prd)) {
                for (String source : serverSessionMap.overAllMap.keySet()) {
                    if (!source.equals(prd)) continue;
                    for (String ip : serverSessionMap.overAllMap.get(source).keySet()) {
                        if (remoteIp == null) {
                            block2: for (String poolName : serverSessionMap.overAllMap.get(source).get(ip).keySet()) {
                                for (String sid : serverSessionMap.overAllMap.get(source).get(ip).get(poolName).keySet()) {
                                    if (!sidConnMap.containsKey(sid)) continue;
                                    WCPSessionManager.sendMetaData(sid, metaType, data);
                                    logger.info("HB--> sending meta packet.. source=" + source + " ip=" + ip + " poolName=" + poolName + " sid=" + sid);
                                    ++sessions;
                                    continue block2;
                                }
                            }
                            continue;
                        }
                        if (!ip.equals(remoteIp)) continue;
                        block4: for (String poolName : serverSessionMap.overAllMap.get(source).get(ip).keySet()) {
                            for (String sid : serverSessionMap.overAllMap.get(source).get(ip).get(poolName).keySet()) {
                                if (!sidConnMap.containsKey(sid)) continue;
                                WCPSessionManager.sendMetaData(sid, metaType, data);
                                logger.info("HB--> sending meta packet.. source=" + source + " ip=" + ip + " poolName=" + poolName + " sid=" + sid);
                                ++sessions;
                                continue block4;
                            }
                        }
                    }
                }
            } else {
                throw new Exception("Session not found for prd=" + prd);
            }
            return sessions;
        }
        throw new Exception("No Session found for uri=api. prd=" + prd + " remoteIp=" + remoteIp);
    }

    public static int sendMetaPacketToAll(int metaType, String data, String uri) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return -1;
        }
        int totalSessions = 0;
        if (uriMap.containsKey(uri)) {
            WCPServerSessionMap ds = uriMap.get(uri);
            logger.info("HB--> ipSidMap=" + ds.ipSidMap);
            for (String ip : ds.ipSidMap.keySet()) {
                ArrayList<String> sidList = ds.ipSidMap.get(ip);
                logger.info("HB--> cluster_context_ip=" + ip + " connCount=" + sidList.size());
                Iterator<String> iterator = sidList.iterator();
                if (!iterator.hasNext()) continue;
                String sid = iterator.next();
                WCPSessionManager.sendMetaData(sid, metaType, data);
                ++totalSessions;
            }
        }
        if (newUriMap.containsKey(uri)) {
            NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
            for (String source : serverSessionMap.overAllMap.keySet()) {
                for (String ip : serverSessionMap.overAllMap.get(source).keySet()) {
                    block3: for (String poolName : serverSessionMap.overAllMap.get(source).get(ip).keySet()) {
                        for (String sid : serverSessionMap.overAllMap.get(source).get(ip).get(poolName).keySet()) {
                            if (!sidConnMap.containsKey(sid)) continue;
                            WCPSessionManager.sendMetaData(sid, metaType, data);
                            logger.info("HB--> sending meta packet.. uri=" + uri + " source=" + source + " ip=" + ip + " poolName=" + poolName + " sid=" + sid);
                            ++totalSessions;
                            continue block3;
                        }
                    }
                }
            }
        } else {
            logger.info("WCPERR--> uri not found. uri=" + uri + " uriMap=" + uriMap + " newUriMap=" + newUriMap);
            return -1;
        }
        if (totalSessions == 0) {
            logger.info("HB--> No sessions found [Meta]");
        }
        return totalSessions;
    }

    public static void sendControlDataToApi(String remoteIp, int controlType, Hashtable<String, String> headers) throws Exception {
        WCPSessionManager.sendControlDataToApi(null, remoteIp, controlType, headers);
    }

    public static void sendControlDataToApi(String source, String remoteIp, int controlType, Hashtable<String, String> headers) throws Exception {
        WCPSessionManager.sendControlDataToApi(source, remoteIp, null, controlType, headers);
    }

    public static void sendControlDataToApi(String source, String remoteIp, String poolName, int controlType, Hashtable<String, String> headers) throws Exception {
        block13: {
            if (CommonUtil.isEmpty((String)remoteIp)) {
                throw new Exception("remoteip is null or empty");
            }
            if (!newUriMap.containsKey("api")) break block13;
            NewWCPServerSessionMap serverSessionMap = newUriMap.get("api");
            if (CommonUtil.isEmpty((String)source)) {
                block0: for (String src : serverSessionMap.overAllMap.keySet()) {
                    if (!serverSessionMap.overAllMap.get(src).containsKey(remoteIp)) continue;
                    if (CommonUtil.isEmpty((Map)serverSessionMap.overAllMap.get(src).get(remoteIp).get(poolName))) {
                        block1: for (String poolname : serverSessionMap.overAllMap.get(src).get(remoteIp).keySet()) {
                            for (String sid : serverSessionMap.overAllMap.get(src).get(remoteIp).get(poolname).keySet()) {
                                if (!sidConnMap.containsKey(sid)) continue;
                                WCPSessionManager.sendControlPacket(sid, controlType, headers);
                                logger.info("HB--> case1 sending control packet to api source=" + source + " ip=" + remoteIp + " poolName=" + poolName + " sid=" + sid);
                                continue block1;
                            }
                        }
                        continue;
                    }
                    for (String sid : serverSessionMap.overAllMap.get(src).get(remoteIp).get(poolName).keySet()) {
                        if (!sidConnMap.containsKey(sid)) continue;
                        WCPSessionManager.sendControlPacket(sid, controlType, headers);
                        logger.info("HB--> case2 sending control packet to api source=" + source + " ip=" + remoteIp + " poolName=" + poolName + " sid=" + sid);
                        continue block0;
                    }
                }
            } else if (CommonUtil.isEmpty((String)poolName)) {
                block4: for (String poolname : serverSessionMap.overAllMap.get(source).get(remoteIp).keySet()) {
                    for (String sid : serverSessionMap.overAllMap.get(source).get(remoteIp).get(poolname).keySet()) {
                        if (!sidConnMap.containsKey(sid)) continue;
                        WCPSessionManager.sendControlPacket(sid, controlType, headers);
                        logger.info("HB--> case3 sending control packet to api source=" + source + " ip=" + remoteIp + " poolName=" + poolName + " sid=" + sid);
                        continue block4;
                    }
                }
            } else {
                for (String sid : serverSessionMap.overAllMap.get(source).get(remoteIp).get(poolName).keySet()) {
                    if (!sidConnMap.containsKey(sid)) continue;
                    WCPSessionManager.sendControlPacket(sid, controlType, headers);
                    logger.info("HB--> case4 sending control packet to api source=" + source + " ip=" + remoteIp + " poolName=" + poolName + " sid=" + sid);
                    break;
                }
            }
        }
    }

    public static void sendControlData(String clusterName, String ip, int controlType, Hashtable<String, String> headers, String uri) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        if (uriMap.containsKey(uri)) {
            WCPServerSessionMap ds = uriMap.get(uri);
            Iterator itr1 = ((ConcurrentHashMap.KeySetView)ds.clusterContextIPMap.keySet()).iterator();
            if (itr1.hasNext()) {
                String clusterContext = (String)itr1.next();
                logger.info("HB--> Cluster_Context==> " + clusterContext);
                if (clusterName.equals(clusterContext.split("_")[0])) {
                    Iterator<String> itr2 = ds.clusterContextIPMap.get(clusterContext).iterator();
                    logger.info("HB--> ds.clusterContextIPMap.get(clusterContext)===> " + ds.clusterContextIPMap.get(clusterContext));
                    while (itr2.hasNext()) {
                        String sid;
                        String remoteIp = itr2.next();
                        logger.info("HB--> remoteIp==> " + remoteIp);
                        if (ip == null) {
                            if (!ds.ipSidMap.containsKey(clusterContext + "_" + remoteIp)) continue;
                            sid = ds.ipSidMap.get(clusterContext + "_" + remoteIp).get(0);
                            WCPSessionManager.sendControlPacket(sid, controlType, headers);
                            continue;
                        }
                        if (!ds.ipSidMap.containsKey(clusterContext + "_" + ip)) continue;
                        sid = ds.ipSidMap.get(clusterContext + "_" + ip).get(0);
                        logger.info("HB--> Cluster_Context_IP ==> " + clusterContext + "_" + ip + " sid=" + sid);
                        WCPSessionManager.sendControlPacket(sid, controlType, headers);
                        break;
                    }
                }
            }
        } else if (newUriMap.containsKey(uri)) {
            NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
            for (String source : serverSessionMap.overAllMap.keySet()) {
                for (String remoteIp : serverSessionMap.overAllMap.get(source).keySet()) {
                    if (!remoteIp.equals(ip)) continue;
                    block3: for (String poolName : serverSessionMap.overAllMap.get(source).get(remoteIp).keySet()) {
                        for (String sid : serverSessionMap.overAllMap.get(source).get(remoteIp).get(poolName).keySet()) {
                            if (!sidConnMap.containsKey(sid)) continue;
                            WCPSessionManager.sendControlPacket(sid, controlType, headers);
                            logger.info("HB--> sending control packet.. uri=" + uri + " source=" + source + " ip=" + remoteIp + " poolName=" + poolName + " sid=" + sid);
                            continue block3;
                        }
                    }
                }
            }
        } else {
            logger.info("WCPERR--> uri not found. uri=" + uri + " uriMap=" + uriMap + " newUriMap=" + newUriMap);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendMetaData(String sid, int metaType, String data) throws Exception {
        if (sid == null) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SESSION_ID_NULL.getErrorCode(), 1L);
            WCPStats.addErrorStats("SESSION_ID_NULL", "[method : sendMetaData]");
            throw new Exception("Sid is null");
        }
        WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 3, 0L, new Hashtable<String, String>(), metaType, data);
        if (!sidConnMap.containsKey(sid)) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_META.getErrorCode(), 1L);
            WCPStats.addErrorStats("NO_VALID_SESSION_FOUND_ON_META", "[sid : " + sid + "]");
            logger.info("WCPERR--> sid=" + sid + " sidConnMap=" + sidConnMap);
            throw new Exception("No Valid Session Present");
        }
        try {
            sidConnMap.get(sid).writeData(packet);
            logger.info("HB--> metaPacket successfully sent. sid=" + sid);
            return;
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_META_PACKET_FAILED.getErrorCode(), 1L);
            logger.log(Level.SEVERE, "WCPERR--> Error in connection while sending metaPacket. sid=" + sid, e);
            return;
        }
    }

    public static void sendResponsePacket(String resid, String reqid, String data, String sourceIP) throws Exception {
        if (!initialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
            return;
        }
        requestIdMap.remove(reqid);
        String reqSource = null;
        String sid = null;
        String uri = null;
        String[] splt = resid.split("&");
        if (splt.length > 1) {
            sid = splt[0];
            reqSource = splt[1];
            uri = reqSource.split("\\|")[0];
        } else {
            String[] sidArray = resid.split("@");
            sid = sidArray[1];
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("reqid", reqid);
        WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 8, 0L, ht, -1, data);
        if (!CommonUtil.isEmpty((String)sourceIP)) {
            packet.addHeader("x-req-source-ip", sourceIP);
        }
        if (sidConnMap.containsKey(sid)) {
            try {
                sidConnMap.get(sid).writeData(packet);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "error in connection while sending response packet. sid=" + sid, e);
            }
        } else {
            WCPSessionManager.writePacket(uri, reqSource, packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleWCPRequest(String remoteServerType, String remoteIp, Hashtable<String, String> packetHeaders, String sid, byte[] byteArray, String uri) {
        block36: {
            String idbEventId;
            String reqid = packetHeaders.get("reqid");
            if (!initialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
                return;
            }
            if (wcpFilter != null && !CommonUtil.isEmpty(packetHeaders)) {
                try {
                    WCPThreadLocal.setRKey(packetHeaders.get("rkey"));
                    WCPFilterResponse wcpFilterResponse = wcpFilter.doRKeyFilterForRequest(packetHeaders.get("uri"), packetHeaders.get("rkey"), WMSUtil.getInteger(packetHeaders.get("x-redirection-count"), 0), packetHeaders.get("rpath"));
                    if (wcpFilterResponse != null) {
                        if (wcpFilterResponse.isDroppedRequest()) {
                            WCPStats.wcpFilterFailed("request", "New Filter", uri, remoteIp);
                            return;
                        }
                        if (wcpFilterResponse.doRedirect()) {
                            if (wcpFilterResponse.getPoolName() != null) {
                                if (packetHeaders.containsKey("rpath")) {
                                    packetHeaders.put("rpath", packetHeaders.get("rpath") + "," + WCPConfManager.getServerIp());
                                } else {
                                    packetHeaders.put("rpath", WCPConfManager.getServerIp());
                                }
                                packetHeaders.put("x-redirection-count", Integer.toString(WMSUtil.getInteger(packetHeaders.get("x-redirection-count"), 0) + 1));
                                WCPResponse res = new WCPResponse(reqid, sid + "&" + remoteServerType);
                                res.setHeaders(packetHeaders);
                                WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, packetHeaders, -1, byteArray);
                                WCPDispatcher.forwardRequest(wcpFilterResponse.getPoolName(), wcpFilterResponse.getIp(), packet, res);
                            }
                            return;
                        }
                        WCPThreadLocal.rKeyFilterPassed();
                    }
                }
                catch (Exception e) {
                    StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_FILTER.getErrorCode(), 1L);
                    logger.log(Level.SEVERE, "WCPERR--> Exception while handling filter. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                    return;
                }
            }
            String data = null;
            try {
                data = new String(byteArray, "UTF-8");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WCPERR--> Error while converting byte array to String. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                return;
            }
            Hashtable ht = (Hashtable)HttpDataWraper.getObject((String)data);
            WCPRequest req = new WCPRequest(ht);
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-isforward-request"))) {
                req.addHeader("x-isforward-request", packetHeaders.get("x-isforward-request"));
            }
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-wcp-reqid"))) {
                req.addHeader("x-wcp-reqid", packetHeaders.get("x-wcp-reqid"));
            }
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-request-path"))) {
                req.addHeader("x-request-path", packetHeaders.get("x-request-path"));
            }
            req.addHeader("wcpuri", uri);
            if (Boolean.valueOf(req.getHeader("x-isforward-request")).booleanValue()) {
                if (!CommonUtil.isEmpty((String)packetHeaders.get("x-request-origin-ip"))) {
                    req.setRemoteIp(packetHeaders.get("x-request-origin-ip"));
                }
            } else {
                req.setRemoteIp(remoteIp);
            }
            String resId = remoteIp + "@" + sid;
            WCPResponse res = new WCPResponse(reqid, resId);
            String sourceIp = packetHeaders.get("x-req-source-ip");
            if (!CommonUtil.isEmpty((String)sourceIp)) {
                res.addHeader("x-req-source-ip", sourceIp);
            }
            if (!CommonUtil.isEmpty((String)(idbEventId = packetHeaders.get("x-idb-event-id")))) {
                req.addHeader("x-idb-event-id", idbEventId);
                res.addHeader("x-req-source-ip", sourceIp + ":" + idbEventId);
            }
            requestIdMap.put(reqid, resId);
            String status = null;
            WCPServlet servlet = null;
            long currTime = System.currentTimeMillis();
            try {
                servlet = WCPServletMapper.getServlet(req.getURI());
                if (servlet != null) {
                    WCPAccessLogger.log(req);
                    if (wcpFilter != null) {
                        try {
                            if (!wcpFilter.doFilterForRequest(req, res)) {
                                WCPStats.wcpFilterFailed("request", "Old Filter", req.getURI(), sourceIp);
                                return;
                            }
                        }
                        catch (Exception e) {
                            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_FILTER.getErrorCode(), 1L);
                            logger.log(Level.SEVERE, "WCPERR--> Exception while handling filter. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                            return;
                        }
                    }
                    try {
                        servlet.wcpService(req, res);
                        status = "Success";
                    }
                    catch (Exception e) {
                        status = "ServletException";
                        res.setResponseStr(status);
                        res.setResponseCode("500");
                        res.sendResponse();
                        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_SERVLET.getErrorCode(), 1L);
                        logger.log(Level.SEVERE, "WCPERR--> Exception in wcpService. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                    }
                    break block36;
                }
                status = "ServletNotFound";
                WCPStats.servletNotFound(remoteServerType, remoteIp, req.getURI(), uri);
                res.setResponseStr(status);
                res.setResponseCode(404);
                res.sendResponse();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WCPERR--> Error while checking servlet mapping; reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, ex);
            }
            finally {
                if (uri.equals("api")) {
                    WCPStats.addWCPAPIHits(DC.getServertype(), remoteServerType, remoteIp, req.getURI(), status, System.currentTimeMillis() - currTime);
                } else {
                    WCPStats.addWCPSrvHits(DC.getServertype(), remoteServerType, remoteIp, req.getURI(), status, System.currentTimeMillis() - currTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleWCPRequest(String uri, String reqSource, String remoteServerType, String remoteIp, Hashtable<String, String> packetHeaders, String sid, byte[] byteArray) {
        block35: {
            String idbEventId;
            String reqid = packetHeaders.get("reqid");
            if (!initialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
                return;
            }
            if (wcpFilter != null && !CommonUtil.isEmpty(packetHeaders)) {
                try {
                    WCPThreadLocal.setRKey(packetHeaders.get("rkey"));
                    WCPFilterResponse wcpFilterResponse = wcpFilter.doRKeyFilterForRequest(packetHeaders.get("uri"), packetHeaders.get("rkey"), WMSUtil.getInteger(packetHeaders.get("x-redirection-count"), 0), packetHeaders.get("rpath"));
                    if (wcpFilterResponse != null) {
                        if (wcpFilterResponse.isDroppedRequest()) {
                            WCPStats.wcpFilterFailed("request", "New Filter", uri, remoteIp);
                            logger.fine("SH --> Dropping request as per the new filter");
                            return;
                        }
                        if (wcpFilterResponse.doRedirect()) {
                            if (wcpFilterResponse.getPoolName() != null) {
                                if (packetHeaders.containsKey("rpath")) {
                                    packetHeaders.put("rpath", packetHeaders.get("rpath") + "," + WCPConfManager.getServerIp());
                                } else {
                                    packetHeaders.put("rpath", WCPConfManager.getServerIp());
                                }
                                packetHeaders.put("x-redirection-count", Integer.toString(WMSUtil.getInteger(packetHeaders.get("x-redirection-count"), 0) + 1));
                                WCPResponse res = new WCPResponse(reqid, sid + "&" + reqSource);
                                res.setHeaders(packetHeaders);
                                WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, packetHeaders, -1, byteArray);
                                WCPDispatcher.forwardRequest(wcpFilterResponse.getPoolName(), wcpFilterResponse.getIp(), packet, res);
                                logger.fine("SH --> Redirecting as per the new filter");
                            }
                            return;
                        }
                        WCPThreadLocal.rKeyFilterPassed();
                    }
                }
                catch (Exception e) {
                    StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_FILTER.getErrorCode(), 1L);
                    logger.log(Level.SEVERE, "WCPERR--> Exception while handling filter. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                    return;
                }
            }
            String data = null;
            try {
                data = new String(byteArray, "UTF-8");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WCPERR--> Error while converting byte array to String. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                return;
            }
            Hashtable ht = (Hashtable)HttpDataWraper.getObject((String)data);
            WCPRequest req = new WCPRequest(ht);
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-isforward-request"))) {
                req.addHeader("x-isforward-request", packetHeaders.get("x-isforward-request"));
            }
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-wcp-reqid"))) {
                req.addHeader("x-wcp-reqid", packetHeaders.get("x-wcp-reqid"));
            }
            if (!CommonUtil.isEmpty((String)packetHeaders.get("x-request-path"))) {
                req.addHeader("x-request-path", packetHeaders.get("x-request-path"));
            }
            req.addHeader("wcpuri", uri);
            if (Boolean.valueOf(req.getHeader("x-isforward-request")).booleanValue()) {
                req.setRemoteIp(req.getHeader("x-request-origin-ip"));
            } else {
                req.setRemoteIp(remoteIp);
            }
            String resId = sid + "&" + reqSource;
            WCPResponse res = new WCPResponse(reqid, resId);
            String sourceIp = packetHeaders.get("x-req-source-ip");
            if (!CommonUtil.isEmpty((String)sourceIp)) {
                res.addHeader("x-req-source-ip", sourceIp);
            }
            if (!CommonUtil.isEmpty((String)(idbEventId = packetHeaders.get("x-idb-event-id")))) {
                req.addHeader("x-idb-event-id", idbEventId);
                res.addHeader("x-req-source-ip", sourceIp + ":" + idbEventId);
            }
            requestIdMap.put(reqid, resId);
            String status = null;
            WCPServlet servlet = null;
            long currTime = System.currentTimeMillis();
            try {
                servlet = WCPServletMapper.getServlet(req.getURI());
                if (servlet != null) {
                    WCPAccessLogger.log(req);
                    if (wcpFilter != null) {
                        try {
                            if (!wcpFilter.doFilterForRequest(req, res)) {
                                WCPStats.wcpFilterFailed("request", "Old Filter", req.getURI(), sourceIp);
                                return;
                            }
                        }
                        catch (Exception e) {
                            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_FILTER.getErrorCode(), 1L);
                            logger.log(Level.SEVERE, "WCPERR--> Exception while handling filter. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                            return;
                        }
                    }
                    try {
                        servlet.wcpService(req, res);
                        status = "Success";
                    }
                    catch (Exception e) {
                        status = "ServletException";
                        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_REQUEST_SERVLET.getErrorCode(), 1L);
                        logger.log(Level.SEVERE, "WCPERR--> Exception in wcpService. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, e);
                    }
                    break block35;
                }
                status = "ServletNotFound";
                WCPStats.servletNotFound(remoteServerType, remoteIp, req.getURI(), uri);
                res.setResponseStr(status);
                res.setResponseCode(404);
                res.sendResponse();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WCPERR--> Error while checking servlet mapping; reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " uri=" + uri, ex);
            }
            finally {
                if (uri.equals("api")) {
                    WCPStats.addWCPAPIHits(DC.getServertype(), remoteServerType, remoteIp, req.getURI(), status, System.currentTimeMillis() - currTime);
                    AbsAutoReBalancer.addApiHits("wcpapi", WCPThreadLocal.getPRD(), WCPThreadLocal.getRemoteIp());
                } else {
                    WCPStats.addWCPSrvHits(DC.getServertype(), remoteServerType, remoteIp, req.getURI(), status, System.currentTimeMillis() - currTime);
                }
            }
        }
    }

    public static void handleForward(String context, String source, int dataType, Hashtable headers, byte[] data) {
        block12: {
            if (!initialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_SESSION_MANAGER_NOT_INITIALIZED.getErrorCode(), 1L);
                return;
            }
            Hashtable frwdinfo = (Hashtable)HttpDataWraper.getObject((String)("" + headers.get("frwdinfo")));
            if (WCPUtil.isNull(context) || listenerMap.get(context) == null) {
                context = "default";
            }
            long currTime = System.currentTimeMillis();
            frwdinfo = listenerMap.get(context).handleForward(source, frwdinfo);
            WCPStats.addWCPListenerStats("handle_forward", source, System.currentTimeMillis() - currTime);
            if (frwdinfo == null) {
                String newData = null;
                try {
                    newData = new String(data, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WCPSessionManager.processDataPackets(context, source, dataType, newData);
                return;
            }
            int frwdcnt = ((String)headers.get("route")).split("\\|").length;
            if (frwdcnt < 5) {
                String poolName = (String)frwdinfo.remove("poolName");
                String ip = (String)frwdinfo.remove("ip");
                if (poolName != null) {
                    try {
                        if (ip != null) {
                            WCPDispatcher.frwdData(poolName, ip, dataType, data, frwdinfo, headers);
                            break block12;
                        }
                        WCPDispatcher.frwdData(poolName, dataType, data, frwdinfo, headers);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "WCPERR--> [Exception - frwdData][" + poolName + "][" + ip + "][" + dataType + "][" + frwdinfo + "][" + headers + "]", e);
                        WCPSessionManager.returnErrorMsg(context, source, dataType, data, "Dispatcher Forward Failure");
                    }
                } else {
                    logger.info("[WCPSessionManager][handleForward][poolName - null][" + poolName + "]");
                    WCPSessionManager.returnErrorMsg(context, source, dataType, data, "Forward Failure - poolName equals null");
                }
            } else {
                logger.info("[WCPSessionManager][handleForward][Forward count exceeds][" + frwdcnt + "][" + headers.get("route") + "]");
                WCPSessionManager.returnErrorMsg(context, source, dataType, data, "Forward count exceeds");
                WCPStats.addWCPForwardMisuse(DC.getServertype());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean writePacket(String uri, String reqSource, WCPPacket packet) throws Exception {
        if (uri != null && reqSource != null) {
            NewWCPServerSessionMap serverSessionMap = newUriMap.get(uri);
            TreeMap<String, Long> map = serverSessionMap.reqSourceMap.get(reqSource);
            if (map == null) throw new Exception("No Valid Session Present, reqSourceMap is empty or null. uri=" + uri + " reqSouce=" + reqSource + " packetType=" + WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()));
            if (map.isEmpty()) {
                throw new Exception("No Valid Session Present, reqSourceMap is empty or null. uri=" + uri + " reqSouce=" + reqSource + " packetType=" + WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()));
            }
            String sid = map.firstKey();
            if (!sidConnMap.containsKey(sid)) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.NO_VALID_SESSION_FOUND_ON_RESPONSE.getErrorCode(), 1L);
                WCPStats.addErrorStats("NO_VALID_SESSION_FOUND_ON_RESPONSE", "[sid : " + sid + "]");
                throw new Exception("No Valid Session Present - writePacket. uri=" + uri + " reqSouce=" + reqSource);
            }
            try {
                if (packet.getPacketType() == 14) {
                    String reqid = packet.getHeader("reqid");
                    reqid = reqSource + "@" + sid + "@" + reqid;
                    packet.addHeader("reqid", reqid);
                }
                sidConnMap.get(sid).writeData(packet);
                WCPStats.sendRandomSidCount(uri, reqSource, sid);
                return true;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "error in connection while sending response packet. sid=" + sid, e);
                return false;
            }
        }
        logger.info("Invalid uri/reqSource. uri=" + uri + " reqSouce=" + reqSource);
        return false;
    }

    public static boolean hasConnection(String sid) {
        return sidConnMap.containsKey(sid);
    }

    public static WCPConnection getConnection(String sid) {
        return sidConnMap.get(sid);
    }

    public static String getServerSessionId(String csid) {
        if (csid != null) {
            return serverSidMap.get(csid);
        }
        return null;
    }

    public static void setServerSessionId(String csid, String ssid) {
        if (csid != null) {
            serverSidMap.put(csid, ssid);
        }
    }

    public static void setCVMismatch() {
        cvMismatchStatus.set(true);
    }

    public static boolean getCVMismatch() {
        return cvMismatchStatus.get() != null;
    }

    public static void clearCVMismatch() {
        cvMismatchStatus.remove();
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, ArrayList<String>>> getStatus() {
        NewWCPServerSessionMap serverSessionMap = null;
        ConcurrentHashMap<String, ConcurrentHashMap<String, ArrayList<String>>> status = new ConcurrentHashMap<String, ConcurrentHashMap<String, ArrayList<String>>>();
        for (String uri : newUriMap.keySet()) {
            status.put(uri, new ConcurrentHashMap());
            serverSessionMap = newUriMap.get(uri);
            for (String source : serverSessionMap.overAllMap.keySet()) {
                status.get(uri).put(source, new ArrayList(serverSessionMap.overAllMap.get(source).keySet()));
            }
        }
        return status;
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>>>> getDetailedStatus() {
        NewWCPServerSessionMap serverSessionMap = null;
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>>>> status = new ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>>>>();
        for (String uri : newUriMap.keySet()) {
            status.put(uri, new ConcurrentHashMap());
            serverSessionMap = newUriMap.get(uri);
            for (String source : serverSessionMap.overAllMap.keySet()) {
                status.get(uri).put(source, new ConcurrentHashMap());
                ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Long>>> ipMap = serverSessionMap.overAllMap.get(source);
                for (String ip : ipMap.keySet()) {
                    status.get(uri).get(source).put(ip, new ConcurrentHashMap());
                    ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> poolNameMap = serverSessionMap.overAllMap.get(source).get(ip);
                    for (String poolName : poolNameMap.keySet()) {
                        status.get(uri).get(source).get(ip).put(poolName, poolNameMap.get(poolName).size());
                    }
                }
            }
        }
        return status;
    }

    protected static String getRemoteip(int sessionOrder) {
        try {
            return (String)remoteIPSessions.get(sessionOrder);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static boolean isValidRemoteIp(String remoteIp) {
        return remoteIPSessions.containsKey((Object)remoteIp);
    }

    protected static boolean isValidPrd(String prd) {
        return prdRemoteipMap.containsKey(prd);
    }

    protected static String getPrd(String remoteIp) {
        if (remoteIPSessions.containsKey((Object)remoteIp)) {
            return ((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteIp)).getPrd();
        }
        return null;
    }

    protected static String getApiName(String remoteIp) {
        if (remoteIPSessions.containsKey((Object)remoteIp)) {
            return ((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteIp)).getApiName();
        }
        return null;
    }

    protected static String getPoolName(String remoteIp) {
        if (remoteIPSessions.containsKey((Object)remoteIp)) {
            return ((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteIp)).getPoolName();
        }
        return null;
    }

    protected static int getSessionsCount(String remoteip) {
        if (remoteIPSessions.containsKey((Object)remoteip)) {
            return ((APIRemoteIPSessionInfo)remoteIPSessions.get((Object)remoteip)).getSessionsCount();
        }
        return 0;
    }

    protected static boolean isSessionAvailable(String remoteip) {
        return remoteIPSessions.containsKey((Object)remoteip);
    }

    protected static LinkedHashMap<String, Map<String, Integer>> getAPISessionCount() {
        LinkedHashMap<String, Map<String, Integer>> sessionCountIpWise = new LinkedHashMap<String, Map<String, Integer>>();
        for (Map.Entry entry : remoteIPSessions.entrySet()) {
            String prd = ((APIRemoteIPSessionInfo)entry.getValue()).getPrd();
            if (!sessionCountIpWise.containsKey(prd)) {
                HashMap ipWiseCount = new HashMap();
                sessionCountIpWise.put(prd, ipWiseCount);
            }
            sessionCountIpWise.get(prd).put((String)entry.getKey(), ((APIRemoteIPSessionInfo)entry.getValue()).getSessionsCount());
        }
        return sessionCountIpWise;
    }

    protected static Hashtable<String, Integer> getAPISessionCount(String prd) {
        Hashtable<String, Integer> sessionCountIpWise = new Hashtable<String, Integer>();
        int totalSessionsCount = 0;
        for (Map.Entry entry : remoteIPSessions.entrySet()) {
            String entryPrd = ((APIRemoteIPSessionInfo)entry.getValue()).getPrd();
            if (!prd.equals(entryPrd)) continue;
            totalSessionsCount += ((APIRemoteIPSessionInfo)entry.getValue()).getSessionsCount();
            sessionCountIpWise.put((String)entry.getKey(), ((APIRemoteIPSessionInfo)entry.getValue()).getSessionsCount());
        }
        sessionCountIpWise.put("totalsessions", totalSessionsCount);
        return sessionCountIpWise;
    }

    protected static WCPFuture sendCBRequest(String prd, String ip, String poolName, WCPRequest wcpCBRequest, WCPResponseCBListener listener) throws Exception {
        if (!WCPDispatcher.isInitialized()) {
            throw new Exception("WCP not Initialized-sendCBRequest");
        }
        if (wcpCBRequest == null) {
            throw new Exception("Invalid WCPCBRequest");
        }
        WCPFuture future = null;
        String reqId = Long.toString(wcpCBRequestId.getAndIncrement());
        try {
            Hashtable<String, String> header = new Hashtable<String, String>();
            header.put("reqid", reqId);
            future = new WCPFuture(wcpCBRequest, null, listener, prd);
            if (ip != null) {
                wcpCBRequest.setDestinationIp(ip);
            }
            wcpCBRequest.setReqId(reqId);
            boolean result = false;
            try {
                wcpCBRequestMap.put(reqId, future);
                WCPCBReqTimeOutListener.TRACKER.touch(wcpCBRequest.getExpiryTime(), prd + "@" + reqId + "@" + wcpCBRequest.getExpiryTime());
                WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 14, 0L, header, -1, wcpCBRequest.getReqAsData());
                String reqSource = null;
                if (ip == null && poolName == null) {
                    reqSource = WCPSessionManager.getRandomReqSource(prd);
                } else if (ip == null && poolName != null) {
                    reqSource = "api|" + prd + "|" + WCPSessionManager.getRemoteIp(prd) + "|" + poolName;
                } else if (ip != null && poolName != null) {
                    reqSource = "api|" + prd + "|" + ip + "|" + poolName;
                } else {
                    throw new Exception("Invalid CBRequest params. prd=" + prd + " remoteIp=" + ip + " poolName=" + poolName + " servlet=" + wcpCBRequest.getURI());
                }
                result = WCPSessionManager.writePacket("api", reqSource, packet);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while sending WCPCBRequest. prd=" + prd, e);
                throw e;
            }
            finally {
                if (!result) {
                    WCPCBReqTimeOutListener.TRACKER.remove(wcpCBRequest.getExpiryTime(), prd + "@" + reqId + "@" + wcpCBRequest.getExpiryTime());
                    future = wcpCBRequestMap.remove(reqId);
                    if (future != null) {
                        future.cancel(true);
                        future = null;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.info("Exception - WCPDispatcher sendCBRequest prd=" + prd + " ip=" + ip + " reqId=" + reqId + " errMsg=" + ex.getMessage());
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_CB_REQUEST_FAILED.getErrorCode(), 1L);
            throw ex;
        }
        return future;
    }

    private static String getRandomReqSource(String source) throws Exception {
        ArrayList<String> reqSourceList = prdReqSourceMap.get(source);
        if (reqSourceList.isEmpty()) {
            throw new Exception("No valid reqSource found. reqSourceList is empty. source=" + source);
        }
        int minValue = 0;
        int randomIndex = 0;
        int maxValue = reqSourceList.size();
        if (maxValue > 1) {
            randomIndex = minValue + random.nextInt(maxValue - minValue);
        }
        return reqSourceList.get(randomIndex);
    }

    protected static String getRemoteIp(String prd) {
        if (prdRemoteipMap.containsKey(prd)) {
            return prdRemoteipMap.get(prd).get(0);
        }
        return null;
    }

    public static boolean invalidateWCPCBRequest(ArrayList<Object> list) {
        try {
            for (String string : list) {
                String[] splt = string.split("@");
                long expTime = Long.parseLong(splt[2]);
                if (System.currentTimeMillis() > expTime) {
                    WCPFuture future = WCPSessionManager.removeWCPFutureObj(splt[1]);
                    if (future != null) {
                        WCPResponse response = new WCPResponse(null, null);
                        response.setResponseCode("408");
                        response.setResponseStr("request_timeout");
                        future.setResponse(response);
                        logger.info("WCPCBRequest Canceled due to timeout. reqid=" + splt[1]);
                    }
                    WCPCBReqTimeOutListener.TRACKER.remove(expTime, string);
                    continue;
                }
                WCPCBReqTimeOutListener.TRACKER.touch(expTime, string);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "NSERR--> Error while invalidating WCPCBRequest. " + list, ex);
        }
        return true;
    }

    public static WCPFuture removeWCPFutureObj(String reqid) {
        return wcpCBRequestMap.remove(reqid);
    }

    public static boolean isWCPCBReqExpired(String id) {
        try {
            String[] splt = id.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime) {
                return false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception while checking isWCPCBReqExpired", e);
        }
        return true;
    }

    public static boolean isValidCBRequest(String id) {
        try {
            String[] splt = id.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime) {
                return wcpCBRequestMap.containsKey(splt[1]);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in isValidRequest", e);
        }
        return false;
    }

    public static void receiveCBResponse(String id, WCPPacket packet) {
        String[] data = id.split("@");
        String reqSource = data[0];
        String sid = data[1];
        String reqid = data[2];
        if (wcpCBRequestMap.get(reqid) != null) {
            try {
                if (packet != null && packet.getPacketType() == 15) {
                    cbResponseHandler.putData(reqSource, packet);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "[Exception - processWCPCBRequestData][" + reqSource + "][" + ex.getMessage() + "]", ex);
            }
        } else {
            logger.info("[WCP][No WCPFutureObject WCPCBRequest][" + reqSource + "][" + sid + "][" + reqid + "]");
        }
    }

    public static boolean isInitialised() {
        return initialized;
    }

    public static long getCBResponseHandlerQueueSize() {
        return cbResponseHandler.getQueueSize();
    }

    protected static void sendCBNotifyDataToAPI(String apiName, String prd, int dataType, String data) throws Exception {
        if (!WCPDispatcher.isInitialized()) {
            throw new Exception("WCP not Initialized-sendCBRequest");
        }
        if (CommonUtil.isEmpty((String)prd)) {
            throw new Exception("Prd is null");
        }
        boolean result = false;
        String reqSource = null;
        try {
            WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 4, 0L, null, dataType, data);
            reqSource = WCPSessionManager.getRandomReqSource((apiName + "-" + prd).toLowerCase());
            result = WCPSessionManager.writePacket("api", reqSource, packet);
            if (!result) {
                logger.warning("WCPERR--> sendCBNotifyDataToAPI failed. prd=" + prd + " reqSource=" + reqSource);
            }
        }
        catch (Exception ex) {
            try {
                logger.info("Exception - sendCBNotifyDataToAPI prd=" + prd + " reqSource=" + reqSource + " errMsg=" + ex.getMessage());
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_CB_NOTIFY_TO_API_FAILED.getErrorCode(), 1L);
                throw ex;
            }
            catch (Throwable throwable) {
                if (!result) {
                    logger.warning("WCPERR--> sendCBNotifyDataToAPI failed. prd=" + prd + " reqSource=" + reqSource);
                }
                throw throwable;
            }
        }
    }

    static {
        random = new SecureRandom();
    }
}

