/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.WmsUIDGenerator;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.StatusCollector;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPConnPoolConfig;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.WCPStatusCollector;
import com.adventnet.wms.servercommon.components.net.callback.ForwardCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPBrdCstCBListnr;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.servercommon.components.net.servlet.WCPBroadcastFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.timeoutlistener.WCPReqTimeOutListener;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.net.util.WCPPacketizer;
import com.adventnet.wms.servercommon.components.net.util.WCPSessionIDGenerator;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import com.adventnet.wms.servercommon.components.security.AccessTokenProvider;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPDispatcher {
    private static Logger logger = Logger.getLogger(WCPDispatcher.class.getName());
    private static boolean isInitialized = false;
    private static long initTime = -1L;
    private static Hashtable<String, WCPServerConnPool> connPoolMap;
    private static HashMap<String, String> idbPoolMap;

    public static boolean initialize() {
        return WCPDispatcher.initialize(true);
    }

    public static boolean initialize(boolean override) {
        if (!override && isInitialized) {
            return false;
        }
        if (!isInitialized || override) {
            try {
                WmsUIDGenerator.initialize(100L, 2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            WCPDispatcher.initInfluxStatsConf();
            if (connPoolMap == null) {
                connPoolMap = new Hashtable();
            }
            isInitialized = true;
            initTime = System.currentTimeMillis();
            StatusCollector.register(new WCPStatusCollector());
            logger.log(Level.INFO, "WCPINFO--> WCPDispatcher - Initialized!! ");
        }
        return isInitialized;
    }

    public static boolean registerListener(String context, WCPListener listener) throws Exception {
        return WCPSessionManager.registerListener(context, listener);
    }

    public static boolean registerCBListener(String context, WCPCBListener cbListener) throws Exception {
        return WCPSessionManager.registerCBListener(context, cbListener);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, null, "default", false);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, boolean enableAR) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, null, "default", enableAR);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, "default", false);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, boolean enableAR) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, "default", enableAR);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, false, 1, WCPConfManager.getWCPURI(), WCPConfManager.getWCPPort(), WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, 1, WCPConfManager.getWCPURI(), WCPConfManager.getWCPPort(), WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, arOpCode, WCPConfManager.getWCPURI(), WCPConfManager.getWCPPort(), WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode, String uri) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, arOpCode, uri, WCPConfManager.getWCPPort(), WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode, String uri, int port) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, arOpCode, uri, port, WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode, String uri, int port, boolean handleAsBB) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, arOpCode, uri, port, handleAsBB, WCPConfManager.getWCPLBTechnique(), WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getWCPAckQueueSize(), WCPConfManager.getWCPMinConnPerIP(), WCPConfManager.getWCPMaxConnPerIP(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode, String uri, int port, String lb_tech, int ipQueueSize, int ackQueueSize, int minConnPerIp, int maxConnPerIp, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        return WCPDispatcher.createWCPConnPool(poolName, serverType, remoteServerType, clusterName, context, enableAR, arOpCode, uri, port, false, lb_tech, ipQueueSize, ackQueueSize, minConnPerIp, maxConnPerIp, maxDataPerConn, maxDataAddRetryCount);
    }

    public static int createWCPConnPool(String poolName, String serverType, String remoteServerType, String clusterName, String context, boolean enableAR, int arOpCode, String uri, int port, boolean handleAsBB, String lb_tech, int ipQueueSize, int ackQueueSize, int minConnPerIp, int maxConnPerIp, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        Hashtable<String, String> seedsMap;
        if (connPoolMap.containsKey(poolName)) {
            logger.log(Level.WARNING, "WCPWARN--> PoolName {0} already exists", poolName);
            return 2;
        }
        long connPoolStatTime = System.currentTimeMillis();
        Hashtable<Object, Object> hashtable = seedsMap = clusterName == null ? new Hashtable() : WCPDispatcher.getSeedsMap(clusterName, true);
        if (seedsMap == null) {
            throw new Exception("Error while getting seeds from Admin poolName=" + poolName + " cluster=" + clusterName);
        }
        logger.log(Level.INFO, "[WCPDispatcher - createWCPConnPool] poolName={0} serverType={1} remoteServerType={2} clusterName={3} seedsMap={4}", new Object[]{poolName, serverType, remoteServerType, clusterName, seedsMap});
        WCPServerConnPool connPool = new WCPServerConnPool(poolName, serverType, remoteServerType, clusterName, seedsMap, context, enableAR, arOpCode, uri, port, handleAsBB, lb_tech, ipQueueSize, ackQueueSize, minConnPerIp, maxConnPerIp, maxDataPerConn, maxDataAddRetryCount);
        logger.log(Level.INFO, "[WCP][New ConnectionPool Created] poolName={0} serverType={1} remoteServerType={2} clusterName={3} seedsMap={4}", new Object[]{poolName, serverType, remoteServerType, clusterName, seedsMap});
        connPoolMap.put(poolName, connPool);
        WCPStats.addConnPoolTime(remoteServerType, clusterName, poolName, context, System.currentTimeMillis() - connPoolStatTime);
        return 1;
    }

    public static int createWCPConnPool(WCPConnPoolConfig info) throws Exception {
        Hashtable<String, String> seedsMap;
        if (connPoolMap.containsKey(info.getPoolName())) {
            logger.warning("WCPWARN--> PoolName " + info.getPoolName() + " already exists");
            return 2;
        }
        long connPoolStatTime = System.currentTimeMillis();
        Hashtable<Object, Object> hashtable = seedsMap = info.getClusterName() == null ? new Hashtable() : WCPDispatcher.getSeedsMap(info.getClusterName(), true);
        if (seedsMap == null) {
            throw new Exception("Error while getting seeds from Admin poolName=" + info.getPoolName() + " cluster=" + info.getClusterName());
        }
        info.setSeedsMap(seedsMap);
        logger.info("[WCPDispatcher - createWCPConnPool][" + info.getPoolName() + "][" + info.getServerType() + "][" + info.getRemoteServerType() + "][" + info.getClusterName() + "][" + seedsMap + "]");
        WCPServerConnPool connPool = new WCPServerConnPool(info);
        logger.info("[WCP][New ConnectionPool Created][" + info.getPoolName() + "][" + info.getServerType() + "][" + info.getRemoteServerType() + "][" + info.getClusterName() + "][" + seedsMap + "]");
        connPoolMap.put(info.getPoolName(), connPool);
        WCPStats.addConnPoolTime(info.getRemoteServerType(), info.getClusterName(), info.getPoolName(), info.getContext(), System.currentTimeMillis() - connPoolStatTime);
        return 1;
    }

    public static boolean refreshSeedsOfPool(String poolName) {
        return WCPDispatcher.refreshSeedsOfPool(poolName, true);
    }

    public static boolean refreshSeedsOfPool(String poolName, boolean isSelfConnEnabled) {
        boolean status = false;
        if (!isInitialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.WCP_NOT_INITIALIZED.getErrorCode(), 1L);
            logger.log(Level.INFO, "HB--> refreshSeedsOfPool failed. WCP Not Initialized. poolName={0}", poolName);
            return status;
        }
        try {
            WCPServerConnPool connPool = connPoolMap.get(poolName);
            if (connPool == null) {
                logger.log(Level.WARNING, "WCPWARN--> Given pool {0} is not found", poolName);
                return status;
            }
            if (connPool.isOnDemand()) {
                logger.log(Level.WARNING, "WCPWARN--> Given pool {0} is an OnDemand and no cluster name is present, hence skipping connection updation.", poolName);
                return true;
            }
            String clusterName = connPool.getClusterName();
            Hashtable<String, String> newSeedsMap = WCPDispatcher.getSeedsMap(clusterName, connPool.isSelfConnEnabled());
            if (newSeedsMap == null) {
                logger.log(Level.WARNING, "WCPWARN--> Error while getting seeds map for pool name={0} for cluster={1}", new Object[]{poolName, clusterName});
                return status;
            }
            if (newSeedsMap.isEmpty()) {
                logger.log(Level.INFO, "WCPERR--> warmUpConnections - seedList is empty; cluster={0}", clusterName);
                return status;
            }
            connPool.manageConnections(newSeedsMap);
            logger.log(Level.INFO, "WCPINFO--> WCPDispatcher - updateConnectionsUsingPoolName poolName={0} cluster={1} newSeedsMap={2}", new Object[]{poolName, clusterName, newSeedsMap});
            status = true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "[Exception - WCPDispatcher][updateConnectionsUsingPoolName] poolName=" + poolName, ex);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.UPDATE_CONNECTIONS.getErrorCode(), 1L);
            WCPStats.addErrorStats("REFRESH_SEEDS_OF_POOL", "[poolName : " + poolName + "]");
        }
        return status;
    }

    public static boolean refreshSeeds(String clusterName) {
        boolean status = false;
        if (!isInitialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.WCP_NOT_INITIALIZED.getErrorCode(), 1L);
            logger.log(Level.INFO, "HB--> refreshSeeds failed. WCP Not Initialized. clusterName={0}", clusterName);
            return status;
        }
        if (WCPUtil.isNull(clusterName)) {
            logger.log(Level.WARNING, "WCPWARN--> clustername is null.");
            return status;
        }
        try {
            if (!WCPDispatcher.isConnPoolAvailable(clusterName)) {
                return false;
            }
            int selfConnEnabledPools = 0;
            int selfConnDisabledPools = 0;
            int connPoolCount = connPoolMap.size();
            for (String poolname : connPoolMap.keySet()) {
                WCPServerConnPool connPool = connPoolMap.get(poolname);
                if (connPool.isSelfConnEnabled()) {
                    ++selfConnEnabledPools;
                    continue;
                }
                ++selfConnDisabledPools;
            }
            Hashtable<String, String> newSeedsMap = null;
            Hashtable<String, String> newSeedsMapWithoutSelfIp = null;
            if (selfConnEnabledPools == connPoolCount) {
                newSeedsMap = WCPDispatcher.getSeedsMap(clusterName, true);
            } else if (selfConnEnabledPools > 0 && selfConnDisabledPools > 0) {
                newSeedsMap = WCPDispatcher.getSeedsMap(clusterName, true);
                newSeedsMapWithoutSelfIp = WCPDispatcher.getSeedsMap(clusterName, false);
            } else {
                newSeedsMapWithoutSelfIp = WCPDispatcher.getSeedsMap(clusterName, false);
            }
            if (newSeedsMap == null) {
                logger.log(Level.WARNING, "WCPWARN--> Error while getting seeds map for clusterName={0}", clusterName);
                return false;
            }
            if (newSeedsMap.isEmpty()) {
                logger.log(Level.WARNING, "WCPERR--> warmUpConnections - seedList is empty; cluster={0}", clusterName);
                return false;
            }
            for (String poolname : connPoolMap.keySet()) {
                WCPServerConnPool connPool = connPoolMap.get(poolname);
                if (!clusterName.equals(connPool.getClusterName())) continue;
                if (connPool.isSelfConnEnabled()) {
                    connPool.manageConnections(newSeedsMap);
                } else {
                    connPool.manageConnections(newSeedsMapWithoutSelfIp);
                }
                logger.log(Level.INFO, "WCPINFO--> WCPDispatcher - updateConnectionsUsingClusterName poolName={0} clusterName={1} seedsMap={2} selfConnEnabled={3}", new Object[]{poolname, clusterName, newSeedsMap, connPool.getClusterName()});
                status = true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "[Exception - WCPDispatcher][updateConnectionsUsingClusterName] clusterName=" + clusterName, ex);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.UPDATE_CONNECTIONS.getErrorCode(), 1L);
            WCPStats.addErrorStats("REFRESH_SEEDS_OF_CLUSTER", "[clusterName : " + clusterName + "]");
        }
        return status;
    }

    public static void processNotifyPackets(String poolName, String remoteIp, String data) throws Exception {
        WCPServerConnPool connPool = null;
        if (poolName != null) {
            connPool = connPoolMap.get(poolName);
            if (connPool != null) {
                WCPSessionManager.processNotifyPackets(connPool.getContext(), connPool.getPoolName(), remoteIp, data);
            } else {
                logger.log(Level.INFO, "HB_ERR--> sendCBNotifyData. poolName not found, poolName={0}", poolName);
            }
        } else {
            logger.log(Level.INFO, "HB_ERR--> poolName is null. remoteIp={0}", remoteIp);
        }
    }

    public static void notifySeedsChange(String message, String uri) throws Exception {
        WCPDispatcher.sendMetaData(1, message, uri);
    }

    public static void receiveResponse(String poolName, String id, WCPPacket packet) {
        WCPServerConnPool connPool = null;
        if (poolName != null) {
            connPool = connPoolMap.get(poolName);
            if (connPool != null) {
                connPool.receiveResponse(id, packet);
            } else {
                logger.log(Level.INFO, "HB_ERR--> IDB-receiveResponse. poolName not found, poolName={0}", poolName);
            }
        } else {
            logger.log(Level.INFO, "HB_ERR--> IDB-receiveResponse poolName is null");
        }
    }

    public static boolean setIsPoolCVDependent(String poolName, boolean isCVDependent) {
        if (!connPoolMap.containsKey(poolName)) {
            logger.log(Level.WARNING, "WCPWARN--> Connection pool not created; PoolName={0}", poolName);
            return false;
        }
        return connPoolMap.get(poolName).setCVDependency(isCVDependent);
    }

    @Deprecated
    public static void setCallBackHandlerPoolSize(String poolName, int corePoolSize, int maximumPoolSize) {
        connPoolMap.get(poolName).setCallBackHandlerPoolSize(corePoolSize, maximumPoolSize);
    }

    public static WCPConnPoolConfig getConnPoolConfig(String poolName) {
        if (!connPoolMap.containsKey(poolName)) {
            logger.warning("WCPWARN--> Connection pool not created; PoolName=" + poolName);
            return null;
        }
        return connPoolMap.get(poolName).getConnPoolConfig();
    }

    @Deprecated
    public static void setCallBackHandlerCorePoolSize(String poolName, int corePoolSize) {
        connPoolMap.get(poolName).setCallBackHandlerCorePoolSize(corePoolSize);
    }

    @Deprecated
    public static void setCallBackHandlerMaxPoolSize(String poolName, int maximumPoolSize) {
        connPoolMap.get(poolName).setCallBackHandlerMaxPoolSize(maximumPoolSize);
    }

    @Deprecated
    public static void setResponseHandlerPoolSize(String poolName, int corePoolSize, int maximumPoolSize) {
        connPoolMap.get(poolName).setResponseHandlerPoolSize(corePoolSize, maximumPoolSize);
    }

    @Deprecated
    public static void setResponseHandlerCorePoolSize(String poolName, int corePoolSize) {
        connPoolMap.get(poolName).setResponseHandlerCorePoolSize(corePoolSize);
    }

    @Deprecated
    public static void setResponseHandlerMaxPoolSize(String poolName, int maximumPoolSize) {
        connPoolMap.get(poolName).setResponseHandlerMaxPoolSize(maximumPoolSize);
    }

    @Deprecated
    public static void setIDBCallBackHandlerPoolSize(String poolName, int corePoolSize, int maximumPoolSize) {
        connPoolMap.get(poolName).setIDBCallBackHandlerPoolSize(corePoolSize, maximumPoolSize);
    }

    public static void sendData(String poolName, String data) throws Exception {
        WCPDispatcher.sendData(poolName, null, 0, data, null, null);
    }

    public static void sendData(String poolName, String ip, String data) throws Exception {
        WCPDispatcher.sendData(poolName, ip, 0, data, null, null);
    }

    public static void sendData(String poolName, String ip, String data, ArrayList<String> rkeys) throws Exception {
        WCPDispatcher.sendData(poolName, ip, 0, data, null, rkeys);
    }

    public static void sendData(String poolName, String ip, String data, String rkey) throws Exception {
        WCPDispatcher.sendData(poolName, ip, 0, data, rkey, null);
    }

    public static void sendData(String poolName, int dataType, String data) throws Exception {
        WCPDispatcher.sendData(poolName, null, dataType, data, null, null);
    }

    public static void sendData(String poolName, String ip, int dataType, String data) throws Exception {
        WCPDispatcher.sendData(poolName, ip, dataType, data.getBytes("UTF-8"), null, null, null, null);
    }

    public static void sendData(String poolName, String ip, int dataType, String data, String rkey, ArrayList<String> rkeys) throws Exception {
        WCPDispatcher.sendData(poolName, ip, dataType, data.getBytes("UTF-8"), null, null, rkey, rkeys);
    }

    public static void frwdData(String poolName, String data, Hashtable frwdinfo) throws Exception {
        WCPDispatcher.frwdData(poolName, 0, data, frwdinfo);
    }

    public static void frwdData(String poolName, String ip, String data, Hashtable frwdinfo) throws Exception {
        WCPDispatcher.frwdData(poolName, ip, 0, data, frwdinfo);
    }

    public static void frwdData(String poolName, int dataType, String data, Hashtable frwdinfo) throws Exception {
        WCPDispatcher.frwdData(poolName, null, dataType, data, frwdinfo);
    }

    public static void frwdData(String poolName, String ip, int dataType, String data, Hashtable frwdinfo) throws Exception {
        WCPDispatcher.frwdData(poolName, ip, dataType, data.getBytes("UTF-8"), frwdinfo, null);
    }

    public static void frwdData(String poolName, int dataType, byte[] data, Hashtable frwdinfo, Hashtable header) throws Exception {
        WCPDispatcher.frwdData(poolName, null, dataType, data, frwdinfo, header);
    }

    public static void frwdData(String poolName, String ip, int dataType, byte[] data, Hashtable header) throws Exception {
        WCPDispatcher.sendData(poolName, ip, dataType, data, null, header, null, null);
    }

    public static void frwdData(String poolName, String ip, int dataType, byte[] data, Hashtable frwdinfo, Hashtable header) throws Exception {
        WCPDispatcher.sendData(poolName, ip, dataType, data, frwdinfo, header, null, null);
    }

    public static void sendData(String poolName, String ip, int dataType, byte[] data, Hashtable<String, String> frwdinfo, Hashtable<String, String> header, String rkey, ArrayList<String> rkeys) throws Exception {
        WCPServerConnPool connPool;
        boolean sendPacketStatus;
        block15: {
            if (!isInitialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_WCP_NOT_INITIALIZED.getErrorCode(), 1L);
                throw new Exception("WCP not Initialized");
            }
            if (data == null) {
                throw new Exception("Data is null");
            }
            if ((long)data.length > WCPConfManager.getWcpMaxAcceptableDataSize()) {
                if (connPoolMap != null) {
                    WCPStats.addWCPDataSizeStats(DC.getServertype(), connPoolMap.get(poolName).getRemoteServerType(), poolName, ip, "exceeds", data.length);
                }
                throw new Exception("Data Size greater the maximum acceptable limit");
            }
            int packetType = 1;
            if (header == null) {
                header = new Hashtable();
            }
            if (!CommonUtil.isEmpty(rkeys)) {
                header.put("rkeys", HttpDataWraper.getString(rkeys));
            } else if (!CommonUtil.isEmpty((String)rkey)) {
                header.put("rkey", rkey);
            }
            if (frwdinfo != null) {
                packetType = 6;
                String route = header.get("route");
                if (route == null) {
                    header.put("route", "" + WCPConfManager.getServerIp());
                } else {
                    header.put("route", route + "|" + WCPConfManager.getServerIp());
                }
                header.put("frwdinfo", "" + frwdinfo);
            }
            sendPacketStatus = false;
            connPool = null;
            try {
                connPool = connPoolMap.get(poolName);
                if (connPool != null) {
                    WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, packetType, 0L, header, dataType, data);
                    sendPacketStatus = ip != null ? connPool.sendPacket(packet, ip) : connPool.sendPacket(packet);
                    break block15;
                }
                WCPSessionManager.returnErrorMsg(poolName, dataType, new String(data, "UTF-8"), "WCPConnPool Not Initilized!!");
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "[Exception - WCPDispatcher][sendData] poolName={0} ip={1} errorMsg={2}", new Object[]{poolName, ip, ex.getMessage()});
                WCPUtil.printDebugLogs("[Exception - WCPDispatcher][sendData][" + poolName + "][" + ip + "][" + ex.getMessage() + "]", ex);
                WCPSessionManager.returnErrorMsg(poolName, dataType, new String(data, "UTF-8"), ex.getMessage());
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEND_DATA_FAILED", "[poolName : " + poolName + "][remoteIP : " + ip + "][method : sendData]");
                throw ex;
            }
        }
        if (!sendPacketStatus) {
            String context = connPool == null ? "default" : connPool.getContext();
            WCPSessionManager.returnErrorMsg(context, poolName, dataType, new String(data, "UTF-8"), "WCP Limitations");
        }
    }

    public static void sendPacket(String poolName, WCPPacket packet) throws Exception {
        WCPDispatcher.sendPacket(poolName, packet, null);
    }

    public static void sendPacket(String poolName, WCPPacket packet, String ip) throws Exception {
        WCPServerConnPool connPool;
        boolean sendPacketStatus;
        block6: {
            if (!isInitialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_WCP_NOT_INITIALIZED.getErrorCode(), 1L);
                throw new Exception("WCP not Initialized");
            }
            if (packet == null) {
                throw new Exception("Packet is null");
            }
            sendPacketStatus = false;
            connPool = null;
            try {
                connPool = connPoolMap.get(poolName);
                if (connPool != null) {
                    sendPacketStatus = ip != null ? connPool.sendPacket(packet, ip) : connPool.sendPacket(packet);
                    break block6;
                }
                WCPSessionManager.returnErrorMsg(poolName, packet.getPacketType(), new String(packet.getPayLoadData(), "UTF-8"), "WCPConnPool Not Initilized!! [sendPacket]");
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "[Exception - WCPDispatcher][sendData] poolname=" + poolName, ex);
                WCPSessionManager.returnErrorMsg(poolName, packet.getPacketType(), new String(packet.getPayLoadData(), "UTF-8"), ex.getMessage());
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEND_DATA_FAILED", "[poolName : " + poolName + "][remoteIP : " + ip + "][method : sendPacket][param : wcpPacketObject]");
                throw ex;
            }
        }
        if (!sendPacketStatus) {
            String context = connPool == null ? "default" : connPool.getContext();
            WCPSessionManager.returnErrorMsg(context, poolName, packet.getPacketType(), new String(packet.getPayLoadData(), "UTF-8"), "WCP Limitations");
        }
    }

    public static void sendPacket(String poolName, byte[] packet, String ip) throws Exception {
        WCPServerConnPool connPool;
        boolean sendPacketStatus;
        block7: {
            if (!isInitialized) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_WCP_NOT_INITIALIZED.getErrorCode(), 1L);
                throw new Exception("WCP not Initialized");
            }
            if (packet == null) {
                throw new Exception("Packet is null");
            }
            sendPacketStatus = false;
            connPool = null;
            try {
                connPool = connPoolMap.get(poolName);
                if (connPool != null) {
                    if (ip != null) {
                        sendPacketStatus = connPool.sendPacket(packet, ip, false);
                    }
                    break block7;
                }
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "[Exception - WCPDispatcher][sendData] poolname=" + poolName, ex);
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEND_DATA_FAILED", "[poolName : " + poolName + "][remoteIP : " + ip + "][method : sendPacket][param : byteArrayObject]");
                throw ex;
            }
        }
        if (!sendPacketStatus) {
            String string = connPool == null ? "default" : connPool.getContext();
        }
    }

    public static void sendDataToDr(String poolName, String data) throws Exception {
        WCPDispatcher.sendDataToDr(poolName, 0, data);
    }

    public static void sendDataToDr(String poolName, int dataType, String data) throws Exception {
        WCPDispatcher.sendDataToDr(poolName, dataType, data, null, null);
    }

    public static void sendDataToDr(String poolName, int dataType, String data, String rkey) throws Exception {
        WCPDispatcher.sendDataToDr(poolName, dataType, data, rkey, null);
    }

    public static void sendDataToDr(String poolName, String data, String rkey) throws Exception {
        WCPDispatcher.sendDataToDr(poolName, data, rkey, null);
    }

    public static void sendDataToDr(String poolName, String data, String rkey, String cluster) throws Exception {
        WCPDispatcher.sendDataToDr(poolName, 0, data, rkey, cluster);
    }

    public static void sendDataToDr(String poolName, int dataType, String data, String rkey, String cluster) throws Exception {
        WCPDispatcher.sendDataToDc(poolName, dataType, data, DC.getDrDCId(), rkey, cluster);
    }

    public static void sendDataToDc(String poolName, int dataType, String data, String dcName, String rkey, String cluster) throws Exception {
        WCPDispatcher.sendDataToDc(poolName, dataType, data.getBytes("UTF-8"), dcName, rkey, cluster);
    }

    public static void sendDataToDc(String poolName, int dataType, byte[] data, String dcName) throws Exception {
        WCPDispatcher.sendDataToDc(poolName, dataType, data, dcName, null, null);
    }

    public static void sendDataToDc(String poolName, int dataType, byte[] data, String dcName, String rkey, String cluster) throws Exception {
        if (!isInitialized) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_WCP_NOT_INITIALIZED.getErrorCode(), 1L);
            throw new Exception("WCP not Initialized");
        }
        if (data == null) {
            throw new Exception("Data is null");
        }
        if ((long)data.length > WCPConfManager.getWcpMaxAcceptableDataSize()) {
            WCPStats.addWCPDataSizeStats(DC.getServertype(), "idbserver", "idbconnpool", "unknown", "exceeds", data.length);
            throw new Exception("Data Size greater the maximum acceptable limit");
        }
        WCPPacket packet = WCPPacketizer.getPacketFromData(0L, 1, 0L, null, dataType, data);
        WCPDispatcher.sendPacketToIDB(dcName, packet, poolName, rkey, cluster);
    }

    protected static boolean sendPacketToIDB(String destinationDCId, WCPPacket packet, String poolName) throws Exception {
        return WCPDispatcher.sendPacketToIDB(destinationDCId, packet, poolName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static boolean sendPacketToIDB(String destinationDCId, WCPPacket packet, String poolName, String rkey, String cluster) throws Exception {
        WCPServerConnPool sourcePool = connPoolMap.get(poolName);
        if (sourcePool == null) {
            logger.log(Level.WARNING, "HB_ERR--> poolName={0} Not found.", poolName);
            return false;
        }
        if (sourcePool.isOnDemand()) {
            logger.log(Level.WARNING, "HB_ERR--> Given connpool is OnDemand. poolName={0}. Can't send to another DC", poolName);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_TO_DC_FAILED_ONDEMAND.getErrorCode(), 1L);
            throw new Exception("Does not support onDemand across DC's poolName=" + poolName);
        }
        WCPServerConnPool idbConnPool = connPoolMap.get("idbconnpool");
        if (idbConnPool == null) {
            String string = "idbconnpool";
            // MONITORENTER : "idbconnpool"
            idbConnPool = connPoolMap.get("idbconnpool");
            if (idbConnPool == null) {
                WCPDispatcher.createWCPConnPool("idbconnpool", DC.getServertype(), "idbserver", "idbserver-main", "intra_dc", false, 1, File.separator + "idb");
                idbConnPool = connPoolMap.get("idbconnpool");
                idbConnPool.setMaxConnPerIp(7);
                idbConnPool.setLBTechnique("rr");
            }
            // MONITOREXIT : string
        }
        try {
            String idbEventId = WCPSessionIDGenerator.getIDBEventId();
            idbPoolMap.putIfAbsent(destinationDCId, DC.getDCId() + "@" + destinationDCId + "@" + DC.getServertype());
            packet.addHeader("x-req-source-ip", WCPConfManager.getServerIp());
            packet.addHeader("x-idb-event-id", idbEventId);
            Hashtable<String, String> idbHeader = new Hashtable<String, String>();
            idbHeader.put("x-req-source-dc", DC.getDCId());
            idbHeader.put("x-req-source-pn", sourcePool.getPoolName());
            idbHeader.put("x-req-source-cluster", DC.getCluster());
            idbHeader.put("x-req-dest-context", sourcePool.getContext());
            idbHeader.put("x-req-dest-dc", destinationDCId);
            idbHeader.put("idbconnpool", idbPoolMap.get(destinationDCId));
            idbHeader.put("x-idb-event-id", idbEventId);
            idbHeader.put("x-idb-event-type", WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()));
            idbHeader.put("x-idb-data-type", "idb-data");
            if (rkey != null) {
                idbHeader.put("rkey", rkey);
            }
            if (WCPUtil.isNull(cluster)) {
                idbHeader.put("x-req-dest-cluster", sourcePool.getClusterName());
            } else {
                idbHeader.put("x-req-dest-cluster", cluster);
            }
            WCPPacket idbpacket = WCPPacketizer.getPacketFromData(0L, 9, 0L, idbHeader, 0, packet.getCompletePacketData());
            return idbConnPool.sendPacket(idbpacket);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[Exception - WCPDispatcher][sendDataToDr]", e);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_DATA_FAILED.getErrorCode(), 1L);
            WCPStats.addErrorStats("SEND_DATA_FAILED", "[poolName : " + poolName + "][method : sendPacketToIDB]");
            throw e;
        }
    }

    public static void sendCBNotifyDataToAPI(String apiName, String prd, int dataType, String data) throws Exception {
        WCPSessionManager.sendCBNotifyDataToAPI(apiName, prd, dataType, data);
    }

    public static void sendCBNotifyData(String destination, int dataType, String data) throws Exception {
        WCPSessionManager.sendCBNotifyData(destination, dataType, data);
    }

    public static void sendMetaData(int metaType, String data, String uri) throws Exception {
        WCPSessionManager.sendMetaPacketToAll(metaType, data, uri);
    }

    public static WCPFuture sendRequest(String poolName, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        return WCPDispatcher.sendRequest(poolName, null, req, listener);
    }

    public static WCPFuture sendRequest(String poolName, String ip, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        return WCPDispatcher.sendRequest(poolName, ip, req, listener, false);
    }

    public static WCPFuture sendRequestToDR(String poolName, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        return WCPDispatcher.sendRequestToDR(poolName, req, listener, null);
    }

    public static WCPFuture sendRequestToDc(String poolName, String dcName, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        return WCPDispatcher.sendRequest(poolName, null, req, listener, false, dcName, null, null);
    }

    public static WCPFuture sendRequestToDR(String poolName, WCPRequest req, WCPResponseCBListener listener, String rkey) throws Exception {
        return WCPDispatcher.sendRequestToDR(poolName, req, listener, rkey, null);
    }

    public static WCPFuture sendRequestToDR(String poolName, WCPRequest req, WCPResponseCBListener listener, String rkey, String cluster) throws Exception {
        return WCPDispatcher.sendRequest(poolName, null, req, listener, false, DC.getDrDCId(), rkey, cluster);
    }

    protected static WCPFuture sendRequest(String poolName, String ip, WCPRequest req, WCPResponseCBListener listener, boolean isFrwdRequest) throws Exception {
        return WCPDispatcher.sendRequest(poolName, ip, req, listener, isFrwdRequest, null, null, null);
    }

    protected static WCPFuture sendRequest(String poolName, String ip, WCPRequest req, WCPResponseCBListener listener, boolean isFrwdRequest, String dcName, String rkey, String cluster) throws Exception {
        WCPFuture future;
        block6: {
            if (!isInitialized) {
                throw new Exception("WCP not Initialized");
            }
            if (req == null) {
                throw new Exception("Invalid WCPRequest");
            }
            if (connPoolMap.get(poolName) == null) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CONNECTION_POOL_NOT_INITIALIZED.getErrorCode(), 1L);
                WCPStats.addErrorStats("CONNECTION_POOL_NOT_INITIALIZED", "[poolName : " + poolName + "]");
                WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", "WCPConnPool Not Initialized!!");
                throw new Exception("WCPConnPool Not Initialized");
            }
            future = null;
            try {
                WCPServerConnPool connPool = connPoolMap.get(poolName);
                if (connPool != null) {
                    future = ip != null ? connPool.sendRequest(req, listener, ip, isFrwdRequest, dcName, rkey, cluster) : connPool.sendRequest(req, listener, isFrwdRequest, dcName, rkey, cluster);
                    break block6;
                }
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "[Exception - WCPDispatcher][sendRequest] poolName={0} ip={1} errorMsg={2}", new Object[]{poolName, ip, ex.getMessage()});
                WCPUtil.printDebugLogs("[Exception - WCPDispatcher][sendRequest][" + poolName + "][" + ip + "][" + ex.getMessage() + "]", ex);
                WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", ex.getMessage());
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_REQUEST_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEND_REQUEST_FAILED", "[poolName : " + poolName + "][IP : " + ip + "]");
                throw ex;
            }
        }
        return future;
    }

    public static WCPFuture sendCBRequest(String prd, WCPRequest wcpRequest, WCPResponseCBListener listener) throws Exception {
        return WCPDispatcher.sendCBRequest(prd, null, null, wcpRequest, listener);
    }

    public static WCPFuture sendCBRequest(String prd, String ip, String poolName, WCPRequest wcpRequest, WCPResponseCBListener listener) throws Exception {
        return WCPSessionManager.sendCBRequest(prd, ip, poolName, wcpRequest, listener);
    }

    public static void forwardRequest(String poolName, String ip, WCPRequest req, WCPResponse res) throws Exception {
        WCPDispatcher.sendRequest(poolName, ip, req, new ForwardCBListener(res), true);
    }

    public static WCPFuture forwardRequest(String poolName, String ip, WCPPacket packet, WCPResponse res) throws Exception {
        if (!isInitialized) {
            throw new Exception("WCP not Initialized");
        }
        if (connPoolMap.get(poolName) == null) {
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CONNECTION_POOL_NOT_INITIALIZED.getErrorCode(), 1L);
            WCPStats.addErrorStats("CONNECTION_POOL_NOT_INITIALIZED", "[poolName : " + poolName + "]");
            WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", "WCPConnPool Not Initialized!!");
            throw new Exception("WCPConnPool Not Initialized");
        }
        WCPFuture future = null;
        try {
            WCPServerConnPool connPool = connPoolMap.get(poolName);
            if (connPool == null) {
                throw new Exception("WCPConnPool Not Initialized");
            }
            future = connPool.forwardRequest(packet, ip, new ForwardCBListener(res));
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "[Exception - WCPDispatcher][sendRequest] poolName={0} ip={1} errorMsg={2}", new Object[]{poolName, ip, ex.getMessage()});
            WCPUtil.printDebugLogs("[Exception - WCPDispatcher][sendRequest][" + poolName + "][" + ip + "][" + ex.getMessage() + "]", ex);
            WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", ex.getMessage());
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_REQUEST_FAILED.getErrorCode(), 1L);
            WCPStats.addErrorStats("SEND_REQUEST_FAILED", "[poolName : " + poolName + "][IP : " + ip + "]");
            throw ex;
        }
        return future;
    }

    public static void forwardRequest(String poolName, String ip, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        WCPDispatcher.sendRequest(poolName, ip, req, listener, true);
    }

    public static WCPBroadcastFuture sendBroadCastRequest(String poolName, WCPRequest req, WCPBrdCstCBListnr listener) throws Exception {
        return WCPDispatcher.sendBroadCastRequest(poolName, null, req, listener);
    }

    public static WCPBroadcastFuture sendBroadCastRequestToDCs(String poolName, Set<String> dcNameList, WCPRequest req, WCPBrdCstCBListnr listener) throws Exception {
        if (!isInitialized) {
            throw new Exception("WCP not Initialized");
        }
        if (req == null) {
            throw new Exception("Invalid WCPRequest");
        }
        if (dcNameList == null) {
            throw new Exception("Empty DC List");
        }
        if (connPoolMap.get(poolName) == null) {
            WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", "WCPConnPool Not Initialized!!");
            throw new Exception("WCPConnPool Not Initialized");
        }
        WCPBroadcastFuture bcFuture = null;
        try {
            WCPServerConnPool connPool = connPoolMap.get(poolName);
            if (connPool == null) {
                throw new Exception("WCPConnPool Not Initialized");
            }
            bcFuture = connPool.sendBroadCastRequestToDcs(req, listener, dcNameList);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "[Exception - WCPDispatcher][sendBroadCastRequestToDCs] poolName={0} dcNameList={1} errorMsg={2}", new Object[]{poolName, dcNameList, ex.getMessage()});
            WCPUtil.printDebugLogs("[Exception - WCPDispatcher][sendBroadCastRequestToDCs][" + poolName + "][" + dcNameList + "][" + ex.getMessage() + "]", ex);
            WCPSessionManager.returnErrorMsg(poolName, -1, "WCPBroadCastRequest Error", ex.getMessage());
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_BROADCAST_REQUEST_FAILED.getErrorCode(), 1L);
            WCPStats.addErrorStats("SEND_BROADCAST_REQUEST_FAILED", "[poolName : " + poolName + "][ipList : " + dcNameList + "]");
            throw ex;
        }
        return bcFuture;
    }

    public static WCPBroadcastFuture sendBroadCastRequest(String poolName, Set<String> ipList, WCPRequest req, WCPBrdCstCBListnr listener) throws Exception {
        WCPBroadcastFuture bcFuture;
        block6: {
            if (!isInitialized) {
                throw new Exception("WCP not Initialized");
            }
            if (req == null) {
                throw new Exception("Invalid WCPRequest");
            }
            if (connPoolMap.get(poolName) == null) {
                WCPSessionManager.returnErrorMsg(poolName, -1, "WCPRequest Error", "WCPConnPool Not Initialized!!");
                throw new Exception("WCPConnPool Not Initialized");
            }
            bcFuture = null;
            try {
                WCPServerConnPool connPool = connPoolMap.get(poolName);
                if (connPool != null) {
                    bcFuture = ipList != null ? connPool.sendBroadCastRequest(req, listener, ipList) : connPool.sendBroadCastRequest(req, listener, null);
                    break block6;
                }
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "[Exception - WCPDispatcher][sendBroadCastRequest] poolName={0} ipList={1} errorMsg={2}", new Object[]{poolName, ipList, ex.getMessage()});
                WCPUtil.printDebugLogs("[Exception - WCPDispatcher][sendBroadCastRequest][" + poolName + "][" + ipList + "][" + ex.getMessage() + "]", ex);
                WCPSessionManager.returnErrorMsg(poolName, -1, "WCPBroadCastRequest Error", ex.getMessage());
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEND_BROADCAST_REQUEST_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEND_BROADCAST_REQUEST_FAILED", "[poolName : " + poolName + "][ipList : " + ipList + "]");
                throw ex;
            }
        }
        return bcFuture;
    }

    public static void processMetaPackets(WCPCBEvent cbe) {
        logger.log(Level.INFO, "[WCPDispatcher - processMetaPackets] source={0} ip={1}", new Object[]{cbe.getSource(), cbe.getIP()});
    }

    private static Hashtable<String, String> getSeedsMap(String clusterName, boolean isSelfConnEnabled) {
        if (clusterName == null) {
            return new Hashtable<String, String>();
        }
        try {
            Hashtable<String, String> ipPositionSeedsMap = new Hashtable<String, String>();
            Hashtable<String, String> positionIpMap = null;
            for (int tryCount = 0; tryCount < 3; ++tryCount) {
                try {
                    positionIpMap = DC.getIpsOfAClusterWithPosition(clusterName, false, isSelfConnEnabled).get(clusterName);
                    break;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception while getting seeds. clusterName=" + clusterName + " retryCount=" + tryCount, e);
                    continue;
                }
            }
            if (positionIpMap == null || positionIpMap.isEmpty()) {
                logger.log(Level.INFO, "HB_ERR--> SeedsMap Empty for cluster={0}", clusterName);
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.SEEDS_EMPTY.getErrorCode(), 1L);
                WCPStats.addErrorStats("SEEDS_EMPTY", "[clusterName : " + clusterName + "]");
                return null;
            }
            for (String ip : positionIpMap.keySet()) {
                ipPositionSeedsMap.put(positionIpMap.get(ip), ip);
            }
            return ipPositionSeedsMap;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "[Exception][WCPDispatcher - getSeedsMap] cluster=" + clusterName, ex);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.GETTING_SEEDS_MAP.getErrorCode(), 1L);
            WCPStats.addErrorStats("EXCEPTION_IN_SEEDS_MAP", "[clusterName : " + clusterName + "]");
            return null;
        }
    }

    public static boolean enableOnDemandConnection(String poolName) {
        if (poolName != null && connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setOnDemand(true);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setIpQueueSize(String poolName, int queueSize) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setIpQueueSize(queueSize);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setAckQueueSize(String poolName, int ackQueueSize) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setAckQueueSize(ackQueueSize);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setMaxConnPerIp(String poolName, int maxConnPerIp) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMaxConnPerIp(maxConnPerIp);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setMinConnPerIp(String poolName, int minConnPerIp) {
        return WCPDispatcher.setMinConnPerIp(poolName, minConnPerIp, false);
    }

    @Deprecated
    public static boolean setMinConnPerIp(String poolName, int minConnPerIp, boolean forceCreateMinConnections) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMinConnPerIp(minConnPerIp, forceCreateMinConnections);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setMaxDataPerConn(String poolName, int maxDataPerConn) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMaxDataPerConn(maxDataPerConn);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setLBTechnique(String poolName, String lb_tech) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setLBTechnique(lb_tech);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setMaxDataAddRetryCount(String poolName, int maxDataAddRetryCount) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMaxDataAddRetryCount(maxDataAddRetryCount);
            return true;
        }
        return false;
    }

    public static void setDebugLogStatus(boolean status) {
        WCPConfManager.setDebugLogStatus(status);
    }

    public static void setWcpMaxAcceptableDataSize(long size) {
        WCPConfManager.setWcpMaxAcceptableDataSize(size);
    }

    public static Hashtable<String, Hashtable<String, Hashtable<String, String>>> getWCPQStats() {
        Hashtable<String, Hashtable<String, Hashtable<String, String>>> connPoolStats = new Hashtable<String, Hashtable<String, Hashtable<String, String>>>();
        for (String poolName : connPoolMap.keySet()) {
            connPoolStats.put(poolName, connPoolMap.get(poolName).getWCPQStats());
        }
        return connPoolStats;
    }

    public static Hashtable<String, Hashtable<String, String>> getWCPQStats(String poolName) {
        if (connPoolMap.get(poolName) != null) {
            return connPoolMap.get(poolName).getWCPQStats();
        }
        return null;
    }

    public static Hashtable<String, String> getWCPQStats(String poolName, String ip) {
        if (connPoolMap.get(poolName) != null) {
            return connPoolMap.get(poolName).getWCPQStats(ip);
        }
        return null;
    }

    public static boolean isWCPReqExpired(String id) {
        try {
            String[] splt = id.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime) {
                return false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - isWCPReqExpired][" + id + "]", e);
        }
        return true;
    }

    public static boolean invalidateWCPRequest(ArrayList<Object> list) {
        try {
            for (String string : list) {
                String[] splt = string.split("@");
                long expTime = Long.parseLong(splt[2]);
                if (System.currentTimeMillis() > expTime) {
                    if (connPoolMap.get(splt[0]) != null) {
                        connPoolMap.get(splt[0]).invalidateWCPRequest(splt[1]);
                    }
                    WCPReqTimeOutListener.TRACKER.remove(expTime, string);
                    continue;
                }
                WCPReqTimeOutListener.TRACKER.touch(expTime, string);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "NSERR--> Error while invalidating WCPRequest. " + list, ex);
        }
        return true;
    }

    public static boolean isValidRequest(String id) {
        try {
            String[] splt = id.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime && connPoolMap.get(splt[0]) != null) {
                return connPoolMap.get(splt[0]).isValidRequest(splt[1]);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - isValidRequest][" + id + "]", e);
        }
        return false;
    }

    public static boolean isInitialised() {
        return isInitialized;
    }

    public static int pauseDataStream() throws Exception {
        return WCPDispatcher.pauseDataStream("srv");
    }

    public static int pauseDataStream(String uri) throws Exception {
        return WCPSessionManager.pauseDataStream(uri);
    }

    public static int resumeDataStream() throws Exception {
        return WCPDispatcher.resumeDataStream("srv");
    }

    public static int resumeDataStream(String uri) throws Exception {
        return WCPSessionManager.resumeDataStream(uri);
    }

    public static int abortAR() throws Exception {
        int resumedSessionsCount = WCPSessionManager.resumeDataStream("srv");
        WCPDispatcher.reopenClientConnections();
        return resumedSessionsCount;
    }

    public static boolean drain(long retryDuration, int retryInterval, TimeUnit timeUnit) {
        WCPServerConnPool connPool;
        int size = 0;
        long retryCount = 0L;
        int pendingResponseSize = 0;
        while (retryCount * (long)retryInterval < retryDuration) {
            size = 0;
            pendingResponseSize = 0;
            for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
                connPool = entry.getValue();
                pendingResponseSize += connPool.getPendingResponses();
                if (!connPool.isAREnabled()) continue;
                size += connPool.getTotalQueueSize();
            }
            if (size == 0 && pendingResponseSize == 0) {
                logger.log(Level.INFO, "HB--> DRAIN completed and No pending responses");
                return true;
            }
            try {
                logger.log(Level.INFO, "HB--> DRAIN totalQsize={0} completed. pendingResponses={1} retryCount={2} in TotalDuration={3}ms", new Object[]{size, pendingResponseSize, retryCount, retryDuration});
                ++retryCount;
                timeUnit.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "InterruptedException", e);
            }
        }
        if (pendingResponseSize == 0) {
            logger.log(Level.INFO, "HB--> Success. No Pending Responses.");
        }
        size = 0;
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            int pendingResponses;
            connPool = entry.getValue();
            if (!connPool.isAREnabled()) continue;
            int currPoolSize = connPool.getTotalQueueSize();
            if (currPoolSize > 0) {
                logger.log(Level.INFO, "HB--> DRAIN FAILED poolName={0} bqsize={1} isOnDemand={2}", new Object[]{entry.getKey(), currPoolSize, connPool.isOnDemand()});
                if (!connPool.isOnDemand()) {
                    size += currPoolSize;
                }
            }
            if ((pendingResponses = connPool.getPendingResponses()) <= 0) continue;
            logger.log(Level.INFO, "HB--> DRAIN pendingResponses found. poolName={0} pendingResponsesCount={1} isOnDemand={2}", new Object[]{entry.getKey(), pendingResponses, connPool.isOnDemand()});
        }
        return size == 0;
    }

    public static int drainAndClose(long retryDuration, int retryInterval, TimeUnit timeUnit) {
        return WCPDispatcher.drainAndClose(retryDuration, retryInterval, false, timeUnit);
    }

    public static int drainAndClose(long retryDuration, int retryInterval, boolean proceedOnFailure, TimeUnit timeUnit) {
        int count = 0;
        boolean isDrained = WCPDispatcher.drain(retryDuration, retryInterval, timeUnit);
        logger.log(Level.INFO, "HB--> DRAIN isDrained = {0} proceedOnFailure={1}", new Object[]{isDrained, proceedOnFailure});
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            WCPServerConnPool connPool = entry.getValue();
            if (!connPool.isAREnabled()) continue;
            connPool.closeQueue();
            ++count;
            logger.log(Level.INFO, "HB--> close BQ. poolName = {0}", entry.getKey());
        }
        if (proceedOnFailure && !isDrained) {
            logger.log(Level.INFO, "HB--> DRAIN Failed. ProceedOnFailure. drainedPools={0}", count);
            return -1;
        }
        return count;
    }

    public static int getConnectionPoolCount() {
        return connPoolMap.size();
    }

    public static int getARConnectionPoolCount() {
        int count = 0;
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            WCPServerConnPool connPool = entry.getValue();
            if (!connPool.isAREnabled()) continue;
            ++count;
        }
        return count;
    }

    public static boolean reopenClientConnections() {
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            logger.log(Level.INFO, "HB--> reopen BQ. poolName = {0}", entry.getKey());
            WCPServerConnPool connPool = entry.getValue();
            connPool.openQueue();
        }
        return true;
    }

    public static LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> wcpServerConnPoolStatus = new LinkedHashMap<String, Object>();
        wcpServerConnPoolStatus.put("Servers", WCPSessionManager.getStatus());
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            wcpServerConnPoolStatus.put(entry.getKey(), entry.getValue().getStatus());
        }
        wcpServerConnPoolStatus.put("_order", new ArrayList(wcpServerConnPoolStatus.keySet()));
        return wcpServerConnPoolStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> wcpServerConnPoolStatus = new LinkedHashMap<String, Object>();
        wcpServerConnPoolStatus.put("Servers", WCPSessionManager.getDetailedStatus());
        for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
            wcpServerConnPoolStatus.put(entry.getKey(), entry.getValue().getDetailedStatus());
        }
        wcpServerConnPoolStatus.put("_order", new ArrayList(wcpServerConnPoolStatus.keySet()));
        return wcpServerConnPoolStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus(String poolName) {
        if (!connPoolMap.containsKey(poolName)) {
            LinkedHashMap<String, Object> errorStatus = new LinkedHashMap<String, Object>();
            errorStatus.put("Error", "Invalid Connection Pool Name");
            return errorStatus;
        }
        return connPoolMap.get(poolName).getDetailedStatus();
    }

    static LinkedHashMap<String, Object> getInfo() {
        LinkedHashMap<String, Object> wcpStatusMap = new LinkedHashMap<String, Object>();
        if (isInitialized) {
            wcpStatusMap.put("WCP Status", "Enabled");
            wcpStatusMap.put("Initialised Time", WMSUtil.HumanReadable.getTime(initTime));
            wcpStatusMap.put("WCP running time", WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - initTime));
            wcpStatusMap.put("Total Connection Pool Size", connPoolMap.size());
            wcpStatusMap.put("Connection Pool List", connPoolMap.keySet());
            wcpStatusMap.put("Servers count", WCPSessionManager.getStatus());
            for (Map.Entry<String, WCPServerConnPool> entry : connPoolMap.entrySet()) {
                wcpStatusMap.put(entry.getKey(), entry.getValue().getStatus());
            }
            wcpStatusMap.put("_order", new ArrayList<String>(wcpStatusMap.keySet()));
        } else {
            wcpStatusMap.put("WCP Status", "Not initialised");
        }
        return wcpStatusMap;
    }

    public static boolean isValidPool(String poolName) {
        return connPoolMap.containsKey(poolName);
    }

    public static boolean blockIP(String poolName, String ip) {
        WCPServerConnPool connPool = connPoolMap.get(poolName);
        return connPool.blockIP(ip);
    }

    public static String unblockIP(String poolName, String ip) {
        WCPServerConnPool connPool = connPoolMap.get(poolName);
        return connPool.unblockIP(ip);
    }

    public static Hashtable<String, Object> getBlockedIPs(String poolName) {
        WCPServerConnPool connPool = connPoolMap.get(poolName);
        return connPool.getBlockedIPs();
    }

    public static Hashtable<String, Object> getBlockedIPs() {
        Hashtable<String, Object> blockedPools = new Hashtable<String, Object>();
        if (connPoolMap != null && connPoolMap.size() > 0) {
            for (String poolName : connPoolMap.keySet()) {
                Hashtable<String, Object> blockedMap = WCPDispatcher.getBlockedIPs(poolName);
                if (blockedMap.size() <= 0) continue;
                blockedPools.put(poolName, blockedMap);
            }
        } else {
            blockedPools.put("Error", "No WCP connection pools");
        }
        return blockedPools;
    }

    private static void initInfluxStatsConf() {
        Hashtable<String, String> statsDefs = new Hashtable<String, String>();
        statsDefs.put("wcp_clientdata", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientdata\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\",\"packet_type\",\"communication\"],[],[\"count\"]]");
        statsDefs.put("wcp_clientconn", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientconn\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\",\"connstatus\",\"reason\"],[],[\"connecttime\",\"onconnect\",\"onclose\",\"connlife\"]]");
        statsDefs.put("wcp_clientdatasize_range", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientdatasize_range\",false,true,0,,,,,3],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\",\"status\"],[],[\"data_size\"]]");
        statsDefs.put("wcp_clientlivestats", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientlivestats\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\"],[],[\"connections\",\"optimalconn\",\"bqrate\",\"bqsize\",\"notify_handler_qsize\",\"response_handler_qsize\",\"idb_notifier_qsize\",\"cb_response_handler_qsize\",\"meta_queue_size\",\"pending_responses\"]]");
        statsDefs.put("wcp_clientrtt", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientrtt\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\",\"packet_type\"],[],[\"rtt\",\"count\"]]");
        statsDefs.put("wcp_clientrtt_range", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientrtt_range\",false,true,10,,,,,2],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\",\"packet_type\"],[],[\"rtt\"]]");
        statsDefs.put("wcp_serverrtt_range", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_serverrtt_range\",false,true,1000,,,,,2],[\"servertype\",\"remote_servertype\",\"context\",\"remoteip\",\"packet_type\"],[],[\"rtt\"]]");
        statsDefs.put("wcp_serverdata", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_serverdata\",false],[\"uri\",\"servertype\",\"remote_servertype\",\"cluster_name\",\"remote_cluster_name\",\"context\",\"remoteip\",\"packet_type\",\"communication\"],[],[\"count\",\"bqtime\",\"nettime\",\"totaltime\"]]");
        statsDefs.put("wcp_server_api_data", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_server_api_data\",false],[\"servertype\",\"remote_servertype\",\"cluster_name\",\"api_name\",\"context\",\"packet_type\",\"communication\"],[\"remoteip\"],[\"count\",\"bqtime\",\"nettime\",\"totaltime\"]]");
        statsDefs.put("wcp_reconnect", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_reconnect\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\"],[],[\"recconnect_count\"]]");
        statsDefs.put("wcp_force_close", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_force_close\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\"],[],[\"close\"]]");
        statsDefs.put("wcp_listnr_process_time", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_listnr_time\",false],[\"listener_action\",\"servertype\",\"cluster_name\",\"remoteip\"],[],[\"process_time\",\"count\"]]");
        statsDefs.put("wcp_bqsize", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_bqsize\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"remoteip\"],[],[\"bqsize\"]]");
        statsDefs.put("wcp_frwd_misuse", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_frwd_misuse\",false],[\"servertype\"],[],[\"misuse_cnt\"]]");
        statsDefs.put("wcp_srv_hits", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_srv_hits\",false],[\"servertype\",\"remote_servertype\",\"remoteip\",\"servlet\",\"status\"],[],[\"count\",\"processtime\"]]");
        statsDefs.put("wcp_api_hits", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_api_hits\",false],[\"servertype\",\"prd\",\"servlet\",\"status\"],[\"remoteip\"],[\"count\",\"processtime\"]]");
        statsDefs.put("wcp_req_timeout", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_req_timeout\",false],[\"servertype\",\"remote_servertype\",\"poolname\",\"cluster_name\",\"remote_cluster_name\",\"remoteip\",\"servlet\",\"is_forward_req\"],[],[\"count\"]]");
        statsDefs.put("wcp_clientrtt_size", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientrtt_size\",false],[\"poolname\",\"uri\",\"servertype\",\"remote_servertype\",\"remote_clustername\",\"remoteip\",\"packet_type\"],[],[\"size\",\"in\",\"out\"]]");
        statsDefs.put("wcp_serverrtt_size", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_serverrtt_size\",false],[\"context\",\"uri\",\"servertype\",\"remote_servertype\",\"remote_clustername\",\"remoteip\",\"packet_type\"],[],[\"size\",\"in\",\"out\"]]");
        statsDefs.put("wcp_cv_mismatch", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_cv_mismatch\",false],[\"cluster_name\"],[\"old_cv\",\"new_cv\"],[\"count\"]]");
        statsDefs.put("wcpapirebalancer", "[[\"metric\",\"metric_wcp\",\"\",\"autorebalancer\",\"false\"],[\"cluster\",\"redirectip\",\"apiname\",\"prd\",\"remoteip\",\"status\"],[],[\"sidCount\"]]");
        statsDefs.put("wcp_controlpacket_err", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_controlpacket_err\",false],[\"poolname\"],[\"old_cv\",\"new_cv\"],[\"count\"]]");
        statsDefs.put("wcp_randomsid_res", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_randomsid_res\",false],[\"uri\"],[\"reqsource\",\"sid\"],[\"count\"]]");
        statsDefs.put("wcp_filter_fail", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_filter_fail\",false],[\"packet_type\",\"filter_type\",\"servlet_or_context\"],[\"remoteip\"],[\"count\"]]");
        statsDefs.put("wcp_servlet_notfound", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_servlet_notfound\",false],[\"remote_servertype\",\"servlet\",\"uri\"],[\"remoteip\"],[\"count\"]]");
        statsDefs.put("wcp_accesslogger", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_accesslogger\",false],[\"cluster_name\",\"servlet\",\"uri\"],[\"remoteip\"],[\"qsize\",\"log_time\",\"count\"]]");
        statsDefs.put("wcp_request_time", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_request_time\",false],[\"servertype\",\"cluster_name\",\"poolname\",\"destip\",\"servlet\",\"response_code\"],[],[\"totaltime\",\"count\"]]");
        statsDefs.put("wcp_serversession_stats", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_serversession_stats\",false],[\"servertype\",\"cluster_name\",\"operation\",\"uri\",\"source\",\"ip\",\"poolname\",\"context\"],[\"req_source\",\"sid\"],[\"listener_time\",\"count\"]]");
        statsDefs.put("wcp_frwd_requests", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_frwd_requests\",false],[\"servertype\",\"remote_servertype\",\"cluster_name\",\"remote_clustername\",\"poolname\",\"remoteip\",\"destination_ip\",\"servlet\"],[\"frwdips\",\"reqid\"],[\"count\"]]");
        statsDefs.put("wcp_handler_processtime", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_handler_processtime\",false],[\"servertype\",\"remote_servertype\",\"cluster_name\",\"remote_cluster_name\",\"poolname\",\"context\",\"handler_name\"],[],[\"processtime\",\"count\"]]");
        statsDefs.put("wcp_error_monitoring", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_errors\",false],[\"error_type\",\"servertype\",\"cluster\"],[\"message\"],[\"count\"]]");
        statsDefs.put("idbloadtest", "[[\"qos\",\"qos_wcp\",\"\",\"idb_load_test\",false],[\"data_type\",\"destination_dc\",\"cluster\"],[\"batchid\"],[\"forward_time\",\"round_trip_time\",\"payload_size\",\"count\"]]");
        statsDefs.put("wcp_serverdata_size", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_serverdata_size\",false,true,0,,,,,3],[\"uri\",\"servertype\",\"remote_servertype\",\"cluster_name\",\"remote_cluster_name\",\"context\",\"remoteip\",\"packet_type\"],[],[\"datasize\"]]");
        statsDefs.put("wcp_clientdata_size", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_clientdata_size\",false,true,0,,,,,3],[\"uri\",\"servertype\",\"remote_servertype\",\"cluster_name\",\"remote_cluster_name\",\"poolname\",\"destination_ip\",\"packet_type\"],[],[\"datasize\"]]");
        statsDefs.put("wcp_security_failure", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_security_failure\",false],[\"uri\",\"source\",\"cluster\",\"poolname\",\"context\",\"remoteip\",\"failed_status\"],[],[\"count\"]]");
        statsDefs.put("wcp_connpool_time", "[[\"qos\",\"qos_wcp\",\"\",\"wcp_connpool_time\",false],[\"servertype\",\"remote_servertype\",\"clustername\",\"remote_clustername\",\"poolname\",\"context\"],[],[\"init_time\",\"count\"]]");
        if (StatsConf.loadStatsKeyDef(statsDefs)) {
            StatsDB.initialize();
            logger.log(Level.INFO, "[WCPDispatcher - Influx Stats Initialized!!]");
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static boolean isOnDemand(String poolName) {
        return connPoolMap.get(poolName).isOnDemand();
    }

    public static void enableForceCloseConn(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).enableForceCloseConn();
        } else {
            logger.log(Level.INFO, "HB_ERR--> enableForceCloseConn - poolName not found. poolName={0}", poolName);
        }
    }

    public static void enableForceCloseConn() {
        if (connPoolMap != null && connPoolMap.size() > 0) {
            for (String poolName : connPoolMap.keySet()) {
                WCPDispatcher.enableForceCloseConn(poolName);
            }
        }
    }

    public static void disableForceCloseConn(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).disableForceCloseConn();
        } else {
            logger.log(Level.INFO, "HB_ERR--> disableForceCloseConn - poolName not found. poolName={0}", poolName);
        }
    }

    public static void disableForceCloseConn() {
        if (connPoolMap != null && connPoolMap.size() > 0) {
            for (String poolName : connPoolMap.keySet()) {
                WCPDispatcher.disableForceCloseConn(poolName);
            }
        }
    }

    public static int getSessionsCount(String remoteip) {
        if (remoteip != null) {
            return WCPSessionManager.getSessionsCount(remoteip);
        }
        return -1;
    }

    public static boolean isSessionAvailable(String remoteip) {
        if (remoteip != null) {
            return WCPSessionManager.isSessionAvailable(remoteip);
        }
        return false;
    }

    public static boolean isConnPoolAvailable(String clusterName) {
        if (clusterName != null) {
            for (String poolname : connPoolMap.keySet()) {
                WCPServerConnPool connPool = connPoolMap.get(poolname);
                if (!clusterName.equals(connPool.getClusterName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void enableSelfConnection(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).enableSelfConnection();
        }
    }

    public static void disableSelfConnection(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).disableSelfConnection();
        }
    }

    public static void registerAccessTokenProvider(String poolName, AccessTokenProvider accessTokenProvider) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).registerAccessTokenProvider(accessTokenProvider);
            logger.log(Level.INFO, "HB--> registerAccessTokenProvider. poolname={0} accessTokenProvider={1}", new Object[]{poolName, accessTokenProvider.getClass()});
        }
    }

    public static void enableSSL(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).enableSSL();
            logger.log(Level.INFO, "HB--> SSL enabled. poolname={0}", poolName);
        }
    }

    public static void disableSSL(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            connPoolMap.get(poolName).disableSSL();
            logger.log(Level.INFO, "HB--> SSL disabled. poolname={0}", poolName);
        }
    }

    public static int clearBQData(String poolName) {
        return WCPDispatcher.clearBQData(poolName, null, 0);
    }

    public static int clearBQData(String poolName, int drainLimit) {
        return WCPDispatcher.clearBQData(poolName, null, drainLimit);
    }

    public static int clearBQData(String poolName, String ip) {
        return WCPDispatcher.clearBQData(poolName, ip, 0);
    }

    public static int clearBQData(String poolName, String ip, int drainLimit) {
        if (connPoolMap.containsKey(poolName)) {
            if (CommonUtil.isEmpty((String)ip)) {
                return connPoolMap.get(poolName).clearBQData(drainLimit);
            }
            return connPoolMap.get(poolName).clearBQData(ip, drainLimit);
        }
        logger.log(Level.INFO, "HB--> BufferedQueue - clearBQData - poolName not found. poolName={0}", poolName);
        return 1;
    }

    public static Hashtable<String, String> getConnPoolInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        for (String poolname : connPoolMap.keySet()) {
            WCPConnPoolConfig conf = WCPDispatcher.getConnPoolConfig(poolname);
            if (conf == null) continue;
            StringBuilder shortInfo = new StringBuilder();
            shortInfo.append("Remote Cluster:");
            shortInfo.append(conf.getClusterName());
            shortInfo.append("\tContext:");
            shortInfo.append(conf.getContext());
            info.put(poolname, shortInfo.toString());
        }
        return info;
    }

    public static Hashtable<String, String> getConnPoolInfo(String poolName) throws Exception {
        if (connPoolMap.containsKey(poolName)) {
            return WCPDispatcher.getConnPoolConfig(poolName).getInfo();
        }
        throw new Exception("poolName is not Valid. poolName=" + poolName);
    }

    static {
        idbPoolMap = new HashMap();
    }
}

