/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.callback.WCPIDBCBListener;
import com.adventnet.wms.servercommon.components.net.security.ServerAccessTokenProviderImpl;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.security.AccessTokenProvider;
import java.util.Hashtable;

public class WCPConnPoolConfig {
    private String poolName;
    private String serverType;
    private String remoteServerType;
    private String clusterName = null;
    private String uri = WCPConfManager.getWCPURI();
    private String context = "default";
    private String lb_tech = WCPConfManager.getWCPLBTechnique();
    private boolean enableAR = false;
    private boolean isCVDependent = false;
    private boolean isSSLBased = false;
    private boolean handleAsBB = false;
    private boolean forceCreateMinConnections = false;
    private boolean isSelfConnEnabled = true;
    private int callBackHandlerCorePoolSize = WCPConfManager.getCallBackHandlerCorePoolSize();
    private int callBackHandlerMaxPoolSize = WCPConfManager.getCallBackHandlerMaxPoolSize();
    private int responseHandlerCorePoolSize = WCPConfManager.getResponseHandlerCorePoolSize();
    private int responseHandlerMaxPoolSize = WCPConfManager.getResponseHandlerMaxPoolSize();
    private int idbCallBackHandlerCorePoolSize = WCPConfManager.getIDBCallBackHandlerCorePoolSize();
    private int idbCallBackHandlerMaxPoolSize = WCPConfManager.getIDBCallBackHandlerMaxPoolSize();
    private int corePoolSize;
    private int maxPoolSize;
    private int port = WCPConfManager.getWCPPort();
    private int arOpCode = 1;
    private int ipQueueSize = WCPConfManager.getWCPIPQueueSize();
    private int ackQueueSize = WCPConfManager.getWCPAckQueueSize();
    private int minConnPerIp = WCPConfManager.getWCPMinConnPerIP();
    private int maxConnPerIp = WCPConfManager.getWCPMaxConnPerIP();
    private int maxDataPerConn = WCPConfManager.getWCPMaxDataPerConn();
    private int maxDataAddRetryCount = WCPConfManager.getWCPMaxDataAddRetryCount();
    private Hashtable<String, String> seedsMap;
    private WCPIDBCBListener idbCBListener = null;
    private AccessTokenProvider accessTokenProvider = new ServerAccessTokenProviderImpl();
    private WCPServerConnPool connPool = null;

    @Deprecated
    public WCPConnPoolConfig(String poolName, String serverType, String remoteServerType) {
        this(poolName, serverType, remoteServerType, null);
    }

    public WCPConnPoolConfig(String poolName, String serverType, String remoteServerType, String destinationCluster) {
        this.poolName = poolName;
        this.serverType = serverType;
        this.remoteServerType = remoteServerType;
        this.clusterName = destinationCluster;
    }

    public int create() throws Exception {
        int status = WCPDispatcher.createWCPConnPool(this);
        this.connPool.setCallBackHandlerPoolSize(this.callBackHandlerCorePoolSize, this.callBackHandlerMaxPoolSize);
        this.connPool.setResponseHandlerPoolSize(this.responseHandlerCorePoolSize, this.responseHandlerMaxPoolSize);
        this.connPool.setIDBCallBackHandlerPoolSize(this.idbCallBackHandlerCorePoolSize, this.idbCallBackHandlerMaxPoolSize);
        return status;
    }

    @Deprecated
    public WCPConnPoolConfig setClusterName(String cluster) throws WMSException {
        this.clusterName = cluster;
        return this;
    }

    public WCPConnPoolConfig setContext(String context) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("Context can't be set after creation of connection pool.");
        }
        this.context = context;
        return this;
    }

    public WCPConnPoolConfig setLbTech(String lb_tech) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("lb_tech can't be set after creation of connection pool.");
        }
        this.lb_tech = lb_tech;
        return this;
    }

    public WCPConnPoolConfig setURI(String uri) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("uri can't be set after creation of connection pool.");
        }
        this.uri = uri;
        return this;
    }

    public WCPConnPoolConfig enableAR(boolean enableAR) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("ar can't be enabled after creation of connection pool.");
        }
        this.enableAR = enableAR;
        return this;
    }

    public WCPConnPoolConfig handleAsBB(boolean handleAsBB) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("handleAsBB can't be set after creation of connection pool.");
        }
        this.handleAsBB = handleAsBB;
        return this;
    }

    public WCPConnPoolConfig forceCreateMinConnections(boolean forceCreateMinConnections) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("forceCreateMinConnections can't be set after creation of connection pool.");
        }
        this.forceCreateMinConnections = forceCreateMinConnections;
        return this;
    }

    public WCPConnPoolConfig setArOpCode(int arOpCode) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("arOpCode can't be set after creation of connection pool.");
        }
        this.arOpCode = arOpCode;
        return this;
    }

    public WCPConnPoolConfig setCorePoolSize(int corePoolSize) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("corePoolSize can't be set after creation of connection pool.");
        }
        this.corePoolSize = corePoolSize;
        return this;
    }

    public WCPConnPoolConfig setMaxPoolSize(int maxPoolSize) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("maxPoolSize can't be set after creation of connection pool.");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public WCPConnPoolConfig setPort(int port) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("port can't be set after creation of connection pool.");
        }
        this.port = port;
        return this;
    }

    public WCPConnPoolConfig setIpQueueSize(int ipQueueSize) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("ipQueueSize can't be set after creation of connection pool.");
        }
        this.ipQueueSize = ipQueueSize;
        return this;
    }

    public WCPConnPoolConfig setAckQueueSize(int ackQueueSize) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("ackQueueSize can't be set after creation of connection pool.");
        }
        this.ackQueueSize = ackQueueSize;
        return this;
    }

    public WCPConnPoolConfig setMinConnPerIp(int minConnPerIp) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("minConnPerIp can't be set after creation of connection pool.");
        }
        this.minConnPerIp = minConnPerIp;
        return this;
    }

    public WCPConnPoolConfig setMaxConnPerIp(int maxConnPerIp) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("maxConnPerIp can't be set after creation of connection pool.");
        }
        this.maxConnPerIp = maxConnPerIp;
        return this;
    }

    public WCPConnPoolConfig setMaxDataPerConn(int maxDataPerConn) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("maxDataPerConn can't be set after creation of connection pool.");
        }
        this.maxDataPerConn = maxDataPerConn;
        return this;
    }

    public WCPConnPoolConfig setMaxDataAddRetryCount(int maxDataAddRetryCount) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("maxDataAddRetryCount can't be set after creation of connection pool.");
        }
        this.maxDataAddRetryCount = maxDataAddRetryCount;
        return this;
    }

    public WCPConnPoolConfig setSeedsMap(Hashtable<String, String> seedsMap) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("seedsMap can't be set after creation of connection pool.");
        }
        this.seedsMap = seedsMap;
        return this;
    }

    public WCPConnPoolConfig setCVDependent(boolean isCVDependent) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("isCVDependent can't be set after creation of connection pool.");
        }
        this.isCVDependent = isCVDependent;
        return this;
    }

    public WCPConnPoolConfig setIDBCBListener(WCPIDBCBListener idbCBListener) throws WMSException {
        if (this.connPool != null) {
            throw new WMSException("lb_tech can't be set after creation of connection pool.");
        }
        this.idbCBListener = idbCBListener;
        return this;
    }

    WCPConnPoolConfig setConnPool(WCPServerConnPool connPool) {
        this.connPool = connPool;
        return this;
    }

    public WCPConnPoolConfig setCallBackHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.callBackHandlerCorePoolSize = corePoolSize;
        this.callBackHandlerMaxPoolSize = maximumPoolSize;
        if (this.connPool != null) {
            this.connPool.setCallBackHandlerPoolSize(corePoolSize, maximumPoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setCallBackHandlerCorePoolSize(int corePoolSize) {
        this.callBackHandlerCorePoolSize = corePoolSize;
        if (this.connPool != null) {
            this.connPool.setCallBackHandlerCorePoolSize(corePoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setCallBackHandlerMaxPoolSize(int maximumPoolSize) {
        this.callBackHandlerMaxPoolSize = maximumPoolSize;
        if (this.connPool != null) {
            this.connPool.setCallBackHandlerMaxPoolSize(this.maxPoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setResponseHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.responseHandlerCorePoolSize = corePoolSize;
        this.responseHandlerMaxPoolSize = maximumPoolSize;
        if (this.connPool != null) {
            this.connPool.setResponseHandlerPoolSize(corePoolSize, maximumPoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setResponseHandlerCorePoolSize(int corePoolSize) {
        this.responseHandlerCorePoolSize = corePoolSize;
        if (this.connPool != null) {
            this.connPool.setResponseHandlerCorePoolSize(corePoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setResponseHandlerMaxPoolSize(int maximumPoolSize) {
        this.responseHandlerMaxPoolSize = maximumPoolSize;
        if (this.connPool != null) {
            this.connPool.setResponseHandlerMaxPoolSize(maximumPoolSize);
        }
        return this;
    }

    public WCPConnPoolConfig setIDBCallBackHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.idbCallBackHandlerCorePoolSize = corePoolSize;
        this.idbCallBackHandlerMaxPoolSize = maximumPoolSize;
        if (this.connPool != null) {
            this.connPool.setIDBCallBackHandlerPoolSize(corePoolSize, maximumPoolSize);
        }
        return this;
    }

    public boolean updateIpQueueSize(int queueSize) {
        this.connPool.setIpQueueSize(queueSize);
        return true;
    }

    public boolean updateAckQueueSize(int ackQueueSize) {
        this.connPool.setAckQueueSize(ackQueueSize);
        return true;
    }

    public boolean updateMaxConnPerIp(int maxConnPerIp) {
        this.connPool.setMaxConnPerIp(maxConnPerIp);
        return true;
    }

    public boolean updateMinConnPerIp(int minConnPerIp) {
        return this.updateMinConnPerIp(minConnPerIp, false);
    }

    public boolean updateMinConnPerIp(int minConnPerIp, boolean forceCreateMinConnections) {
        this.connPool.setMinConnPerIp(minConnPerIp, forceCreateMinConnections);
        return true;
    }

    public boolean updateMaxDataPerConn(int maxDataPerConn) {
        this.connPool.setMaxDataPerConn(maxDataPerConn);
        return true;
    }

    public boolean updateLBTechnique(String lb_tech) {
        this.connPool.setLBTechnique(lb_tech);
        return true;
    }

    public boolean updateMaxDataAddRetryCount(int maxDataAddRetryCount) {
        this.connPool.setMaxDataAddRetryCount(maxDataAddRetryCount);
        return true;
    }

    public boolean enableForceCloseConn() {
        this.connPool.enableForceCloseConn();
        return true;
    }

    public boolean disableForceCloseConn() {
        this.connPool.disableForceCloseConn();
        return true;
    }

    public WCPConnPoolConfig enableSelfConnection() {
        this.isSelfConnEnabled = true;
        return this;
    }

    public WCPConnPoolConfig disableSelfConnection() {
        this.isSelfConnEnabled = false;
        return this;
    }

    public WCPConnPoolConfig disableSSL() {
        this.isSSLBased = false;
        return this;
    }

    public WCPConnPoolConfig enableSSL() {
        this.isSSLBased = true;
        return this;
    }

    public WCPConnPoolConfig registerAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
        return this;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public AccessTokenProvider getAccessTokenProvider() {
        return this.accessTokenProvider;
    }

    public boolean isSelfConnEnabled() {
        return this.isSelfConnEnabled;
    }

    public boolean isSSLBased() {
        return this.isSSLBased;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getContext() {
        return this.context;
    }

    public String getLbTech() {
        return this.lb_tech;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean getEnableAR() {
        return this.enableAR;
    }

    public boolean getCVDependent() {
        return this.isCVDependent;
    }

    public boolean getHandleAsBB() {
        return this.handleAsBB;
    }

    public boolean getForceCreateMinConnections() {
        return this.forceCreateMinConnections;
    }

    public int getArOpCode() {
        return this.arOpCode;
    }

    public int getPort() {
        return this.port;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getIpQueueSize() {
        return this.ipQueueSize;
    }

    public int getAckQueueSize() {
        return this.ackQueueSize;
    }

    public int getMinConnPerIp() {
        return this.minConnPerIp;
    }

    public int getMaxConnPerIp() {
        return this.maxConnPerIp;
    }

    public int getMaxDataPerConn() {
        return this.maxDataPerConn;
    }

    public int getMaxDataAddRetryCount() {
        return this.maxDataAddRetryCount;
    }

    public WCPIDBCBListener getIDBCBListener() {
        return this.idbCBListener;
    }

    public Hashtable<String, String> getSeedsMap() {
        return this.seedsMap;
    }

    public Hashtable<String, String> getInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        info.put("_order", HttpDataWraper.getString(WCPConstants.INFO.WCPINFO_ORDER));
        info.put("PoolName", this.poolName);
        info.put("ServerType", this.serverType);
        info.put("RemoteServerType", this.remoteServerType);
        info.put("RemoteCluster", this.clusterName);
        info.put("Context", this.context);
        info.put("SeedsMap", String.valueOf(this.seedsMap));
        info.put("Port", String.valueOf(this.port));
        info.put("LB_Tech", this.lb_tech);
        info.put("isAREnabled", String.valueOf(this.enableAR));
        info.put("isCVDependent", String.valueOf(this.isCVDependent));
        info.put("isSSLBased", String.valueOf(this.isSSLBased));
        info.put("isSelfConnEnabled", String.valueOf(this.isSelfConnEnabled));
        info.put("CallBackHandler Core-Max PoolSize", this.callBackHandlerCorePoolSize + "-" + this.callBackHandlerMaxPoolSize);
        info.put("ResponseHandler Core-Max PoolSize", this.responseHandlerCorePoolSize + "-" + this.responseHandlerMaxPoolSize);
        info.put("IDBCallBackHandler Core-Max PoolSize", this.idbCallBackHandlerCorePoolSize + "-" + this.idbCallBackHandlerMaxPoolSize);
        info.put("BufferedQueue Size", String.valueOf(this.ipQueueSize));
        info.put("Min ConnectionPerIp", String.valueOf(this.minConnPerIp));
        info.put("Max ConnectionPerIp", String.valueOf(this.maxConnPerIp));
        info.put("Max DataPerConnection", String.valueOf(this.maxDataPerConn));
        return info;
    }
}

