/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPConfManager {
    private static Logger logger = Logger.getLogger(WCPConfManager.class.getName());
    private static String servletFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "wcpservlet.properties";
    private static Properties servletProps = new Properties();
    private static String serverIp = null;
    private static int wcpPort = 7070;
    private static String wcpURI = "/wcpsrv";
    private static String wcpSource = null;
    private static String wcpHome = ServerUtil.dataHome + "wcp" + File.separator;
    private static int wcpIPQueueSize = 1000;
    private static int wcpAckQueueSize = 100;
    private static int wcpMinConnPerIP = 3;
    private static int wcpMaxConnPerIP = 10;
    private static int wcpMaxDataPerConn = 250;
    private static int wcpMaxDataAddRetryCount = 3;
    private static long wcpMaxRetryTime = 180000L;
    private static long wcpMaxConnIdelTime = 180000L;
    private static long wcpMaxAckRetryTime = 30000L;
    private static long requestTimeOutInMillis = 30000L;
    private static String wcpLBTechnique = "rr";
    private static int bqAvgRateTime = 5;
    private static int callBackHandlerCorePoolSize = 1;
    private static int callBackHandlerMaxPoolSize = 1;
    private static int responseHandlerCorePoolSize = 1;
    private static int responseHandlerMaxPoolSize = 1;
    private static int idbCallBackHandlerCorePoolSize = 1;
    private static int idbCallBackHandlerMaxPoolSize = 1;
    private static boolean isWCPSecurityEnabled = true;
    private static boolean isWCPSecurityEnabledForAPI = false;
    private static long accessTokenExpireTime = 3600000L;
    private static long accessTokenExpireTimeForAPI = 21600000L;
    private static long wcpRequestTimeoutTrackerInterval = 10000L;
    private static Hashtable<String, HashSet<String>> allowedIps = new Hashtable();
    private static Hashtable<String, Long> lastUpdatedAllowedIpsTime = new Hashtable();
    private static Hashtable<String, String> allowedClusters = new Hashtable();
    private static Hashtable<String, String> allowedapis = new Hashtable();
    private static boolean isDebugLogsEnabled = false;
    private static long wcpMaxAcceptableDataSize = 0xA00000L;

    public static int getCallBackHandlerCorePoolSize() {
        return callBackHandlerCorePoolSize;
    }

    public static int getCallBackHandlerMaxPoolSize() {
        return callBackHandlerMaxPoolSize;
    }

    public static int getResponseHandlerCorePoolSize() {
        return responseHandlerCorePoolSize;
    }

    public static int getResponseHandlerMaxPoolSize() {
        return responseHandlerMaxPoolSize;
    }

    public static int getIDBCallBackHandlerCorePoolSize() {
        return idbCallBackHandlerCorePoolSize;
    }

    public static int getIDBCallBackHandlerMaxPoolSize() {
        return idbCallBackHandlerMaxPoolSize;
    }

    public static int getWCPPort() {
        return wcpPort;
    }

    public static String getWCPURI() {
        return wcpURI;
    }

    public static String getWCPSource() {
        return wcpSource;
    }

    public static String getWCPHome() {
        return wcpHome;
    }

    public static int getWCPIPQueueSize() {
        return wcpIPQueueSize;
    }

    public static int getWCPAckQueueSize() {
        return wcpAckQueueSize;
    }

    public static int getWCPMaxConnPerIP() {
        return wcpMaxConnPerIP;
    }

    public static int getWCPMinConnPerIP() {
        return wcpMinConnPerIP;
    }

    public static int getWCPMaxDataPerConn() {
        return wcpMaxDataPerConn;
    }

    public static int getWCPMaxDataAddRetryCount() {
        return wcpMaxDataAddRetryCount;
    }

    public static String getWCPLBTechnique() {
        return wcpLBTechnique;
    }

    public static String getServerIp() {
        return serverIp;
    }

    public static long getWCPMaxRetryTime() {
        return wcpMaxRetryTime;
    }

    public static long getWCPMaxConnIdelTime() {
        return wcpMaxConnIdelTime;
    }

    public static long getWCPMaxAckRetryTime() {
        return wcpMaxAckRetryTime;
    }

    public static boolean isDebugLogsEnabled() {
        return isDebugLogsEnabled;
    }

    public static void setDebugLogStatus(boolean status) {
        isDebugLogsEnabled = status;
    }

    public static long getWcpMaxAcceptableDataSize() {
        return wcpMaxAcceptableDataSize;
    }

    public static void setWcpMaxAcceptableDataSize(long size) {
        wcpMaxAcceptableDataSize = size;
    }

    public static Properties getServletProperties() {
        return servletProps;
    }

    public static int getBqAvgRateTime() {
        return bqAvgRateTime;
    }

    public static void setSecurityProps(String props) {
        try {
            Hashtable propsMap = (Hashtable)HttpDataWraper.getObject((String)props);
            allowedClusters = CommonUtil.getHash((String)((String)propsMap.get("allowedclusters")));
            allowedapis = CommonUtil.getHash((String)((String)propsMap.get("allowedapis")));
            isWCPSecurityEnabled = Boolean.parseBoolean((String)propsMap.get("iswcpsecurity-enabled"));
            isWCPSecurityEnabledForAPI = Boolean.parseBoolean((String)propsMap.get("iswcpsecurity-enabled-forapi"));
            if (CommonUtil.isEmpty(allowedClusters)) {
                allowedClusters = new Hashtable();
                logger.info("WCPERR--> AllowedCluster list is empty.");
            } else {
                for (String clusterName : allowedClusters.keySet()) {
                    WCPConfManager.updateAllowedIps(clusterName);
                }
            }
            if (CommonUtil.isEmpty(allowedapis)) {
                allowedapis = new Hashtable();
                logger.info("WCPERR--> AllowedApiName list is empty.");
            }
            logger.info("WCPSecurityConf--> allowedClusters=" + allowedClusters + " allowedapis=" + allowedapis + " isWCPSecurityEnabled=" + isWCPSecurityEnabled);
            try {
                wcpPort = WMSUtil.getInteger((String)propsMap.get("port"), wcpPort);
                if (!WCPUtil.isNull((String)propsMap.get("uri"))) {
                    wcpURI = (String)propsMap.get("uri");
                }
                if (!WCPUtil.isNull((String)propsMap.get("lb-technique"))) {
                    wcpLBTechnique = (String)propsMap.get("lb-technique");
                }
                wcpIPQueueSize = WMSUtil.getInteger((String)propsMap.get("ip-queuesize"), wcpIPQueueSize);
                wcpMinConnPerIP = WMSUtil.getInteger((String)propsMap.get("minconnperip"), wcpMinConnPerIP);
                wcpMaxConnPerIP = WMSUtil.getInteger((String)propsMap.get("maxconnperip"), wcpMaxConnPerIP);
                wcpMaxDataPerConn = WMSUtil.getInteger((String)propsMap.get("maxdataperconn"), wcpMaxDataPerConn);
                wcpMaxConnIdelTime = WMSUtil.getLong((String)propsMap.get("maxconnideltime"), wcpMaxConnIdelTime);
                requestTimeOutInMillis = WMSUtil.getLong((String)propsMap.get("maxretrytime"), requestTimeOutInMillis);
                bqAvgRateTime = WMSUtil.getInteger((String)propsMap.get("bqavgratetime"), bqAvgRateTime);
                accessTokenExpireTime = WMSUtil.getLong((String)propsMap.get("accesstoken-expiretime"), accessTokenExpireTime);
                accessTokenExpireTimeForAPI = WMSUtil.getLong((String)propsMap.get("accesstoken-expiretime-api"), accessTokenExpireTimeForAPI);
                StringBuilder logInfo = new StringBuilder("WCPSecurityConf--> wcpPort=");
                logInfo.append(wcpPort).append(" wcpURI=").append(wcpURI).append(" wcpLBTechnique=").append(wcpLBTechnique).append(" wcpIPQueueSize=").append(wcpIPQueueSize);
                logInfo.append(" wcpMinConnPerIP=").append(wcpMinConnPerIP).append(" wcpMaxConnPerIP=").append(wcpMaxConnPerIP).append(" wcpMaxDataPerConn=").append(wcpMaxDataPerConn);
                logInfo.append(" wcpMaxConnIdelTime=").append(wcpMaxConnIdelTime).append(" requestTimeOutInMillis=").append(requestTimeOutInMillis).append(" bqAvgRateTime=");
                logInfo.append(bqAvgRateTime).append(" accessTokenExpireTime=").append(accessTokenExpireTime).append(" accessTokenExpireTimeForAPI=").append(accessTokenExpireTimeForAPI);
                logger.info(logInfo.toString());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while setting props. props map = " + propsMap, e);
            }
        }
        catch (Exception e) {
            allowedapis = new Hashtable();
            allowedClusters = new Hashtable();
            logger.log(Level.SEVERE, "Exception in initialiseSecurity. props=" + props, e);
        }
    }

    public static boolean isAllowedCluster(String clusterName) {
        return allowedClusters.containsKey(clusterName);
    }

    public static boolean isAllowedAPI(String apiName) {
        return allowedapis.containsKey(apiName);
    }

    public static boolean isAllowedIp(String clusterName, String ip) {
        boolean isAllowedIp = false;
        try {
            if (allowedIps.containsKey(clusterName)) {
                isAllowedIp = allowedIps.get(clusterName).contains(ip);
                if (!isAllowedIp) {
                    long time = lastUpdatedAllowedIpsTime.get(clusterName);
                    if (System.currentTimeMillis() - time < 10000L) {
                        return false;
                    }
                    WCPConfManager.updateAllowedIps(clusterName);
                    isAllowedIp = allowedIps.get(clusterName).contains(ip);
                }
                return isAllowedIp;
            }
            WCPConfManager.updateAllowedIps(clusterName);
            return WCPConfManager.isAllowedIp(clusterName, ip);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in isAllowedIp. clusterName=" + clusterName + " ip=" + ip, e);
            return isAllowedIp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAllowedIps(String clusterName) {
        try {
            if (lastUpdatedAllowedIpsTime.containsKey(clusterName)) {
                long time = lastUpdatedAllowedIpsTime.get(clusterName);
                if (System.currentTimeMillis() - time < 10000L) {
                    return;
                }
            }
            Object object = WCPUtil.getObjLock(clusterName);
            synchronized (object) {
                block12: {
                    if (!lastUpdatedAllowedIpsTime.containsKey(clusterName)) break block12;
                    long time = lastUpdatedAllowedIpsTime.get(clusterName);
                    if (System.currentTimeMillis() - time >= 10000L) break block12;
                    return;
                }
                List<String> ipList = DC.getAllowedIpsOfACluster(clusterName);
                if (CommonUtil.isEmpty(ipList)) {
                    logger.info("WCPERR--> AllowedIps list is empty.");
                }
                allowedIps.put(clusterName, new HashSet<String>(ipList));
                lastUpdatedAllowedIpsTime.put(clusterName, System.currentTimeMillis());
                logger.info("HB--> updateAllowedIps. ipList=" + ipList + " of clusterName=" + clusterName);
            }
        }
        finally {
            WCPUtil.releaseObjLock(clusterName);
        }
    }

    public static void setAccessTokenExpireTime(long expireTime) {
        accessTokenExpireTime = expireTime;
    }

    public static long getAccessTokenExpireTime() {
        return accessTokenExpireTime;
    }

    public static void setAccessTokenExpireTimeForAPI(long expireTime) {
        accessTokenExpireTimeForAPI = expireTime;
    }

    public static long getAccessTokenExpireTimeForAPI() {
        return accessTokenExpireTimeForAPI;
    }

    public static boolean isWCPSecurityEnabled() {
        return isWCPSecurityEnabled;
    }

    public static boolean isWCPSecurityEnabledForAPI() {
        return isWCPSecurityEnabledForAPI;
    }

    public static long getWCPRequestTimeOutInMillis() {
        return requestTimeOutInMillis;
    }

    public static void setRequestTimeOutInMillis(long reqTimeOutInMillis) {
        requestTimeOutInMillis = reqTimeOutInMillis;
    }

    public static long getWCPRequestTimeOutTrackerIntervalInMillis() {
        return wcpRequestTimeoutTrackerInterval;
    }

    public static void setWCPRequestTimeOutTrackerIntervalInMillis(long wcpRequestTimeoutTrackerIntervalinMillis) {
        wcpRequestTimeoutTrackerInterval = wcpRequestTimeoutTrackerIntervalinMillis;
    }

    static {
        try {
            servletProps.load(new FileInputStream(servletFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wcpSource = DC.getCluster();
    }
}

