/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.mdckms;

import com.adventnet.wms.servercommon.components.mdckms.OwnershipState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OwnershipObject {
    private long sequenceID;
    private long stateChangeTime;
    private long appUUID;
    private OwnershipState state;
    private String ownerDC;
    private Set<String> followerDC;
    private long appUUIDBeforeStateChange;
    private Map<String, String> serverDetails;
    private OwnershipObject previousOwner;
    private OwnershipObject conflictOwner;

    public OwnershipObject(long sequenceID, long stateChangeTime, long appUUID, OwnershipState state, String ownerDC, Set<String> followerDC) {
        this.sequenceID = sequenceID;
        this.stateChangeTime = stateChangeTime;
        this.appUUID = appUUID;
        this.state = state;
        this.ownerDC = ownerDC;
        this.followerDC = followerDC;
    }

    public OwnershipObject(long sequenceID, long stateChangeTime, long appUUID, OwnershipState state, String ownerDC, Set<String> followerDC, long appUUIDBeforeStateChange) {
        this.sequenceID = sequenceID;
        this.stateChangeTime = stateChangeTime;
        this.appUUID = appUUID;
        this.state = state;
        this.ownerDC = ownerDC;
        this.followerDC = followerDC;
        this.appUUIDBeforeStateChange = appUUIDBeforeStateChange;
    }

    public void setSequenceID(long sequenceID) {
        this.sequenceID = sequenceID;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    private void incrementSequenceID() {
        ++this.sequenceID;
        this.setStateChangeTime(System.currentTimeMillis());
    }

    public void setStateChangeTime(long stateChangeTime) {
        this.stateChangeTime = stateChangeTime;
    }

    public long getStateChangeTime() {
        return this.stateChangeTime;
    }

    public void setAppUUID(long appUUID) {
        this.appUUID = appUUID;
    }

    public long getAppUUID() {
        return this.appUUID;
    }

    public void setAppUUIDBeforeStateChange(long appUUIDBeforeStateChange) {
        this.appUUIDBeforeStateChange = appUUIDBeforeStateChange;
    }

    public long getAppUUIDBeforeStateChange() {
        return this.appUUIDBeforeStateChange;
    }

    public void setState(OwnershipState state) {
        this.state = state;
    }

    public OwnershipState getState() {
        return this.state;
    }

    public void setOwnerDC(String ownerDC) {
        this.ownerDC = ownerDC;
        this.incrementSequenceID();
    }

    public String getOwnerDC() {
        return this.ownerDC;
    }

    public void setFollowerDC(Set<String> followerDC) {
        this.followerDC = followerDC;
    }

    public Set<String> getFollowerDC() {
        return this.followerDC;
    }

    public void addFollowerDC(String dcName) {
        if (this.followerDC == null) {
            this.followerDC = new HashSet<String>();
        }
        this.followerDC.add(dcName);
    }

    public static OwnershipState getOwnershipState(String state) {
        return OwnershipState.valueOf(state);
    }

    public static String getString(OwnershipState state) {
        return state.name();
    }

    public void addServerDetails(String key, String value) {
        if (this.serverDetails == null) {
            this.serverDetails = new HashMap<String, String>(3);
        }
        this.serverDetails.put(key, value);
    }

    public Map<String, String> getServerDetails() {
        return this.serverDetails;
    }

    public String getServerDetails(String key) {
        return this.serverDetails != null ? this.serverDetails.get(key) : null;
    }

    public void setPreviousOwner(OwnershipObject prevOwnershipObject) {
        this.previousOwner = prevOwnershipObject;
    }

    public OwnershipObject getPreviousOwner() {
        return this.previousOwner;
    }

    public void setConflictOwner(OwnershipObject conflictOwnershipObject) {
        this.conflictOwner = conflictOwnershipObject;
    }

    public OwnershipObject getConflictOwner() {
        return this.conflictOwner;
    }
}

