/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.logging.util;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.eaio.uuid.UUIDGen;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.UUID;

public class LoggingUtil {
    private static long prev = -1L;
    private static Object lock = new Object();
    private static final String CF_PREFIX = "wmslog_day";
    private static final long DURATION_PER_DAY = 86400000L;
    private static Calendar calendar = null;
    private static int timezoneOffset = 0;

    private static long getCurrentDay(long time) {
        calendar.setTimeInMillis(time);
        time = calendar.getTimeInMillis() + (long)timezoneOffset;
        return time / 86400000L;
    }

    public static String getCFName(long time) {
        return CF_PREFIX + LoggingUtil.getCurrentDay(time);
    }

    public static ArrayList<String> getCFList(long stime, long etime) {
        long initial = LoggingUtil.getCurrentDay(stime);
        long end = LoggingUtil.getCurrentDay(etime);
        ArrayList<String> cfList = new ArrayList<String>();
        for (long i = end; i >= initial; --i) {
            cfList.add(CF_PREFIX + i);
        }
        return cfList;
    }

    public static UUID getTimeUUID(long timeMillis) {
        long _time = timeMillis * 10000L + 122192928000000000L;
        long time = _time << 32;
        time |= (_time & 0xFFFF00000000L) >> 16;
        return new UUID(time |= 0x1000L | _time >> 48 & 0xFFFL, UUIDGen.getClockSeqAndNode());
    }

    public static long getTimeStamp(UUID uuid) {
        return (uuid.timestamp() - 122192928000000000L) / 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeStamp() {
        long cur = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            if (cur > prev) {
                prev = cur;
            } else {
                cur = ++prev;
            }
        }
        return cur;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static void recordException(Exception e) {
        if (e instanceof InvalidQueryException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.INVALID_QUERY_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof UnavailableException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.UNAVAILABLE_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof NoHostAvailableException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.NO_HOST_AVAILABLE_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof AuthenticationException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.AUTHENTICATION_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof WriteTimeoutException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.WRITE_TIMEOUT_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof ReadTimeoutException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.READ_TIMEOUT_EXCEPTION.getErrorCode(), 1L);
        } else if (e instanceof QueryExecutionException) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.QUERY_EXECUTION_EXCEPTION.getErrorCode(), 1L);
        } else {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.UNHANDLED_EXCEPTION.getErrorCode(), 1L);
        }
    }

    static {
        calendar = Calendar.getInstance();
        timezoneOffset = calendar.getTimeZone().getRawOffset();
    }
}

