/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.logging.util;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.components.logging.WMSLogDatastaxManager;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CassandraUtil {
    private static final Logger LOGGER = Logger.getLogger(CassandraUtil.class.getName());

    public static RegularStatement createWMSLogTableStatement(String keyspace, String cfname) {
        return ((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)SchemaBuilder.createTable((String)QueryBuilder.quote((String)keyspace), (String)QueryBuilder.quote((String)cfname)).addPartitionKey("service", DataType.text()).addPartitionKey("entityid", DataType.text()).addClusteringColumn("prd", DataType.text()).addClusteringColumn("category", DataType.text()).addClusteringColumn("time_uuid", DataType.uuid()).addColumn("message", DataType.text())).addColumn("milestone", DataType.text())).addColumn("subcategory", DataType.text())).addColumn("reqid", DataType.text())).addColumn("status", DataType.smallint())).addColumn("addlinfo1", DataType.text())).addColumn("addlinfo2", DataType.text())).addColumn("addlinfo3", DataType.text())).ifNotExists()).withOptions().clusteringOrder("prd", SchemaBuilder.Direction.ASC).clusteringOrder("category", SchemaBuilder.Direction.ASC).clusteringOrder("time_uuid", SchemaBuilder.Direction.DESC).bloomFilterFPChance(Double.valueOf(0.01))).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.noRows())).comment("")).compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.timeWindowCompactionStrategy().compactionWindowSize(Integer.valueOf(6)).compactionWindowUnit(TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions.CompactionWindowUnit.HOURS))).compressionOptions(SchemaBuilder.lz4())).dcLocalReadRepairChance(Double.valueOf(0.1))).defaultTimeToLive(Integer.valueOf(864000))).gcGraceSeconds(Integer.valueOf(60))).maxIndexInterval(Integer.valueOf(2048))).memtableFlushPeriodInMillis(Integer.valueOf(0))).minIndexInterval(Integer.valueOf(128))).readRepairChance(Double.valueOf(0.0))).speculativeRetry(SchemaBuilder.percentile((int)99));
    }

    public static void createUniqueTable(String cfname, DatastaxSession session, RegularStatement statement) {
        try {
            QueryExecutor.execute(session, statement.setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while creating table, cfname:" + cfname, e);
        }
    }

    public static RegularStatement deleteTableStatement(String keyspace, String cfname) {
        return SchemaBuilder.dropTable((String)QueryBuilder.quote((String)keyspace), (String)QueryBuilder.quote((String)cfname)).ifExists();
    }

    public static void deleteTable(String cfname, DatastaxSession session, RegularStatement statement) {
        try {
            QueryExecutor.execute(session, statement.setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while deleting table, cfname:" + cfname, e);
        }
    }

    public static Hashtable<String, String> getTablesList(DatastaxSession session, int days) {
        Hashtable<String, String> returnHash = new Hashtable<String, String>();
        try {
            ArrayList<String> tables = new ArrayList<String>();
            SimpleStatement statement = new SimpleStatement("select table_name from system_schema.tables where keyspace_name='WMSLOG' LIMIT 31");
            ResultSet resultset = QueryExecutor.execute(session, (Statement)statement);
            for (Row row : resultset) {
                tables.add(row.getString("table_name"));
            }
            if (tables.size() <= days) {
                returnHash.put("Available Tables", (String)((Object)tables));
            } else {
                returnHash.put("Available Tables", (String)((Object)tables.subList(tables.size() - days, tables.size())));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while getting table list, days=" + days, e);
            returnHash.put("Status", "Error while getting tables list");
        }
        return returnHash;
    }

    public static boolean cleanup() {
        DatastaxSession session = WMSLogDatastaxManager.getDefaultSession();
        if (session == null) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Session not initialised, aborting cassandra cf cleanup operation.");
            return false;
        }
        try {
            long creationStartDay = System.currentTimeMillis() / 86400000L;
            long creationEndDay = creationStartDay + 5L;
            long deletionStartDay = creationStartDay - 16L;
            long deletionEndDay = creationStartDay - 12L;
            String cfname = null;
            RegularStatement statement = null;
            for (long creationDay = creationStartDay; creationDay <= creationEndDay; ++creationDay) {
                cfname = "wmslog_day" + creationDay;
                statement = CassandraUtil.createWMSLogTableStatement("WMSLOG", cfname);
                CassandraUtil.createUniqueTable(cfname, session, statement);
                LOGGER.info("WMSLOG --> Created new table, cfname : " + cfname);
            }
            for (long deletionDay = deletionStartDay; deletionDay <= deletionEndDay; ++deletionDay) {
                cfname = "wmslog_day" + deletionDay;
                statement = CassandraUtil.deleteTableStatement("WMSLOG", cfname);
                CassandraUtil.deleteTable(cfname, session, statement);
                LOGGER.info("WMSLOG --> Dropped table, cfname : " + cfname);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while executing cassandra cleanup", e);
            return false;
        }
    }
}

