/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.logging;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.util.FileUtil;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSLogDatastaxManager {
    private static Logger logger = Logger.getLogger(WMSLogDatastaxManager.class.getName());
    private static boolean isInitialised = false;
    private static Properties loggingProperties = null;
    private static DatastaxSession defaultSession = null;
    private static Hashtable<String, ProtocolVersion> protocolVersionHash = new Hashtable();

    public static boolean initialise() {
        try {
            if (isInitialised) {
                logger.info("YG --> WMS Logger already initialised");
                return false;
            }
            if (loggingProperties == null && !WMSLogDatastaxManager.loadPropertyFile()) {
                StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.FAILED_TO_LOAD_CONF.getErrorCode(), 1L);
                logger.info("YG --> Unable to load wmslogger conf files");
                return false;
            }
            String clusterName = loggingProperties.getProperty("clustername");
            String contactPoints = loggingProperties.getProperty("cassandraips");
            String username = loggingProperties.getProperty("username");
            String password = loggingProperties.getProperty("password");
            String protocolversion = loggingProperties.getProperty("protocol");
            String keyspaceName = loggingProperties.getProperty("keyspacename");
            String clusterDataCenter = loggingProperties.getProperty("datacenter");
            ProtocolVersion protocolVersion = protocolVersionHash.get(protocolversion);
            Hashtable<DatastaxManager.ClusterProp, Object> clusterProps = new Hashtable<DatastaxManager.ClusterProp, Object>();
            clusterProps.put(DatastaxManager.ClusterProp.CLUSTERNAME, clusterName);
            clusterProps.put(DatastaxManager.ClusterProp.CONTACTPOINTS, contactPoints.split(","));
            clusterProps.put(DatastaxManager.ClusterProp.PROTOCOLVERSION, protocolVersion);
            clusterProps.put(DatastaxManager.ClusterProp.COMPRESSION, ProtocolOptions.Compression.NONE);
            clusterProps.put(DatastaxManager.ClusterProp.LOADBALANCINGPOLICY, new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(clusterDataCenter).build()));
            clusterProps.put(DatastaxManager.ClusterProp.QUERYOPTIONS, new QueryOptions().setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM));
            if (!CommonUtil.isEmpty((String)username) && !CommonUtil.isEmpty((String)password)) {
                clusterProps.put(DatastaxManager.ClusterProp.AUTHPROVIDER, new PlainTextAuthProvider(username, password));
            } else {
                clusterProps.put(DatastaxManager.ClusterProp.AUTHPROVIDER, AuthProvider.NONE);
            }
            defaultSession = DatastaxManager.initialize(clusterName + "_" + keyspaceName, "\"" + keyspaceName + "\"", clusterProps, true);
            if (defaultSession == null) {
                StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.SESSION_INITIALISATION_FAILED.getErrorCode(), 1L);
                logger.info("YG --> DefaultSession is null.");
                return false;
            }
            isInitialised = true;
            logger.info("YG --> WMSLogDatastaxManager initialised successfully");
            return true;
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.WMSLOGGER_NOT_INITIALIZED.getErrorCode(), 1L);
            logger.log(Level.SEVERE, "YG --> Error initialising WMSLogDatastaxManager", e);
            return false;
        }
    }

    private static boolean loadPropertyFile() {
        try {
            String serverHome = System.getProperty("server.home");
            loggingProperties = FileUtil.getFileAsProperties(serverHome + File.separator + "conf" + File.separator + "wmslogger.conf");
            if (loggingProperties != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "YG --> Error while loading wmslogger conf file", e);
        }
        return false;
    }

    public static DatastaxSession getDefaultSession() {
        return defaultSession;
    }

    static {
        protocolVersionHash.put("v1", ProtocolVersion.V1);
        protocolVersionHash.put("v2", ProtocolVersion.V2);
        protocolVersionHash.put("v3", ProtocolVersion.V3);
        protocolVersionHash.put("v4", ProtocolVersion.V4);
    }
}

