/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutorInventory;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSThreadPoolExecutor {
    private Logger logger = Logger.getLogger(WMSThreadPoolExecutor.class.getName());
    private final String name;
    private final BufferedQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> coreWorkers = new LinkedHashSet<Worker>();
    private final HashSet<Worker> nonCoreWorkers = new LinkedHashSet<Worker>();
    private final SortedSet<Integer> freeWorkerIds = new TreeSet<Integer>();
    private int largestPoolSize = 0;
    private int largestActivePoolSize = 0;
    private AtomicInteger currentPoolSize = new AtomicInteger();
    private AtomicInteger activePoolSize = new AtomicInteger();
    private AtomicLong completedTaskCount = new AtomicLong();
    private volatile long keepAliveTime;
    private boolean isShutDown = false;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private WmsTask wmstask;
    private String state = "Running";
    private boolean isPaused = false;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition pauseCondition = this.pauseLock.newCondition();

    public WMSThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BufferedQueue workQueue, WmsTask wmstask) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || wmstask == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toMillis(keepAliveTime);
        this.wmstask = wmstask;
        if (!WMSThreadPoolExecutorInventory.register(name, this)) {
            this.logger.info("VS -->  Executor Name is duplicated name - " + name);
        }
    }

    public void start() {
        this.freeWorkerIds.clear();
        for (int i = this.corePoolSize + 1; i <= this.maximumPoolSize; ++i) {
            this.freeWorkerIds.add(i);
        }
        if (!this.workQueue.isEmpty()) {
            int queueSize = this.workQueue.size();
            if (queueSize < this.corePoolSize) {
                for (int i = 0; i < queueSize; ++i) {
                    this.addWorker(true);
                }
            } else if (queueSize < this.maximumPoolSize) {
                int i;
                for (i = 0; i < this.corePoolSize; ++i) {
                    this.addWorker(true);
                }
                for (i = this.corePoolSize; i < queueSize; ++i) {
                    this.addWorker(false);
                }
            } else {
                int i;
                for (i = 0; i < this.corePoolSize; ++i) {
                    this.addWorker(true);
                }
                for (i = this.corePoolSize; i < this.maximumPoolSize; ++i) {
                    this.addWorker(false);
                }
            }
        }
        this.isShutDown = false;
        this.logger.info("NSTPE--> Pool=" + this.name + " started sucessfully. CurrentPoolSize=" + this.currentPoolSize.get() + " CorePoolSize=" + this.corePoolSize + " MaxPoolSize=" + this.maximumPoolSize);
    }

    public void execute(Object event) {
        if (event == null) {
            throw new NullPointerException();
        }
        this.workQueue.add(event);
        StatsDB.addData("tpeinstats", DC.getServertype(), DC.getCluster(), this.name, 1);
        if (this.isShutDown) {
            return;
        }
        if (this.currentPoolSize.get() < this.corePoolSize) {
            this.addWorker(true);
        } else if (this.workQueue.size() > this.maximumPoolSize && this.currentPoolSize.get() < this.maximumPoolSize) {
            this.addWorker(false);
        }
    }

    public int getActivePoolSize() {
        return this.activePoolSize.get();
    }

    public int getCurrentPoolSize() {
        return this.currentPoolSize.get();
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount.get();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getLargestActivePoolSize() {
        return this.largestActivePoolSize;
    }

    protected void resetLargestPoolSize() {
        this.largestPoolSize = this.currentPoolSize.get();
    }

    protected void resetLargestActivePoolSize() {
        this.largestActivePoolSize = this.activePoolSize.get();
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public BufferedQueue getQueue() {
        return this.workQueue;
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(true)) {
            ++n;
        }
        return n;
    }

    public String toString() {
        return super.toString() + "[" + this.state + ", pool size = " + this.currentPoolSize.get() + ", active threads = " + this.activePoolSize.get() + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + this.completedTaskCount.get() + "]";
    }

    public synchronized void setPoolSize(int corePoolSize, int maxPoolSize) {
        if (corePoolSize < 0 || maxPoolSize <= 0 || maxPoolSize < corePoolSize || this.keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (maxPoolSize < this.corePoolSize) {
            this.setCorePoolSize(corePoolSize);
            this.setMaximumPoolSize(maxPoolSize);
        } else {
            this.setMaximumPoolSize(maxPoolSize);
            this.setCorePoolSize(corePoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCorePoolSize(int corePoolSize) {
        block8: {
            if (this.isShutDown) {
                return;
            }
            try {
                this.mainLock.lock();
                if (corePoolSize > this.maximumPoolSize || corePoolSize < 0) {
                    throw new IllegalArgumentException();
                }
                int delta = corePoolSize - this.corePoolSize;
                this.corePoolSize = corePoolSize;
                if (delta > 0) {
                    if (this.currentPoolSize.get() <= corePoolSize) break block8;
                    Iterator<Worker> iterator = this.nonCoreWorkers.iterator();
                    while (iterator.hasNext()) {
                        Worker worker = iterator.next();
                        worker.setasCore();
                        this.coreWorkers.add(worker);
                        iterator.remove();
                        if (--delta != 0) continue;
                        break block8;
                    }
                    break block8;
                }
                if (delta >= 0) break block8;
                Iterator<Worker> iterator = this.coreWorkers.iterator();
                while (iterator.hasNext()) {
                    Worker worker = iterator.next();
                    worker.removeAsCore();
                    worker.interrupt();
                    iterator.remove();
                    this.nonCoreWorkers.add(worker);
                    if (++delta != 0) continue;
                    break;
                }
            }
            finally {
                this.mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        if (this.isShutDown) {
            return;
        }
        int delta = 0;
        try {
            this.mainLock.lock();
            if (this.corePoolSize > maximumPoolSize || maximumPoolSize < 1) {
                throw new IllegalArgumentException();
            }
            delta = maximumPoolSize - this.maximumPoolSize;
            if (delta < 0) {
                if (this.currentPoolSize.get() > maximumPoolSize) {
                    for (Worker worker : this.nonCoreWorkers) {
                        worker.shutdown();
                        worker.interrupt();
                        if (++delta != 0) continue;
                        break;
                    }
                }
            } else if (delta != 0) {
                for (int i = 1; i <= delta; ++i) {
                    this.freeWorkerIds.add(i + this.maximumPoolSize);
                }
            }
            this.maximumPoolSize = maximumPoolSize;
        }
        finally {
            this.mainLock.unlock();
        }
        for (int i = 0; i < delta; ++i) {
            this.addWorker(false);
        }
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (this.isShutDown) {
            return;
        }
        this.keepAliveTime = unit.toMillis(time);
    }

    /*
     * Unable to fully structure code
     */
    public boolean shutdown() {
        if (this.isShutDown) {
            return false;
        }
        try {
            this.mainLock.lock();
            this.state = "Shutting down";
            for (Worker worker : this.coreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            for (Worker worker : this.nonCoreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            do lbl-1000:
            // 3 sources

            {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.name);
                }
                if (this.activePoolSize.get() != 0) ** GOTO lbl-1000
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.name);
                }
            } while (this.activePoolSize.get() != 0);
            this.state = "Terminated";
        }
        finally {
            this.mainLock.unlock();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean drain() {
        if (this.isShutDown) {
            return false;
        }
        this.state = "Draining";
        while (!this.workQueue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.name);
            }
        }
        try {
            this.mainLock.lock();
            for (Worker worker : this.coreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            for (Worker worker : this.nonCoreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            do lbl-1000:
            // 3 sources

            {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.name);
                }
                if (this.activePoolSize.get() != 0) ** GOTO lbl-1000
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.name);
                }
            } while (this.activePoolSize.get() != 0);
            this.state = "Terminated";
        }
        finally {
            this.mainLock.unlock();
        }
        return true;
    }

    public void pauseAsync() {
        this.state = "Paused";
        this.isPaused = true;
    }

    public void pauseSync() {
        this.state = "Paused";
        this.isPaused = true;
        while (this.activePoolSize.get() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.fine("VS --> InterruptedException");
            }
        }
    }

    public void play() {
        if (this.isPaused) {
            this.state = "Running";
            try {
                this.isPaused = false;
                this.pauseLock.lock();
                this.pauseCondition.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addWorker(boolean isCore) {
        if (this.currentPoolSize.get() >= (isCore ? this.corePoolSize : this.maximumPoolSize)) {
            return false;
        }
        if (!isCore && this.freeWorkerIds.isEmpty()) {
            return false;
        }
        int count = 0;
        try {
            this.mainLock.lock();
            count = this.currentPoolSize.incrementAndGet();
            if (!isCore) {
                count = (Integer)this.freeWorkerIds.iterator().next();
            }
            Worker worker = new Worker(isCore, this.keepAliveTime, this.workQueue, this.wmstask, this.name + "_" + count, count);
            worker.start();
            if (isCore) {
                this.coreWorkers.add(worker);
            } else {
                this.nonCoreWorkers.add(worker);
            }
            this.freeWorkerIds.remove(count);
        }
        finally {
            this.mainLock.unlock();
        }
        if (this.currentPoolSize.get() > this.largestPoolSize) {
            this.largestPoolSize = count;
        }
        return true;
    }

    class Worker
    extends Thread {
        private int threadIndex;
        private boolean isCore;
        private WmsTask handler;
        private BufferedQueue workQueue;
        private boolean isThreadAlive = true;

        public Worker(boolean isCore, long keepAliveTime, BufferedQueue workQueue, WmsTask handler, String threadName, int index) {
            this.isCore = isCore;
            this.workQueue = workQueue;
            this.handler = handler;
            this.setName(threadName);
            this.threadIndex = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isThreadAlive) {
                try {
                    Object event = null;
                    if (WMSThreadPoolExecutor.this.isPaused) {
                        try {
                            WMSThreadPoolExecutor.this.pauseLock.lock();
                            if (WMSThreadPoolExecutor.this.isPaused) {
                                WMSThreadPoolExecutor.this.pauseCondition.await();
                            }
                        }
                        catch (InterruptedException e) {
                            WMSThreadPoolExecutor.this.logger.fine("VS --> InterruptedException");
                        }
                        finally {
                            WMSThreadPoolExecutor.this.pauseLock.unlock();
                        }
                    }
                    if ((event = this.isCore ? this.workQueue.poll() : this.workQueue.poll(WMSThreadPoolExecutor.this.keepAliveTime)) != null) {
                        if (WMSThreadPoolExecutor.this.activePoolSize.incrementAndGet() > WMSThreadPoolExecutor.this.largestActivePoolSize) {
                            WMSThreadPoolExecutor.this.largestActivePoolSize = WMSThreadPoolExecutor.this.activePoolSize.get();
                        }
                        try {
                            long srtTime = System.currentTimeMillis();
                            this.handler.handle(event);
                            WMSThreadPoolExecutor.this.completedTaskCount.incrementAndGet();
                            StatsDB.addData("tpeoutstats", DC.getServertype(), DC.getCluster(), WMSThreadPoolExecutor.this.name, 1, System.currentTimeMillis() - srtTime);
                        }
                        catch (Exception e) {
                            WMSThreadPoolExecutor.this.logger.log(Level.SEVERE, "VS_ERR --> Exception while processing in WMSThreadPoolExecutor in " + WMSThreadPoolExecutor.this.name, e);
                        }
                        catch (Error e) {
                            WMSThreadPoolExecutor.this.activePoolSize.decrementAndGet();
                            WMSThreadPoolExecutor.this.logger.log(Level.SEVERE, "VS_ERR --> Error while processing in WMSThreadPoolManager in " + WMSThreadPoolExecutor.this.name + " thred id - " + this.threadIndex, e);
                            try {
                                WMSThreadPoolExecutor.this.mainLock.lock();
                                if (this.isCore) {
                                    WMSThreadPoolExecutor.this.coreWorkers.remove(this);
                                } else {
                                    WMSThreadPoolExecutor.this.nonCoreWorkers.remove(this);
                                }
                            }
                            finally {
                                WMSThreadPoolExecutor.this.mainLock.unlock();
                            }
                            if (WMSThreadPoolExecutor.this.coreWorkers.isEmpty() && WMSThreadPoolExecutor.this.nonCoreWorkers.isEmpty() && WMSThreadPoolExecutor.this.currentPoolSize.get() == WMSThreadPoolExecutor.this.maximumPoolSize) {
                                WMSThreadPoolExecutor.this.state = "Terminated due to Error";
                                WMSThreadPoolExecutor.this.isShutDown = true;
                            }
                            throw e;
                        }
                        WMSThreadPoolExecutor.this.activePoolSize.decrementAndGet();
                        continue;
                    }
                    try {
                        WMSThreadPoolExecutor.this.mainLock.lock();
                        if (this.isCore) continue;
                        this.isThreadAlive = false;
                        WMSThreadPoolExecutor.this.nonCoreWorkers.remove(this);
                        if (this.threadIndex > WMSThreadPoolExecutor.this.maximumPoolSize || this.threadIndex < WMSThreadPoolExecutor.this.corePoolSize) continue;
                        WMSThreadPoolExecutor.this.freeWorkerIds.add(this.threadIndex);
                    }
                    finally {
                        WMSThreadPoolExecutor.this.mainLock.unlock();
                    }
                }
                catch (Exception e) {
                    WMSThreadPoolExecutor.this.logger.log(Level.SEVERE, "VS_ERR --> Exception in worker threads", e);
                }
            }
            try {
                WMSThreadPoolExecutor.this.mainLock.lock();
                if (this.isCore) {
                    WMSThreadPoolExecutor.this.coreWorkers.remove(this);
                } else {
                    WMSThreadPoolExecutor.this.nonCoreWorkers.remove(this);
                }
                WMSThreadPoolExecutor.this.currentPoolSize.decrementAndGet();
            }
            finally {
                WMSThreadPoolExecutor.this.mainLock.unlock();
            }
        }

        void shutdown() {
            this.isThreadAlive = false;
        }

        void setasCore() {
            this.isCore = true;
        }

        void removeAsCore() {
            this.isCore = false;
        }
    }
}

