/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskQueueDrainManager
extends WmsRuntime {
    private Logger logger = Logger.getLogger(TaskQueueDrainManager.class.getName());

    @Override
    public Hashtable getInfo(Hashtable prams) {
        Hashtable<String, String> returnHash = new Hashtable<String, String>();
        try {
            int drainCount;
            String tmName = (String)prams.get("taskmanager");
            String teName = (String)prams.get("taskengine");
            String task = (String)prams.get("task");
            String queueID = (String)prams.get("queueid");
            if (queueID == null) {
                queueID = "all";
            }
            try {
                drainCount = Integer.parseInt((String)prams.get("drainCount"));
            }
            catch (Exception e) {
                returnHash.put("Result", "invalid drain count");
                return returnHash;
            }
            boolean isIsolation = false;
            if (prams.containsKey("isolation")) {
                isIsolation = true;
            }
            String result = "";
            result = task != null ? TaskExecutorService.dropTask(tmName, teName, task, drainCount) : TaskExecutorService.drainQueue(tmName, teName, queueID, drainCount, isIsolation);
            returnHash.put("Result", result);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "VS--> Exception in IsolationDrainManager command", e);
        }
        return returnHash;
    }
}

