/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.io.File;
import java.util.Hashtable;

public class TaskQueue {
    private BufferedQueue bq;
    private String queueName;

    public TaskQueue(String queueName, int inMemBufSize, boolean isAREnabled) {
        this.queueName = queueName;
        this.bq = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + queueName + "_tmp", queueName, inMemBufSize, isAREnabled);
    }

    public TaskQueue(String tmName, String queueName, int inMemBufSize, boolean isAREnabled) {
        this.queueName = queueName;
        this.bq = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + tmName + File.separator + queueName + "_tmp", queueName, inMemBufSize, isAREnabled);
    }

    public void add(WmsEvent event) {
        this.bq.add(event);
    }

    public WmsEvent remove() {
        return (WmsEvent)this.bq.get(5);
    }

    public int size() {
        return this.bq.size();
    }

    public boolean isEmpty() {
        return this.bq.isEmpty();
    }

    public String drop(int drainCount) {
        if (drainCount < -1) {
            return "invalid count";
        }
        if (drainCount == -1 ? this.bq.dropAll() : this.bq.drop(drainCount)) {
            return "Drain completed for " + this.queueName;
        }
        return "Drain failed for " + this.queueName;
    }

    public Hashtable<String, String> getStats() {
        return this.bq.getStats();
    }

    public Hashtable<String, String> getWmsQStats() {
        return this.bq.getWmsQStats();
    }

    public void clearStats() {
        this.bq.clearStats();
    }

    public void open() {
        this.bq.open();
    }

    public void close() {
        this.bq.close();
    }

    public String getname() {
        return this.queueName;
    }
}

