/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class TESIsolationRuntime
extends WmsRuntime {
    private Logger logger = Logger.getLogger(TESIsolationRuntime.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getInfo(Hashtable prams) {
        String opr = (String)prams.get("opr");
        Hashtable<String, Object> returnHash = new Hashtable<String, Object>();
        String tmName = (String)prams.get("taskmanager");
        String teName = (String)prams.get("taskengine");
        String taskName = (String)prams.get("task");
        String prd = (String)prams.get("prd");
        String rkey = (String)prams.get("rkey");
        try {
            if (opr == null) {
                HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> map = TaskExecutorService.getParallelIsolationStatus();
                if (map.isEmpty()) {
                    returnHash.put("Status", "None");
                } else {
                    returnHash.put("Status", map);
                }
            } else {
                switch (opr) {
                    case "iso": {
                        if (prd != null) {
                            if (teName == null) {
                                returnHash.put("Status", TaskExecutorService.isolatePrd(tmName, prd));
                            } else {
                                returnHash.put("Status", TaskExecutorService.isolatePrd(tmName, teName, prd));
                            }
                            Hashtable<String, Object> hashtable = returnHash;
                            return hashtable;
                        }
                        if (rkey != null) {
                            if (teName == null) {
                                returnHash.put("Status", TaskExecutorService.isolateRkey(tmName, rkey));
                            } else {
                                returnHash.put("Status", TaskExecutorService.isolateRkey(tmName, teName, rkey));
                            }
                            Hashtable<String, Object> hashtable = returnHash;
                            return hashtable;
                        }
                        if (tmName == null) {
                            returnHash.put("Status", "Invalid TaskManager");
                            break;
                        }
                        if (teName == null) {
                            returnHash.put("Status", "Invalid TaskEngine");
                            break;
                        }
                        if (taskName == null) {
                            returnHash.put("Status", TaskExecutorService.isolateEngine(tmName, teName));
                            break;
                        }
                        returnHash.put("Status", TaskExecutorService.isolateTask(tmName, teName, taskName));
                        break;
                    }
                    case "deiso": {
                        if (prd != null) {
                            if (teName == null) {
                                returnHash.put("Status", TaskExecutorService.deIsolatePrd(tmName, prd));
                            } else {
                                returnHash.put("Status", TaskExecutorService.deIsolatePrd(tmName, teName, prd));
                            }
                            Hashtable<String, Object> hashtable = returnHash;
                            return hashtable;
                        }
                        if (rkey != null) {
                            if (teName == null) {
                                returnHash.put("Status", TaskExecutorService.deIsolateRkey(tmName, rkey));
                            } else {
                                returnHash.put("Status", TaskExecutorService.deIsolateRkey(tmName, teName, rkey));
                            }
                            Hashtable<String, Object> hashtable = returnHash;
                            return hashtable;
                        }
                        if (tmName == null) {
                            returnHash.put("Status", "Invalid TaskManager");
                            break;
                        }
                        if (teName == null) {
                            returnHash.put("Status", "Invalid TaskEngine");
                            break;
                        }
                        if (taskName == null) {
                            returnHash.put("Status", TaskExecutorService.deIsolateEngine(tmName, teName));
                            break;
                        }
                        returnHash.put("Status", TaskExecutorService.deIsolateTask(tmName, teName, taskName));
                        break;
                    }
                    case "set": {
                        if (tmName == null) {
                            returnHash.put("Status", "Invalid TaskManager");
                            break;
                        }
                        try {
                            int threads = Integer.parseInt((String)prams.get("thread"));
                            if (threads <= 0) {
                                returnHash.put("Status", "Invalid Thread Count");
                                break;
                            }
                            returnHash.put("Status", TaskExecutorService.setIsolationThreadsCount(tmName, threads));
                        }
                        catch (Exception e) {
                            returnHash.put("Status", "Invalid Thread Count");
                        }
                        break;
                    }
                    default: {
                        returnHash.put("Status", "Invalid Opr");
                    }
                }
            }
            Object object = returnHash;
            return object;
        }
        finally {
            if (opr != null) {
                this.logger.info("VS --> TESIsolationRuntime prams " + prams);
                this.logger.info("VS --> TESIsolationRuntime request opr -" + opr + " tmName - " + tmName + " teName - " + teName + " taskName - " + taskName + " rkey - " + rkey + " prd - " + prd + " result - " + returnHash.get("Status"));
            }
        }
    }
}

