/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.AbsStatusCollector;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatusCollector {
    private static ConcurrentHashMap<String, AbsStatusCollector> componentInventory = new ConcurrentHashMap();

    public static void register(AbsStatusCollector component) {
        componentInventory.put(component.getName(), component);
    }

    public static Hashtable<String, Object> getStatus() {
        Hashtable<String, Object> componentStatusDetails = new Hashtable<String, Object>();
        for (Map.Entry<String, AbsStatusCollector> entry : componentInventory.entrySet()) {
            componentStatusDetails.put(entry.getKey(), entry.getValue().getStatus());
        }
        return componentStatusDetails;
    }

    public static LinkedHashMap<String, Object> getStatus(String componentName) {
        if (!StatusCollector.isComponentRegistered(componentName)) {
            return null;
        }
        return componentInventory.get(componentName).getDetailedStatus();
    }

    public static LinkedHashMap<String, Object> getStatus(String componentName, String subComponentName) {
        if (!StatusCollector.isComponentRegistered(componentName)) {
            return null;
        }
        return componentInventory.get(componentName).getDetailedStatus(subComponentName);
    }

    public static boolean isComponentRegistered(String componentName) {
        return componentInventory.containsKey(componentName);
    }
}

