/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.logging.LogLevelChange;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;

public class LogLevelRuntime
extends WmsRuntime {
    private static ArrayList<String> level = new ArrayList();

    @Override
    public Hashtable getInfo(Hashtable params) {
        Hashtable<String, String> returnHash = new Hashtable<String, String>();
        String levelToChange = (String)params.get("level");
        if (CommonUtil.isEmpty((String)levelToChange)) {
            levelToChange = "OFF";
        }
        if (!level.contains(levelToChange.toUpperCase())) {
            returnHash.put("Status", "Invalid Level");
            return returnHash;
        }
        if (params.containsKey("package")) {
            String packageName = (String)params.get("package");
            returnHash = LogLevelChange.changeLevelForPackage(packageName, Level.parse(levelToChange));
        } else if (params.containsKey("loggername")) {
            String loggerName = (String)params.get("loggername");
            returnHash = LogLevelChange.changeLevelOfAFile(loggerName, Level.parse(levelToChange));
        } else {
            returnHash.put("Status", "Params must contain packageName or loggername");
        }
        return returnHash;
    }

    static {
        level.add("OFF");
        level.add("SEVERE");
        level.add("WARNING");
        level.add("INFO");
        level.add("CONFIG");
        level.add("FINE");
        level.add("FINER");
        level.add("FINEST");
        level.add("ALL");
    }
}

