/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.exception.WMSEventException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.DeferredExecutorService;
import com.adventnet.wms.servercommon.components.executor.SequentialIsoQueueListener;
import com.adventnet.wms.servercommon.components.executor.SequentialTaskManager;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.taskengine.WmsTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IsolatedSequentialTaskEngine {
    private static Logger logger = Logger.getLogger(IsolatedSequentialTaskEngine.class.getName());
    private String teName;
    private String tmName;
    private String tesVersion = "";
    private boolean isAREnabled;
    private final int inMemBufSize;
    private int isolationThreads = 0;
    private int maxIsolationLimit;
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, SequentialTaskQueue>> queuesMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, SequentialTaskQueue> currentQueueMap = new ConcurrentHashMap();
    private Hashtable<Integer, TaskDispatcher> threadsMap = new Hashtable();
    private ReentrantLock threadsMapLock = new ReentrantLock();
    private ReentrantLock versionLock = new ReentrantLock();
    private Condition versionCondition = this.versionLock.newCondition();
    private boolean stopEngine;
    private String isoPropDir;
    private IsolationManager isolationManager;
    private ConcurrentHashMap<String, AtomicLong> isolationMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> manualIsolationMap = new ConcurrentHashMap();
    private LinkedBlockingQueue<String> isolationQueue = new LinkedBlockingQueue();
    private AtomicInteger activeThreadCount = new AtomicInteger();
    private AtomicInteger threadCount = new AtomicInteger();
    private Integer maxThreadCount = 0;
    private Integer maxIsolatedSeqIDCount = 0;
    private boolean drain;
    private HashMap<String, WmsTask> taskMap;
    private HashMap<String, String> deferredMap;
    private SequentialTaskManager manager;
    private MappedByteBuffer mappedBB;
    private Map<Integer, Integer> inQueuePosition = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> outQueuePosition = new HashMap<Integer, Integer>();
    private Map<Integer, Long> initialCountInQueue = new HashMap<Integer, Long>();
    private ConcurrentHashMap<String, AtomicLong> blockedTaskMap;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedRKeyMap;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedPrdMap;
    private static final int LONG_BYTES = 8;

    IsolatedSequentialTaskEngine(String tmName, String teName, String tesVersion, int inMemBufSize, boolean isAREnabled, int isolationThreads, int maxIsolationLimit, HashMap<String, WmsTask> taskMap, SequentialTaskManager manager, ConcurrentHashMap<String, AtomicLong> blockedTaskMap, ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedRKeyMap, ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedPrdMap, HashMap<String, String> deferredMap) {
        this.teName = teName;
        this.tmName = tmName;
        this.tesVersion = tesVersion;
        this.isolationThreads = isolationThreads;
        this.taskMap = taskMap;
        this.inMemBufSize = inMemBufSize;
        this.isAREnabled = isAREnabled;
        this.maxIsolationLimit = maxIsolationLimit;
        this.manager = manager;
        this.deferredMap = deferredMap;
        this.blockedTaskMap = blockedTaskMap;
        this.blockedRKeyMap = blockedRKeyMap;
        this.blockedPrdMap = blockedPrdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        this.isoPropDir = ServerUtil.dataHome + File.separator + "tes" + File.separator + this.tmName + File.separator + this.teName + File.separator;
        new File(this.isoPropDir).mkdirs();
        File isolatedseqidsFile = new File(this.isoPropDir + "isolatedSeqidFile.properties");
        File tempIsoSeqIdFile = new File(this.isoPropDir + "tempIsoSeqIdFile.properties");
        try {
            this.versionLock.lock();
            VersionControler versionController = new VersionControler(this);
            versionController.start();
            try {
                this.versionCondition.await();
            }
            catch (InterruptedException e) {
                logger.fine("InterruptedException");
            }
        }
        finally {
            this.versionLock.unlock();
        }
        try {
            Boolean isPropertiesAvailable = false;
            Properties isoDetails = ServerUtil.getProperties(this.isoPropDir + "isolatedSeqidFile.properties");
            if (isoDetails != null && isolatedseqidsFile.lastModified() > tempIsoSeqIdFile.lastModified()) {
                isPropertiesAvailable = true;
            }
            if (isPropertiesAvailable.booleanValue()) {
                Enumeration<?> e = isoDetails.propertyNames();
                while (e.hasMoreElements()) {
                    String seqID = (String)e.nextElement();
                    if (!isoDetails.get(seqID).equals("-1")) {
                        if (isoDetails.get(seqID).equals("-2")) {
                            this.isolationMap.put(seqID, new AtomicLong(1L));
                            this.manualIsolationMap.put(seqID, new AtomicLong());
                            continue;
                        }
                        this.isolationMap.put(seqID, new AtomicLong());
                        int code = Math.abs(seqID.hashCode() % this.isolationThreads);
                        SequentialTaskQueue queue = this.currentQueueMap.get(code);
                        queue.isolate(seqID);
                        continue;
                    }
                    isoDetails.remove(seqID);
                }
                try {
                    isoDetails.store(new FileOutputStream(this.isoPropDir + "tempIsoSeqIdFile.properties"), null);
                    isoDetails.store(new FileOutputStream(this.isoPropDir + "isolatedSeqidFile.properties"), null);
                }
                catch (FileNotFoundException e2) {
                    logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException", e2);
                }
                catch (IOException e3) {
                    logger.log(Level.SEVERE, "VS_ERR --> IOException", e3);
                }
            } else {
                isoDetails = ServerUtil.getProperties(this.isoPropDir + "tempIsoSeqIdFile.properties");
                if (isoDetails != null) {
                    e = isoDetails.propertyNames();
                    while (e.hasMoreElements()) {
                        String seqID = (String)e.nextElement();
                        if (!isoDetails.get(seqID).equals("-1")) {
                            if (isoDetails.get(seqID).equals("-2")) {
                                this.isolationMap.put(seqID, new AtomicLong(1L));
                                this.manualIsolationMap.put(seqID, new AtomicLong());
                                continue;
                            }
                            this.isolationMap.put(seqID, new AtomicLong());
                            int code = Math.abs(seqID.hashCode() % this.isolationThreads);
                            SequentialTaskQueue queue = this.currentQueueMap.get(code);
                            queue.isolate(seqID);
                            continue;
                        }
                        isoDetails.remove(seqID);
                    }
                    try {
                        isoDetails.store(new FileOutputStream(this.isoPropDir + "tempIsoSeqIdFile.properties"), null);
                        isoDetails.store(new FileOutputStream(this.isoPropDir + "isolatedSeqidFile.properties"), null);
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException", e);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> IOException", e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "VS_ERR --> Exception while getting isolated seqids", e);
        }
        logger.info("NSINFO--> taskmanager - " + this.tmName + " taskengine - " + this.teName + " initialCountInQueue " + this.initialCountInQueue + " for taskmanager - " + this.tmName + " taskengine - " + this.teName);
        this.isolationManager = new IsolationManager(this.isolationQueue);
        this.isolationManager.start();
        this.stopEngine = false;
        logger.info("VS --> Sequential TaskEngine started tmname - " + this.tmName + " tename - " + this.teName + " bufSize - " + this.inMemBufSize + " workerThreads - " + this.isolationThreads + " maxIsolationLimit - " + this.maxIsolationLimit + " isAREnabled - " + this.isAREnabled + " deferredMap = " + this.deferredMap);
        logger.info("VS --> Sequential TaskEngine started tmname - " + this.tmName + " tename - " + this.teName + " bufSize - " + this.inMemBufSize + " workerThreads - " + this.isolationThreads + " maxIsolationLimit - " + this.maxIsolationLimit + " isAREnabled - " + this.isAREnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addIfIsolated(WmsEvent event, String seqID) {
        boolean isIsolated = false;
        AtomicLong count = this.isolationMap.get(seqID);
        if (count != null) {
            int code = Math.abs(seqID.hashCode() % this.isolationThreads);
            AtomicLong atomicLong = count;
            synchronized (atomicLong) {
                if (this.isolationMap.containsKey(seqID)) {
                    count.incrementAndGet();
                    isIsolated = true;
                    String deferredName = this.deferredMap.get(event.getOpr());
                    if (deferredName != null && !Boolean.parseBoolean(event.getHeader("isdeferredevent"))) {
                        try {
                            event.putHeader("desgroupid", seqID);
                            DeferredExecutorService.add(deferredName, event, false);
                            return true;
                        }
                        catch (Exception e) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("VS--> Exception in Adding to DES opr = ");
                            buffer.append(event.getOpr());
                            buffer.append(" deferredName = ");
                            buffer.append(deferredName);
                            logger.log(Level.SEVERE, buffer.toString(), e);
                        }
                    }
                    this.currentQueueMap.get(code).add(event);
                }
            }
            if (!this.threadsMap.containsKey(code)) {
                try {
                    this.threadsMapLock.lock();
                    if (!this.threadsMap.containsKey(code)) {
                        TaskDispatcher taskDispatcher = new TaskDispatcher(this.tmName, this.teName, this.currentQueueMap.get(code), code, false, true);
                        taskDispatcher.start();
                        this.threadsMap.put(code, taskDispatcher);
                    }
                }
                finally {
                    this.threadsMapLock.unlock();
                }
            }
        }
        return isIsolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(WmsEvent event, String seqID) {
        boolean status = false;
        if (this.isolationMap.size() <= this.maxIsolationLimit) {
            this.isolationMap.put(seqID, new AtomicLong(1L));
            int code = Math.abs(seqID.hashCode() % this.isolationThreads);
            SequentialTaskQueue queue = this.currentQueueMap.get(code);
            queue.add(event);
            queue.isolate(seqID);
            this.isolationQueue.add(seqID + "=" + code + "\r\n");
            logger.info("VS --> seqid = " + seqID + " is isolated in taskmanager - " + this.tmName + " taskengine - " + this.teName);
            try {
                this.threadsMapLock.lock();
                if (!this.threadsMap.containsKey(code)) {
                    TaskDispatcher taskDispatcher = new TaskDispatcher(this.tmName, this.teName, this.currentQueueMap.get(code), code, false, true);
                    taskDispatcher.start();
                    this.threadsMap.put(code, taskDispatcher);
                }
            }
            finally {
                this.threadsMapLock.unlock();
            }
            status = true;
            if (this.isolationMap.size() > this.maxIsolatedSeqIDCount) {
                this.maxIsolatedSeqIDCount = this.isolationMap.size();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isolate(String seqID) {
        if (!this.manualIsolationMap.containsKey(seqID)) {
            AtomicLong count = this.isolationMap.get(seqID);
            if (count != null) {
                AtomicLong atomicLong = count;
                synchronized (atomicLong) {
                    if (this.isolationMap.containsKey(seqID)) {
                        count.incrementAndGet();
                    } else {
                        this.isolationMap.put(seqID, new AtomicLong(1L));
                    }
                }
            } else {
                this.isolationMap.put(seqID, new AtomicLong(1L));
            }
            this.isolationQueue.add(seqID + "=-2\r\n");
            this.manualIsolationMap.put(seqID, new AtomicLong());
            logger.info("VS --> seqid = " + seqID + " is isolated manually in taskmanager - " + this.tmName + " taskengine - " + this.teName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deisolate(String seqID) {
        if (this.manualIsolationMap.containsKey(seqID)) {
            AtomicLong count = this.isolationMap.get(seqID);
            if (count != null) {
                AtomicLong atomicLong = count;
                synchronized (atomicLong) {
                    logger.info("VS --> seqid = " + seqID + " is deisolated manually in taskmanager - " + this.tmName + " taskengine - " + this.teName);
                    if (count.decrementAndGet() == 0L) {
                        this.isolationMap.remove(seqID);
                        this.currentQueueMap.get(Math.abs(seqID.hashCode() % this.isolationThreads)).deisolate(seqID);
                        this.isolationQueue.add(seqID + "=-1\r\n");
                        logger.info("VS --> seqid = " + seqID + " is deisolated in taskmanager - " + this.tmName + " taskengine - " + this.teName);
                    }
                }
            }
            this.manualIsolationMap.remove(seqID);
            return true;
        }
        return false;
    }

    public HashMap<String, ConcurrentHashMap<String, AtomicLong>> getIsolatedSeqIDs() {
        HashMap<String, ConcurrentHashMap<String, AtomicLong>> map = new HashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        map.put("auto", this.isolationMap);
        map.put("manual", this.manualIsolationMap);
        return map;
    }

    public String drainQueue(String queueID, int drainCount) {
        int queueid;
        try {
            queueid = Integer.parseInt(queueID);
        }
        catch (NumberFormatException e) {
            return "invalid queue id";
        }
        if (this.currentQueueMap.containsKey(queueid)) {
            SequentialTaskQueue queue = this.currentQueueMap.get(queueid);
            int previousSize = queue.size();
            logger.info("VS --> drain initiated taskmanager - " + this.tmName + " taskengine - " + this.teName + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + previousSize);
            String result = queue.drop(drainCount);
            logger.info("VS --> drain completed taskmanager - " + this.tmName + " taskengine - " + this.teName + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + queue.size());
            StatsDB.addDataInstant(System.currentTimeMillis(), "drainstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, queueID, previousSize - queue.size());
            return result;
        }
        return "invalid queue id";
    }

    public void shutdown() {
        this.stopEngine = true;
        try {
            this.threadsMapLock.lock();
            for (Integer count : this.threadsMap.keySet()) {
                this.threadsMap.get(count).shutdown();
                this.threadsMap.get(count).interrupt();
            }
        }
        finally {
            this.threadsMapLock.unlock();
        }
    }

    public void shutdownIsolationManager() {
        this.isolationManager.shutdown();
        this.isolationManager.interrupt();
    }

    public void restart() {
        this.stopEngine = false;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            que.open();
        }
    }

    protected void stop() {
        this.stopEngine = true;
        for (Map.Entry<String, ConcurrentHashMap<Integer, SequentialTaskQueue>> entry : this.queuesMap.entrySet()) {
            ConcurrentHashMap<Integer, SequentialTaskQueue> versionQueueMap = entry.getValue();
            for (Map.Entry<Integer, SequentialTaskQueue> versionMapEntry : versionQueueMap.entrySet()) {
                versionMapEntry.getValue().close();
            }
        }
        this.isolationManager.interrupt();
    }

    public int getQueueSize() {
        int size = 0;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            size += que.size();
        }
        return size;
    }

    public int getCurrentThreadCount() {
        return this.threadCount.get();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxThreadCount(boolean reset) {
        int count = this.maxThreadCount;
        if (reset) {
            Integer n = this.maxThreadCount;
            synchronized (n) {
                this.maxThreadCount = 0;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxIsolatedSeqIDs() {
        int count = this.maxIsolatedSeqIDCount;
        Integer n = this.maxIsolatedSeqIDCount;
        synchronized (n) {
            this.maxIsolatedSeqIDCount = this.isolationMap.size();
        }
        return count;
    }

    public void setDrain(boolean isdrain) {
        this.drain = isdrain;
    }

    public Hashtable<String, Hashtable<String, String>> getIsolationQueueStats() {
        Hashtable<String, Hashtable<String, String>> returnhash = new Hashtable<String, Hashtable<String, String>>();
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que.isEmpty()) continue;
            returnhash.put(que.getname(), que.getStats());
        }
        return returnhash;
    }

    public Hashtable<String, String> getStats() {
        int in = 0;
        int out = 0;
        int size = 0;
        int waiting = 0;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            Hashtable<String, String> stats = que.getStats();
            in += Integer.parseInt(stats.get("in"));
            out += Integer.parseInt(stats.get("out"));
            size += Integer.parseInt(stats.get("size"));
            waiting += Integer.parseInt(stats.get("waitingthreads"));
        }
        boolean overflow = size > this.activeThreadCount.get() * this.inMemBufSize;
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + in);
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        returnhash.put("overflow", "" + overflow);
        returnhash.put("waitingthreads", "" + waiting);
        returnhash.put("totalthreads", "" + this.activeThreadCount.get());
        return returnhash;
    }

    public void clearStats() {
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            que.clearStats();
        }
    }

    public Hashtable<String, String> getWmsQStats() {
        long in = 0L;
        long out = 0L;
        long size = 0L;
        long createdfiles = 0L;
        long proccesdfiles = 0L;
        long savetofiletime = 0L;
        long loadfromfiletime = 0L;
        long remainingfiles = 0L;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            Hashtable<String, String> stats = que.getWmsQStats();
            in += Long.parseLong("" + stats.get("in"));
            out += Long.parseLong("" + stats.get("out"));
            size += Long.parseLong("" + stats.get("size"));
            createdfiles += Long.parseLong("" + stats.get("createdfiles"));
            proccesdfiles += Long.parseLong("" + stats.get("proccesdfiles"));
            savetofiletime += Long.parseLong("" + stats.get("savetofiletime"));
            loadfromfiletime += Long.parseLong("" + stats.get("loadfromfiletime"));
            remainingfiles += Long.parseLong("" + stats.get("remainingfiles"));
        }
        boolean overflow = size > (long)(this.activeThreadCount.get() * this.inMemBufSize);
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + in);
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        returnhash.put("bqname", "iso-seq-" + this.teName);
        returnhash.put("overflow", "" + overflow);
        returnhash.put("createdfiles", "" + createdfiles);
        returnhash.put("proccesdfiles", "" + proccesdfiles);
        returnhash.put("savetofiletime", "" + savetofiletime);
        returnhash.put("loadfromfiletime", "" + loadfromfiletime);
        returnhash.put("remainingfiles", "" + remainingfiles);
        return returnhash;
    }

    public void incrementInQueue(int queueId) {
        long count = this.mappedBB.getLong(this.inQueuePosition.get(queueId));
        this.mappedBB.putLong(this.inQueuePosition.get(queueId), ++count);
    }

    public void incrementOutQueue(int queueId) {
        long count = this.mappedBB.getLong(this.outQueuePosition.get(queueId));
        this.mappedBB.putLong(this.outQueuePosition.get(queueId), ++count);
    }

    private long getInQueue(int queueId) {
        return this.mappedBB.getLong(this.inQueuePosition.get(queueId));
    }

    private long getOutQueue(int queueId) {
        return this.mappedBB.getLong(this.outQueuePosition.get(queueId));
    }

    private void resetInQueue(int queueId) {
        this.mappedBB.putLong(this.inQueuePosition.get(queueId), 0L);
    }

    private void resetOutQueue(int queueId) {
        this.mappedBB.putLong(this.outQueuePosition.get(queueId), 0L);
    }

    private boolean isBlocked(WmsEvent event) {
        if (this.blockedTaskMap.containsKey(event.getOpr())) {
            try {
                this.blockedTaskMap.get(event.getOpr()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_opr_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getRKey() != null && this.blockedRKeyMap.get(event.getOpr()).containsKey(event.getRKey())) {
            try {
                this.blockedRKeyMap.get(event.getOpr()).get(event.getRKey()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_rkey_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getDataAsString("prd") != null && this.blockedPrdMap.get(event.getOpr()).containsKey(event.getDataAsString("prd"))) {
            try {
                this.blockedPrdMap.get(event.getOpr()).get(event.getDataAsString("prd")).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_prd_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getExpiryTime() > 0L && event.getExpiryTime() < System.currentTimeMillis()) {
            ServerUtil.logExternal(event, "delegate", "event_dropped_ttl");
            StatsDB.addData("droppedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        return false;
    }

    private static void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File subfiles : file.listFiles()) {
                IsolatedSequentialTaskEngine.deleteRecursive(subfiles);
            }
        }
        file.delete();
    }

    class IsolationManager
    extends Thread {
        private boolean isthreadAlive;
        private LinkedBlockingQueue<String> isolationQueue;

        IsolationManager(LinkedBlockingQueue<String> isolationQueue) {
            super("TES/" + IsolatedSequentialTaskEngine.this.tesVersion + "-" + IsolatedSequentialTaskEngine.this.tmName + "-" + IsolatedSequentialTaskEngine.this.teName + "-isolation manager");
            this.isthreadAlive = true;
            this.isolationQueue = new LinkedBlockingQueue();
            this.isolationQueue = isolationQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String value;
            String seqID;
            Properties newProp;
            Properties oldProp;
            File isolatedseqids;
            FileOutputStream conf;
            while (this.isthreadAlive) {
                conf = null;
                try {
                    try {
                        isolatedseqids = new File(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties");
                        isolatedseqids.createNewFile();
                        conf = new FileOutputStream(isolatedseqids, true);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while initializing", e);
                    }
                    for (int count = 0; count < 100 && this.isthreadAlive; ++count) {
                        String confEntry = null;
                        try {
                            confEntry = this.isolationQueue.take();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.FINE, "VS_ERR --> InterruptedException", e);
                            break;
                        }
                        try {
                            conf.write(confEntry.getBytes());
                            continue;
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while writing", e);
                        }
                    }
                }
                finally {
                    try {
                        conf.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while closing", e);
                    }
                }
                oldProp = ServerUtil.getProperties(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties");
                newProp = new Properties();
                Enumeration<?> e = oldProp.propertyNames();
                while (e.hasMoreElements()) {
                    seqID = (String)e.nextElement();
                    value = (String)oldProp.get(seqID);
                    if ("-1".equals(value)) continue;
                    newProp.setProperty(seqID, value);
                }
                try {
                    newProp.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties"), null);
                    newProp.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + "isolatedSeqidFile.properties"), null);
                }
                catch (IOException e2) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e2);
                }
            }
            conf = null;
            try {
                try {
                    isolatedseqids = new File(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties");
                    isolatedseqids.createNewFile();
                    conf = new FileOutputStream(isolatedseqids, true);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while initializing", e);
                }
                while (!this.isolationQueue.isEmpty()) {
                    String confEntry = null;
                    confEntry = this.isolationQueue.poll();
                    if (confEntry == null) continue;
                    try {
                        conf.write(confEntry.getBytes());
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while writing", e);
                    }
                }
            }
            finally {
                try {
                    conf.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in FileOutputStream while closing", e);
                }
            }
            oldProp = ServerUtil.getProperties(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties");
            newProp = new Properties();
            e = oldProp.propertyNames();
            while (e.hasMoreElements()) {
                seqID = (String)e.nextElement();
                value = (String)oldProp.get(seqID);
                if ("-1".equals(value)) continue;
                newProp.setProperty(seqID, value);
            }
            try {
                newProp.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + "tempIsoSeqIdFile.properties"), null);
                newProp.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + "isolatedSeqidFile.properties"), null);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
            }
            while (IsolatedSequentialTaskEngine.this.activeThreadCount.get() != 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.fine("VS_ERR --> Exception while ShuttingDown " + IsolatedSequentialTaskEngine.this.tmName);
                }
            }
            logger.info("VS --> TES_SD IsoSeqTaskManager - " + IsolatedSequentialTaskEngine.this.tmName + " SeqTaskEngine - " + IsolatedSequentialTaskEngine.this.teName + " is shutdown");
            IsolatedSequentialTaskEngine.this.manager.shutdownCompleted();
        }

        protected void shutdown() {
            this.isthreadAlive = false;
        }
    }

    class VersionControler
    extends Thread {
        private IsolatedSequentialTaskEngine isoEngine;

        public VersionControler(IsolatedSequentialTaskEngine isoEngine) {
            this.setName("TES/" + IsolatedSequentialTaskEngine.this.tesVersion + "-" + IsolatedSequentialTaskEngine.this.tmName + "-" + IsolatedSequentialTaskEngine.this.teName + "-iso-versioncontroler");
            this.isoEngine = isoEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block107: {
                try {
                    Properties versionDetails = ServerUtil.getProperties(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta");
                    logger.info("VS --> isolation versionDetails = " + versionDetails + " for taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                    if (versionDetails != null) {
                        SequentialTaskQueue que;
                        String versions = versionDetails.get("versions").toString();
                        ArrayList versionList = CommonUtil.getList((String)versions);
                        for (int i = 0; i < versionList.size() - 1; ++i) {
                            ConcurrentHashMap<Integer, SequentialTaskQueue> map = null;
                            String version = (String)versionList.get(i);
                            if (!versionDetails.containsKey(version)) continue;
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            map = new ConcurrentHashMap<Integer, SequentialTaskQueue>();
                            for (int j = 0; j < queueSize; ++j) {
                                SequentialTaskQueue que2 = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + j, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, j, false, this.isoEngine);
                                map.put(j, que2);
                            }
                            IsolatedSequentialTaskEngine.this.queuesMap.put(version, map);
                        }
                        String version = (String)versionList.get(versionList.size() - 1);
                        int lastQueueSize = Integer.parseInt((String)versionDetails.get(version));
                        if (lastQueueSize == IsolatedSequentialTaskEngine.this.isolationThreads) {
                            RandomAccessFile raf = null;
                            try {
                                raf = new RandomAccessFile(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap", "rw");
                                IsolatedSequentialTaskEngine.this.mappedBB = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, IsolatedSequentialTaskEngine.this.isolationThreads * 2 * 8);
                            }
                            catch (FileNotFoundException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException ", e);
                            }
                            catch (IOException io) {
                                logger.log(Level.SEVERE, "VS_ERR --> IOException ", io);
                            }
                            finally {
                                if (raf != null) {
                                    try {
                                        raf.close();
                                    }
                                    catch (IOException e) {
                                        logger.log(Level.FINE, "VS_ERR --> IOException ", e);
                                    }
                                }
                            }
                            ConcurrentHashMap<Integer, SequentialTaskQueue> map = new ConcurrentHashMap<Integer, SequentialTaskQueue>();
                            for (int i = 0; i < lastQueueSize; ++i) {
                                IsolatedSequentialTaskEngine.this.inQueuePosition.put(i, i * 2 * 8);
                                IsolatedSequentialTaskEngine.this.outQueuePosition.put(i, i * 2 * 8 + 8);
                                long size = IsolatedSequentialTaskEngine.this.getInQueue(i) - IsolatedSequentialTaskEngine.this.getOutQueue(i);
                                IsolatedSequentialTaskEngine.this.initialCountInQueue.put(i, size > 0L ? size : 0L);
                                que = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + i, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, i, true, this.isoEngine);
                                map.put(i, que);
                            }
                            IsolatedSequentialTaskEngine.this.queuesMap.put(version, map);
                            IsolatedSequentialTaskEngine.this.currentQueueMap = map;
                            logger.info("VS --> Current versionID = " + version + " workers count = " + IsolatedSequentialTaskEngine.this.isolationThreads + " in taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                        } else {
                            ConcurrentHashMap<Integer, SequentialTaskQueue> map = new ConcurrentHashMap<Integer, SequentialTaskQueue>();
                            for (int i = 0; i < lastQueueSize; ++i) {
                                SequentialTaskQueue que3 = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + i, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, i, false, this.isoEngine);
                                map.put(i, que3);
                            }
                            IsolatedSequentialTaskEngine.this.queuesMap.put(version, map);
                            new File(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap").delete();
                            map = new ConcurrentHashMap();
                            version = Long.toString(System.currentTimeMillis());
                            RandomAccessFile raf = null;
                            raf = null;
                            try {
                                raf = new RandomAccessFile(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap", "rw");
                                IsolatedSequentialTaskEngine.this.mappedBB = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, IsolatedSequentialTaskEngine.this.isolationThreads * 2 * 8);
                            }
                            catch (FileNotFoundException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException ", e);
                            }
                            catch (IOException io) {
                                logger.log(Level.SEVERE, "VS_ERR --> IOException ", io);
                            }
                            finally {
                                if (raf != null) {
                                    try {
                                        raf.close();
                                    }
                                    catch (IOException e) {
                                        logger.log(Level.FINE, "VS_ERR --> IOException ", e);
                                    }
                                }
                            }
                            for (int i = 0; i < IsolatedSequentialTaskEngine.this.isolationThreads; ++i) {
                                IsolatedSequentialTaskEngine.this.inQueuePosition.put(i, i * 2 * 8);
                                IsolatedSequentialTaskEngine.this.outQueuePosition.put(i, i * 2 * 8 + 8);
                                long size = IsolatedSequentialTaskEngine.this.getInQueue(i) - IsolatedSequentialTaskEngine.this.getOutQueue(i);
                                IsolatedSequentialTaskEngine.this.initialCountInQueue.put(i, size > 0L ? size : 0L);
                                que = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + i, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, i, true, this.isoEngine);
                                map.put(i, que);
                            }
                            versions = versions + "," + version;
                            versionList.add(version);
                            versionDetails.setProperty("versions", versions);
                            versionDetails.setProperty(version, Long.toString(IsolatedSequentialTaskEngine.this.isolationThreads));
                            IsolatedSequentialTaskEngine.this.currentQueueMap = map;
                            IsolatedSequentialTaskEngine.this.queuesMap.put(version, map);
                            try {
                                versionDetails.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                            logger.info("VS --> New Version created versionID = " + version + " workers count = " + IsolatedSequentialTaskEngine.this.isolationThreads + " in taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                        }
                        logger.info("VS --> Isolated Seq queuesMap = " + IsolatedSequentialTaskEngine.this.queuesMap + " for taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                        try {
                            IsolatedSequentialTaskEngine.this.versionLock.lock();
                            IsolatedSequentialTaskEngine.this.versionCondition.signal();
                        }
                        finally {
                            IsolatedSequentialTaskEngine.this.versionLock.unlock();
                        }
                        block90: for (int i = 0; i < versionList.size() - 1; ++i) {
                            version = (String)versionList.get(i);
                            if (!versionDetails.containsKey(version)) continue;
                            long time = System.currentTimeMillis();
                            logger.info("VS --> taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName + " draining version id - " + version + " in isolation");
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            ConcurrentHashMap versionQueuemap = (ConcurrentHashMap)IsolatedSequentialTaskEngine.this.queuesMap.get(version);
                            for (int j = 0; j < queueSize; ++j) {
                                TaskDispatcher taskDispatcher = new TaskDispatcher(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName, (SequentialTaskQueue)versionQueuemap.get(j), j, false, false);
                                taskDispatcher.start();
                                IsolatedSequentialTaskEngine.this.threadsMap.put(j, taskDispatcher);
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                logger.fine("InterruptedException int VersionControler");
                            }
                            while (IsolatedSequentialTaskEngine.this.activeThreadCount.get() != 0) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    logger.fine("InterruptedException int VersionControler");
                                }
                                if (!IsolatedSequentialTaskEngine.this.stopEngine) continue;
                                break block90;
                            }
                            logger.info("VS --> taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName + "version id = " + version + " is drained in " + (System.currentTimeMillis() - time) + " ms in isolation");
                            versionDetails.remove(version);
                            ArrayList list = CommonUtil.getList((String)versions);
                            list.remove(version);
                            versionDetails.setProperty("versions", CommonUtil.getString((ArrayList)list));
                            try {
                                versionDetails.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                            IsolatedSequentialTaskEngine.this.queuesMap.remove(version);
                            IsolatedSequentialTaskEngine.deleteRecursive(new File(ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + IsolatedSequentialTaskEngine.this.tmName + File.separator + "isolated" + File.separator + version + File.separator));
                        }
                        if (!IsolatedSequentialTaskEngine.this.stopEngine) {
                            version = (String)versionList.get(versionList.size() - 1);
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            ConcurrentHashMap versionQueuemap = (ConcurrentHashMap)IsolatedSequentialTaskEngine.this.queuesMap.get(version);
                            for (int j = 0; j < queueSize; ++j) {
                                TaskDispatcher taskDispatcher = new TaskDispatcher(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName, (SequentialTaskQueue)versionQueuemap.get(j), j, false, true);
                                taskDispatcher.start();
                                IsolatedSequentialTaskEngine.this.threadsMap.put(j, taskDispatcher);
                            }
                            versionDetails.setProperty("versions", version);
                            try {
                                versionDetails.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                        }
                        break block107;
                    }
                    RandomAccessFile raf = null;
                    try {
                        raf = new RandomAccessFile(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap", "rw");
                        IsolatedSequentialTaskEngine.this.mappedBB = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, IsolatedSequentialTaskEngine.this.isolationThreads * 2 * 8);
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException ", e);
                    }
                    catch (IOException io) {
                        logger.log(Level.SEVERE, "VS_ERR --> IOException ", io);
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                logger.log(Level.FINE, "VS_ERR --> IOException ", e);
                            }
                        }
                    }
                    IsolatedSequentialTaskEngine.this.currentQueueMap = new ConcurrentHashMap();
                    String version = Long.toString(System.currentTimeMillis());
                    for (int i = 0; i < IsolatedSequentialTaskEngine.this.isolationThreads; ++i) {
                        IsolatedSequentialTaskEngine.this.inQueuePosition.put(i, i * 2 * 8);
                        IsolatedSequentialTaskEngine.this.outQueuePosition.put(i, i * 2 * 8 + 8);
                        long size = IsolatedSequentialTaskEngine.this.getInQueue(i) - IsolatedSequentialTaskEngine.this.getOutQueue(i);
                        IsolatedSequentialTaskEngine.this.initialCountInQueue.put(i, size > 0L ? size : 0L);
                        SequentialTaskQueue que = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + i, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, i, true, this.isoEngine);
                        IsolatedSequentialTaskEngine.this.currentQueueMap.put(i, que);
                        TaskDispatcher taskDispatcher = new TaskDispatcher(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName, que, i, false, true);
                        taskDispatcher.start();
                        IsolatedSequentialTaskEngine.this.threadsMap.put(i, taskDispatcher);
                    }
                    IsolatedSequentialTaskEngine.this.queuesMap.put(version, IsolatedSequentialTaskEngine.this.currentQueueMap);
                    versionDetails = new Properties();
                    versionDetails.setProperty("versions", version);
                    versionDetails.setProperty(version, Long.toString(IsolatedSequentialTaskEngine.this.isolationThreads));
                    try {
                        versionDetails.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta"), null);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                    }
                    logger.info("VS --> New Version created versionID = " + version + " workers count = " + IsolatedSequentialTaskEngine.this.isolationThreads + " in taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                    try {
                        IsolatedSequentialTaskEngine.this.versionLock.lock();
                        IsolatedSequentialTaskEngine.this.versionCondition.signal();
                    }
                    finally {
                        IsolatedSequentialTaskEngine.this.versionLock.unlock();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in VersionController for IsolationSequentialTaskEngine ", e);
                    new File(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap").delete();
                    RandomAccessFile raf = null;
                    try {
                        raf = new RandomAccessFile(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + ".mmap", "rw");
                        IsolatedSequentialTaskEngine.this.mappedBB = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, IsolatedSequentialTaskEngine.this.isolationThreads * 2 * 8);
                    }
                    catch (FileNotFoundException exp) {
                        logger.log(Level.SEVERE, "VS_ERR --> FileNotFoundException ", exp);
                    }
                    catch (IOException io) {
                        logger.log(Level.SEVERE, "VS_ERR --> IOException ", io);
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException exp) {
                                logger.log(Level.FINE, "VS_ERR --> IOException ", exp);
                            }
                        }
                    }
                    IsolatedSequentialTaskEngine.this.currentQueueMap = new ConcurrentHashMap();
                    String version = Long.toString(System.currentTimeMillis());
                    for (int i = 0; i < IsolatedSequentialTaskEngine.this.isolationThreads; ++i) {
                        IsolatedSequentialTaskEngine.this.inQueuePosition.put(i, i * 2 * 8);
                        IsolatedSequentialTaskEngine.this.outQueuePosition.put(i, i * 2 * 8 + 8);
                        long size = IsolatedSequentialTaskEngine.this.getInQueue(i) - IsolatedSequentialTaskEngine.this.getOutQueue(i);
                        IsolatedSequentialTaskEngine.this.initialCountInQueue.put(i, size > 0L ? size : 0L);
                        SequentialTaskQueue que = new SequentialTaskQueue(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName + "-" + i, version, IsolatedSequentialTaskEngine.this.inMemBufSize, IsolatedSequentialTaskEngine.this.isAREnabled, i, true, this.isoEngine);
                        IsolatedSequentialTaskEngine.this.currentQueueMap.put(i, que);
                        TaskDispatcher taskDispatcher = new TaskDispatcher(IsolatedSequentialTaskEngine.this.tmName, IsolatedSequentialTaskEngine.this.teName, que, i, false, true);
                        taskDispatcher.start();
                        IsolatedSequentialTaskEngine.this.threadsMap.put(i, taskDispatcher);
                    }
                    IsolatedSequentialTaskEngine.this.queuesMap.put(version, IsolatedSequentialTaskEngine.this.currentQueueMap);
                    Properties versionDetails = new Properties();
                    versionDetails.setProperty("versions", version);
                    versionDetails.setProperty(version, Long.toString(IsolatedSequentialTaskEngine.this.isolationThreads));
                    try {
                        versionDetails.store(new FileOutputStream(IsolatedSequentialTaskEngine.this.isoPropDir + IsolatedSequentialTaskEngine.this.teName + "_iso.meta"), null);
                    }
                    catch (IOException exp) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", exp);
                    }
                    logger.info("VS --> New Version created versionID = " + version + " workers count = " + IsolatedSequentialTaskEngine.this.isolationThreads + " in taskmanager - " + IsolatedSequentialTaskEngine.this.tmName + " taskengine - " + IsolatedSequentialTaskEngine.this.teName);
                    try {
                        IsolatedSequentialTaskEngine.this.versionLock.lock();
                        IsolatedSequentialTaskEngine.this.versionCondition.signal();
                    }
                    finally {
                        IsolatedSequentialTaskEngine.this.versionLock.unlock();
                    }
                }
            }
        }
    }

    class TaskDispatcher
    extends Thread {
        private SequentialTaskQueue queue;
        private int queueId;
        private String teName;
        private String tmName;
        private long initialSize;
        private AtomicInteger processedCount;
        boolean dispatchTask;
        private boolean isDraininitiated;
        private int drainCount;
        private boolean isCurrentVersion;

        public TaskDispatcher(String tmName, String teName, SequentialTaskQueue queue, int queueId, boolean isOldDataAvailable, boolean isCurrentVersion) {
            super("TES/" + IsolatedSequentialTaskEngine.this.tesVersion + "-" + tmName + "-" + teName + "-iso-" + queueId);
            this.initialSize = 0L;
            this.dispatchTask = true;
            this.isDraininitiated = false;
            this.drainCount = 0;
            this.tmName = tmName;
            this.queue = queue;
            this.queueId = queueId;
            this.teName = teName;
            this.isCurrentVersion = isCurrentVersion;
            this.processedCount = new AtomicInteger();
            if (isOldDataAvailable) {
                this.initialSize = (Long)IsolatedSequentialTaskEngine.this.initialCountInQueue.get(queueId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IsolatedSequentialTaskEngine.this.threadCount.incrementAndGet();
            while (this.dispatchTask) {
                WmsEvent event = null;
                try {
                    event = this.queue.remove();
                    if (event == null) {
                        try {
                            IsolatedSequentialTaskEngine.this.threadsMapLock.lock();
                            if (!this.queue.isEmpty()) continue;
                            this.dispatchTask = false;
                            IsolatedSequentialTaskEngine.this.threadsMap.remove(this.queueId);
                            if (!this.isCurrentVersion) continue;
                            this.queue.removeAllIsolatedSeqids();
                            IsolatedSequentialTaskEngine.this.resetInQueue(this.queueId);
                            IsolatedSequentialTaskEngine.this.resetOutQueue(this.queueId);
                            continue;
                        }
                        finally {
                            IsolatedSequentialTaskEngine.this.threadsMapLock.unlock();
                            continue;
                        }
                    }
                    if (IsolatedSequentialTaskEngine.this.isBlocked(event)) continue;
                    if (IsolatedSequentialTaskEngine.this.activeThreadCount.incrementAndGet() > IsolatedSequentialTaskEngine.this.maxThreadCount) {
                        IsolatedSequentialTaskEngine.this.maxThreadCount = IsolatedSequentialTaskEngine.this.activeThreadCount.get();
                    }
                    this.processedCount.incrementAndGet();
                    long inqtime = -1L;
                    if (event.getData("inqueuetime") != null) {
                        inqtime = Long.parseLong((String)event.getData("inqueuetime"));
                    }
                    if (event.getOpr() == null) {
                        throw new WMSEventException("Operation Not Defined");
                    }
                    WmsTask task = (WmsTask)IsolatedSequentialTaskEngine.this.taskMap.get(event.getOpr().split("\\.")[1]);
                    if (task == null) {
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.INVALID_TASK.getErrorCode(), 1L);
                        logger.log(Level.SEVERE, "TES_ERR --> INVALID_TASK Task {0} not found task manager - {1}", new Object[]{event.getOpr(), this.tmName});
                        continue;
                    }
                    WmsTask.setAsIsolatedTask(true);
                    long stime = System.currentTimeMillis();
                    String handleType = "";
                    try {
                        if (IsolatedSequentialTaskEngine.this.drain) {
                            handleType = "drain";
                            task.handleDrain(event);
                        } else if (event.isBounced()) {
                            handleType = "bounce";
                            task.handleBounce(event.getBounceDetails(), event);
                        } else if (Boolean.parseBoolean(event.getHeader("isdeferredevent"))) {
                            handleType = "defer";
                            List list = (List)event.getData("desdata");
                            task.handle(list);
                            String seqID = event.getSeqID();
                            AtomicLong count = (AtomicLong)IsolatedSequentialTaskEngine.this.isolationMap.get(seqID);
                            long value = count.get() - (long)list.size();
                            count.set(value);
                        } else {
                            handleType = "handle";
                            task.handle(event);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "TES_ERR --> TE_HANDLE_EXP Exception while handling Isolation Sequential Task Engine: opr - " + event.getOpr() + " isBounced - " + event.isBounced() + " drain - " + IsolatedSequentialTaskEngine.this.drain, e);
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_EXP.getErrorCode(), 1L);
                    }
                    catch (Error e) {
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_ERR.getErrorCode(), 1L);
                        logger.log(Level.SEVERE, "VS_ERR --> TE_HANDLE_ERR Error while processing in TaskEngine in " + this.tmName + " for event opr " + event.getOpr() + ".", e);
                        IsolatedSequentialTaskEngine.this.activeThreadCount.decrementAndGet();
                        IsolatedSequentialTaskEngine.this.threadCount.decrementAndGet();
                        try {
                            IsolatedSequentialTaskEngine.this.threadsMapLock.lock();
                            IsolatedSequentialTaskEngine.this.threadsMap.remove(this.queueId);
                        }
                        finally {
                            IsolatedSequentialTaskEngine.this.threadsMapLock.unlock();
                        }
                        throw e;
                    }
                    finally {
                        WmsTask.clear();
                    }
                    long currenttime = System.currentTimeMillis();
                    long executiontime = currenttime - stime;
                    StatsDB.addData("taskenginetime", this.tmName, this.teName, event.getOpr(), 1, currenttime - inqtime - executiontime, executiontime);
                    StatsDB.addData("tesoutstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), handleType, 1, currenttime - inqtime - executiontime, executiontime);
                    StatsDB.addData("seqstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), "iso-" + this.queueId, 1, currenttime - inqtime - executiontime, executiontime);
                    ServerUtil.logExternal(event, "delegate", "event_end");
                    IsolatedSequentialTaskEngine.this.activeThreadCount.decrementAndGet();
                    if (!this.isCurrentVersion || (long)this.processedCount.get() <= this.initialSize) continue;
                    String seqID = event.getSeqID();
                    try {
                        AtomicLong count;
                        AtomicLong atomicLong = count = (AtomicLong)IsolatedSequentialTaskEngine.this.isolationMap.get(seqID);
                        synchronized (atomicLong) {
                            if (count.decrementAndGet() <= 0L) {
                                IsolatedSequentialTaskEngine.this.isolationMap.remove(seqID);
                                IsolatedSequentialTaskEngine.this.isolationQueue.add(seqID + "=-1\r\n");
                                this.queue.deisolate(seqID);
                                logger.info("VS --> seqid = " + seqID + " is deisolated in taskmanager - " + this.tmName + " taskengine - " + this.teName);
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exp) {
                    logger.log(Level.SEVERE, "TES_ERR --> TE_PROCESS_EXP Exception in task evt: opr = " + event.getOpr() + " tmname = " + this.tmName, exp);
                    StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_PROCESS_EXP.getErrorCode(), 1L);
                    ServerUtil.logExternal(event, "delegate", "event_error:" + exp.getMessage());
                }
            }
            IsolatedSequentialTaskEngine.this.threadCount.decrementAndGet();
        }

        protected void shutdown() {
            this.dispatchTask = false;
        }
    }

    class SequentialTaskQueue {
        private BufferedQueue bq;
        private String queueName;
        private boolean isCurrentVersion;
        private ConcurrentHashMap<String, Integer> isolationSeqidMap = new ConcurrentHashMap();

        public SequentialTaskQueue(String tmName, String queueName, String version, int inMemBufSize, boolean isAREnabled, int queueId, boolean isCurrentVersion, IsolatedSequentialTaskEngine isoTE) {
            this.queueName = queueName;
            this.isCurrentVersion = isCurrentVersion;
            String filePath = ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + tmName + File.separator + IsolatedSequentialTaskEngine.this.teName + File.separator + "isolated" + File.separator + version + File.separator + queueName + "_tmp";
            String fileName = "iso-" + queueName;
            this.bq = isCurrentVersion ? new BufferedQueue(filePath, fileName, inMemBufSize, isAREnabled, new SequentialIsoQueueListener(filePath, fileName, queueId, isoTE)) : new BufferedQueue(filePath, fileName, inMemBufSize, isAREnabled);
        }

        public void add(WmsEvent event) {
            this.bq.add(event);
        }

        public WmsEvent remove() {
            WmsEvent event = null;
            event = (WmsEvent)this.bq.poll(30000L);
            return event;
        }

        public int size() {
            return this.bq.size();
        }

        public boolean isEmpty() {
            return this.bq.isEmpty();
        }

        public String drop(int drainCount) {
            if (drainCount < -1) {
                return "invalid count";
            }
            if (drainCount == -1 ? this.bq.dropAll() : this.bq.drop(drainCount)) {
                return "Drain completed for " + this.queueName;
            }
            return "Drain failed for " + this.queueName;
        }

        public Hashtable<String, String> getStats() {
            return this.bq.getStats();
        }

        public Hashtable<String, String> getWmsQStats() {
            return this.bq.getWmsQStats();
        }

        public void clearStats() {
            this.bq.clearStats();
        }

        public void open() {
            this.bq.open();
        }

        public void close() {
            this.bq.close();
        }

        public String getname() {
            return this.queueName;
        }

        public void isolate(String seqID) {
            this.isolationSeqidMap.put(seqID, 1);
        }

        public void deisolate(String seqID) {
            this.isolationSeqidMap.remove(seqID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllIsolatedSeqids() {
            if (this.isCurrentVersion) {
                for (Map.Entry<String, Integer> entry : this.isolationSeqidMap.entrySet()) {
                    String seqID = entry.getKey();
                    AtomicLong count = (AtomicLong)IsolatedSequentialTaskEngine.this.isolationMap.get(seqID);
                    if (count != null) {
                        AtomicLong atomicLong = count;
                        synchronized (atomicLong) {
                            IsolatedSequentialTaskEngine.this.isolationMap.remove(seqID);
                            IsolatedSequentialTaskEngine.this.isolationQueue.add(seqID + "=-1\r\n");
                            this.isolationSeqidMap.remove(entry.getValue());
                            continue;
                        }
                    }
                    IsolatedSequentialTaskEngine.this.isolationQueue.add(seqID + "=-1\r\n");
                    this.isolationSeqidMap.remove(entry.getValue());
                }
            }
        }
    }
}

