/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.DeferredDispatcher;
import com.adventnet.wms.servercommon.components.executor.DeferredEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeferredExecutorService {
    private static Logger logger = Logger.getLogger(DeferredExecutorService.class.getName());
    private static String version = "";
    private static DeferredDispatcher dispatcher;
    private static boolean isInitialized;
    private static AtomicLong engineForShutdown;
    private static HashMap<String, DeferredEngine> deferredEngineMap;
    private static String desConfDir;
    protected static final long MAX_AR_PREPARE_TIME = 10000L;
    protected static final long MAX_AR_PERFORM_TIME = 1000L;
    private static ReentrantLock shutDownLock;
    private static Condition shutDownCompleted;
    protected static final String DES_THREAD_PREFIX = "DES/";

    public static boolean initialise() {
        if (isInitialized) {
            logger.info("DeferredExecutorService is already initialized version : " + version);
            return false;
        }
        try {
            version = Long.toString(System.currentTimeMillis());
            dispatcher = new DeferredDispatcher();
            Properties tconf = ServerUtil.getProperties(desConfDir + "deferredengine.conf");
            for (String deName : tconf.stringPropertyNames()) {
                boolean actAsSingleton;
                boolean isAREnabled;
                String value = tconf.getProperty(deName);
                long deferredTime = 0L;
                deferredTime = Long.parseLong(value.split(",")[0]);
                long interval = 0L;
                interval = Long.parseLong(value.split(",")[1]);
                int maxLimit = 0;
                maxLimit = Integer.parseInt(value.split(",")[2]);
                String tmName = value.split(",")[3];
                String opr = value.split(",")[4];
                int inMemBufSize = 0;
                try {
                    inMemBufSize = Integer.parseInt(value.split(",")[5]);
                }
                catch (Exception e) {
                    inMemBufSize = 100;
                }
                try {
                    isAREnabled = Boolean.parseBoolean(value.split(",")[6]);
                }
                catch (Exception e) {
                    isAREnabled = true;
                }
                try {
                    actAsSingleton = Boolean.parseBoolean(value.split(",")[7]);
                }
                catch (Exception e) {
                    actAsSingleton = false;
                }
                if (deferredEngineMap.containsKey(deName)) {
                    throw new Exception("Differed Engine Name already exists");
                }
                DeferredEngine engine = new DeferredEngine(deName, deferredTime, interval, maxLimit, tmName, opr, inMemBufSize, isAREnabled, actAsSingleton);
                engine.start();
                deferredEngineMap.put(deName, engine);
            }
            dispatcher.start();
            for (String deName : deferredEngineMap.keySet()) {
                deferredEngineMap.get(deName).setDispatcher(dispatcher);
            }
            logger.info("DeferredExecutorService is initialized version : " + version);
            isInitialized = true;
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "VS--> Error while initialising DeferredExecutorService. ", e);
            return false;
        }
    }

    public static boolean startEngine(String deName, long deferredTime, long interval, int maxLimit, String tmName, String opr, int inMemBufSize, boolean isAREnabled) {
        if (deferredEngineMap.containsKey(deName)) {
            logger.info("DeferredExecutorService is already initialized version : " + version);
            return false;
        }
        try {
            DeferredEngine engine = new DeferredEngine(deName, deferredTime, interval, maxLimit, tmName, opr, inMemBufSize, isAREnabled, false);
            engine.start();
            engine.setDispatcher(dispatcher);
            deferredEngineMap.put(deName, engine);
            logger.info("DeferredExecutorService new engine started deName : " + deName + " version : " + version);
            return true;
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("VS--> Error while initialising DeferredExecutorService. deName : ");
            buffer.append(deName);
            buffer.append(" version : ");
            buffer.append(version);
            logger.log(Level.SEVERE, buffer.toString(), e);
            return false;
        }
    }

    public static void add(String deName, WmsEvent event, boolean needsDuplication) throws Exception {
        if (!deferredEngineMap.containsKey(deName)) {
            throw new Exception("Invalid Deferred Engine Name");
        }
        deferredEngineMap.get(deName).add(event, needsDuplication);
    }

    protected static String setDeferredTime(String deName, long time) {
        if (time <= 0L) {
            return "invalid time";
        }
        if (deferredEngineMap.containsKey(deName)) {
            deferredEngineMap.get(deName).setDeferredTime(time);
            return "Deferred Time is changed";
        }
        return "invalid engine name";
    }

    public static String setIntervalTime(String deName, long time) {
        if (time <= 0L) {
            return "invalid time";
        }
        if (deferredEngineMap.containsKey(deName)) {
            deferredEngineMap.get(deName).setInterval(time);
            return "Interval Time is changed";
        }
        return "invalid engine name";
    }

    public static boolean drain() {
        logger.info("DES_SD --> DeferredExecutorService Drain Started");
        for (String deName : deferredEngineMap.keySet()) {
            deferredEngineMap.get(deName).startDrain();
        }
        long counter = 0L;
        while (counter++ <= 6000L) {
            int size;
            int totalSize = 0;
            for (String deName : deferredEngineMap.keySet()) {
                size = deferredEngineMap.get(deName).getQueueSize();
                if (size <= 0) continue;
                if (counter % 50L == 0L) {
                    logger.info("DES_SD --> Drain Manager name = " + deName + " pending count = " + size);
                }
                totalSize += size;
            }
            if ((totalSize += dispatcher.getQueueSize()) <= 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.fine("DES_SD --> InterruptedException in drain");
                }
                totalSize = 0;
                for (String engine : deferredEngineMap.keySet()) {
                    size = deferredEngineMap.get(engine).getQueueSize();
                    if (size <= 0) continue;
                    logger.info("DES_SD --> Drain Manager name = " + engine + " pending count = " + size);
                    totalSize += size;
                }
                if ((totalSize += dispatcher.getQueueSize()) == 0) break;
            }
            logger.info("DES_SD --> Drain Total pending count = " + totalSize + " dispatcher size = " + dispatcher.getQueueSize());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.fine("DES_SD --> InterruptedException in drain");
            }
        }
        for (String deName : deferredEngineMap.keySet()) {
            deferredEngineMap.get(deName).stopDrain();
        }
        if (counter > 6000L) {
            logger.info("DES_SD --> DeferredExecutorService Drain failed");
            return false;
        }
        logger.info("DES_SD --> DeferredExecutorService Drain Completed");
        return true;
    }

    public static boolean stop() {
        boolean result = false;
        if (isInitialized) {
            try {
                shutDownLock.lock();
                for (String deName : deferredEngineMap.keySet()) {
                    deferredEngineMap.get(deName).stop();
                    engineForShutdown.incrementAndGet();
                }
                result = shutDownCompleted.await(10000L, TimeUnit.MILLISECONDS);
                if (result) {
                    result = dispatcher.stop();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "VS_ERR --> DES Exception while shutdown", e);
            }
            finally {
                shutDownLock.unlock();
            }
            isInitialized = false;
            return result;
        }
        logger.info("VS --> DES is not initialized");
        return result;
    }

    public static void shutDown() {
        if (!isInitialized) {
            for (String deName : deferredEngineMap.keySet()) {
                deferredEngineMap.get(deName).shutdown();
            }
            logger.info("VS --> DES shutdown completed");
        }
    }

    protected static void stopCompleted(String engineName) {
        deferredEngineMap.remove(engineName);
        if (engineForShutdown.decrementAndGet() <= 0L) {
            try {
                shutDownLock.lock();
                shutDownCompleted.signal();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "VS_ERR --> Exception while DES shutdown", e);
            }
            finally {
                shutDownLock.unlock();
            }
            logger.info("VS --> DES stopAllEngines completed");
        }
    }

    static {
        isInitialized = false;
        engineForShutdown = new AtomicLong();
        deferredEngineMap = new HashMap();
        desConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "des" + File.separator;
        shutDownLock = new ReentrantLock();
        shutDownCompleted = shutDownLock.newCondition();
    }
}

