/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.DeferredDispatcher;
import com.adventnet.wms.servercommon.components.executor.DeferredExecutorService;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeferredEngine {
    private static Logger logger = Logger.getLogger(DeferredEngine.class.getName());
    private String opr;
    private String name;
    private String tmName;
    private int maxLimit = 0;
    private long interval = 0L;
    private long deferredTime = 0L;
    private BufferedQueue queue = null;
    private boolean isAREnabled;
    private boolean isdrainStarted = false;
    private boolean actAsSingleton;
    private DeferredDispatcher dispatcher;
    private DeferredExecutor deferredExecutor;
    private ConcurrentHashMap<String, ArrayList<WmsEvent>> dispatchMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, WmsEvent> singletonDispatchMap = new ConcurrentHashMap();

    public DeferredEngine(String name, long deferredTime, long interval, int maxLimit, String tmName, String opr, int inMemBufSize, boolean isAREnabled, boolean actAsSingleton) {
        this.opr = opr;
        this.name = name;
        this.tmName = tmName;
        this.interval = interval;
        this.maxLimit = maxLimit;
        this.isAREnabled = isAREnabled;
        this.deferredTime = deferredTime;
        this.actAsSingleton = actAsSingleton;
        this.deferredExecutor = new DeferredExecutor();
        this.queue = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "des" + File.separator + name + "_tmp", this.name, inMemBufSize, isAREnabled);
    }

    public void start() {
        this.deferredExecutor.start();
    }

    protected void setDispatcher(DeferredDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void add(WmsEvent event, boolean needsDuplication) throws Exception {
        if (!event.getManager().equals(this.tmName)) {
            throw new Exception("Invalid Taskmanager");
        }
        if (!event.getOpr().equals(this.opr)) {
            throw new Exception("Invalid Opr");
        }
        if (needsDuplication) {
            event = event.duplicate();
        }
        StatsDB.addData("desinstats", DC.getServertype(), DC.getCluster(), this.name, 1);
        event.putHeader("desevtintime", Long.toString(System.currentTimeMillis()));
        this.queue.add(event);
    }

    public boolean isAREnabled() {
        return this.isAREnabled;
    }

    public void setDeferredTime(long time) {
        this.deferredTime = time;
    }

    public void setInterval(long time) {
        this.interval = time;
    }

    public void startDrain() {
        this.isdrainStarted = true;
        this.deferredExecutor.interrupt();
    }

    public void stopDrain() {
        this.isdrainStarted = false;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void stop() {
        this.deferredExecutor.shutDown();
        this.deferredExecutor.interrupt();
    }

    public void shutdown() {
        this.queue.close();
    }

    class DeferredExecutor
    extends Thread {
        private boolean shutDown;

        public DeferredExecutor() {
            super("DES/" + DeferredEngine.this.name);
            this.shutDown = false;
        }

        @Override
        public void run() {
            logger.info("VS --> DES DeferredEngine started name - " + DeferredEngine.this.name + " tmName - " + DeferredEngine.this.tmName + " opr - " + DeferredEngine.this.opr);
            while (!this.shutDown) {
                try {
                    while (true) {
                        ArrayList<Object> list;
                        WmsEvent event;
                        if ((event = (WmsEvent)DeferredEngine.this.queue.peek()) != null) {
                            if (System.currentTimeMillis() - Long.parseLong(event.getHeader("desevtintime")) > DeferredEngine.this.deferredTime || DeferredEngine.this.isdrainStarted) {
                                event = (WmsEvent)DeferredEngine.this.queue.get(5);
                                if (event == null) continue;
                                event.removeHeader("desevtintime");
                                this.addToMap(event);
                                continue;
                            }
                            if (DeferredEngine.this.actAsSingleton) {
                                for (String key : DeferredEngine.this.singletonDispatchMap.keySet()) {
                                    list = new ArrayList();
                                    list.add(DeferredEngine.this.singletonDispatchMap.remove(key));
                                    this.dispatch(list);
                                }
                            } else {
                                for (String key : DeferredEngine.this.dispatchMap.keySet()) {
                                    this.dispatch((List)DeferredEngine.this.dispatchMap.remove(key));
                                }
                            }
                            if (System.currentTimeMillis() - Long.parseLong(event.getHeader("desevtintime")) > DeferredEngine.this.deferredTime) {
                                continue;
                            }
                            break;
                        }
                        if (DeferredEngine.this.actAsSingleton) {
                            for (String key : DeferredEngine.this.singletonDispatchMap.keySet()) {
                                list = new ArrayList<WmsEvent>();
                                list.add(DeferredEngine.this.singletonDispatchMap.remove(key));
                                this.dispatch(list);
                            }
                        } else {
                            for (String key : DeferredEngine.this.dispatchMap.keySet()) {
                                this.dispatch((List)DeferredEngine.this.dispatchMap.remove(key));
                            }
                        }
                        if (DeferredEngine.this.queue.isEmpty()) break;
                    }
                    try {
                        Thread.sleep(DeferredEngine.this.interval);
                    }
                    catch (InterruptedException e) {
                        logger.fine("InterruptedException");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in DeferredEngine in " + DeferredEngine.this.name, e);
                }
            }
            DeferredExecutorService.stopCompleted(DeferredEngine.this.name);
            logger.info("VS --> DES DeferredEngine Stopped name - " + DeferredEngine.this.name);
        }

        private void addToMap(WmsEvent event) {
            String groupID = event.getHeader("desgroupid");
            if (DeferredEngine.this.actAsSingleton) {
                DeferredEngine.this.singletonDispatchMap.put(groupID, event);
            } else if (DeferredEngine.this.dispatchMap.containsKey(groupID)) {
                List list = (List)DeferredEngine.this.dispatchMap.get(groupID);
                list.add(event);
                if (list.size() > DeferredEngine.this.maxLimit) {
                    this.dispatch(list);
                    DeferredEngine.this.dispatchMap.remove(groupID);
                }
            } else {
                ArrayList<WmsEvent> list = new ArrayList<WmsEvent>();
                list.add(event);
                DeferredEngine.this.dispatchMap.put(groupID, list);
            }
        }

        private void dispatch(List<WmsEvent> list) {
            WmsEvent event = new WmsEvent();
            event.putHeader("isdeferredevent", "true");
            event.setManager(DeferredEngine.this.tmName);
            event.setOpr(DeferredEngine.this.opr);
            if (list.get(0).getSeqID() != null) {
                event.setSeqID(list.get(0).getSeqID());
            }
            if (list.get(0).getRKey() != null) {
                event.setRKey(list.get(0).getRKey());
            }
            event.putData("desdata", list);
            DeferredEngine.this.dispatcher.dispatch(event);
            StatsDB.addData("desoutstats", DC.getServertype(), DC.getCluster(), DeferredEngine.this.name, list.size(), 1);
        }

        public void shutDown() {
            this.shutDown = true;
        }
    }
}

