/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup.wdb;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.backup.wdb.BackupObject;
import com.adventnet.wms.servercommon.wdb.engine.WDBDataInputStream;
import com.adventnet.wms.servercommon.wdb.engine.WDBDataOutputStream;
import com.adventnet.wms.servercommon.wdb.engine.WDBRecordBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class BkpClientRecordBinding
extends WDBRecordBinding {
    @Override
    public void objectToDBEntry(Object paramObject, WDBDataOutputStream os) throws IOException {
        BackupObject record = (BackupObject)paramObject;
        os.writeLong(record.getRecordVersion());
        os.writeUTF(record.getServerType());
        os.writeUTF(record.getStorage());
        os.writeUTF(record.getFolderName());
        os.writeUTF(record.getEntityID());
        os.writeUTF(record.getRemoteFilepath());
        os.writeInt(record.getBackupType());
        os.writeLong(record.getLastModifiedTime());
        os.writeUTF(record.getRemoteIP());
        os.writeUTF(HttpDataWraper.getString(record.getServiceList()));
        os.writeUTF(HttpDataWraper.getString(record.getAddlInfo()));
    }

    @Override
    public Object dbEntryToObject(WDBDataInputStream is) throws IOException {
        try {
            long version = is.readLong();
            if (version == 1L) {
                String serverType = is.readUTF();
                String storage = is.readUTF();
                String folderName = is.readUTF();
                String entityID = is.readUTF();
                String remoteFilePath = is.readUTF();
                int backupType = is.readInt();
                long lastModifiedTime = is.readLong();
                String remoteIP = is.readUTF();
                String serviceName = is.readUTF();
                String addlInfoData = is.readUTF();
                if (serverType != null && storage != null && folderName != null && entityID != null && remoteFilePath != null && remoteIP != null && addlInfoData != null && backupType != 0 && lastModifiedTime != 0L) {
                    Hashtable addlInfo = (Hashtable)HttpDataWraper.getObject((String)addlInfoData);
                    ArrayList serviceList = (ArrayList)HttpDataWraper.getObject((String)serviceName);
                    BackupObject record = new BackupObject(serverType, storage, folderName, entityID, remoteFilePath, backupType, lastModifiedTime, remoteIP, addlInfo);
                    record.setServiceList(serviceList);
                    return record;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

