/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import com.adventnet.wms.servercommon.FixedHashMap;
import com.adventnet.wms.servercommon.LockManager;
import com.adventnet.wms.servercommon.components.backup.BackupClient;
import com.adventnet.wms.servercommon.components.backup.BackupConfManager;
import com.adventnet.wms.servercommon.components.backup.wdb.BackupObject;
import com.adventnet.wms.servercommon.rocksdb.RocksDBIteratorHandler;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupClientDB {
    private static final Logger LOGGER = Logger.getLogger(BackupClientDB.class.getName());
    private static LockManager backupClientInventoryLock = new LockManager();
    private static Map<String, BackupObject> cache = Collections.synchronizedMap(new FixedHashMap(BackupConfManager.getBackupCacheSize(), 1.1f, false));
    private static final String BKP_CLIENT_TABLE = "backup_client_table_ver_1";

    public static int getCacheSize() {
        return cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCache(String filePath, BackupObject obj) {
        try {
            BackupObject prevObj = BackupClientInventory.getRecord(filePath);
            BackupClientInventory.updateRecord(filePath, obj);
            Object object = backupClientInventoryLock.lock(filePath);
            synchronized (object) {
                cache.put(filePath, obj);
                BackupClient.notifyBackup(filePath);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while Loading Backup List Cache from DB for filepath:{0}::Exception:{1}", new Object[]{filePath, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheFromDB(String filePath, BackupObject obj) {
        try {
            Object object = backupClientInventoryLock.lock(filePath);
            synchronized (object) {
                cache.put(filePath, obj);
                BackupClient.notifyBackup(filePath);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while Loading Backup List Cache from DB for filepath:{0}::Exception:{1}", new Object[]{filePath, e});
        }
        finally {
            backupClientInventoryLock.release(filePath);
        }
    }

    public static Hashtable<String, BackupObject> getHeadFiles(int count) {
        Hashtable<String, BackupObject> headTable = new Hashtable<String, BackupObject>(count);
        if (!cache.isEmpty()) {
            try {
                Set<Map.Entry<String, BackupObject>> backupSet = cache.entrySet();
                Iterator<Map.Entry<String, BackupObject>> iterator = backupSet.iterator();
                while (iterator.hasNext() && count > 0) {
                    Map.Entry<String, BackupObject> entry = iterator.next();
                    headTable.put(entry.getKey(), entry.getValue());
                    --count;
                }
            }
            catch (Exception exception) {}
        } else {
            BackupClientDB.loadDBData(BackupConfManager.getBackupCacheSize() - BackupClientDB.getCacheSize());
        }
        return headTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, String> remove(String filePath, BackupObject obj) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put(filePath, "false");
        try {
            BackupObject prevobj = BackupClientInventory.getRecord(filePath);
            if (prevobj != null) {
                if (prevobj.getEntityID() != null && Long.parseLong(prevobj.getAddlInfo("ctime")) > Long.parseLong(obj.getAddlInfo("ctime"))) {
                    Hashtable<String, String> hashtable = result;
                    return hashtable;
                }
                BackupClientInventory.deleteRecord(filePath);
            }
            Object object = backupClientInventoryLock.lock(filePath);
            synchronized (object) {
                cache.remove(filePath);
            }
            result.put(filePath, "true");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while removing from backup list for filepath:{0}::details:{1} : Exception:{2}", new Object[]{filePath, obj, e});
        }
        finally {
            backupClientInventoryLock.release(filePath);
        }
        return result;
    }

    private static void loadDBData(int count) {
        try {
            BackupClientInventoryHandler bkpClientDBHandler = new BackupClientInventoryHandler(count);
            bkpClientDBHandler.getData();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while getting N BackupList itenary Record ::Exception:{0}", new Object[]{e});
        }
    }

    private static class BackupClientInventoryHandler
    implements RocksDBIteratorHandler {
        int count = -1;
        HashMap<String, BackupObject> data = new HashMap();

        public BackupClientInventoryHandler(int count) {
            this.count = count;
        }

        public HashMap<String, BackupObject> getData() {
            this.data.clear();
            try {
                RocksDBManager.iterateDBSync(this, BackupClientDB.BKP_CLIENT_TABLE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.data;
        }

        @Override
        public void handleClose() {
        }

        @Override
        public void handleFailure() {
        }

        @Override
        public void handleInitialized(RocksDBManager.RocksDBSeekHandle arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleRecord(String key, Object value, RocksDBManager.RocksDBSeekHandle seek) {
            block11: {
                try {
                    BackupObject obj = (BackupObject)value;
                    if (obj != null && obj.getEntityID() != null) {
                        try {
                            Object object = backupClientInventoryLock.lock(key);
                            synchronized (object) {
                                cache.put(key, obj);
                                this.data.put(key, obj);
                            }
                        }
                        finally {
                            backupClientInventoryLock.release(key);
                        }
                        if (this.count > 0) {
                            --this.count;
                        }
                        break block11;
                    }
                    BackupClientInventory.deleteRecord(key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.count != 0;
        }
    }

    private static final class BackupClientInventory {
        private BackupClientInventory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BackupObject getRecord(String key) {
            BackupObject record = null;
            long stime = System.currentTimeMillis();
            try {
                Object object = backupClientInventoryLock.lock(key);
                synchronized (object) {
                    record = (BackupObject)RocksDBManager.get(BackupClientDB.BKP_CLIENT_TABLE, key);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "SM-->[BKPEXCEPTION] Exception in LocalFileSystemInventory get for key{0}, Ex:{1}", new Object[]{key, ex});
            }
            finally {
                backupClientInventoryLock.release(key);
            }
            return record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean updateRecord(String key, BackupObject record) {
            block8: {
                long stime = System.currentTimeMillis();
                try {
                    if (record == null) break block8;
                    Object object = backupClientInventoryLock.lock(key);
                    synchronized (object) {
                        RocksDBManager.put(BackupClientDB.BKP_CLIENT_TABLE, key, record);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "SM-->[BKPEXCEPTION] Exception in LocalFileSystemInventory update for key:{0}, Ex:{1}", new Object[]{key, ex});
                }
                finally {
                    backupClientInventoryLock.release(key);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean deleteRecord(String key) {
            block8: {
                BackupObject record = null;
                long stime = System.currentTimeMillis();
                try {
                    record = BackupClientInventory.getRecord(key);
                    if (record == null) break block8;
                    Object object = backupClientInventoryLock.lock(key);
                    synchronized (object) {
                        RocksDBManager.delete(BackupClientDB.BKP_CLIENT_TABLE, key);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "SM-->[BKPEXCEPTION] Exception in LocalFileSystemInventory delete for key:{0}, Ex:{1}", new Object[]{key, ex});
                }
                finally {
                    backupClientInventoryLock.release(key);
                }
            }
            return false;
        }
    }
}

