/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.cassandra.CassandraIDGenerator;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.AbstractThriftCompatibleTableModel;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UniqueKeyModel
extends AbstractThriftCompatibleTableModel {
    private static final Logger LOGGER = Logger.getLogger(UniqueKeyModel.class.getName());

    public static QueryId[] allPreparableIds() {
        return UniqueKeyModel.allPreparableIds(UniqueKeyQuery.values());
    }

    private UniqueKeyModel(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value) {
        super(dsession, tablename, name_rowkey, name_column1, name_value);
    }

    public static UniqueKeyModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value) throws Exception {
        return new UniqueKeyModel(dsession, tablename, name_rowkey, name_column1, name_value);
    }

    public static UniqueKeyModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        UniqueKeyModel uniquekeymodel = new UniqueKeyModel(dsession, tablename, name_rowkey, name_column1, name_value);
        if (queriestoprepare != null) {
            for (QueryId query : queriestoprepare) {
                uniquekeymodel.prepareQuery(query, preparetype);
            }
        }
        return uniquekeymodel;
    }

    public static UniqueKeyModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value, Map<QueryId, Integer> queriestoprepare) throws Exception {
        UniqueKeyModel uniquekeymodel = new UniqueKeyModel(dsession, tablename, name_rowkey, name_column1, name_value);
        uniquekeymodel.prepareQueries(queriestoprepare);
        return uniquekeymodel;
    }

    @Override
    protected RegularStatement getStatementToPrepareForQuery(QueryId querytoprepare) throws Exception {
        Select statement = null;
        if (querytoprepare == UniqueKeyQuery.GETONE) {
            statement = this.select.byFirstClusteringColumn(new String[]{this.name_value}, QueryBuilder.bindMarker(), this.name_column1, QueryBuilder.bindMarker());
        } else if (querytoprepare == UniqueKeyQuery.GETFIRSTN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.select.byPartitionKey(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey));
            }
        } else if (querytoprepare == UniqueKeyQuery.GETSTARTINGFROMCOLUMN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            }
        } else if (querytoprepare == UniqueKeyQuery.GETFIRSTNCOLUMNNAMES) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.select.byPartitionKey(new String[]{this.name_column1}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey));
            }
        } else if (querytoprepare == UniqueKeyQuery.GETCOLUMNNAMESSTARTINGFROM) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            }
        } else if (querytoprepare == UniqueKeyQuery.PUT && !this.dsession.isProtocolVersionV1()) {
            LinkedHashMap<String, Object> criteria = new LinkedHashMap<String, Object>();
            criteria.put(this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            criteria.put(this.name_value, QueryBuilder.bindMarker((String)this.name_value));
            statement = this.insert.values(QueryBuilder.bindMarker(), QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), criteria);
        }
        return statement;
    }

    public String getString(String key, String cname) throws Exception {
        return this.getString(key, cname, null);
    }

    public String getString(String key, String cname, ConsistencyLevel consistencylevel) throws Exception {
        ResultSet resultset = null;
        Object statement = null;
        try {
            Row row;
            statement = this.isPreparedQuery(UniqueKeyQuery.GETONE) ? this.getPreparedStatement(UniqueKeyQuery.GETONE).bind(new Object[]{this.validated(QueryExecutor.Operation.GET, key), cname}) : this.select.byFirstClusteringColumn(new String[]{this.name_value}, key, this.name_column1, cname);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#getString - key: " + key + " cname: " + cname + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null && (row = resultset.one()) != null) {
                return row.getString(this.name_value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getString", e);
            throw e;
        }
        return null;
    }

    public Hashtable get(String key, String cname, ConsistencyLevel consistencylevel) throws Exception {
        return (Hashtable)HttpDataWraper.getObject((String)this.getString(key, cname, consistencylevel));
    }

    public Hashtable get(String key, String cname) throws Exception {
        return this.get(key, cname, null);
    }

    public void putString(String key, String cname, String cvalue, int ttl, ConsistencyLevel consistencylevel, Long timestamp) throws Exception {
        Insert statement = null;
        try {
            timestamp = timestamp == null ? CassandraIDGenerator.getTimeStamp() : timestamp;
            if (this.isPreparedQuery(UniqueKeyQuery.PUT)) {
                statement = this.getPreparedStatement(UniqueKeyQuery.PUT).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.PUT, key)).setString(this.name_column1, cname).setString(this.name_value, cvalue).setLong("[timestamp]", timestamp.longValue()).setInt("[ttl]", ttl);
            } else {
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                values.put(this.name_column1, cname);
                values.put(this.name_value, cvalue);
                statement = this.insert.values(ttl, timestamp, key, values);
            }
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#putString - key: " + key + " cname: " + cname + " cvalue: " + cvalue + " cl: " + consistencylevel + " ts: " + timestamp);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.PUT, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#putString", e);
            throw e;
        }
    }

    public void putString(String key, String cname, String cvalue, int ttl, ConsistencyLevel consistencylevel) throws Exception {
        this.putString(key, cname, cvalue, ttl, null, null);
    }

    public void putString(String key, String cname, String cvalue, int ttl) throws Exception {
        this.putString(key, cname, cvalue, ttl, null);
    }

    public void put(String key, String cname, Hashtable cvalue, int ttl) throws Exception {
        this.put(key, cname, cvalue, ttl, null);
    }

    public void put(String key, String cname, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel) throws Exception {
        this.put(key, cname, cvalue, ttl, consistencylevel, null);
    }

    public void put(String key, String cname, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel, Long timestamp) throws Exception {
        this.putString(key, cname, HttpDataWraper.getString((Object)cvalue), ttl, consistencylevel, timestamp);
    }

    public ArrayList<Hashtable> getFirstN(String key, int limit, ConsistencyLevel consistencylevel) throws Exception {
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(UniqueKeyQuery.GETFIRSTN) ? this.getPreparedStatement(UniqueKeyQuery.GETFIRSTN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setInt("[limit]", limit) : this.select.byPartitionKey(new String[]{this.name_column1, this.name_value}, limit, key);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#getFirstN - key: " + key + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            ArrayList<Hashtable> arr = new ArrayList<Hashtable>();
            if (resultset != null) {
                List rows = resultset.all();
                if (rows == null || rows.isEmpty()) {
                    return null;
                }
                for (Row row : rows) {
                    String cname = row.getString(this.name_column1);
                    String value = row.getString(this.name_value);
                    if (value == null) continue;
                    Hashtable data = (Hashtable)HttpDataWraper.getObject((String)value);
                    data.put("_sys.cname", cname);
                    arr.add(data);
                }
                return arr;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getFirstN", e);
            throw e;
        }
        return null;
    }

    public ArrayList<Hashtable> getNFromColumn(String key, String start_cname, int limit, ConsistencyLevel consistencylevel) throws Exception {
        if (start_cname == null) {
            return this.getFirstN(key, limit, consistencylevel);
        }
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(UniqueKeyQuery.GETSTARTINGFROMCOLUMN) ? this.getPreparedStatement(UniqueKeyQuery.GETSTARTINGFROMCOLUMN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setString(this.name_column1, start_cname).setInt("[limit]", limit) : this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, limit, key, this.name_column1, start_cname);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#getNFromColumn - key: " + key + " start_cname: " + start_cname + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                List rows = resultset.all();
                if (rows == null || rows.isEmpty()) {
                    return null;
                }
                ArrayList<Hashtable> arr = new ArrayList<Hashtable>();
                for (Row row : rows) {
                    String cname = row.getString(this.name_column1);
                    String value = row.getString(this.name_value);
                    if (value == null) continue;
                    Hashtable data = (Hashtable)HttpDataWraper.getObject((String)value);
                    data.put("_sys.cname", cname);
                    arr.add(data);
                }
                return arr;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getNFromColumn", e);
            throw e;
        }
        return null;
    }

    public ArrayList<String> getFirstNColumnNames(String key, int limit, ConsistencyLevel consistencylevel) throws Exception {
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(UniqueKeyQuery.GETFIRSTNCOLUMNNAMES) ? this.getPreparedStatement(UniqueKeyQuery.GETFIRSTNCOLUMNNAMES).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setInt("[limit]", limit) : this.select.byPartitionKey(new String[]{this.name_column1}, limit, key);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#getFirstNColumnNames - key: " + key + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                List rows = resultset.all();
                if (rows == null || rows.isEmpty()) {
                    return null;
                }
                ArrayList<String> arr = new ArrayList<String>();
                for (Row row : rows) {
                    arr.add(row.getString(this.name_column1));
                }
                return arr;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getFirstNColumnNames", e);
            throw e;
        }
        return null;
    }

    public ArrayList<String> getColumnNames(String key, String start_cname, int limit, ConsistencyLevel consistencylevel) throws Exception {
        if (start_cname == null) {
            return this.getFirstNColumnNames(key, limit, consistencylevel);
        }
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(UniqueKeyQuery.GETCOLUMNNAMESSTARTINGFROM) ? this.getPreparedStatement(UniqueKeyQuery.GETCOLUMNNAMESSTARTINGFROM).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setString(this.name_column1, start_cname).setInt("[limit]", limit) : this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1}, limit, key, this.name_column1, start_cname);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#getColumnNames - key: " + key + " start_cname: " + start_cname + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                List rows = resultset.all();
                if (rows == null || rows.isEmpty()) {
                    return null;
                }
                ArrayList<String> arr = new ArrayList<String>();
                for (Row row : rows) {
                    arr.add(row.getString(this.name_column1));
                }
                return arr;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getColumnNames", e);
            throw e;
        }
        return null;
    }

    public ArrayList get(String key, String[] cnames, ConsistencyLevel consistencylevel) throws Exception {
        if (cnames == null || cnames.length == 0) {
            return null;
        }
        Select statement = null;
        ResultSet resultset = null;
        try {
            Object[] clusteringcolumns = new Object[cnames.length];
            System.arraycopy(cnames, 0, clusteringcolumns, 0, cnames.length);
            Arrays.sort(clusteringcolumns);
            statement = this.select.byFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, key, this.name_column1, clusteringcolumns);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("UniqueKeyModel#get - key: " + key + " cnames: " + cnames + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                List rows = resultset.all();
                if (rows == null || rows.isEmpty()) {
                    return null;
                }
                ArrayList<Hashtable> arr = new ArrayList<Hashtable>();
                for (Row row : rows) {
                    String cname = row.getString(this.name_column1);
                    String value = row.getString(this.name_value);
                    if (value == null) continue;
                    Hashtable data = (Hashtable)HttpDataWraper.getObject((String)value);
                    data.put("_sys.cname", cname);
                    arr.add(data);
                }
                return arr;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#get (multi)", e);
            throw e;
        }
        return null;
    }

    public ArrayList<String> getAllRowKeys() throws Exception {
        ArrayList<String> rowkeys = new ArrayList<String>(10);
        ResultSet rs = null;
        BigInteger token = BigInteger.ZERO;
        boolean proceed = true;
        try {
            while (proceed) {
                rs = token.equals(BigInteger.ZERO) ? QueryExecutor.execute(this.dsession, "select token(" + this.name_rowkey + ")," + this.name_rowkey + " from " + this.table + " limit 500", new Object[0]) : QueryExecutor.execute(this.dsession, "select token(" + this.name_rowkey + ")," + this.name_rowkey + " from " + this.table + " where token(" + this.name_rowkey + ") > " + token + " limit 500", new Object[0]);
                if (rs.getAvailableWithoutFetching() < 500) {
                    proceed = false;
                }
                for (Row row : rs) {
                    token = row.getVarint(0);
                    String pk = row.getString(this.name_rowkey);
                    if (rowkeys.contains(pk)) continue;
                    rowkeys.add(pk);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowkeys;
    }

    private ResultSet getAllRows() throws Exception {
        Select statement = null;
        try {
            statement = this.select.getAllRowKeys(new String[]{this.name_rowkey, this.name_column1});
            return QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getAllRows", e);
            throw e;
        }
    }

    public ResultSet getAllRows(ConsistencyLevel consistencylevel, Integer fetchsize) throws Exception {
        if (this.dsession.isProtocolVersionV1()) {
            throw new UnsupportedOperationException("Row iteration not supported in protocol version v1. Apply the patch from https://issues.apache.org/jira/browse/CASSANDRA-4536 and use direct cql with QueryExecutor");
        }
        Select statement = null;
        try {
            statement = this.select.distinctPartitionKeys(null);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            if (fetchsize != null) {
                statement.setFetchSize(fetchsize.intValue());
            }
            LOGGER.fine("UniqueKeyModel#getAllRows - fetchsize: " + fetchsize + " cl: " + consistencylevel);
            return QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in UniqueKeyModel#getAllRows", e);
            throw e;
        }
    }

    public static enum UniqueKeyQuery implements QueryId
    {
        GETONE(true),
        GETFIRSTN(true),
        GETSTARTINGFROMCOLUMN(true),
        GETFIRSTNCOLUMNNAMES(true),
        GETCOLUMNNAMESSTARTINGFROM(true),
        GETMULTICOLUMNS,
        PUT(true);

        private final boolean ispreparable;

        private UniqueKeyQuery() {
            this(false);
        }

        private UniqueKeyQuery(boolean ispreparable) {
            this.ispreparable = ispreparable;
        }

        @Override
        public boolean isPreparable() {
            return this.ispreparable;
        }

        @Override
        public String getIdentifier() {
            return this.name();
        }
    }
}

