/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.datastax.DefaultPreparedQueryImpl;
import com.adventnet.wms.servercommon.cassandra.datastax.PreparedQuery;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.CounterModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.TableModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.TimeSeriesModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.UniqueKeyModel;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.PartitionKeyValidator;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.RetryPolicy;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatastaxSession {
    private static final Logger LOGGER = Logger.getLogger(DatastaxSession.class.getName());
    private static final String CLASSNAME_WRAPPEDSESSION = "com.zoho.cassandra.instrument.WrappedSession";
    private Cluster cluster;
    private Session session;
    private boolean isinstrumentationenabled = true;
    private final Map<String, TableModel> models = new ConcurrentHashMap<String, TableModel>();
    private final Map<String, TableProps> table_prop_map = new HashMap<String, TableProps>();
    private final Map<String, Map<String, PreparedQuery>> prepared_query_store = new ConcurrentHashMap<String, Map<String, PreparedQuery>>();

    public DatastaxSession(Cluster cluster, Session session) {
        this.cluster = cluster;
        this.session = session;
        LOGGER.info("Creating DSession for cluster: " + cluster + " session: " + session);
        LOGGER.info("[JAVEED] " + cluster.getClusterName());
        try {
            Class<?> clazz = Class.forName(CLASSNAME_WRAPPEDSESSION);
            Constructor<?> constructor = clazz.getDeclaredConstructor(Session.class);
            constructor.setAccessible(true);
            this.session = (Session)constructor.newInstance(this.session);
            LOGGER.info("Wrapped Session for MI Stats support");
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warning("com.zoho.cassandra.instrument.WrappedSession not found! Is sas.jar not included? " + ex.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while initializing com.zoho.cassandra.instrument.WrappedSession", e);
        }
    }

    Cluster getCluster() {
        return this.cluster;
    }

    public boolean isInstrumentationEnabled() {
        return this.isinstrumentationenabled;
    }

    public DatastaxSession disableInstrumentation() {
        this.isinstrumentationenabled = false;
        return this;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public boolean isProtocolVersionV1() {
        return this.getProtocolVersion() == ProtocolVersion.V1;
    }

    Session getSession() {
        return this.session;
    }

    public String getKeyspace() {
        return this.session.getLoggedKeyspace();
    }

    public String getClusterName() {
        LOGGER.info(this.cluster.getClusterName());
        return this.cluster.getClusterName();
    }

    TableProps getPropsFor(String tablename) {
        return tablename == null ? null : this.table_prop_map.get(tablename);
    }

    public PartitionKeyValidator getPartitionKeyValidator(String tablename) {
        TableProps tableprops = this.getPropsFor(tablename);
        return tableprops != null ? tableprops.pkvalidator : PartitionKeyValidator.DEFAULT;
    }

    public void register(String tablename, TableProps tableprops) {
        LOGGER.info("Registering table " + tablename + " with tableprps: " + tableprops);
        this.table_prop_map.put(tablename, tableprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PreparedQuery> getPreparedQueriesFor(String table) {
        Map<String, PreparedQuery> map = this.prepared_query_store.get(table);
        if (map == null) {
            DatastaxSession datastaxSession = this;
            synchronized (datastaxSession) {
                map = this.prepared_query_store.get(table);
                if (map == null) {
                    map = new ConcurrentHashMap<String, PreparedQuery>();
                    this.prepared_query_store.put(table, map);
                }
            }
        }
        return map;
    }

    public void registerPreparedQuery(String table, String identifier, String query, Integer preparetype) throws Exception {
        LOGGER.info("Registering preparedquery for table: " + table + " identifier: " + identifier + " preparetype: " + preparetype + " query: " + query);
        Map<String, PreparedQuery> map = this.getPreparedQueriesFor(table);
        map.put(identifier, new DefaultPreparedQueryImpl(identifier, this, table, query, preparetype));
    }

    public void registerPreparedQuery(String table, String identifier, RegularStatement regularstatement, Integer preparetype) throws Exception {
        LOGGER.info("Registering preparedquery for table: " + table + " identifier: " + identifier + " preparetype: " + preparetype + " stmt: " + regularstatement);
        Map<String, PreparedQuery> map = this.getPreparedQueriesFor(table);
        map.put(identifier, new DefaultPreparedQueryImpl(identifier, this, table, regularstatement, preparetype));
    }

    public boolean isPreparedQuery(String table, String identifier) {
        return this.getPreparedQueriesFor(table).containsKey(identifier);
    }

    public PreparedStatement getPreparedStatement(String table, String identifier) throws Exception {
        return this.getPreparedQueriesFor(table).get(identifier).getPreparedStatement();
    }

    public void prepareTheseQueries(String table, String ... queryidentifiers) throws Exception {
        LOGGER.info("Preparing these queries for table: " + table + " queryids: " + queryidentifiers);
        for (String queryidentifier : queryidentifiers) {
            this.getPreparedQueriesFor(table).get(queryidentifier).getPreparedStatement();
        }
    }

    public TableModel getModel(String tablename) {
        return this.models.get(tablename);
    }

    public UniqueKeyModel createUniqueKeyModelFor(String tablename) throws Exception {
        return this.createUniqueKeyModelFor(tablename, "key", "column1", "value");
    }

    public UniqueKeyModel createUniqueKeyModelFor(String tablename, String name_rowkey, String name_column1, String name_value) throws Exception {
        return this.createUniqueKeyModelFor(tablename, name_rowkey, name_column1, name_value, 1, UniqueKeyModel.allPreparableIds());
    }

    public UniqueKeyModel createUniqueKeyModelFor(String tablename, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        LOGGER.info("Creating UniqueKeyModel for table: " + tablename + " rk: " + name_rowkey + " col1: " + name_column1 + " value: " + name_value + " preparetype: " + preparetype + " queriestoprepare: " + queriestoprepare);
        this.models.put(tablename, UniqueKeyModel.build(this, tablename, name_rowkey, name_column1, name_value, preparetype, queriestoprepare));
        return (UniqueKeyModel)this.models.get(tablename);
    }

    public CounterModel createCounterModelFor(String tablename, String name_rowkey, String name_column1, String name_value) throws Exception {
        return this.createCounterModelFor(tablename, name_rowkey, name_column1, name_value, 1, CounterModel.allPreparableIds());
    }

    public CounterModel createCounterModelFor(String tablename, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        LOGGER.info("Creating CounterModel for table: " + tablename + " rk: " + name_rowkey + " col1: " + name_column1 + " value: " + name_value + " preparetype: " + preparetype + " queriestoprepare: " + queriestoprepare);
        this.models.put(tablename, CounterModel.build(this, tablename, name_rowkey, name_column1, name_value, preparetype, queriestoprepare));
        return (CounterModel)this.models.get(tablename);
    }

    public TimeSeriesModel createReversedTimeSeriesModelFor(String tablename) throws Exception {
        return this.createReversedTimeSeriesModelFor(tablename, "key", "column1", "value");
    }

    public TimeSeriesModel createReversedTimeSeriesModelFor(String tablename, String name_rowkey, String name_column1, String name_value) throws Exception {
        return this.createTimeSeriesModelFor(tablename, true, name_rowkey, name_column1, name_value, 1, TimeSeriesModel.allPreparableIds());
    }

    public TimeSeriesModel createTimeSeriesModelFor(String tablename, boolean reversed, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        LOGGER.info("Creating TimeSeriesModel for table: " + tablename + " rk: " + name_rowkey + " col1: " + name_column1 + " value: " + name_value + " preparetype: " + preparetype + " queriestoprepare: " + queriestoprepare);
        this.models.put(tablename, TimeSeriesModel.build(this, tablename, reversed, name_rowkey, name_column1, name_value, preparetype, queriestoprepare));
        return (TimeSeriesModel)this.models.get(tablename);
    }

    public String toString() {
        return "[\nCluster: " + this.cluster + "\nSession: " + this.session + "\nProtocolversion: \nModels: " + this.models + "\nTableProps: " + this.table_prop_map + "\n]\n";
    }

    public static class TableProps {
        final ConsistencyLevel consistencylevel;
        final int fetchsize;
        final RetryPolicy retrypolicy;
        final PartitionKeyValidator pkvalidator;

        public TableProps(ConsistencyLevel consistencylevel, RetryPolicy retrypolicy) {
            this(consistencylevel, retrypolicy, -1, null);
        }

        public TableProps(ConsistencyLevel consistencylevel, RetryPolicy retrypolicy, int fetchsize, PartitionKeyValidator pkvalidator) {
            this.consistencylevel = consistencylevel;
            this.retrypolicy = retrypolicy;
            this.fetchsize = fetchsize;
            this.pkvalidator = pkvalidator != null ? pkvalidator : PartitionKeyValidator.DEFAULT;
        }

        public String toString() {
            return "[Props - CL: " + this.consistencylevel + " RP: " + this.retrypolicy + " FS: " + this.fetchsize + " PKV: " + this.pkvalidator + "]";
        }
    }
}

