/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.cassandra.CassandraIDGenerator;
import com.adventnet.wms.servercommon.cassandra.WMSBaseCF;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.UniqueKeyModel;
import com.datastax.driver.core.ConsistencyLevel;
import java.util.ArrayList;
import java.util.Hashtable;

public class WMSUniqueKeyCF {
    public static Object get(DatastaxSession session, String cfname, String type, String key, String cname) throws Exception {
        return WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).get(WMSBaseCF.getServerKey(type, key), cname);
    }

    public static ArrayList get(DatastaxSession session, String cfname, String key, String type, String start_cname, int limit) throws Exception {
        return WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).getColumnNames(WMSBaseCF.getServerKey(type, key), start_cname, limit, ConsistencyLevel.LOCAL_QUORUM);
    }

    public static void put(DatastaxSession session, String cfname, String type, String key, String cname, Object data) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).putString(WMSBaseCF.getServerKey(type, key), cname, HttpDataWraper.getString((Object)data), 94608000, ConsistencyLevel.LOCAL_QUORUM, CassandraIDGenerator.getTimeStamp());
    }

    public static void put(DatastaxSession session, String cfname, String key, String cname, Hashtable cvalue, int ttl) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).put(key, cname, cvalue, ttl);
    }

    public static void deleteColumn(DatastaxSession session, String cfname, String key, String type, ArrayList cnamelist) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).deleteColumn(WMSBaseCF.getServerKey(type, key), cnamelist);
    }

    public static void deleteColumn(DatastaxSession session, String cfname, String key, String type, String cname) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).deleteColumn(WMSBaseCF.getServerKey(type, key), cname);
    }

    public static void deleteColumn(DatastaxSession session, String cfname, String rkey, ArrayList cnamelist) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).deleteColumn(rkey, cnamelist);
    }

    public static void deleteRow(DatastaxSession session, String cfname, String rowKey) throws Exception {
        WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).deleteRow(rowKey);
    }

    public static ArrayList getAllRowKeys(DatastaxSession session, String cfname) throws Exception {
        return WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).getAllRowKeys();
    }

    public static ArrayList<String> getColumnNames(DatastaxSession session, String cfname, String rowkey) throws Exception {
        return WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).getColumnNames(rowkey, null, 2000, ConsistencyLevel.LOCAL_QUORUM);
    }

    public static ArrayList<String> getColumnNames(DatastaxSession session, String cfname, String start_cname, String rowkey) throws Exception {
        return WMSUniqueKeyCF.getUniqueKeyModel(session, cfname).getColumnNames(rowkey, start_cname, 2000, ConsistencyLevel.LOCAL_QUORUM);
    }

    private static UniqueKeyModel getUniqueKeyModel(DatastaxSession session, String cfname) throws Exception {
        UniqueKeyModel wmsConfigCF = (UniqueKeyModel)session.getModel(cfname);
        return wmsConfigCF == null ? (wmsConfigCF = session.createUniqueKeyModelFor(cfname)) : wmsConfigCF;
    }
}

