/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra;

import com.adventnet.wms.servercommon.cassandra.CassandraIDGenerator;
import com.adventnet.wms.servercommon.cassandra.CassandraStats;
import com.adventnet.wms.servercommon.cassandra.WMSBaseCF;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.TimeSeriesModel;
import com.datastax.driver.core.ConsistencyLevel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSTimeSeriesCF {
    private static final Logger LOGGER = Logger.getLogger(WMSTimeSeriesCF.class.getName());
    private static String cfname = "TimeSeries";

    private static TimeSeriesModel getTimeSeriesModel(DatastaxSession session) throws Exception {
        TimeSeriesModel wmsTimeSeriesCF = (TimeSeriesModel)session.getModel(cfname);
        return wmsTimeSeriesCF == null ? (wmsTimeSeriesCF = session.createTimeSeriesModelFor(cfname, false, "key", "column1", "value", 1, TimeSeriesModel.allPreparableIds())) : wmsTimeSeriesCF;
    }

    public static void put(DatastaxSession session, String key, Hashtable data) throws Exception {
        WMSTimeSeriesCF.put(session, new String[]{key}, data);
    }

    public static void put(DatastaxSession session, String[] keys, Hashtable data) throws Exception {
        for (String key : keys) {
            WMSTimeSeriesCF.getTimeSeriesModel(session).add(WMSBaseCF.getRowKey(key), data, 94608000, ConsistencyLevel.LOCAL_QUORUM, CassandraIDGenerator.getTimeStamp());
        }
        LOGGER.log(Level.FINE, "GS --> {0} update success {1}", new Object[]{cfname, "Success"});
        CassandraStats.hit("put", cfname, System.currentTimeMillis(), null);
    }

    public static ArrayList get(DatastaxSession session, String key, int limit) throws Exception {
        return WMSTimeSeriesCF.getTimeSeriesModel(session).getFirstN(WMSBaseCF.getRowKey(key), limit, ConsistencyLevel.LOCAL_QUORUM);
    }

    public static Hashtable getFirstColumn(DatastaxSession session, String key) throws Exception {
        return WMSTimeSeriesCF.getTimeSeriesModel(session).getFirstColumn(WMSBaseCF.getRowKey(key), ConsistencyLevel.LOCAL_QUORUM);
    }
}

