/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra;

import com.adventnet.wms.servercommon.WMSServerTypes;
import com.adventnet.wms.servercommon.cassandra.WMSUniqueKeyCF;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import java.util.ArrayList;
import java.util.Hashtable;

public class WMSS2SUtil {
    protected static String CFNAME = "S2S_AccountsInfo";
    protected static String sertype = WMSServerTypes.RSERVER.toString();
    protected static String S2SDOMAINS_ROWKEY = "S2SDomains";
    protected static String S2SACCOUNTS_ROWKEY = "S2SAccounts";

    private static ArrayList get(DatastaxSession session, String key, String start_cname, int limit) throws Exception {
        return WMSUniqueKeyCF.get(session, CFNAME, key, sertype, start_cname, limit);
    }

    private static Hashtable get(DatastaxSession session, String key, String cname) throws Exception {
        return (Hashtable)WMSUniqueKeyCF.get(session, CFNAME, sertype, key, cname);
    }

    private static void put(DatastaxSession session, String key, String cname, Hashtable data) throws Exception {
        WMSUniqueKeyCF.put(session, CFNAME, sertype, key, cname, data);
    }

    private static void deleteColumn(DatastaxSession session, String key, ArrayList dellist) throws Exception {
        WMSUniqueKeyCF.deleteColumn(session, CFNAME, key, sertype, dellist);
    }

    public static ArrayList getS2SDomains(DatastaxSession session, String start_cname, int limit) throws Exception {
        return WMSS2SUtil.get(session, S2SDOMAINS_ROWKEY, start_cname, limit);
    }

    public static Hashtable getS2SDomain(DatastaxSession session, String cname) throws Exception {
        return WMSS2SUtil.get(session, S2SDOMAINS_ROWKEY, cname);
    }

    public static ArrayList getS2SAccounts(DatastaxSession session, String start_cname, int limit) throws Exception {
        return WMSS2SUtil.get(session, S2SACCOUNTS_ROWKEY, start_cname, limit);
    }

    public static void putS2SDomains(DatastaxSession session, String cname, Hashtable data) throws Exception {
        WMSS2SUtil.put(session, S2SDOMAINS_ROWKEY, cname, data);
    }

    public static void putS2SAccounts(DatastaxSession session, String cname, Hashtable data) throws Exception {
        WMSS2SUtil.put(session, S2SACCOUNTS_ROWKEY, cname, data);
    }

    public static void deleteS2SDomains(DatastaxSession session, ArrayList colnames) throws Exception {
        WMSS2SUtil.deleteColumn(session, S2SDOMAINS_ROWKEY, colnames);
    }
}

